/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.operation.AbstractJobOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import java.io.IOException;

public class GetJobConfigOperation
extends AbstractJobOperation
implements AllowedDuringPassiveState,
Versioned {
    private boolean isLightJob;
    private JobConfig response;

    public GetJobConfigOperation() {
    }

    public GetJobConfigOperation(long jobId, boolean isLightJob) {
        super(jobId);
        this.isLightJob = isLightJob;
    }

    @Override
    public void run() {
        JetServiceBackend service = this.getJetServiceBackend();
        this.response = service.getJobConfig(this.jobId(), this.isLightJob);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public int getClassId() {
        return 21;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_1)) {
            out.writeBoolean(this.isLightJob);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        if (in.getVersion().isGreaterOrEqual(Versions.V5_1)) {
            this.isLightJob = in.readBoolean();
        }
    }
}

