/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.controller;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.seatunnel.app.bean.engine.EngineDataType;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.app.domain.response.engine.Engine;
import org.apache.seatunnel.app.service.IEngineService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/seatunnel/api/v1/engine"})
@RestController
public class EngineController {
    @Resource
    private IEngineService engineService;

    @GetMapping(value={"/list"})
    @ApiOperation(value="list all supported engines", httpMethod="GET")
    public Result<List<Engine>> listSupportEngines() {
        return Result.success(this.engineService.listSupportEngines());
    }

    @GetMapping(value={"/type"})
    @ApiOperation(value="list all supported Data Type", httpMethod="GET")
    public Result<List<String>> listSupportDataTypes() {
        return Result.success(this.engineService.listSupportDataTypes().stream().map(EngineDataType.DataType::getName).collect(Collectors.toList()));
    }
}

