/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource.impl;

import com.google.auto.service.AutoService;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.impl.BaseJdbcDataSourceConfigSwitcher;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.datasource.plugin.api.utils.JdbcUtils;

@AutoService(value={DataSourceConfigSwitcher.class})
public class PostgresqlDataSourceConfigSwitcher
extends BaseJdbcDataSourceConfigSwitcher {
    public static final String CATALOG_NAME = "Postgres";

    @Override
    protected Optional<String> getCatalogName() {
        return Optional.of(CATALOG_NAME);
    }

    @Override
    protected String tableFieldsToSql(List<String> tableFields, String database, String fullTable) {
        String[] split = fullTable.split("\\.");
        if (split.length != 2) {
            throw new SeaTunnelException("The tableName for postgres must be schemaName.tableName, but tableName is " + fullTable);
        }
        String schemaName = split[0];
        String tableName = split[1];
        return this.generateSql(tableFields, database, schemaName, tableName);
    }

    @Override
    protected String quoteIdentifier(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    protected String replaceDatabaseNameInUrl(String url, String databaseName) {
        return JdbcUtils.replaceDatabase((String)url, (String)databaseName);
    }

    @Override
    public String getDataSourceName() {
        return "JDBC-POSTGRES";
    }

    @Override
    protected boolean isSupportDefaultSchema() {
        return true;
    }
}

