/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.app.dal.entity.JobInstanceHistory;
import org.apache.seatunnel.app.dal.entity.JobMetrics;
import org.apache.seatunnel.app.thirdparty.engine.SeaTunnelEngineProxy;
import org.apache.seatunnel.app.thirdparty.metrics.IEngineMetricsExtractor;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaTunnelEngineMetricsExtractor
implements IEngineMetricsExtractor {
    private static final Logger log = LoggerFactory.getLogger(SeaTunnelEngineMetricsExtractor.class);
    private SeaTunnelEngineProxy seaTunnelEngineProxy = SeaTunnelEngineProxy.getInstance();
    public static final String[] clusterHealthMetricsKeys = new String[]{"processors", "load.systemAverage", "physical.memory.total", "physical.memory.free", "swap.space.total", "swap.space.free", "heap.memory.used", "heap.memory.free", "heap.memory.total", "heap.memory.max", "heap.memory.used/total", "heap.memory.used/max", "minor.gc.count", "minor.gc.time", "major.gc.count", "major.gc.time", "thread.count", "thread.peakCount", "operations.completed.count", "operations.running.count", "operations.pending.invocations.percentage", "operations.pending.invocations.count", "clientEndpoint.count", "connection.active.count", "client.connection.count", "connection.count"};

    private SeaTunnelEngineMetricsExtractor() {
    }

    public static SeaTunnelEngineMetricsExtractor getInstance() {
        return SeaTunnelEngineMetricsExtractorHolder.INSTANCE;
    }

    @Override
    public List<JobMetrics> getMetricsByJobEngineId(@NonNull String jobEngineId) {
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        LinkedHashMap<Integer, String> jobPipelineStatus = this.getJobPipelineStatus(jobEngineId);
        try {
            String metricsContent = this.seaTunnelEngineProxy.getMetricsContent(jobEngineId);
            if (StringUtils.isEmpty((CharSequence)metricsContent)) {
                return new ArrayList<JobMetrics>();
            }
            JsonNode jsonNode = JsonUtils.stringToJsonNode((String)this.seaTunnelEngineProxy.getMetricsContent(jobEngineId));
            LinkedHashMap<Integer, JobMetrics> metricsMap = this.extractMetrics(jobPipelineStatus, jsonNode);
            return Arrays.asList(metricsMap.values().toArray(new JobMetrics[0]));
        }
        catch (JsonProcessingException e) {
            throw new SeatunnelException(SeatunnelErrorEnum.LOAD_ENGINE_METRICS_JSON_ERROR, new Object[]{"SeaTunnel", ExceptionUtils.getMessage((Throwable)e)});
        }
    }

    @Override
    public LinkedHashMap<Integer, String> getJobPipelineStatus(@NonNull String jobEngineId) {
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        String jobState = this.seaTunnelEngineProxy.getJobPipelineStatusStr(jobEngineId);
        LinkedHashMap<Integer, String> pipelineStatusMap = new LinkedHashMap<Integer, String>();
        try {
            JsonNode jsonNode = JsonUtils.stringToJsonNode((String)jobState);
            if (jsonNode.get("err") != null) {
                throw new SeatunnelException(SeatunnelErrorEnum.LOAD_ENGINE_METRICS_ERROR, new Object[]{jsonNode.get("err").asText()});
            }
            Iterator iterator = jsonNode.get("pipelineStateMapperMap").fields();
            while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                String pipelineLocation = (String)next.getKey();
                String pipelineId = pipelineLocation.substring(pipelineLocation.lastIndexOf("=") + 1, pipelineLocation.length() - 1);
                pipelineStatusMap.put(Integer.valueOf(pipelineId), ((JsonNode)next.getValue()).get("pipelineStatus").asText());
            }
        }
        catch (JsonProcessingException e) {
            throw new SeatunnelException(SeatunnelErrorEnum.LOAD_ENGINE_JOB_STATUS_JSON_ERROR, new Object[]{"SeaTunnel", ExceptionUtils.getMessage((Throwable)e)});
        }
        return pipelineStatusMap;
    }

    @Override
    public JobInstanceHistory getJobHistoryById(String jobEngineId) {
        JobDAGInfo jobInfo = this.seaTunnelEngineProxy.getJobInfo(jobEngineId);
        JobInstanceHistory jobInstanceHistory = new JobInstanceHistory();
        jobInstanceHistory.setDag(JsonUtils.toJsonString((Object)jobInfo));
        return jobInstanceHistory;
    }

    @Override
    public boolean isJobEnd(@NonNull String jobEngineId) {
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        JobStatus jobStatus = this.seaTunnelEngineProxy.getJobStatus(jobEngineId);
        return jobStatus == JobStatus.FINISHED || jobStatus == JobStatus.CANCELED || jobStatus == JobStatus.FAILED;
    }

    @Override
    public JobStatus getJobStatus(@NonNull String jobEngineId) {
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        return this.seaTunnelEngineProxy.getJobStatus(jobEngineId);
    }

    @Override
    public List<Map<String, String>> getClusterHealthMetrics() {
        ArrayList<Map<String, String>> zetaClusterMetrics = new ArrayList<Map<String, String>>();
        Map<String, String> clusterHealthMetrics = this.seaTunnelEngineProxy.getClusterHealthMetrics();
        for (Map.Entry<String, String> entry : clusterHealthMetrics.entrySet()) {
            LinkedHashMap<String, String> hostMetrics = new LinkedHashMap<String, String>();
            String[] split = entry.getKey().split(":");
            hostMetrics.put("host", split[0]);
            hostMetrics.put("port", split[1]);
            String value = entry.getValue();
            value = value.replace(" ", "");
            Map otherMetrics = JsonUtils.toMap((String)value);
            for (String key : clusterHealthMetricsKeys) {
                hostMetrics.put(key, (String)otherMetrics.get(key));
            }
            zetaClusterMetrics.add(hostMetrics);
        }
        return zetaClusterMetrics;
    }

    @Override
    public Map<Integer, JobMetrics> getMetricsByJobEngineIdRTMap(@NonNull String jobEngineId) {
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        LinkedHashMap<Integer, String> jobPipelineStatus = this.getJobPipelineStatus(jobEngineId);
        try {
            String metricsContent = this.seaTunnelEngineProxy.getMetricsContent(jobEngineId);
            if (StringUtils.isEmpty((CharSequence)metricsContent)) {
                return new HashMap<Integer, JobMetrics>();
            }
            JsonNode jsonNode = JsonUtils.stringToJsonNode((String)metricsContent);
            return this.extractMetrics(jobPipelineStatus, jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new SeatunnelException(SeatunnelErrorEnum.LOAD_ENGINE_METRICS_JSON_ERROR, new Object[]{"SeaTunnel", ExceptionUtils.getMessage((Throwable)e)});
        }
    }

    private LinkedHashMap<Integer, JobMetrics> extractMetrics(LinkedHashMap<Integer, String> jobPipelineStatus, JsonNode jsonNode) {
        JsonNode cdcRecordEmitDelay;
        JsonNode sourceReceivedQPS;
        JsonNode sinkWriteQPS;
        JsonNode sinkWriteCount;
        LinkedHashMap<Integer, JobMetrics> metricsMap = new LinkedHashMap<Integer, JobMetrics>();
        JsonNode sourceReceivedCount = jsonNode.get("SourceReceivedCount");
        if (sourceReceivedCount != null && sourceReceivedCount.isArray()) {
            for (Object node : sourceReceivedCount) {
                Integer pipelineId = node.get("tags").get("pipelineId").asInt();
                JobMetrics currPipelineMetrics = this.getOrCreatePipelineMetricsMap(metricsMap, jobPipelineStatus, pipelineId);
                currPipelineMetrics.setReadRowCount(currPipelineMetrics.getReadRowCount() + node.get("value").asLong());
            }
        }
        if ((sinkWriteCount = jsonNode.get("SinkWriteCount")) != null && sinkWriteCount.isArray()) {
            for (Iterator node : jsonNode.get("SinkWriteCount")) {
                Integer pipelineId = node.get("tags").get("pipelineId").asInt();
                JobMetrics currPipelineMetrics = this.getOrCreatePipelineMetricsMap(metricsMap, jobPipelineStatus, pipelineId);
                currPipelineMetrics.setWriteRowCount(currPipelineMetrics.getWriteRowCount() + node.get("value").asLong());
            }
        }
        if ((sinkWriteQPS = jsonNode.get("SinkWriteQPS")) != null && sinkWriteQPS.isArray()) {
            for (Iterator node : jsonNode.get("SinkWriteQPS")) {
                Integer pipelineId = node.get("tags").get("pipelineId").asInt();
                JobMetrics currPipelineMetrics = this.getOrCreatePipelineMetricsMap(metricsMap, jobPipelineStatus, pipelineId);
                currPipelineMetrics.setWriteQps(currPipelineMetrics.getWriteQps() + new Double(node.get("value").asDouble()).longValue());
            }
        }
        if ((sourceReceivedQPS = jsonNode.get("SourceReceivedQPS")) != null && sourceReceivedQPS.isArray()) {
            for (JsonNode node : jsonNode.get("SourceReceivedQPS")) {
                Integer pipelineId = node.get("tags").get("pipelineId").asInt();
                JobMetrics currPipelineMetrics = this.getOrCreatePipelineMetricsMap(metricsMap, jobPipelineStatus, pipelineId);
                currPipelineMetrics.setReadQps(currPipelineMetrics.getReadQps() + new Double(node.get("value").asDouble()).longValue());
            }
        }
        if ((cdcRecordEmitDelay = jsonNode.get("CDCRecordEmitDelay")) != null && cdcRecordEmitDelay.isArray()) {
            HashMap<Integer, List> dataMap = new HashMap<Integer, List>();
            for (JsonNode node : jsonNode.get("CDCRecordEmitDelay")) {
                Integer pipelineId = node.get("tags").get("pipelineId").asInt();
                long value2 = node.get("value").asLong();
                dataMap.computeIfAbsent(pipelineId, n -> new ArrayList()).add(value2);
            }
            dataMap.forEach((key, value) -> {
                JobMetrics currPipelineMetrics = this.getOrCreatePipelineMetricsMap(metricsMap, jobPipelineStatus, (Integer)key);
                OptionalDouble average = value.stream().mapToDouble(a -> a.longValue()).average();
                currPipelineMetrics.setRecordDelay(Double.valueOf(average.isPresent() ? average.getAsDouble() : 0.0).longValue());
            });
        }
        return metricsMap;
    }

    @Override
    public Map<Long, HashMap<Integer, JobMetrics>> getAllRunningJobMetrics() {
        HashMap<Long, HashMap<Integer, JobMetrics>> allRunningJobMetricsHashMap = new HashMap<Long, HashMap<Integer, JobMetrics>>();
        try {
            String allJobMetricsContent = this.seaTunnelEngineProxy.getAllRunningJobMetricsContent();
            if (StringUtils.isEmpty((CharSequence)allJobMetricsContent)) {
                return new HashMap<Long, HashMap<Integer, JobMetrics>>();
            }
            JsonNode jsonNode = JsonUtils.stringToJsonNode((String)allJobMetricsContent);
            for (JsonNode item : jsonNode) {
                JsonNode cdcRecordEmitDelay;
                JsonNode sourceReceivedQPS;
                JsonNode sinkWriteQPS;
                JsonNode sinkWriteCount;
                LinkedHashMap<Integer, JobMetrics> metricsMap = new LinkedHashMap<Integer, JobMetrics>();
                JsonNode sourceReceivedCount = item.get("metrics").get("SourceReceivedCount");
                long jobEngineId = 0L;
                if (sourceReceivedCount != null && sourceReceivedCount.isArray()) {
                    for (Object node : sourceReceivedCount) {
                        jobEngineId = node.get("tags").get("jobId").asLong();
                        Integer pipelineId = node.get("tags").get("pipelineId").asInt();
                        JobMetrics currPipelineMetrics = this.getOrCreatePipelineMetricsMapStatusRunning(metricsMap, pipelineId);
                        currPipelineMetrics.setReadRowCount(currPipelineMetrics.getReadRowCount() + node.get("value").asLong());
                    }
                }
                if ((sinkWriteCount = item.get("metrics").get("SinkWriteCount")) != null && sinkWriteCount.isArray()) {
                    Object node;
                    node = sinkWriteCount.iterator();
                    while (node.hasNext()) {
                        JsonNode node2 = (JsonNode)node.next();
                        jobEngineId = node2.get("tags").get("jobId").asLong();
                        Integer pipelineId = node2.get("tags").get("pipelineId").asInt();
                        JobMetrics currPipelineMetrics = this.getOrCreatePipelineMetricsMapStatusRunning(metricsMap, pipelineId);
                        currPipelineMetrics.setWriteRowCount(currPipelineMetrics.getWriteRowCount() + node2.get("value").asLong());
                    }
                }
                if ((sinkWriteQPS = item.get("metrics").get("SinkWriteQPS")) != null && sinkWriteQPS.isArray()) {
                    for (Object node : sinkWriteQPS) {
                        Integer pipelineId = node.get("tags").get("pipelineId").asInt();
                        JobMetrics currPipelineMetrics = this.getOrCreatePipelineMetricsMapStatusRunning(metricsMap, pipelineId);
                        currPipelineMetrics.setWriteQps(currPipelineMetrics.getWriteQps() + new Double(node.get("value").asDouble()).longValue());
                    }
                }
                if ((sourceReceivedQPS = item.get("metrics").get("SourceReceivedQPS")) != null && sourceReceivedQPS.isArray()) {
                    Object node;
                    node = sourceReceivedQPS.iterator();
                    while (node.hasNext()) {
                        JsonNode node3 = (JsonNode)node.next();
                        Integer pipelineId = node3.get("tags").get("pipelineId").asInt();
                        JobMetrics currPipelineMetrics = this.getOrCreatePipelineMetricsMapStatusRunning(metricsMap, pipelineId);
                        currPipelineMetrics.setReadQps(currPipelineMetrics.getReadQps() + new Double(node3.get("value").asDouble()).longValue());
                    }
                }
                if ((cdcRecordEmitDelay = item.get("metrics").get("CDCRecordEmitDelay")) != null && cdcRecordEmitDelay.isArray()) {
                    HashMap<Integer, List> dataMap = new HashMap<Integer, List>();
                    for (JsonNode node : cdcRecordEmitDelay) {
                        Integer pipelineId = node.get("tags").get("pipelineId").asInt();
                        long value2 = node.get("value").asLong();
                        dataMap.computeIfAbsent(pipelineId, n -> new ArrayList()).add(value2);
                    }
                    dataMap.forEach((key, value) -> {
                        JobMetrics currPipelineMetrics = this.getOrCreatePipelineMetricsMapStatusRunning(metricsMap, (Integer)key);
                        OptionalDouble average = value.stream().mapToDouble(a -> a.longValue()).average();
                        currPipelineMetrics.setRecordDelay(Double.valueOf(average.isPresent() ? average.getAsDouble() : 0.0).longValue());
                    });
                }
                log.info("jobEngineId={},metricsMap={}", (Object)jobEngineId, metricsMap);
                allRunningJobMetricsHashMap.put(jobEngineId, metricsMap);
            }
        }
        catch (Exception e) {
            log.error("Failed to fetch running job metrics", (Throwable)e);
        }
        return allRunningJobMetricsHashMap;
    }

    private JobMetrics getOrCreatePipelineMetricsMapStatusRunning(LinkedHashMap<Integer, JobMetrics> metricsMap, Integer pipelineId) {
        JobMetrics currPipelineMetrics = metricsMap.get(pipelineId);
        if (currPipelineMetrics == null) {
            currPipelineMetrics = new JobMetrics();
            currPipelineMetrics.setStatus(JobStatus.RUNNING);
            currPipelineMetrics.setPipelineId(pipelineId);
            metricsMap.put(pipelineId, currPipelineMetrics);
        }
        return currPipelineMetrics;
    }

    private JobMetrics getOrCreatePipelineMetricsMap(LinkedHashMap<Integer, JobMetrics> metricsMap, LinkedHashMap<Integer, String> jobPipelineStatus, Integer pipelineId) {
        JobMetrics currPipelineMetrics = metricsMap.get(pipelineId);
        if (currPipelineMetrics == null) {
            currPipelineMetrics = new JobMetrics();
            metricsMap.put(pipelineId, currPipelineMetrics);
            currPipelineMetrics.setStatus("DEPLOYING".equals(jobPipelineStatus.get(pipelineId)) ? JobStatus.SCHEDULED : JobStatus.valueOf((String)jobPipelineStatus.get(pipelineId)));
            currPipelineMetrics.setPipelineId(pipelineId);
        }
        return currPipelineMetrics;
    }

    public SeaTunnelEngineProxy getSeaTunnelEngineProxy() {
        return this.seaTunnelEngineProxy;
    }

    public void setSeaTunnelEngineProxy(SeaTunnelEngineProxy seaTunnelEngineProxy) {
        this.seaTunnelEngineProxy = seaTunnelEngineProxy;
    }

    private static class SeaTunnelEngineMetricsExtractorHolder {
        private static final SeaTunnelEngineMetricsExtractor INSTANCE = new SeaTunnelEngineMetricsExtractor();

        private SeaTunnelEngineMetricsExtractorHolder() {
        }
    }
}

