/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.engine;

import com.hazelcast.client.config.ClientConfig;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;
import org.apache.seatunnel.engine.client.SeaTunnelClient;
import org.apache.seatunnel.engine.common.config.ConfigProvider;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.config.SeaTunnelConfig;
import org.apache.seatunnel.engine.common.config.YamlSeaTunnelConfigBuilder;
import org.apache.seatunnel.engine.core.job.JobDAGInfo;
import org.apache.seatunnel.engine.core.job.JobStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeaTunnelEngineProxy {
    private static final Logger log = LoggerFactory.getLogger(SeaTunnelEngineProxy.class);
    private ClientConfig clientConfig = ConfigProvider.locateAndGetClientConfig();

    public static SeaTunnelEngineProxy getInstance() {
        return SeaTunnelEngineProxyHolder.INSTANCE;
    }

    private SeaTunnelEngineProxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetricsContent(@NonNull String jobEngineId) {
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        try (SeaTunnelClient seaTunnelClient = new SeaTunnelClient(this.clientConfig);){
            String string = seaTunnelClient.getJobMetrics(Long.valueOf(jobEngineId));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJobPipelineStatusStr(@NonNull String jobEngineId) {
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        try (SeaTunnelClient seaTunnelClient = new SeaTunnelClient(this.clientConfig);){
            String string = seaTunnelClient.getJobDetailStatus(Long.valueOf(jobEngineId));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobDAGInfo getJobInfo(@NonNull String jobEngineId) {
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        try (SeaTunnelClient seaTunnelClient = new SeaTunnelClient(this.clientConfig);){
            JobDAGInfo jobDAGInfo = seaTunnelClient.getJobInfo(Long.valueOf(jobEngineId));
            return jobDAGInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobStatus getJobStatus(@NonNull String jobEngineId) {
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        try (SeaTunnelClient seaTunnelClient = new SeaTunnelClient(this.clientConfig);){
            JobStatus jobStatus = JobStatus.valueOf((String)seaTunnelClient.getJobStatus(Long.valueOf(jobEngineId)));
            return jobStatus;
        }
    }

    public Map<String, String> getClusterHealthMetrics() {
        try (SeaTunnelClient seaTunnelClient = new SeaTunnelClient(this.clientConfig);){
            Map map = seaTunnelClient.getClusterHealthMetrics();
            return map;
        }
    }

    public String getAllRunningJobMetricsContent() {
        try (SeaTunnelClient seaTunnelClient = new SeaTunnelClient(this.clientConfig);){
            String string = seaTunnelClient.getJobClient().getRunningJobMetrics();
            return string;
        }
    }

    public void pauseJob(@NonNull String jobEngineId) {
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        try (SeaTunnelClient seaTunnelClient = new SeaTunnelClient(this.clientConfig);){
            seaTunnelClient.getJobClient().savePointJob(Long.valueOf(jobEngineId));
        }
        catch (Exception e) {
            log.warn("Can not pause job from engine.", (Throwable)e);
        }
    }

    public void restoreJob(@NonNull String filePath, @NonNull Long jobInstanceId, @NonNull Long jobEngineId) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        if (jobInstanceId == null) {
            throw new NullPointerException("jobInstanceId is marked non-null but is null");
        }
        if (jobEngineId == null) {
            throw new NullPointerException("jobEngineId is marked non-null but is null");
        }
        JobConfig jobConfig = new JobConfig();
        jobConfig.setName(jobInstanceId + "_job");
        SeaTunnelConfig seaTunnelConfig = new YamlSeaTunnelConfigBuilder().build();
        try (SeaTunnelClient seaTunnelClient = new SeaTunnelClient(this.clientConfig);){
            seaTunnelClient.restoreExecutionContext(filePath, jobConfig, seaTunnelConfig, jobEngineId).execute();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static class SeaTunnelEngineProxyHolder {
        private static final SeaTunnelEngineProxy INSTANCE = new SeaTunnelEngineProxy();

        private SeaTunnelEngineProxyHolder() {
        }
    }
}

