/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy;

import com.p6spy.engine.common.P6LogQuery;
import com.p6spy.engine.common.P6Util;
import com.p6spy.engine.spy.DefaultJdbcEventListenerFactory;
import com.p6spy.engine.spy.P6DriverNotFoundError;
import com.p6spy.engine.spy.P6Factory;
import com.p6spy.engine.spy.P6LoadableOptions;
import com.p6spy.engine.spy.P6MBeansRegistry;
import com.p6spy.engine.spy.P6SpyFactory;
import com.p6spy.engine.spy.P6SpyLoadableOptions;
import com.p6spy.engine.spy.P6SpyOptions;
import com.p6spy.engine.spy.option.EnvironmentVariables;
import com.p6spy.engine.spy.option.P6OptionChangedListener;
import com.p6spy.engine.spy.option.P6OptionsRepository;
import com.p6spy.engine.spy.option.P6OptionsSource;
import com.p6spy.engine.spy.option.SpyDotProperties;
import com.p6spy.engine.spy.option.SystemProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;

public class P6ModuleManager {
    private final P6OptionsSource[] optionsSources = new P6OptionsSource[]{new SpyDotProperties(), new EnvironmentVariables(), new SystemProperties()};
    private final Map<Class<? extends P6LoadableOptions>, P6LoadableOptions> allOptions = new HashMap<Class<? extends P6LoadableOptions>, P6LoadableOptions>();
    private final List<P6Factory> factories = new CopyOnWriteArrayList<P6Factory>();
    private final P6MBeansRegistry mBeansRegistry = new P6MBeansRegistry();
    private final P6OptionsRepository optionsRepository = new P6OptionsRepository();
    private static P6ModuleManager instance;

    private static synchronized void initMe() {
        try {
            P6ModuleManager.cleanUp();
            instance = new P6ModuleManager();
            P6LogQuery.initialize();
        }
        catch (IOException e) {
            P6ModuleManager.handleInitEx(e);
        }
        catch (MBeanRegistrationException e) {
            P6ModuleManager.handleInitEx(e);
        }
        catch (InstanceNotFoundException e) {
            P6ModuleManager.handleInitEx(e);
        }
        catch (MalformedObjectNameException e) {
            P6ModuleManager.handleInitEx(e);
        }
        catch (NotCompliantMBeanException e) {
            P6ModuleManager.handleInitEx(e);
        }
    }

    private static void cleanUp() throws MBeanRegistrationException, InstanceNotFoundException, MalformedObjectNameException {
        if (instance == null) {
            return;
        }
        for (P6OptionsSource optionsSource : P6ModuleManager.instance.optionsSources) {
            optionsSource.preDestroy(instance);
        }
        if (P6SpyOptions.getActiveInstance().getJmx() && P6ModuleManager.instance.mBeansRegistry != null) {
            P6ModuleManager.instance.mBeansRegistry.unregisterAllMBeans(P6SpyOptions.getActiveInstance().getJmxPrefix());
        }
        new DefaultJdbcEventListenerFactory();
        DefaultJdbcEventListenerFactory.clearCache();
    }

    private P6ModuleManager() throws IOException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException, InstanceNotFoundException {
        this.debug(this.getClass().getName() + " re/initiating modules started");
        this.registerOptionChangedListener(new P6LogQuery());
        P6SpyLoadableOptions spyOptions = (P6SpyLoadableOptions)this.registerModule(new P6SpyFactory());
        this.loadDriversExplicitly(spyOptions);
        Set<P6Factory> moduleFactories = spyOptions.getModuleFactories();
        if (null != moduleFactories) {
            for (P6Factory factory : spyOptions.getModuleFactories()) {
                this.registerModule(factory);
            }
        }
        this.optionsRepository.initCompleted();
        this.mBeansRegistry.registerMBeans(this.allOptions.values());
        for (P6OptionsSource optionsSource : this.optionsSources) {
            optionsSource.postInit(this);
        }
        this.debug(this.getClass().getName() + " re/initiating modules done");
    }

    protected synchronized P6LoadableOptions registerModule(P6Factory factory) {
        for (P6Factory registeredFactory : this.factories) {
            if (!registeredFactory.getClass().equals(factory.getClass())) continue;
            return null;
        }
        P6LoadableOptions options = factory.getOptions(this.optionsRepository);
        this.loadOptions(options);
        this.factories.add(factory);
        this.debug("Registered factory: " + factory.getClass().getName() + " with options: " + options.getClass().getName());
        return options;
    }

    private void loadOptions(P6LoadableOptions options) {
        options.load(options.getDefaults());
        for (P6OptionsSource optionsSource : this.optionsSources) {
            Map<String, String> toLoad = optionsSource.getOptions();
            if (null == toLoad) continue;
            options.load(toLoad);
        }
        this.allOptions.put(options.getClass(), options);
    }

    public static P6ModuleManager getInstance() {
        return instance;
    }

    private static void handleInitEx(Exception e) {
        e.printStackTrace(System.err);
    }

    private void loadDriversExplicitly(P6SpyLoadableOptions spyOptions) {
        Set<String> driverNames = spyOptions.getDriverNames();
        if (null != driverNames) {
            for (String driverName : driverNames) {
                try {
                    P6Util.forName(driverName).newInstance();
                }
                catch (Exception e) {
                    String err = "Error registering driver names: " + driverNames + " \nCaused By: " + e.toString();
                    P6LogQuery.error(err);
                    throw new P6DriverNotFoundError(err);
                }
            }
        }
    }

    private void debug(String msg) {
        if (instance == null || this.factories.isEmpty()) {
            return;
        }
        P6LogQuery.debug(msg);
    }

    public <T extends P6LoadableOptions> T getOptions(Class<T> optionsClass) {
        return (T)this.allOptions.get(optionsClass);
    }

    public void reload() {
        P6ModuleManager.initMe();
    }

    public List<P6Factory> getFactories() {
        return this.factories;
    }

    public void registerOptionChangedListener(P6OptionChangedListener listener) {
        this.optionsRepository.registerOptionChangedListener(listener);
    }

    public void unregisterOptionChangedListener(P6OptionChangedListener listener) {
        this.optionsRepository.unregisterOptionChangedListener(listener);
    }

    static {
        P6ModuleManager.initMe();
    }
}

