/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.streaming.runtime.operators.sink.AbstractCommitterHandler;
import org.apache.flink.streaming.runtime.operators.sink.CommitterHandler;
import org.apache.flink.util.Preconditions;

final class BatchCommitterHandler<InputT, OutputT>
extends AbstractCommitterHandler<InputT, OutputT, InputT> {
    private final Committer<InputT> committer;
    private final CommitterHandler<InputT, OutputT> chainedHandler;

    public BatchCommitterHandler(Committer<InputT> committer, CommitterHandler<InputT, OutputT> chainedHandler) {
        this.committer = (Committer)Preconditions.checkNotNull(committer);
        this.chainedHandler = chainedHandler;
    }

    @Override
    public List<OutputT> processCommittables(List<InputT> committables) {
        super.processCommittables(committables);
        return this.chainedHandler.processCommittables(committables);
    }

    @Override
    public boolean needsRetry() {
        return super.needsRetry() || this.chainedHandler.needsRetry();
    }

    @Override
    protected void retry(List<InputT> recoveredCommittables) throws IOException, InterruptedException {
        if (!recoveredCommittables.isEmpty()) {
            this.recoveredCommittables(this.committer.commit(recoveredCommittables));
        }
        this.chainedHandler.retry();
    }

    @Override
    public List<OutputT> endOfInput() throws IOException, InterruptedException {
        List allCommittables = this.pollCommittables();
        if (!allCommittables.isEmpty()) {
            this.recoveredCommittables(this.committer.commit(allCommittables));
        }
        return this.chainedHandler.endOfInput();
    }

    @Override
    public void close() throws Exception {
        this.committer.close();
        this.chainedHandler.close();
        super.close();
    }
}

