/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.java;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.inject.Inject;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.template.BaseTemplateEngine;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.components.template.TemplateEngine;
import org.apache.struts2.components.template.TemplateEngineManager;
import org.apache.struts2.components.template.TemplateRenderingContext;
import org.apache.struts2.views.java.Theme;
import org.apache.struts2.views.java.simple.SimpleTheme;

public class JavaTemplateEngine
extends BaseTemplateEngine {
    private static final Logger LOG = LogManager.getLogger(JavaTemplateEngine.class);
    protected TemplateEngineManager templateEngineManager;
    private String defaultTemplateType = "ftl";
    private Themes themes = new Themes(){
        {
            this.add(new SimpleTheme());
        }
    };

    @Inject
    public void setTemplateEngineManager(TemplateEngineManager mgr) {
        this.templateEngineManager = mgr;
    }

    protected String getSuffix() {
        return "java";
    }

    public void renderTemplate(TemplateRenderingContext templateContext) throws Exception {
        Template t = templateContext.getTemplate();
        Theme theme = this.themes.get(t.getTheme());
        if (theme == null) {
            LOG.debug("Theme not found [{}] trying default template engine using template type [{}]", (Object)t.getTheme(), (Object)this.defaultTemplateType);
            TemplateEngine engine = this.templateEngineManager.getTemplateEngine(templateContext.getTemplate(), this.defaultTemplateType);
            if (engine == null) {
                throw new ConfigurationException("Unable to find a TemplateEngine for template type '" + this.defaultTemplateType + "' whilst trying to render template " + templateContext.getTemplate());
            }
            try {
                engine.renderTemplate(templateContext);
            }
            catch (Exception e) {
                throw new StrutsException("Cannot render tag [" + t.getName() + "] because theme [" + t.getTheme() + "] was not found.", (Throwable)e);
            }
        } else {
            theme.renderTag(t.getName(), templateContext);
        }
    }

    @Inject(value="struts.javatemplates.customThemes", required=false)
    public void setThemeClasses(String themeClasses) {
        StringTokenizer customThemes = new StringTokenizer(themeClasses, ",");
        while (customThemes.hasMoreTokens()) {
            String themeClass = customThemes.nextToken().trim();
            try {
                LOG.info("Registering custom theme [{}] to javatemplates engine", (Object)themeClass);
                ObjectFactory factory = (ObjectFactory)ActionContext.getContext().getContainer().getInstance(ObjectFactory.class);
                Theme theme = (Theme)factory.buildBean(themeClass, new HashMap());
                this.themes.add(theme);
            }
            catch (ClassCastException cce) {
                LOG.error("Invalid java them class [{}]. Class does not implement 'org.apache.struts2.views.java.Theme' interface", (Object)themeClass, (Object)cce);
            }
            catch (ClassNotFoundException cnf) {
                LOG.error("Invalid java theme class [{}]. Class not found!", (Object)themeClass, (Object)cnf);
            }
            catch (Exception e) {
                LOG.error("Could not find messages file [{}].properties. Skipping!", (Object)themeClass, (Object)e);
            }
        }
    }

    @Inject(value="struts.javatemplates.defaultTemplateType", required=false)
    public void setDefaultTemplateType(String defaultTemplateTheme) {
        if (defaultTemplateTheme != null && !defaultTemplateTheme.equalsIgnoreCase(this.getSuffix())) {
            this.defaultTemplateType = defaultTemplateTheme.toLowerCase();
        } else {
            LOG.error("Invalid struts.javatemplates.defaultTemplateType value. Cannot be [{}]!", (Object)this.getSuffix());
        }
    }

    private static class Themes {
        private HashMap<String, Theme> themes = new HashMap();

        private Themes() {
        }

        public void add(Theme theme) {
            this.themes.put(theme.getName(), theme);
        }

        public Theme get(String name) {
            return this.themes.get(name);
        }
    }
}

