/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.tez.runtime.api.impl.IOStatistics;
import org.apache.tez.util.StringInterner;

public class TaskStatistics
implements Writable {
    private Map<String, IOStatistics> ioStatistics = Maps.newConcurrentMap();

    public void addIO(String edgeName) {
        this.addIO(edgeName, new IOStatistics());
    }

    public void addIO(String edgeName, IOStatistics stats) {
        Objects.requireNonNull(stats, edgeName);
        this.ioStatistics.put(StringInterner.intern((String)edgeName), stats);
    }

    public Map<String, IOStatistics> getIOStatistics() {
        return this.ioStatistics;
    }

    public void write(DataOutput out) throws IOException {
        int numEntries = this.ioStatistics.size();
        out.writeInt(numEntries);
        for (Map.Entry<String, IOStatistics> entry : this.ioStatistics.entrySet()) {
            IOStatistics edgeStats = entry.getValue();
            Text.writeString((DataOutput)out, (String)entry.getKey());
            edgeStats.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numEntries = in.readInt();
        for (int i = 0; i < numEntries; ++i) {
            String edgeName = Text.readString((DataInput)in);
            IOStatistics edgeStats = new IOStatistics();
            edgeStats.readFields(in);
            this.addIO(edgeName, edgeStats);
        }
    }
}

