/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.LocalBarrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;

public abstract class SideEffectBarrierStep<S>
extends AbstractStep<S, S>
implements LocalBarrier<S> {
    protected TraverserSet<S> barrier;

    public SideEffectBarrierStep(Traversal.Admin traversal) {
        super(traversal);
        this.barrier = this.traversal.getTraverserSetSupplier().get();
    }

    protected abstract void sideEffect(Traverser.Admin<S> var1);

    @Override
    protected Traverser.Admin<S> processNextStart() {
        if (this.barrier.isEmpty()) {
            this.processAllStarts();
        }
        return this.barrier.remove();
    }

    @Override
    public void processAllStarts() {
        while (this.starts.hasNext()) {
            Object traverser = this.starts.next();
            this.sideEffect((Traverser.Admin<S>)traverser);
            traverser.setStepId(this.getNextStep().getId());
            this.barrier.add((Traverser.Admin<S>)traverser);
        }
    }

    @Override
    public boolean hasNextBarrier() {
        if (this.barrier.isEmpty()) {
            this.processAllStarts();
        }
        return !this.barrier.isEmpty();
    }

    @Override
    public TraverserSet<S> nextBarrier() throws NoSuchElementException {
        if (this.barrier.isEmpty()) {
            this.processAllStarts();
        }
        if (this.barrier.isEmpty()) {
            throw FastNoSuchElementException.instance();
        }
        TraverserSet<S> temp = this.barrier;
        this.barrier = this.traversal.getTraverserSetSupplier().get();
        return temp;
    }

    @Override
    public void addBarrier(TraverserSet<S> barrier) {
        this.barrier.addAll(barrier);
    }

    @Override
    public void reset() {
        super.reset();
        this.barrier.clear();
    }

    @Override
    public SideEffectBarrierStep<S> clone() {
        SideEffectBarrierStep clone = (SideEffectBarrierStep)super.clone();
        clone.barrier = this.traversal.getTraverserSetSupplier().get();
        return clone;
    }
}

