package org.apache.stratum.scheduler.examplejobs;

/*
 * Copyright 2001-2005 The Apache Software Foundation or its licensors,
 * as applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.Date;

import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

/**
 * <p>
 * A dumb implementation of Job, for unittesting purposes.
 * </p>
 *
 * @author James House
 */
public class JobTwo
        implements Job
{
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    *
    * Constructors.
    *
    * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    public JobTwo()
    {
    }

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
     *
     * Interface.
     *
     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

    /**
     * <p>
     * Called by the <code>{@link org.quartz.Scheduler}</code> when a <code>{@link org.quartz.Trigger}</code> fires that is
     * associated with the <code>Job</code>.
     * </p>
     *
     * @param context TODO: DOCUMENT ME!
     *
     * @throws JobExecutionException if there is an exception while executing the job.
     */
    public void execute(JobExecutionContext context)
            throws JobExecutionException
    {
        System.err.println("    --- Testing Scheduler Component\n    --- " + context.getJobDetail().getFullName() + " executed.["
            + new Date() + "]");
    }
}
