
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The normalizeDocument method method acts as if the document was going through a save 
 *  and load cycle, putting the document in a "normal" form. 
 *  Set the validate-if-schema feature to true.  Invoke the normalizeDocument method on this 
 *  document.  Retreive the documentElement node and check the nodeName of this node 
 *  to make sure it has not changed.  Now set validate to false and verify the same. 
 *  Register an error handler on this Document and in each case make sure that it does
 *  not get called.
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-normalizeDocument">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-normalizeDocument</a>
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-validate-if-schema">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-validate-if-schema</a>
*/
public final class documentnormalizedocument09 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentnormalizedocument09(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

     /**
      *    Inner class implementation for variable errHandler 
      */
      private static class DOMErrorHandlerN1003C
           extends org.w3c.domts.DOMTestInnerClass 
           implements DOMErrorHandler {
       /**
        * Constructor
        * @param test test case
        */
        public DOMErrorHandlerN1003C(DOMTestCase test) { 
        super(test);
           }
   
        /**
         *    
This method is called on the error handler when an error occurs.
If an exception is thrown from this method, it is considered to be equivalent of returningtrue.

         * @param error The error object that describes the error. This object may be reused by the DOM implementation across multiple calls to thehandleErrormethod.
         * @return If thehandleErrormethod returnsfalse, the DOM implementation should stop the current processing when possible. If the method returnstrue, the processing may continue depending onDOMError.severity.
         */
         public boolean handleError(DOMError error) {
        assertFalse("documentnormalizedocument09_Err", true);
        return true;
      }
}

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element docElem;
      String docElemNodeName;
      boolean canSet;
      DOMErrorHandler errorHandler;
      DOMErrorHandler errHandler = new DOMErrorHandlerN1003C(this);
      DOMConfiguration domConfig;
      doc = (Document) load("hc_staff", false);
      domConfig = doc.getDomConfig();
      domConfig.setParameter("error-handler", ((Object) /*DOMErrorHandler */errHandler));
      canSet = domConfig.canSetParameter("validate-if-schema", Boolean.TRUE);
      
      if (canSet) {
          domConfig.setParameter("validate-if-schema", Boolean.TRUE);
      doc.normalizeDocument();
      docElem = doc.getDocumentElement();
      docElemNodeName = docElem.getNodeName();
      assertEquals("documentnormalizedocument09_True", "html", docElemNodeName);
      }
    domConfig.setParameter("validate-if-schema", Boolean.FALSE);
      doc.normalizeDocument();
      docElem = doc.getDocumentElement();
      docElemNodeName = docElem.getNodeName();
      assertEquals("documentnormalizedocument09_False", "html", docElemNodeName);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentnormalizedocument09";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(documentnormalizedocument09.class, args);
   }
}

