/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, iio, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */

static const char* __doc_gr_iio_fmcomms2_sink = R"doc(Device specific sink for FMComms evaluation cards.

This block is a sink specifically designed for FMComms2/3/4 evaluation cards. However, it should support any AD936x based device using an IIO driver.

Constructor Specific Documentation:



Args:
    uri : 
    ch_en : 
    buffer_size : 
    cyclic : )doc";

static const char* __doc_gr_iio_fmcomms2_sink_make = R"doc(Device specific sink for FMComms evaluation cards.

This block is a sink specifically designed for FMComms2/3/4 evaluation cards. However, it should support any AD936x based device using an IIO driver.

Constructor Specific Documentation:



Args:
    uri : 
    ch_en : 
    buffer_size : 
    cyclic : )doc";

static const char* __doc_gr_iio_fmcomms2_sink_set_params = R"doc()doc";

static const char* __doc_gr_iio_fmcomms2_sink_set_len_tag_key = R"doc(The key of the tag that indicates packet length. When not empty, samples are expected as \"packets\" and must be tagged as such, i.e. the first sample of a packet needs to be tagged with the corresponding length of that packet. Note, packet size MUST be equal to buffer_size / (1+interpolation), otherwise a runtime_error will be thrown. This is a deliberate design choice, because all other options would result in potentially unexpected behavior.)doc";
