{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- GtkSymbolicColor is a boxed type that represents a symbolic color.
-- It is the result of parsing a
-- [color expression][gtkcssprovider-symbolic-colors].
-- To obtain the color represented by a GtkSymbolicColor, it has to
-- be resolved with 'GI.Gtk.Structs.SymbolicColor.symbolicColorResolve', which replaces all
-- symbolic color references by the colors they refer to (in a given
-- context) and evaluates mix, shade and other expressions, resulting
-- in a t'GI.Gdk.Structs.RGBA.RGBA' value.
-- 
-- It is not normally necessary to deal directly with @/GtkSymbolicColors/@,
-- since they are mostly used behind the scenes by t'GI.Gtk.Objects.StyleContext.StyleContext' and
-- t'GI.Gtk.Objects.CssProvider.CssProvider'.
-- 
-- t'GI.Gtk.Structs.SymbolicColor.SymbolicColor' is deprecated. Symbolic colors are considered an
-- implementation detail of GTK+.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Structs.SymbolicColor
    ( 

-- * Exported types
    SymbolicColor(..)                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gtk.Structs.SymbolicColor#g:method:ref"), [resolve]("GI.Gtk.Structs.SymbolicColor#g:method:resolve"), [toString]("GI.Gtk.Structs.SymbolicColor#g:method:toString"), [unref]("GI.Gtk.Structs.SymbolicColor#g:method:unref").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveSymbolicColorMethod              ,
#endif

-- ** newAlpha #method:newAlpha#

    symbolicColorNewAlpha                   ,


-- ** newLiteral #method:newLiteral#

    symbolicColorNewLiteral                 ,


-- ** newMix #method:newMix#

    symbolicColorNewMix                     ,


-- ** newName #method:newName#

    symbolicColorNewName                    ,


-- ** newShade #method:newShade#

    symbolicColorNewShade                   ,


-- ** newWin32 #method:newWin32#

    symbolicColorNewWin32                   ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    SymbolicColorRefMethodInfo              ,
#endif
    symbolicColorRef                        ,


-- ** resolve #method:resolve#

#if defined(ENABLE_OVERLOADING)
    SymbolicColorResolveMethodInfo          ,
#endif
    symbolicColorResolve                    ,


-- ** toString #method:toString#

#if defined(ENABLE_OVERLOADING)
    SymbolicColorToStringMethodInfo         ,
#endif
    symbolicColorToString                   ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    SymbolicColorUnrefMethodInfo            ,
#endif
    symbolicColorUnref                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Atk.Interfaces.ImplementorIface as Atk.ImplementorIface
import qualified GI.Atk.Objects.Object as Atk.Object
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.MarkupParser as GLib.MarkupParser
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Enums as Gdk.Enums
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Screen as Gdk.Screen
import qualified GI.Gdk.Objects.Visual as Gdk.Visual
import qualified GI.Gdk.Objects.Window as Gdk.Window
import qualified GI.Gdk.Structs.Atom as Gdk.Atom
import qualified GI.Gdk.Structs.Color as Gdk.Color
import qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.AccelGroup as Gtk.AccelGroup
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.Bin as Gtk.Bin
import {-# SOURCE #-} qualified GI.Gtk.Objects.Builder as Gtk.Builder
import {-# SOURCE #-} qualified GI.Gtk.Objects.Clipboard as Gtk.Clipboard
import {-# SOURCE #-} qualified GI.Gtk.Objects.Container as Gtk.Container
import {-# SOURCE #-} qualified GI.Gtk.Objects.IconFactory as Gtk.IconFactory
import {-# SOURCE #-} qualified GI.Gtk.Objects.RcStyle as Gtk.RcStyle
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Style as Gtk.Style
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleProperties as Gtk.StyleProperties
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextBuffer as Gtk.TextBuffer
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextChildAnchor as Gtk.TextChildAnchor
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextMark as Gtk.TextMark
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextTag as Gtk.TextTag
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextTagTable as Gtk.TextTagTable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.AccelGroupEntry as Gtk.AccelGroupEntry
import {-# SOURCE #-} qualified GI.Gtk.Structs.AccelKey as Gtk.AccelKey
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.CssSection as Gtk.CssSection
import {-# SOURCE #-} qualified GI.Gtk.Structs.IconSet as Gtk.IconSet
import {-# SOURCE #-} qualified GI.Gtk.Structs.IconSource as Gtk.IconSource
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import {-# SOURCE #-} qualified GI.Gtk.Structs.SelectionData as Gtk.SelectionData
import {-# SOURCE #-} qualified GI.Gtk.Structs.SettingsValue as Gtk.SettingsValue
import {-# SOURCE #-} qualified GI.Gtk.Structs.TargetEntry as Gtk.TargetEntry
import {-# SOURCE #-} qualified GI.Gtk.Structs.TargetList as Gtk.TargetList
import {-# SOURCE #-} qualified GI.Gtk.Structs.TextAppearance as Gtk.TextAppearance
import {-# SOURCE #-} qualified GI.Gtk.Structs.TextAttributes as Gtk.TextAttributes
import {-# SOURCE #-} qualified GI.Gtk.Structs.TextIter as Gtk.TextIter
import {-# SOURCE #-} qualified GI.Gtk.Structs.WidgetPath as Gtk.WidgetPath
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout
import qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import qualified GI.Pango.Structs.Language as Pango.Language
import qualified GI.Pango.Structs.TabArray as Pango.TabArray

#else
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleProperties as Gtk.StyleProperties

#endif

-- | Memory-managed wrapper type.
newtype SymbolicColor = SymbolicColor (SP.ManagedPtr SymbolicColor)
    deriving (Eq)

instance SP.ManagedPtrNewtype SymbolicColor where
    toManagedPtr (SymbolicColor p) = p

foreign import ccall "gtk_symbolic_color_get_type" c_gtk_symbolic_color_get_type :: 
    IO GType

type instance O.ParentTypes SymbolicColor = '[]
instance O.HasParentTypes SymbolicColor

instance B.Types.TypedObject SymbolicColor where
    glibType = c_gtk_symbolic_color_get_type

instance B.Types.GBoxed SymbolicColor

-- | Convert t'SymbolicColor' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SymbolicColor) where
    gvalueGType_ = c_gtk_symbolic_color_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr SymbolicColor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr SymbolicColor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed SymbolicColor ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SymbolicColor
type instance O.AttributeList SymbolicColor = SymbolicColorAttributeList
type SymbolicColorAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method SymbolicColor::new_alpha
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "color"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SymbolicColor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another #GtkSymbolicColor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factor"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "factor to apply to @color alpha"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SymbolicColor" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_symbolic_color_new_alpha" gtk_symbolic_color_new_alpha :: 
    Ptr SymbolicColor ->                    -- color : TInterface (Name {namespace = "Gtk", name = "SymbolicColor"})
    CDouble ->                              -- factor : TBasicType TDouble
    IO (Ptr SymbolicColor)

{-# DEPRECATED symbolicColorNewAlpha ["(Since version 3.8)","t'GI.Gtk.Structs.SymbolicColor.SymbolicColor' is deprecated."] #-}
-- | Creates a symbolic color by modifying the relative alpha
-- value of /@color@/. A factor \< 1.0 would resolve to a more
-- transparent color, while > 1.0 would resolve to a more
-- opaque color.
-- 
-- /Since: 3.0/
symbolicColorNewAlpha ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SymbolicColor
    -- ^ /@color@/: another t'GI.Gtk.Structs.SymbolicColor.SymbolicColor'
    -> Double
    -- ^ /@factor@/: factor to apply to /@color@/ alpha
    -> m SymbolicColor
    -- ^ __Returns:__ A newly created t'GI.Gtk.Structs.SymbolicColor.SymbolicColor'
symbolicColorNewAlpha color factor = liftIO $ do
    color' <- unsafeManagedPtrGetPtr color
    let factor' = realToFrac factor
    result <- gtk_symbolic_color_new_alpha color' factor'
    checkUnexpectedReturnNULL "symbolicColorNewAlpha" result
    result' <- (wrapBoxed SymbolicColor) result
    touchManagedPtr color
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SymbolicColor::new_literal
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "color"
--           , argType = TInterface Name { namespace = "Gdk" , name = "RGBA" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkRGBA" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SymbolicColor" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_symbolic_color_new_literal" gtk_symbolic_color_new_literal :: 
    Ptr Gdk.RGBA.RGBA ->                    -- color : TInterface (Name {namespace = "Gdk", name = "RGBA"})
    IO (Ptr SymbolicColor)

{-# DEPRECATED symbolicColorNewLiteral ["(Since version 3.8)","t'GI.Gtk.Structs.SymbolicColor.SymbolicColor' is deprecated."] #-}
-- | Creates a symbolic color pointing to a literal color.
-- 
-- /Since: 3.0/
symbolicColorNewLiteral ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gdk.RGBA.RGBA
    -- ^ /@color@/: a t'GI.Gdk.Structs.RGBA.RGBA'
    -> m SymbolicColor
    -- ^ __Returns:__ a newly created t'GI.Gtk.Structs.SymbolicColor.SymbolicColor'
symbolicColorNewLiteral color = liftIO $ do
    color' <- unsafeManagedPtrGetPtr color
    result <- gtk_symbolic_color_new_literal color'
    checkUnexpectedReturnNULL "symbolicColorNewLiteral" result
    result' <- (wrapBoxed SymbolicColor) result
    touchManagedPtr color
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SymbolicColor::new_mix
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "color1"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SymbolicColor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "color to mix" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color2"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SymbolicColor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another color to mix"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factor"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "mix factor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SymbolicColor" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_symbolic_color_new_mix" gtk_symbolic_color_new_mix :: 
    Ptr SymbolicColor ->                    -- color1 : TInterface (Name {namespace = "Gtk", name = "SymbolicColor"})
    Ptr SymbolicColor ->                    -- color2 : TInterface (Name {namespace = "Gtk", name = "SymbolicColor"})
    CDouble ->                              -- factor : TBasicType TDouble
    IO (Ptr SymbolicColor)

{-# DEPRECATED symbolicColorNewMix ["(Since version 3.8)","t'GI.Gtk.Structs.SymbolicColor.SymbolicColor' is deprecated."] #-}
-- | Creates a symbolic color defined as a mix of another
-- two colors. a mix factor of 0 would resolve to /@color1@/,
-- while a factor of 1 would resolve to /@color2@/.
-- 
-- /Since: 3.0/
symbolicColorNewMix ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SymbolicColor
    -- ^ /@color1@/: color to mix
    -> SymbolicColor
    -- ^ /@color2@/: another color to mix
    -> Double
    -- ^ /@factor@/: mix factor
    -> m SymbolicColor
    -- ^ __Returns:__ A newly created t'GI.Gtk.Structs.SymbolicColor.SymbolicColor'
symbolicColorNewMix color1 color2 factor = liftIO $ do
    color1' <- unsafeManagedPtrGetPtr color1
    color2' <- unsafeManagedPtrGetPtr color2
    let factor' = realToFrac factor
    result <- gtk_symbolic_color_new_mix color1' color2' factor'
    checkUnexpectedReturnNULL "symbolicColorNewMix" result
    result' <- (wrapBoxed SymbolicColor) result
    touchManagedPtr color1
    touchManagedPtr color2
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SymbolicColor::new_name
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "color name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SymbolicColor" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_symbolic_color_new_name" gtk_symbolic_color_new_name :: 
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr SymbolicColor)

{-# DEPRECATED symbolicColorNewName ["(Since version 3.8)","t'GI.Gtk.Structs.SymbolicColor.SymbolicColor' is deprecated."] #-}
-- | Creates a symbolic color pointing to an unresolved named
-- color. See 'GI.Gtk.Objects.StyleContext.styleContextLookupColor' and
-- 'GI.Gtk.Objects.StyleProperties.stylePropertiesLookupColor'.
-- 
-- /Since: 3.0/
symbolicColorNewName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: color name
    -> m SymbolicColor
    -- ^ __Returns:__ a newly created t'GI.Gtk.Structs.SymbolicColor.SymbolicColor'
symbolicColorNewName name = liftIO $ do
    name' <- textToCString name
    result <- gtk_symbolic_color_new_name name'
    checkUnexpectedReturnNULL "symbolicColorNewName" result
    result' <- (wrapBoxed SymbolicColor) result
    freeMem name'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SymbolicColor::new_shade
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "color"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SymbolicColor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another #GtkSymbolicColor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factor"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "shading factor to apply to @color"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SymbolicColor" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_symbolic_color_new_shade" gtk_symbolic_color_new_shade :: 
    Ptr SymbolicColor ->                    -- color : TInterface (Name {namespace = "Gtk", name = "SymbolicColor"})
    CDouble ->                              -- factor : TBasicType TDouble
    IO (Ptr SymbolicColor)

{-# DEPRECATED symbolicColorNewShade ["(Since version 3.8)","t'GI.Gtk.Structs.SymbolicColor.SymbolicColor' is deprecated."] #-}
-- | Creates a symbolic color defined as a shade of
-- another color. A factor > 1.0 would resolve to
-- a brighter color, while \< 1.0 would resolve to
-- a darker color.
-- 
-- /Since: 3.0/
symbolicColorNewShade ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SymbolicColor
    -- ^ /@color@/: another t'GI.Gtk.Structs.SymbolicColor.SymbolicColor'
    -> Double
    -- ^ /@factor@/: shading factor to apply to /@color@/
    -> m SymbolicColor
    -- ^ __Returns:__ A newly created t'GI.Gtk.Structs.SymbolicColor.SymbolicColor'
symbolicColorNewShade color factor = liftIO $ do
    color' <- unsafeManagedPtrGetPtr color
    let factor' = realToFrac factor
    result <- gtk_symbolic_color_new_shade color' factor'
    checkUnexpectedReturnNULL "symbolicColorNewShade" result
    result' <- (wrapBoxed SymbolicColor) result
    touchManagedPtr color
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SymbolicColor::new_win32
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "theme_class"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The theme class to pull color from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The color id" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SymbolicColor" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_symbolic_color_new_win32" gtk_symbolic_color_new_win32 :: 
    CString ->                              -- theme_class : TBasicType TUTF8
    Int32 ->                                -- id : TBasicType TInt
    IO (Ptr SymbolicColor)

{-# DEPRECATED symbolicColorNewWin32 ["(Since version 3.8)","t'GI.Gtk.Structs.SymbolicColor.SymbolicColor' is deprecated."] #-}
-- | Creates a symbolic color based on the current win32
-- theme.
-- 
-- Note that while this call is available on all platforms
-- the actual value returned is not reliable on non-win32
-- platforms.
-- 
-- /Since: 3.4/
symbolicColorNewWin32 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@themeClass@/: The theme class to pull color from
    -> Int32
    -- ^ /@id@/: The color id
    -> m SymbolicColor
    -- ^ __Returns:__ A newly created t'GI.Gtk.Structs.SymbolicColor.SymbolicColor'
symbolicColorNewWin32 themeClass id = liftIO $ do
    themeClass' <- textToCString themeClass
    result <- gtk_symbolic_color_new_win32 themeClass' id
    checkUnexpectedReturnNULL "symbolicColorNewWin32" result
    result' <- (wrapBoxed SymbolicColor) result
    freeMem themeClass'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SymbolicColor::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "color"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SymbolicColor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkSymbolicColor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SymbolicColor" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_symbolic_color_ref" gtk_symbolic_color_ref :: 
    Ptr SymbolicColor ->                    -- color : TInterface (Name {namespace = "Gtk", name = "SymbolicColor"})
    IO (Ptr SymbolicColor)

{-# DEPRECATED symbolicColorRef ["(Since version 3.8)","t'GI.Gtk.Structs.SymbolicColor.SymbolicColor' is deprecated."] #-}
-- | Increases the reference count of /@color@/
-- 
-- /Since: 3.0/
symbolicColorRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SymbolicColor
    -- ^ /@color@/: a t'GI.Gtk.Structs.SymbolicColor.SymbolicColor'
    -> m SymbolicColor
    -- ^ __Returns:__ the same /@color@/
symbolicColorRef color = liftIO $ do
    color' <- unsafeManagedPtrGetPtr color
    result <- gtk_symbolic_color_ref color'
    checkUnexpectedReturnNULL "symbolicColorRef" result
    result' <- (wrapBoxed SymbolicColor) result
    touchManagedPtr color
    return result'

#if defined(ENABLE_OVERLOADING)
data SymbolicColorRefMethodInfo
instance (signature ~ (m SymbolicColor), MonadIO m) => O.OverloadedMethod SymbolicColorRefMethodInfo SymbolicColor signature where
    overloadedMethod = symbolicColorRef

instance O.OverloadedMethodInfo SymbolicColorRefMethodInfo SymbolicColor where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.SymbolicColor.symbolicColorRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.43/docs/GI-Gtk-Structs-SymbolicColor.html#v:symbolicColorRef"
        })


#endif

-- method SymbolicColor::resolve
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "color"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SymbolicColor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkSymbolicColor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "props"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StyleProperties" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "#GtkStyleProperties to use when resolving\n   named colors, or %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resolved_color"
--           , argType = TInterface Name { namespace = "Gdk" , name = "RGBA" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the resolved color"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_symbolic_color_resolve" gtk_symbolic_color_resolve :: 
    Ptr SymbolicColor ->                    -- color : TInterface (Name {namespace = "Gtk", name = "SymbolicColor"})
    Ptr Gtk.StyleProperties.StyleProperties -> -- props : TInterface (Name {namespace = "Gtk", name = "StyleProperties"})
    Ptr Gdk.RGBA.RGBA ->                    -- resolved_color : TInterface (Name {namespace = "Gdk", name = "RGBA"})
    IO CInt

{-# DEPRECATED symbolicColorResolve ["(Since version 3.8)","t'GI.Gtk.Structs.SymbolicColor.SymbolicColor' is deprecated."] #-}
-- | If /@color@/ is resolvable, /@resolvedColor@/ will be filled in
-- with the resolved color, and 'P.True' will be returned. Generally,
-- if /@color@/ can’t be resolved, it is due to it being defined on
-- top of a named color that doesn’t exist in /@props@/.
-- 
-- When /@props@/ is 'P.Nothing', resolving of named colors will fail, so if
-- your /@color@/ is or references such a color, this function will
-- return 'P.False'.
-- 
-- /Since: 3.0/
symbolicColorResolve ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.StyleProperties.IsStyleProperties a) =>
    SymbolicColor
    -- ^ /@color@/: a t'GI.Gtk.Structs.SymbolicColor.SymbolicColor'
    -> Maybe (a)
    -- ^ /@props@/: t'GI.Gtk.Objects.StyleProperties.StyleProperties' to use when resolving
    --    named colors, or 'P.Nothing'
    -> m ((Bool, Gdk.RGBA.RGBA))
    -- ^ __Returns:__ 'P.True' if the color has been resolved
symbolicColorResolve color props = liftIO $ do
    color' <- unsafeManagedPtrGetPtr color
    maybeProps <- case props of
        Nothing -> return FP.nullPtr
        Just jProps -> do
            jProps' <- unsafeManagedPtrCastPtr jProps
            return jProps'
    resolvedColor <- SP.callocBoxedBytes 32 :: IO (Ptr Gdk.RGBA.RGBA)
    result <- gtk_symbolic_color_resolve color' maybeProps resolvedColor
    let result' = (/= 0) result
    resolvedColor' <- (wrapBoxed Gdk.RGBA.RGBA) resolvedColor
    touchManagedPtr color
    whenJust props touchManagedPtr
    return (result', resolvedColor')

#if defined(ENABLE_OVERLOADING)
data SymbolicColorResolveMethodInfo
instance (signature ~ (Maybe (a) -> m ((Bool, Gdk.RGBA.RGBA))), MonadIO m, Gtk.StyleProperties.IsStyleProperties a) => O.OverloadedMethod SymbolicColorResolveMethodInfo SymbolicColor signature where
    overloadedMethod = symbolicColorResolve

instance O.OverloadedMethodInfo SymbolicColorResolveMethodInfo SymbolicColor where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.SymbolicColor.symbolicColorResolve",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.43/docs/GI-Gtk-Structs-SymbolicColor.html#v:symbolicColorResolve"
        })


#endif

-- method SymbolicColor::to_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "color"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SymbolicColor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "color to convert to a string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_symbolic_color_to_string" gtk_symbolic_color_to_string :: 
    Ptr SymbolicColor ->                    -- color : TInterface (Name {namespace = "Gtk", name = "SymbolicColor"})
    IO CString

{-# DEPRECATED symbolicColorToString ["(Since version 3.8)","t'GI.Gtk.Structs.SymbolicColor.SymbolicColor' is deprecated."] #-}
-- | Converts the given /@color@/ to a string representation. This is useful
-- both for debugging and for serialization of strings. The format of
-- the string may change between different versions of GTK, but it is
-- guaranteed that the GTK css parser is able to read the string and
-- create the same symbolic color from it.
symbolicColorToString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SymbolicColor
    -- ^ /@color@/: color to convert to a string
    -> m T.Text
    -- ^ __Returns:__ a new string representing /@color@/
symbolicColorToString color = liftIO $ do
    color' <- unsafeManagedPtrGetPtr color
    result <- gtk_symbolic_color_to_string color'
    checkUnexpectedReturnNULL "symbolicColorToString" result
    result' <- cstringToText result
    freeMem result
    touchManagedPtr color
    return result'

#if defined(ENABLE_OVERLOADING)
data SymbolicColorToStringMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod SymbolicColorToStringMethodInfo SymbolicColor signature where
    overloadedMethod = symbolicColorToString

instance O.OverloadedMethodInfo SymbolicColorToStringMethodInfo SymbolicColor where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.SymbolicColor.symbolicColorToString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.43/docs/GI-Gtk-Structs-SymbolicColor.html#v:symbolicColorToString"
        })


#endif

-- method SymbolicColor::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "color"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SymbolicColor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkSymbolicColor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_symbolic_color_unref" gtk_symbolic_color_unref :: 
    Ptr SymbolicColor ->                    -- color : TInterface (Name {namespace = "Gtk", name = "SymbolicColor"})
    IO ()

{-# DEPRECATED symbolicColorUnref ["(Since version 3.8)","t'GI.Gtk.Structs.SymbolicColor.SymbolicColor' is deprecated."] #-}
-- | Decreases the reference count of /@color@/, freeing its memory if the
-- reference count reaches 0.
-- 
-- /Since: 3.0/
symbolicColorUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    SymbolicColor
    -- ^ /@color@/: a t'GI.Gtk.Structs.SymbolicColor.SymbolicColor'
    -> m ()
symbolicColorUnref color = liftIO $ do
    color' <- unsafeManagedPtrGetPtr color
    gtk_symbolic_color_unref color'
    touchManagedPtr color
    return ()

#if defined(ENABLE_OVERLOADING)
data SymbolicColorUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod SymbolicColorUnrefMethodInfo SymbolicColor signature where
    overloadedMethod = symbolicColorUnref

instance O.OverloadedMethodInfo SymbolicColorUnrefMethodInfo SymbolicColor where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.SymbolicColor.symbolicColorUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.43/docs/GI-Gtk-Structs-SymbolicColor.html#v:symbolicColorUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSymbolicColorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSymbolicColorMethod "ref" o = SymbolicColorRefMethodInfo
    ResolveSymbolicColorMethod "resolve" o = SymbolicColorResolveMethodInfo
    ResolveSymbolicColorMethod "toString" o = SymbolicColorToStringMethodInfo
    ResolveSymbolicColorMethod "unref" o = SymbolicColorUnrefMethodInfo
    ResolveSymbolicColorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSymbolicColorMethod t SymbolicColor, O.OverloadedMethod info SymbolicColor p) => OL.IsLabel t (SymbolicColor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSymbolicColorMethod t SymbolicColor, O.OverloadedMethod info SymbolicColor p, R.HasField t SymbolicColor p) => R.HasField t SymbolicColor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSymbolicColorMethod t SymbolicColor, O.OverloadedMethodInfo info SymbolicColor) => OL.IsLabel t (O.MethodProxy info SymbolicColor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


