{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @PangoGlyphVisAttr@ structure communicates information between
-- the shaping and rendering phases.
-- 
-- Currently, it contains cluster start and color information.
-- More attributes may be added in the future.
-- 
-- Clusters are stored in visual order, within the cluster, glyphs
-- are always ordered in logical order, since visual order is meaningless;
-- that is, in Arabic text, accent glyphs follow the glyphs for the
-- base character.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.GlyphVisAttr
    ( 

-- * Exported types
    GlyphVisAttr(..)                        ,
    newZeroGlyphVisAttr                     ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveGlyphVisAttrMethod               ,
#endif



 -- * Properties


-- ** isClusterStart #attr:isClusterStart#
-- | set for the first logical glyph in each cluster.

    getGlyphVisAttrIsClusterStart           ,
#if defined(ENABLE_OVERLOADING)
    glyphVisAttr_isClusterStart             ,
#endif
    setGlyphVisAttrIsClusterStart           ,


-- ** isColor #attr:isColor#
-- | set if the the font will render this glyph with color. Since 1.50

    getGlyphVisAttrIsColor                  ,
#if defined(ENABLE_OVERLOADING)
    glyphVisAttr_isColor                    ,
#endif
    setGlyphVisAttrIsColor                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype GlyphVisAttr = GlyphVisAttr (SP.ManagedPtr GlyphVisAttr)
    deriving (Eq)

instance SP.ManagedPtrNewtype GlyphVisAttr where
    toManagedPtr (GlyphVisAttr p) = p

instance BoxedPtr GlyphVisAttr where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 8 >=> B.ManagedPtr.wrapPtr GlyphVisAttr)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr GlyphVisAttr where
    boxedPtrCalloc = callocBytes 8


-- | Construct a t'GlyphVisAttr' struct initialized to zero.
newZeroGlyphVisAttr :: MonadIO m => m GlyphVisAttr
newZeroGlyphVisAttr = liftIO $ boxedPtrCalloc >>= wrapPtr GlyphVisAttr

instance tag ~ 'AttrSet => Constructible GlyphVisAttr tag where
    new _ attrs = do
        o <- newZeroGlyphVisAttr
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@is_cluster_start@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphVisAttr #isClusterStart
-- @
getGlyphVisAttrIsClusterStart :: MonadIO m => GlyphVisAttr -> m Word32
getGlyphVisAttrIsClusterStart s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@is_cluster_start@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphVisAttr [ #isClusterStart 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphVisAttrIsClusterStart :: MonadIO m => GlyphVisAttr -> Word32 -> m ()
setGlyphVisAttrIsClusterStart s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data GlyphVisAttrIsClusterStartFieldInfo
instance AttrInfo GlyphVisAttrIsClusterStartFieldInfo where
    type AttrBaseTypeConstraint GlyphVisAttrIsClusterStartFieldInfo = (~) GlyphVisAttr
    type AttrAllowedOps GlyphVisAttrIsClusterStartFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphVisAttrIsClusterStartFieldInfo = (~) Word32
    type AttrTransferTypeConstraint GlyphVisAttrIsClusterStartFieldInfo = (~)Word32
    type AttrTransferType GlyphVisAttrIsClusterStartFieldInfo = Word32
    type AttrGetType GlyphVisAttrIsClusterStartFieldInfo = Word32
    type AttrLabel GlyphVisAttrIsClusterStartFieldInfo = "is_cluster_start"
    type AttrOrigin GlyphVisAttrIsClusterStartFieldInfo = GlyphVisAttr
    attrGet = getGlyphVisAttrIsClusterStart
    attrSet = setGlyphVisAttrIsClusterStart
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphVisAttr.isClusterStart"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphVisAttr.html#g:attr:isClusterStart"
        })

glyphVisAttr_isClusterStart :: AttrLabelProxy "isClusterStart"
glyphVisAttr_isClusterStart = AttrLabelProxy

#endif


-- | Get the value of the “@is_color@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphVisAttr #isColor
-- @
getGlyphVisAttrIsColor :: MonadIO m => GlyphVisAttr -> m Word32
getGlyphVisAttrIsColor s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Word32
    return val

-- | Set the value of the “@is_color@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphVisAttr [ #isColor 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphVisAttrIsColor :: MonadIO m => GlyphVisAttr -> Word32 -> m ()
setGlyphVisAttrIsColor s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data GlyphVisAttrIsColorFieldInfo
instance AttrInfo GlyphVisAttrIsColorFieldInfo where
    type AttrBaseTypeConstraint GlyphVisAttrIsColorFieldInfo = (~) GlyphVisAttr
    type AttrAllowedOps GlyphVisAttrIsColorFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphVisAttrIsColorFieldInfo = (~) Word32
    type AttrTransferTypeConstraint GlyphVisAttrIsColorFieldInfo = (~)Word32
    type AttrTransferType GlyphVisAttrIsColorFieldInfo = Word32
    type AttrGetType GlyphVisAttrIsColorFieldInfo = Word32
    type AttrLabel GlyphVisAttrIsColorFieldInfo = "is_color"
    type AttrOrigin GlyphVisAttrIsColorFieldInfo = GlyphVisAttr
    attrGet = getGlyphVisAttrIsColor
    attrSet = setGlyphVisAttrIsColor
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphVisAttr.isColor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphVisAttr.html#g:attr:isColor"
        })

glyphVisAttr_isColor :: AttrLabelProxy "isColor"
glyphVisAttr_isColor = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GlyphVisAttr
type instance O.AttributeList GlyphVisAttr = GlyphVisAttrAttributeList
type GlyphVisAttrAttributeList = ('[ '("isClusterStart", GlyphVisAttrIsClusterStartFieldInfo), '("isColor", GlyphVisAttrIsColorFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveGlyphVisAttrMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGlyphVisAttrMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGlyphVisAttrMethod t GlyphVisAttr, O.OverloadedMethod info GlyphVisAttr p) => OL.IsLabel t (GlyphVisAttr -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGlyphVisAttrMethod t GlyphVisAttr, O.OverloadedMethod info GlyphVisAttr p, R.HasField t GlyphVisAttr p) => R.HasField t GlyphVisAttr p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGlyphVisAttrMethod t GlyphVisAttr, O.OverloadedMethodInfo info GlyphVisAttr) => OL.IsLabel t (O.MethodProxy info GlyphVisAttr) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


