/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Substitute the type names.  */
#define YYSTYPE         FRONTEND_VERILOG_YYSTYPE
#define YYLTYPE         FRONTEND_VERILOG_YYLTYPE
/* Substitute the variable and function names.  */
#define yyparse         frontend_verilog_yyparse
#define yylex           frontend_verilog_yylex
#define yyerror         frontend_verilog_yyerror
#define yydebug         frontend_verilog_yydebug
#define yynerrs         frontend_verilog_yynerrs

/* First part of user prologue.  */
#line 38 "frontends/verilog/verilog_parser.y"

#include <list>
#include <stack>
#include <string.h>
#include "frontends/verilog/verilog_frontend.h"
#include "frontends/verilog/verilog_parser.tab.hh"
#include "kernel/log.h"

#define YYLEX_PARAM &yylval, &yylloc

USING_YOSYS_NAMESPACE
using namespace AST;
using namespace VERILOG_FRONTEND;

YOSYS_NAMESPACE_BEGIN
namespace VERILOG_FRONTEND {
	int port_counter;
	dict<std::string, int> port_stubs;
	dict<IdString, AstNode*> *attr_list, default_attr_list;
	std::stack<dict<IdString, AstNode*> *> attr_list_stack;
	dict<IdString, AstNode*> *albuf;
	std::vector<UserTypeMap> user_type_stack;
	dict<std::string, AstNode*> pkg_user_types;
	std::vector<AstNode*> ast_stack;
	struct AstNode *astbuf1, *astbuf2, *astbuf3;
	struct AstNode *current_function_or_task;
	struct AstNode *current_ast, *current_ast_mod;
	int current_function_or_task_port_id;
	std::vector<char> case_type_stack;
	bool do_not_require_port_stubs;
	bool default_nettype_wire;
	bool sv_mode, formal_mode, lib_mode, specify_mode;
	bool noassert_mode, noassume_mode, norestrict_mode;
	bool assume_asserts_mode, assert_assumes_mode;
	bool current_wire_rand, current_wire_const;
	bool current_modport_input, current_modport_output;
	std::istream *lexin;
}
YOSYS_NAMESPACE_END

#define SET_AST_NODE_LOC(WHICH, BEGIN, END) \
    do { (WHICH)->location.first_line = (BEGIN).first_line; \
    (WHICH)->location.first_column = (BEGIN).first_column; \
    (WHICH)->location.last_line = (END).last_line; \
    (WHICH)->location.last_column = (END).last_column; } while(0)

#define SET_RULE_LOC(LHS, BEGIN, END) \
    do { (LHS).first_line = (BEGIN).first_line; \
    (LHS).first_column = (BEGIN).first_column; \
    (LHS).last_line = (END).last_line; \
    (LHS).last_column = (END).last_column; } while(0)

int frontend_verilog_yylex(YYSTYPE *yylval_param, YYLTYPE *yyloc_param);

static void append_attr(AstNode *ast, dict<IdString, AstNode*> *al)
{
	for (auto &it : *al) {
		if (ast->attributes.count(it.first) > 0)
			delete ast->attributes[it.first];
		ast->attributes[it.first] = it.second;
	}
	delete al;
}

static void append_attr_clone(AstNode *ast, dict<IdString, AstNode*> *al)
{
	for (auto &it : *al) {
		if (ast->attributes.count(it.first) > 0)
			delete ast->attributes[it.first];
		ast->attributes[it.first] = it.second->clone();
	}
}

static void free_attr(dict<IdString, AstNode*> *al)
{
	for (auto &it : *al)
		delete it.second;
	delete al;
}

struct specify_target {
	char polarity_op;
	AstNode *dst, *dat;
};

struct specify_triple {
	AstNode *t_min, *t_avg, *t_max;
};

struct specify_rise_fall {
	specify_triple rise;
	specify_triple fall;
};

static void addWiretypeNode(std::string *name, AstNode *node)
{
	log_assert(node);
	node->is_custom_type = true;
	node->children.push_back(new AstNode(AST_WIRETYPE));
	node->children.back()->str = *name;
	delete name;
}

static void addTypedefNode(std::string *name, AstNode *node)
{
	log_assert(node);
	auto *tnode = new AstNode(AST_TYPEDEF, node);
	tnode->str = *name;
	auto &user_types = user_type_stack.back();
	user_types[*name] = tnode;
	if (current_ast_mod && current_ast_mod->type == AST_PACKAGE) {
		// typedef inside a package so we need the qualified name
		auto qname = current_ast_mod->str + "::" + (*name).substr(1);
		pkg_user_types[qname] = tnode;
	}
	delete name;
	ast_stack.back()->children.push_back(tnode);
}

static void enterTypeScope()
{
	user_type_stack.push_back(UserTypeMap());
}

static void exitTypeScope()
{
	user_type_stack.pop_back();
}

static bool isInLocalScope(const std::string *name)
{
	// tests if a name was declared in the current block scope
	auto &user_types = user_type_stack.back();
	return (user_types.count(*name) > 0);
}

static AstNode *makeRange(int msb = 31, int lsb = 0, bool isSigned = true)
{
	auto range = new AstNode(AST_RANGE);
	range->children.push_back(AstNode::mkconst_int(msb, true));
	range->children.push_back(AstNode::mkconst_int(lsb, true));
	range->is_signed = isSigned;
	return range;
}

static void addRange(AstNode *parent, int msb = 31, int lsb = 0, bool isSigned = true)
{
	auto range = makeRange(msb, lsb, isSigned);
	parent->children.push_back(range);
}

static AstNode *checkRange(AstNode *type_node, AstNode *range_node)
{
	if (type_node->range_left >= 0 && type_node->range_right >= 0) {
		// type already restricts the range
		if (range_node) {
			frontend_verilog_yyerror("integer/genvar types cannot have packed dimensions.");
		}
		else {
			range_node = makeRange(type_node->range_left, type_node->range_right, false);
		}
	}

	if (range_node) {
		bool valid = true;
		if (range_node->type == AST_RANGE) {
			valid = range_node->children.size() == 2;
		} else {  // AST_MULTIRANGE
			for (auto child : range_node->children) {
				valid = valid && child->children.size() == 2;
			}
		}
		if (!valid)
			frontend_verilog_yyerror("wire/reg/logic packed dimension must be of the form [<expr>:<expr>]");
	}

	return range_node;
}

static void rewriteRange(AstNode *rangeNode)
{
	if (rangeNode->type == AST_RANGE && rangeNode->children.size() == 1) {
		// SV array size [n], rewrite as [0:n-1]
		rangeNode->children.push_back(new AstNode(AST_SUB, rangeNode->children[0], AstNode::mkconst_int(1, true)));
		rangeNode->children[0] = AstNode::mkconst_int(0, false);
	}
}

static void rewriteAsMemoryNode(AstNode *node, AstNode *rangeNode)
{
	node->type = AST_MEMORY;
	if (rangeNode->type == AST_MULTIRANGE) {
		for (auto *itr : rangeNode->children)
			rewriteRange(itr);
	} else
		rewriteRange(rangeNode);
	node->children.push_back(rangeNode);
}

static void checkLabelsMatch(const char *element, const std::string *before, const std::string *after)
{
	if (!before && after)
		frontend_verilog_yyerror("%s missing where end label (%s) was given.",
			element, after->c_str() + 1);
	if (before && after && *before != *after)
		frontend_verilog_yyerror("%s (%s) and end label (%s) don't match.",
			element, before->c_str() + 1, after->c_str() + 1);
}

// This transforms a loop like
//   for (genvar i = 0; i < 10; i++) begin : blk
// to
//   genvar _i;
//   for (_i = 0; _i < 10; _i++) begin : blk
//     localparam i = _i;
// where `_i` is actually some auto-generated name.
static void rewriteGenForDeclInit(AstNode *loop)
{
	// check if this generate for loop contains an inline declaration
	log_assert(loop->type == AST_GENFOR);
	AstNode *decl = loop->children[0];
	if (decl->type == AST_ASSIGN_EQ)
		return;
	log_assert(decl->type == AST_GENVAR);
	log_assert(loop->children.size() == 5);

	// identify each component of the loop
	AstNode *init = loop->children[1];
	AstNode *cond = loop->children[2];
	AstNode *incr = loop->children[3];
	AstNode *body = loop->children[4];
	log_assert(init->type == AST_ASSIGN_EQ);
	log_assert(incr->type == AST_ASSIGN_EQ);
	log_assert(body->type == AST_GENBLOCK);

	// create a unique name for the genvar
	std::string old_str = decl->str;
	std::string new_str = stringf("$genfordecl$%d$%s", autoidx++, old_str.c_str());

	// rename and move the genvar declaration to the containing description
	decl->str = new_str;
	loop->children.erase(loop->children.begin());
	log_assert(current_ast_mod != nullptr);
	current_ast_mod->children.push_back(decl);

	// create a new localparam with old name so that the items in the loop
	// can simply use the old name and shadow it as necessary
	AstNode *indirect = new AstNode(AST_LOCALPARAM);
	indirect->str = old_str;
	AstNode *ident = new AstNode(AST_IDENTIFIER);
	ident->str = new_str;
	indirect->children.push_back(ident);

	body->children.insert(body->children.begin(), indirect);

	// only perform the renaming for the initialization, guard, and
	// incrementation to enable proper shadowing of the synthetic localparam
	std::function<void(AstNode*)> substitute = [&](AstNode *node) {
		if (node->type == AST_IDENTIFIER && node->str == old_str)
			node->str = new_str;
		for (AstNode *child : node->children)
			substitute(child);
	};
	substitute(init);
	substitute(cond);
	substitute(incr);
}

static void ensureAsgnExprAllowed()
{
	if (!sv_mode)
		frontend_verilog_yyerror("Assignments within expressions are only supported in SystemVerilog mode.");
	if (ast_stack.back()->type != AST_BLOCK)
		frontend_verilog_yyerror("Assignments within expressions are only permitted within procedures.");
}

// add a pre/post-increment/decrement statement
static const AstNode *addIncOrDecStmt(dict<IdString, AstNode*> *stmt_attr, AstNode *lhs,
				      dict<IdString, AstNode*> *op_attr, AST::AstNodeType op,
				      YYLTYPE begin, YYLTYPE end)
{
	AstNode *one = AstNode::mkconst_int(1, true);
	AstNode *rhs = new AstNode(op, lhs->clone(), one);
	if (op_attr != nullptr)
		append_attr(rhs, op_attr);
	AstNode *stmt = new AstNode(AST_ASSIGN_EQ, lhs, rhs);
	SET_AST_NODE_LOC(stmt, begin, end);
	if (stmt_attr != nullptr)
		append_attr(stmt, stmt_attr);
	ast_stack.back()->children.push_back(stmt);
	return stmt;
}

// create a pre/post-increment/decrement expression, and add the corresponding statement
static AstNode *addIncOrDecExpr(AstNode *lhs, dict<IdString, AstNode*> *attr, AST::AstNodeType op, YYLTYPE begin, YYLTYPE end, bool undo)
{
	ensureAsgnExprAllowed();
	const AstNode *stmt = addIncOrDecStmt(nullptr, lhs, attr, op, begin, end);
	log_assert(stmt->type == AST_ASSIGN_EQ);
	AstNode *expr = stmt->children[0]->clone();
	if (undo) {
		AstNode *one = AstNode::mkconst_int(1, false, 1);
		AstNode *minus_one = new AstNode(AST_NEG, one);
		expr = new AstNode(op, expr, minus_one);
	}
	SET_AST_NODE_LOC(expr, begin, end);
	return expr;
}

// add a binary operator assignment statement, e.g., a += b
static const AstNode *addAsgnBinopStmt(dict<IdString, AstNode*> *attr, AstNode *lhs, AST::AstNodeType op, AstNode *rhs, YYLTYPE begin, YYLTYPE end)
{
	SET_AST_NODE_LOC(rhs, end, end);
	if (op == AST_SHIFT_LEFT || op == AST_SHIFT_RIGHT ||
		op == AST_SHIFT_SLEFT || op == AST_SHIFT_SRIGHT) {
		rhs = new AstNode(AST_TO_UNSIGNED, rhs);
		SET_AST_NODE_LOC(rhs, end, end);
	}
	rhs = new AstNode(op, lhs->clone(), rhs);
	AstNode *stmt = new AstNode(AST_ASSIGN_EQ, lhs, rhs);
	SET_AST_NODE_LOC(rhs, begin, end);
	SET_AST_NODE_LOC(stmt, begin, end);
	ast_stack.back()->children.push_back(stmt);
	if (attr != nullptr)
		append_attr(stmt, attr);
	return lhs;
}


#line 408 "frontends/verilog/verilog_parser.tab.cc"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "verilog_parser.tab.hh"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_TOK_STRING = 3,                 /* TOK_STRING  */
  YYSYMBOL_TOK_ID = 4,                     /* TOK_ID  */
  YYSYMBOL_TOK_CONSTVAL = 5,               /* TOK_CONSTVAL  */
  YYSYMBOL_TOK_REALVAL = 6,                /* TOK_REALVAL  */
  YYSYMBOL_TOK_PRIMITIVE = 7,              /* TOK_PRIMITIVE  */
  YYSYMBOL_TOK_SVA_LABEL = 8,              /* TOK_SVA_LABEL  */
  YYSYMBOL_TOK_SPECIFY_OPER = 9,           /* TOK_SPECIFY_OPER  */
  YYSYMBOL_TOK_MSG_TASKS = 10,             /* TOK_MSG_TASKS  */
  YYSYMBOL_TOK_BASE = 11,                  /* TOK_BASE  */
  YYSYMBOL_TOK_BASED_CONSTVAL = 12,        /* TOK_BASED_CONSTVAL  */
  YYSYMBOL_TOK_UNBASED_UNSIZED_CONSTVAL = 13, /* TOK_UNBASED_UNSIZED_CONSTVAL  */
  YYSYMBOL_TOK_USER_TYPE = 14,             /* TOK_USER_TYPE  */
  YYSYMBOL_TOK_PKG_USER_TYPE = 15,         /* TOK_PKG_USER_TYPE  */
  YYSYMBOL_TOK_ASSERT = 16,                /* TOK_ASSERT  */
  YYSYMBOL_TOK_ASSUME = 17,                /* TOK_ASSUME  */
  YYSYMBOL_TOK_RESTRICT = 18,              /* TOK_RESTRICT  */
  YYSYMBOL_TOK_COVER = 19,                 /* TOK_COVER  */
  YYSYMBOL_TOK_FINAL = 20,                 /* TOK_FINAL  */
  YYSYMBOL_ATTR_BEGIN = 21,                /* ATTR_BEGIN  */
  YYSYMBOL_ATTR_END = 22,                  /* ATTR_END  */
  YYSYMBOL_DEFATTR_BEGIN = 23,             /* DEFATTR_BEGIN  */
  YYSYMBOL_DEFATTR_END = 24,               /* DEFATTR_END  */
  YYSYMBOL_TOK_MODULE = 25,                /* TOK_MODULE  */
  YYSYMBOL_TOK_ENDMODULE = 26,             /* TOK_ENDMODULE  */
  YYSYMBOL_TOK_PARAMETER = 27,             /* TOK_PARAMETER  */
  YYSYMBOL_TOK_LOCALPARAM = 28,            /* TOK_LOCALPARAM  */
  YYSYMBOL_TOK_DEFPARAM = 29,              /* TOK_DEFPARAM  */
  YYSYMBOL_TOK_PACKAGE = 30,               /* TOK_PACKAGE  */
  YYSYMBOL_TOK_ENDPACKAGE = 31,            /* TOK_ENDPACKAGE  */
  YYSYMBOL_TOK_PACKAGESEP = 32,            /* TOK_PACKAGESEP  */
  YYSYMBOL_TOK_INTERFACE = 33,             /* TOK_INTERFACE  */
  YYSYMBOL_TOK_ENDINTERFACE = 34,          /* TOK_ENDINTERFACE  */
  YYSYMBOL_TOK_MODPORT = 35,               /* TOK_MODPORT  */
  YYSYMBOL_TOK_VAR = 36,                   /* TOK_VAR  */
  YYSYMBOL_TOK_WILDCARD_CONNECT = 37,      /* TOK_WILDCARD_CONNECT  */
  YYSYMBOL_TOK_INPUT = 38,                 /* TOK_INPUT  */
  YYSYMBOL_TOK_OUTPUT = 39,                /* TOK_OUTPUT  */
  YYSYMBOL_TOK_INOUT = 40,                 /* TOK_INOUT  */
  YYSYMBOL_TOK_WIRE = 41,                  /* TOK_WIRE  */
  YYSYMBOL_TOK_WAND = 42,                  /* TOK_WAND  */
  YYSYMBOL_TOK_WOR = 43,                   /* TOK_WOR  */
  YYSYMBOL_TOK_REG = 44,                   /* TOK_REG  */
  YYSYMBOL_TOK_LOGIC = 45,                 /* TOK_LOGIC  */
  YYSYMBOL_TOK_INTEGER = 46,               /* TOK_INTEGER  */
  YYSYMBOL_TOK_SIGNED = 47,                /* TOK_SIGNED  */
  YYSYMBOL_TOK_ASSIGN = 48,                /* TOK_ASSIGN  */
  YYSYMBOL_TOK_ALWAYS = 49,                /* TOK_ALWAYS  */
  YYSYMBOL_TOK_INITIAL = 50,               /* TOK_INITIAL  */
  YYSYMBOL_TOK_ALWAYS_FF = 51,             /* TOK_ALWAYS_FF  */
  YYSYMBOL_TOK_ALWAYS_COMB = 52,           /* TOK_ALWAYS_COMB  */
  YYSYMBOL_TOK_ALWAYS_LATCH = 53,          /* TOK_ALWAYS_LATCH  */
  YYSYMBOL_TOK_BEGIN = 54,                 /* TOK_BEGIN  */
  YYSYMBOL_TOK_END = 55,                   /* TOK_END  */
  YYSYMBOL_TOK_IF = 56,                    /* TOK_IF  */
  YYSYMBOL_TOK_ELSE = 57,                  /* TOK_ELSE  */
  YYSYMBOL_TOK_FOR = 58,                   /* TOK_FOR  */
  YYSYMBOL_TOK_WHILE = 59,                 /* TOK_WHILE  */
  YYSYMBOL_TOK_REPEAT = 60,                /* TOK_REPEAT  */
  YYSYMBOL_TOK_DPI_FUNCTION = 61,          /* TOK_DPI_FUNCTION  */
  YYSYMBOL_TOK_POSEDGE = 62,               /* TOK_POSEDGE  */
  YYSYMBOL_TOK_NEGEDGE = 63,               /* TOK_NEGEDGE  */
  YYSYMBOL_TOK_OR = 64,                    /* TOK_OR  */
  YYSYMBOL_TOK_AUTOMATIC = 65,             /* TOK_AUTOMATIC  */
  YYSYMBOL_TOK_CASE = 66,                  /* TOK_CASE  */
  YYSYMBOL_TOK_CASEX = 67,                 /* TOK_CASEX  */
  YYSYMBOL_TOK_CASEZ = 68,                 /* TOK_CASEZ  */
  YYSYMBOL_TOK_ENDCASE = 69,               /* TOK_ENDCASE  */
  YYSYMBOL_TOK_DEFAULT = 70,               /* TOK_DEFAULT  */
  YYSYMBOL_TOK_FUNCTION = 71,              /* TOK_FUNCTION  */
  YYSYMBOL_TOK_ENDFUNCTION = 72,           /* TOK_ENDFUNCTION  */
  YYSYMBOL_TOK_TASK = 73,                  /* TOK_TASK  */
  YYSYMBOL_TOK_ENDTASK = 74,               /* TOK_ENDTASK  */
  YYSYMBOL_TOK_SPECIFY = 75,               /* TOK_SPECIFY  */
  YYSYMBOL_TOK_IGNORED_SPECIFY = 76,       /* TOK_IGNORED_SPECIFY  */
  YYSYMBOL_TOK_ENDSPECIFY = 77,            /* TOK_ENDSPECIFY  */
  YYSYMBOL_TOK_SPECPARAM = 78,             /* TOK_SPECPARAM  */
  YYSYMBOL_TOK_SPECIFY_AND = 79,           /* TOK_SPECIFY_AND  */
  YYSYMBOL_TOK_IGNORED_SPECIFY_AND = 80,   /* TOK_IGNORED_SPECIFY_AND  */
  YYSYMBOL_TOK_GENERATE = 81,              /* TOK_GENERATE  */
  YYSYMBOL_TOK_ENDGENERATE = 82,           /* TOK_ENDGENERATE  */
  YYSYMBOL_TOK_GENVAR = 83,                /* TOK_GENVAR  */
  YYSYMBOL_TOK_REAL = 84,                  /* TOK_REAL  */
  YYSYMBOL_TOK_SYNOPSYS_FULL_CASE = 85,    /* TOK_SYNOPSYS_FULL_CASE  */
  YYSYMBOL_TOK_SYNOPSYS_PARALLEL_CASE = 86, /* TOK_SYNOPSYS_PARALLEL_CASE  */
  YYSYMBOL_TOK_SUPPLY0 = 87,               /* TOK_SUPPLY0  */
  YYSYMBOL_TOK_SUPPLY1 = 88,               /* TOK_SUPPLY1  */
  YYSYMBOL_TOK_TO_SIGNED = 89,             /* TOK_TO_SIGNED  */
  YYSYMBOL_TOK_TO_UNSIGNED = 90,           /* TOK_TO_UNSIGNED  */
  YYSYMBOL_TOK_POS_INDEXED = 91,           /* TOK_POS_INDEXED  */
  YYSYMBOL_TOK_NEG_INDEXED = 92,           /* TOK_NEG_INDEXED  */
  YYSYMBOL_TOK_PROPERTY = 93,              /* TOK_PROPERTY  */
  YYSYMBOL_TOK_ENUM = 94,                  /* TOK_ENUM  */
  YYSYMBOL_TOK_TYPEDEF = 95,               /* TOK_TYPEDEF  */
  YYSYMBOL_TOK_RAND = 96,                  /* TOK_RAND  */
  YYSYMBOL_TOK_CONST = 97,                 /* TOK_CONST  */
  YYSYMBOL_TOK_CHECKER = 98,               /* TOK_CHECKER  */
  YYSYMBOL_TOK_ENDCHECKER = 99,            /* TOK_ENDCHECKER  */
  YYSYMBOL_TOK_EVENTUALLY = 100,           /* TOK_EVENTUALLY  */
  YYSYMBOL_TOK_INCREMENT = 101,            /* TOK_INCREMENT  */
  YYSYMBOL_TOK_DECREMENT = 102,            /* TOK_DECREMENT  */
  YYSYMBOL_TOK_UNIQUE = 103,               /* TOK_UNIQUE  */
  YYSYMBOL_TOK_UNIQUE0 = 104,              /* TOK_UNIQUE0  */
  YYSYMBOL_TOK_PRIORITY = 105,             /* TOK_PRIORITY  */
  YYSYMBOL_TOK_STRUCT = 106,               /* TOK_STRUCT  */
  YYSYMBOL_TOK_PACKED = 107,               /* TOK_PACKED  */
  YYSYMBOL_TOK_UNSIGNED = 108,             /* TOK_UNSIGNED  */
  YYSYMBOL_TOK_INT = 109,                  /* TOK_INT  */
  YYSYMBOL_TOK_BYTE = 110,                 /* TOK_BYTE  */
  YYSYMBOL_TOK_SHORTINT = 111,             /* TOK_SHORTINT  */
  YYSYMBOL_TOK_LONGINT = 112,              /* TOK_LONGINT  */
  YYSYMBOL_TOK_VOID = 113,                 /* TOK_VOID  */
  YYSYMBOL_TOK_UNION = 114,                /* TOK_UNION  */
  YYSYMBOL_TOK_BIT_OR_ASSIGN = 115,        /* TOK_BIT_OR_ASSIGN  */
  YYSYMBOL_TOK_BIT_AND_ASSIGN = 116,       /* TOK_BIT_AND_ASSIGN  */
  YYSYMBOL_TOK_BIT_XOR_ASSIGN = 117,       /* TOK_BIT_XOR_ASSIGN  */
  YYSYMBOL_TOK_ADD_ASSIGN = 118,           /* TOK_ADD_ASSIGN  */
  YYSYMBOL_TOK_SUB_ASSIGN = 119,           /* TOK_SUB_ASSIGN  */
  YYSYMBOL_TOK_DIV_ASSIGN = 120,           /* TOK_DIV_ASSIGN  */
  YYSYMBOL_TOK_MOD_ASSIGN = 121,           /* TOK_MOD_ASSIGN  */
  YYSYMBOL_TOK_MUL_ASSIGN = 122,           /* TOK_MUL_ASSIGN  */
  YYSYMBOL_TOK_SHL_ASSIGN = 123,           /* TOK_SHL_ASSIGN  */
  YYSYMBOL_TOK_SHR_ASSIGN = 124,           /* TOK_SHR_ASSIGN  */
  YYSYMBOL_TOK_SSHL_ASSIGN = 125,          /* TOK_SSHL_ASSIGN  */
  YYSYMBOL_TOK_SSHR_ASSIGN = 126,          /* TOK_SSHR_ASSIGN  */
  YYSYMBOL_TOK_BIND = 127,                 /* TOK_BIND  */
  YYSYMBOL_TOK_TIME_SCALE = 128,           /* TOK_TIME_SCALE  */
  YYSYMBOL_OP_LOR = 129,                   /* OP_LOR  */
  YYSYMBOL_OP_LAND = 130,                  /* OP_LAND  */
  YYSYMBOL_131_ = 131,                     /* '|'  */
  YYSYMBOL_OP_NOR = 132,                   /* OP_NOR  */
  YYSYMBOL_133_ = 133,                     /* '^'  */
  YYSYMBOL_OP_XNOR = 134,                  /* OP_XNOR  */
  YYSYMBOL_135_ = 135,                     /* '&'  */
  YYSYMBOL_OP_NAND = 136,                  /* OP_NAND  */
  YYSYMBOL_OP_EQ = 137,                    /* OP_EQ  */
  YYSYMBOL_OP_NE = 138,                    /* OP_NE  */
  YYSYMBOL_OP_EQX = 139,                   /* OP_EQX  */
  YYSYMBOL_OP_NEX = 140,                   /* OP_NEX  */
  YYSYMBOL_141_ = 141,                     /* '<'  */
  YYSYMBOL_OP_LE = 142,                    /* OP_LE  */
  YYSYMBOL_OP_GE = 143,                    /* OP_GE  */
  YYSYMBOL_144_ = 144,                     /* '>'  */
  YYSYMBOL_OP_SHL = 145,                   /* OP_SHL  */
  YYSYMBOL_OP_SHR = 146,                   /* OP_SHR  */
  YYSYMBOL_OP_SSHL = 147,                  /* OP_SSHL  */
  YYSYMBOL_OP_SSHR = 148,                  /* OP_SSHR  */
  YYSYMBOL_149_ = 149,                     /* '+'  */
  YYSYMBOL_150_ = 150,                     /* '-'  */
  YYSYMBOL_151_ = 151,                     /* '*'  */
  YYSYMBOL_152_ = 152,                     /* '/'  */
  YYSYMBOL_153_ = 153,                     /* '%'  */
  YYSYMBOL_OP_POW = 154,                   /* OP_POW  */
  YYSYMBOL_OP_CAST = 155,                  /* OP_CAST  */
  YYSYMBOL_UNARY_OPS = 156,                /* UNARY_OPS  */
  YYSYMBOL_FAKE_THEN = 157,                /* FAKE_THEN  */
  YYSYMBOL_158_ = 158,                     /* ','  */
  YYSYMBOL_159_ = 159,                     /* '='  */
  YYSYMBOL_160_ = 160,                     /* '.'  */
  YYSYMBOL_161_ = 161,                     /* '('  */
  YYSYMBOL_162_ = 162,                     /* ')'  */
  YYSYMBOL_163_ = 163,                     /* ';'  */
  YYSYMBOL_164_ = 164,                     /* '#'  */
  YYSYMBOL_165_ = 165,                     /* ':'  */
  YYSYMBOL_166_ = 166,                     /* '['  */
  YYSYMBOL_167_ = 167,                     /* ']'  */
  YYSYMBOL_168_ = 168,                     /* '{'  */
  YYSYMBOL_169_ = 169,                     /* '}'  */
  YYSYMBOL_170_ = 170,                     /* '@'  */
  YYSYMBOL_171_ = 171,                     /* '?'  */
  YYSYMBOL_172_ = 172,                     /* '~'  */
  YYSYMBOL_173_ = 173,                     /* '!'  */
  YYSYMBOL_YYACCEPT = 174,                 /* $accept  */
  YYSYMBOL_input = 175,                    /* input  */
  YYSYMBOL_176_1 = 176,                    /* $@1  */
  YYSYMBOL_design = 177,                   /* design  */
  YYSYMBOL_attr = 178,                     /* attr  */
  YYSYMBOL_179_2 = 179,                    /* $@2  */
  YYSYMBOL_attr_opt = 180,                 /* attr_opt  */
  YYSYMBOL_defattr = 181,                  /* defattr  */
  YYSYMBOL_182_3 = 182,                    /* $@3  */
  YYSYMBOL_183_4 = 183,                    /* $@4  */
  YYSYMBOL_opt_attr_list = 184,            /* opt_attr_list  */
  YYSYMBOL_attr_list = 185,                /* attr_list  */
  YYSYMBOL_attr_assign = 186,              /* attr_assign  */
  YYSYMBOL_hierarchical_id = 187,          /* hierarchical_id  */
  YYSYMBOL_hierarchical_type_id = 188,     /* hierarchical_type_id  */
  YYSYMBOL_module = 189,                   /* module  */
  YYSYMBOL_190_5 = 190,                    /* $@5  */
  YYSYMBOL_191_6 = 191,                    /* $@6  */
  YYSYMBOL_module_para_opt = 192,          /* module_para_opt  */
  YYSYMBOL_193_7 = 193,                    /* $@7  */
  YYSYMBOL_194_8 = 194,                    /* $@8  */
  YYSYMBOL_module_para_list = 195,         /* module_para_list  */
  YYSYMBOL_single_module_para = 196,       /* single_module_para  */
  YYSYMBOL_197_9 = 197,                    /* $@9  */
  YYSYMBOL_198_10 = 198,                   /* $@10  */
  YYSYMBOL_module_args_opt = 199,          /* module_args_opt  */
  YYSYMBOL_module_args = 200,              /* module_args  */
  YYSYMBOL_optional_comma = 201,           /* optional_comma  */
  YYSYMBOL_module_arg_opt_assignment = 202, /* module_arg_opt_assignment  */
  YYSYMBOL_module_arg = 203,               /* module_arg  */
  YYSYMBOL_204_11 = 204,                   /* $@11  */
  YYSYMBOL_205_12 = 205,                   /* $@12  */
  YYSYMBOL_206_13 = 206,                   /* $@13  */
  YYSYMBOL_207_14 = 207,                   /* $@14  */
  YYSYMBOL_package = 208,                  /* package  */
  YYSYMBOL_209_15 = 209,                   /* $@15  */
  YYSYMBOL_210_16 = 210,                   /* $@16  */
  YYSYMBOL_package_body = 211,             /* package_body  */
  YYSYMBOL_package_body_stmt = 212,        /* package_body_stmt  */
  YYSYMBOL_interface = 213,                /* interface  */
  YYSYMBOL_214_17 = 214,                   /* $@17  */
  YYSYMBOL_215_18 = 215,                   /* $@18  */
  YYSYMBOL_interface_body = 216,           /* interface_body  */
  YYSYMBOL_interface_body_stmt = 217,      /* interface_body_stmt  */
  YYSYMBOL_bind_directive = 218,           /* bind_directive  */
  YYSYMBOL_219_19 = 219,                   /* $@19  */
  YYSYMBOL_220_20 = 220,                   /* $@20  */
  YYSYMBOL_221_21 = 221,                   /* $@21  */
  YYSYMBOL_bind_target = 222,              /* bind_target  */
  YYSYMBOL_opt_bind_target_instance_list = 223, /* opt_bind_target_instance_list  */
  YYSYMBOL_bind_target_instance_list = 224, /* bind_target_instance_list  */
  YYSYMBOL_bind_target_instance = 225,     /* bind_target_instance  */
  YYSYMBOL_mintypmax_expr = 226,           /* mintypmax_expr  */
  YYSYMBOL_non_opt_delay = 227,            /* non_opt_delay  */
  YYSYMBOL_delay = 228,                    /* delay  */
  YYSYMBOL_io_wire_type = 229,             /* io_wire_type  */
  YYSYMBOL_230_22 = 230,                   /* $@22  */
  YYSYMBOL_non_io_wire_type = 231,         /* non_io_wire_type  */
  YYSYMBOL_232_23 = 232,                   /* $@23  */
  YYSYMBOL_wire_type = 233,                /* wire_type  */
  YYSYMBOL_wire_type_token_io = 234,       /* wire_type_token_io  */
  YYSYMBOL_wire_type_signedness = 235,     /* wire_type_signedness  */
  YYSYMBOL_wire_type_const_rand = 236,     /* wire_type_const_rand  */
  YYSYMBOL_opt_wire_type_token = 237,      /* opt_wire_type_token  */
  YYSYMBOL_wire_type_token = 238,          /* wire_type_token  */
  YYSYMBOL_net_type = 239,                 /* net_type  */
  YYSYMBOL_logic_type = 240,               /* logic_type  */
  YYSYMBOL_integer_atom_type = 241,        /* integer_atom_type  */
  YYSYMBOL_integer_vector_type = 242,      /* integer_vector_type  */
  YYSYMBOL_non_opt_range = 243,            /* non_opt_range  */
  YYSYMBOL_non_opt_multirange = 244,       /* non_opt_multirange  */
  YYSYMBOL_range = 245,                    /* range  */
  YYSYMBOL_range_or_multirange = 246,      /* range_or_multirange  */
  YYSYMBOL_module_body = 247,              /* module_body  */
  YYSYMBOL_module_body_stmt = 248,         /* module_body_stmt  */
  YYSYMBOL_checker_decl = 249,             /* checker_decl  */
  YYSYMBOL_250_24 = 250,                   /* $@24  */
  YYSYMBOL_task_func_decl = 251,           /* task_func_decl  */
  YYSYMBOL_252_25 = 252,                   /* $@25  */
  YYSYMBOL_253_26 = 253,                   /* $@26  */
  YYSYMBOL_254_27 = 254,                   /* $@27  */
  YYSYMBOL_255_28 = 255,                   /* $@28  */
  YYSYMBOL_256_29 = 256,                   /* $@29  */
  YYSYMBOL_257_30 = 257,                   /* $@30  */
  YYSYMBOL_func_return_type = 258,         /* func_return_type  */
  YYSYMBOL_opt_type_vec = 259,             /* opt_type_vec  */
  YYSYMBOL_opt_signedness_default_signed = 260, /* opt_signedness_default_signed  */
  YYSYMBOL_opt_signedness_default_unsigned = 261, /* opt_signedness_default_unsigned  */
  YYSYMBOL_dpi_function_arg = 262,         /* dpi_function_arg  */
  YYSYMBOL_opt_dpi_function_args = 263,    /* opt_dpi_function_args  */
  YYSYMBOL_dpi_function_args = 264,        /* dpi_function_args  */
  YYSYMBOL_opt_automatic = 265,            /* opt_automatic  */
  YYSYMBOL_task_func_args_opt = 266,       /* task_func_args_opt  */
  YYSYMBOL_267_31 = 267,                   /* $@31  */
  YYSYMBOL_268_32 = 268,                   /* $@32  */
  YYSYMBOL_task_func_args = 269,           /* task_func_args  */
  YYSYMBOL_task_func_port = 270,           /* task_func_port  */
  YYSYMBOL_271_33 = 271,                   /* $@33  */
  YYSYMBOL_272_34 = 272,                   /* $@34  */
  YYSYMBOL_task_func_body = 273,           /* task_func_body  */
  YYSYMBOL_specify_block = 274,            /* specify_block  */
  YYSYMBOL_specify_item_list = 275,        /* specify_item_list  */
  YYSYMBOL_specify_item = 276,             /* specify_item  */
  YYSYMBOL_specify_opt_triple = 277,       /* specify_opt_triple  */
  YYSYMBOL_specify_if = 278,               /* specify_if  */
  YYSYMBOL_specify_condition = 279,        /* specify_condition  */
  YYSYMBOL_specify_target = 280,           /* specify_target  */
  YYSYMBOL_specify_edge = 281,             /* specify_edge  */
  YYSYMBOL_specify_rise_fall = 282,        /* specify_rise_fall  */
  YYSYMBOL_specify_triple = 283,           /* specify_triple  */
  YYSYMBOL_ignored_specify_block = 284,    /* ignored_specify_block  */
  YYSYMBOL_ignored_specify_item_opt = 285, /* ignored_specify_item_opt  */
  YYSYMBOL_ignored_specify_item = 286,     /* ignored_specify_item  */
  YYSYMBOL_specparam_declaration = 287,    /* specparam_declaration  */
  YYSYMBOL_specparam_range = 288,          /* specparam_range  */
  YYSYMBOL_list_of_specparam_assignments = 289, /* list_of_specparam_assignments  */
  YYSYMBOL_specparam_assignment = 290,     /* specparam_assignment  */
  YYSYMBOL_ignspec_opt_cond = 291,         /* ignspec_opt_cond  */
  YYSYMBOL_path_declaration = 292,         /* path_declaration  */
  YYSYMBOL_simple_path_declaration = 293,  /* simple_path_declaration  */
  YYSYMBOL_path_delay_value = 294,         /* path_delay_value  */
  YYSYMBOL_list_of_path_delay_extra_expressions = 295, /* list_of_path_delay_extra_expressions  */
  YYSYMBOL_specify_edge_identifier = 296,  /* specify_edge_identifier  */
  YYSYMBOL_parallel_path_description = 297, /* parallel_path_description  */
  YYSYMBOL_full_path_description = 298,    /* full_path_description  */
  YYSYMBOL_list_of_path_inputs = 299,      /* list_of_path_inputs  */
  YYSYMBOL_more_path_inputs = 300,         /* more_path_inputs  */
  YYSYMBOL_list_of_path_outputs = 301,     /* list_of_path_outputs  */
  YYSYMBOL_opt_polarity_operator = 302,    /* opt_polarity_operator  */
  YYSYMBOL_specify_input_terminal_descriptor = 303, /* specify_input_terminal_descriptor  */
  YYSYMBOL_specify_output_terminal_descriptor = 304, /* specify_output_terminal_descriptor  */
  YYSYMBOL_system_timing_declaration = 305, /* system_timing_declaration  */
  YYSYMBOL_system_timing_arg = 306,        /* system_timing_arg  */
  YYSYMBOL_system_timing_args = 307,       /* system_timing_args  */
  YYSYMBOL_ignspec_constant_expression = 308, /* ignspec_constant_expression  */
  YYSYMBOL_ignspec_expr = 309,             /* ignspec_expr  */
  YYSYMBOL_ignspec_id = 310,               /* ignspec_id  */
  YYSYMBOL_311_35 = 311,                   /* $@35  */
  YYSYMBOL_param_signed = 312,             /* param_signed  */
  YYSYMBOL_param_integer = 313,            /* param_integer  */
  YYSYMBOL_param_real = 314,               /* param_real  */
  YYSYMBOL_param_range = 315,              /* param_range  */
  YYSYMBOL_param_integer_type = 316,       /* param_integer_type  */
  YYSYMBOL_param_range_type = 317,         /* param_range_type  */
  YYSYMBOL_param_implicit_type = 318,      /* param_implicit_type  */
  YYSYMBOL_param_type = 319,               /* param_type  */
  YYSYMBOL_param_decl = 320,               /* param_decl  */
  YYSYMBOL_321_36 = 321,                   /* $@36  */
  YYSYMBOL_localparam_decl = 322,          /* localparam_decl  */
  YYSYMBOL_323_37 = 323,                   /* $@37  */
  YYSYMBOL_param_decl_list = 324,          /* param_decl_list  */
  YYSYMBOL_single_param_decl = 325,        /* single_param_decl  */
  YYSYMBOL_single_param_decl_ident = 326,  /* single_param_decl_ident  */
  YYSYMBOL_defparam_decl = 327,            /* defparam_decl  */
  YYSYMBOL_defparam_decl_list = 328,       /* defparam_decl_list  */
  YYSYMBOL_single_defparam_decl = 329,     /* single_defparam_decl  */
  YYSYMBOL_enum_type = 330,                /* enum_type  */
  YYSYMBOL_331_38 = 331,                   /* $@38  */
  YYSYMBOL_enum_base_type = 332,           /* enum_base_type  */
  YYSYMBOL_type_atom = 333,                /* type_atom  */
  YYSYMBOL_type_vec = 334,                 /* type_vec  */
  YYSYMBOL_type_signing = 335,             /* type_signing  */
  YYSYMBOL_enum_name_list = 336,           /* enum_name_list  */
  YYSYMBOL_enum_name_decl = 337,           /* enum_name_decl  */
  YYSYMBOL_opt_enum_init = 338,            /* opt_enum_init  */
  YYSYMBOL_enum_var_list = 339,            /* enum_var_list  */
  YYSYMBOL_enum_var = 340,                 /* enum_var  */
  YYSYMBOL_enum_decl = 341,                /* enum_decl  */
  YYSYMBOL_struct_decl = 342,              /* struct_decl  */
  YYSYMBOL_343_39 = 343,                   /* $@39  */
  YYSYMBOL_struct_type = 344,              /* struct_type  */
  YYSYMBOL_345_40 = 345,                   /* $@40  */
  YYSYMBOL_struct_union = 346,             /* struct_union  */
  YYSYMBOL_struct_body = 347,              /* struct_body  */
  YYSYMBOL_opt_packed = 348,               /* opt_packed  */
  YYSYMBOL_opt_signed_struct = 349,        /* opt_signed_struct  */
  YYSYMBOL_struct_member_list = 350,       /* struct_member_list  */
  YYSYMBOL_struct_member = 351,            /* struct_member  */
  YYSYMBOL_member_name_list = 352,         /* member_name_list  */
  YYSYMBOL_member_name = 353,              /* member_name  */
  YYSYMBOL_354_41 = 354,                   /* $@41  */
  YYSYMBOL_struct_member_type = 355,       /* struct_member_type  */
  YYSYMBOL_356_42 = 356,                   /* $@42  */
  YYSYMBOL_member_type_token = 357,        /* member_type_token  */
  YYSYMBOL_358_43 = 358,                   /* $@43  */
  YYSYMBOL_359_44 = 359,                   /* $@44  */
  YYSYMBOL_member_type = 360,              /* member_type  */
  YYSYMBOL_struct_var_list = 361,          /* struct_var_list  */
  YYSYMBOL_struct_var = 362,               /* struct_var  */
  YYSYMBOL_wire_decl = 363,                /* wire_decl  */
  YYSYMBOL_364_45 = 364,                   /* $@45  */
  YYSYMBOL_365_46 = 365,                   /* $@46  */
  YYSYMBOL_366_47 = 366,                   /* $@47  */
  YYSYMBOL_367_48 = 367,                   /* $@48  */
  YYSYMBOL_opt_supply_wires = 368,         /* opt_supply_wires  */
  YYSYMBOL_wire_name_list = 369,           /* wire_name_list  */
  YYSYMBOL_wire_name_and_opt_assign = 370, /* wire_name_and_opt_assign  */
  YYSYMBOL_wire_name = 371,                /* wire_name  */
  YYSYMBOL_assign_stmt = 372,              /* assign_stmt  */
  YYSYMBOL_assign_expr_list = 373,         /* assign_expr_list  */
  YYSYMBOL_assign_expr = 374,              /* assign_expr  */
  YYSYMBOL_type_name = 375,                /* type_name  */
  YYSYMBOL_typedef_decl = 376,             /* typedef_decl  */
  YYSYMBOL_typedef_base_type = 377,        /* typedef_base_type  */
  YYSYMBOL_enum_struct_type = 378,         /* enum_struct_type  */
  YYSYMBOL_cell_stmt = 379,                /* cell_stmt  */
  YYSYMBOL_380_49 = 380,                   /* $@49  */
  YYSYMBOL_381_50 = 381,                   /* $@50  */
  YYSYMBOL_tok_prim_wrapper = 382,         /* tok_prim_wrapper  */
  YYSYMBOL_cell_list = 383,                /* cell_list  */
  YYSYMBOL_single_cell = 384,              /* single_cell  */
  YYSYMBOL_single_cell_no_array = 385,     /* single_cell_no_array  */
  YYSYMBOL_386_51 = 386,                   /* $@51  */
  YYSYMBOL_single_cell_arraylist = 387,    /* single_cell_arraylist  */
  YYSYMBOL_388_52 = 388,                   /* $@52  */
  YYSYMBOL_cell_list_no_array = 389,       /* cell_list_no_array  */
  YYSYMBOL_prim_list = 390,                /* prim_list  */
  YYSYMBOL_single_prim = 391,              /* single_prim  */
  YYSYMBOL_392_53 = 392,                   /* $@53  */
  YYSYMBOL_cell_parameter_list_opt = 393,  /* cell_parameter_list_opt  */
  YYSYMBOL_cell_parameter_list = 394,      /* cell_parameter_list  */
  YYSYMBOL_cell_parameter = 395,           /* cell_parameter  */
  YYSYMBOL_cell_port_list = 396,           /* cell_port_list  */
  YYSYMBOL_cell_port_list_rules = 397,     /* cell_port_list_rules  */
  YYSYMBOL_cell_port = 398,                /* cell_port  */
  YYSYMBOL_always_comb_or_latch = 399,     /* always_comb_or_latch  */
  YYSYMBOL_always_or_always_ff = 400,      /* always_or_always_ff  */
  YYSYMBOL_always_stmt = 401,              /* always_stmt  */
  YYSYMBOL_402_54 = 402,                   /* $@54  */
  YYSYMBOL_403_55 = 403,                   /* $@55  */
  YYSYMBOL_404_56 = 404,                   /* $@56  */
  YYSYMBOL_405_57 = 405,                   /* $@57  */
  YYSYMBOL_always_cond = 406,              /* always_cond  */
  YYSYMBOL_always_events = 407,            /* always_events  */
  YYSYMBOL_always_event = 408,             /* always_event  */
  YYSYMBOL_opt_label = 409,                /* opt_label  */
  YYSYMBOL_opt_sva_label = 410,            /* opt_sva_label  */
  YYSYMBOL_opt_property = 411,             /* opt_property  */
  YYSYMBOL_modport_stmt = 412,             /* modport_stmt  */
  YYSYMBOL_413_58 = 413,                   /* $@58  */
  YYSYMBOL_414_59 = 414,                   /* $@59  */
  YYSYMBOL_modport_args_opt = 415,         /* modport_args_opt  */
  YYSYMBOL_modport_args = 416,             /* modport_args  */
  YYSYMBOL_modport_arg = 417,              /* modport_arg  */
  YYSYMBOL_modport_member = 418,           /* modport_member  */
  YYSYMBOL_modport_type_token = 419,       /* modport_type_token  */
  YYSYMBOL_assert = 420,                   /* assert  */
  YYSYMBOL_assert_property = 421,          /* assert_property  */
  YYSYMBOL_simple_behavioral_stmt = 422,   /* simple_behavioral_stmt  */
  YYSYMBOL_asgn_binop = 423,               /* asgn_binop  */
  YYSYMBOL_inc_or_dec_op = 424,            /* inc_or_dec_op  */
  YYSYMBOL_for_initialization = 425,       /* for_initialization  */
  YYSYMBOL_behavioral_stmt = 426,          /* behavioral_stmt  */
  YYSYMBOL_427_60 = 427,                   /* $@60  */
  YYSYMBOL_428_61 = 428,                   /* $@61  */
  YYSYMBOL_429_62 = 429,                   /* $@62  */
  YYSYMBOL_430_63 = 430,                   /* $@63  */
  YYSYMBOL_431_64 = 431,                   /* $@64  */
  YYSYMBOL_432_65 = 432,                   /* $@65  */
  YYSYMBOL_433_66 = 433,                   /* $@66  */
  YYSYMBOL_434_67 = 434,                   /* $@67  */
  YYSYMBOL_435_68 = 435,                   /* $@68  */
  YYSYMBOL_436_69 = 436,                   /* $@69  */
  YYSYMBOL_437_70 = 437,                   /* $@70  */
  YYSYMBOL_438_71 = 438,                   /* $@71  */
  YYSYMBOL_if_attr = 439,                  /* if_attr  */
  YYSYMBOL_case_attr = 440,                /* case_attr  */
  YYSYMBOL_case_type = 441,                /* case_type  */
  YYSYMBOL_opt_synopsys_attr = 442,        /* opt_synopsys_attr  */
  YYSYMBOL_behavioral_stmt_list = 443,     /* behavioral_stmt_list  */
  YYSYMBOL_optional_else = 444,            /* optional_else  */
  YYSYMBOL_445_72 = 445,                   /* $@72  */
  YYSYMBOL_case_body = 446,                /* case_body  */
  YYSYMBOL_case_item = 447,                /* case_item  */
  YYSYMBOL_448_73 = 448,                   /* $@73  */
  YYSYMBOL_449_74 = 449,                   /* $@74  */
  YYSYMBOL_gen_case_body = 450,            /* gen_case_body  */
  YYSYMBOL_gen_case_item = 451,            /* gen_case_item  */
  YYSYMBOL_452_75 = 452,                   /* $@75  */
  YYSYMBOL_453_76 = 453,                   /* $@76  */
  YYSYMBOL_case_select = 454,              /* case_select  */
  YYSYMBOL_case_expr_list = 455,           /* case_expr_list  */
  YYSYMBOL_rvalue = 456,                   /* rvalue  */
  YYSYMBOL_lvalue = 457,                   /* lvalue  */
  YYSYMBOL_lvalue_concat_list = 458,       /* lvalue_concat_list  */
  YYSYMBOL_opt_arg_list = 459,             /* opt_arg_list  */
  YYSYMBOL_arg_list = 460,                 /* arg_list  */
  YYSYMBOL_arg_list2 = 461,                /* arg_list2  */
  YYSYMBOL_single_arg = 462,               /* single_arg  */
  YYSYMBOL_module_gen_body = 463,          /* module_gen_body  */
  YYSYMBOL_gen_stmt_or_module_body_stmt = 464, /* gen_stmt_or_module_body_stmt  */
  YYSYMBOL_genvar_identifier = 465,        /* genvar_identifier  */
  YYSYMBOL_genvar_initialization = 466,    /* genvar_initialization  */
  YYSYMBOL_gen_stmt = 467,                 /* gen_stmt  */
  YYSYMBOL_468_77 = 468,                   /* $@77  */
  YYSYMBOL_469_78 = 469,                   /* $@78  */
  YYSYMBOL_470_79 = 470,                   /* $@79  */
  YYSYMBOL_471_80 = 471,                   /* $@80  */
  YYSYMBOL_472_81 = 472,                   /* $@81  */
  YYSYMBOL_gen_block = 473,                /* gen_block  */
  YYSYMBOL_474_82 = 474,                   /* $@82  */
  YYSYMBOL_475_83 = 475,                   /* $@83  */
  YYSYMBOL_gen_stmt_block = 476,           /* gen_stmt_block  */
  YYSYMBOL_477_84 = 477,                   /* $@84  */
  YYSYMBOL_opt_gen_else = 478,             /* opt_gen_else  */
  YYSYMBOL_expr = 479,                     /* expr  */
  YYSYMBOL_basic_expr = 480,               /* basic_expr  */
  YYSYMBOL_481_85 = 481,                   /* $@85  */
  YYSYMBOL_concat_list = 482,              /* concat_list  */
  YYSYMBOL_integral_number = 483           /* integral_number  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
# define YYCOPY_NEEDED 1
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined FRONTEND_VERILOG_YYLTYPE_IS_TRIVIAL && FRONTEND_VERILOG_YYLTYPE_IS_TRIVIAL \
             && defined FRONTEND_VERILOG_YYSTYPE_IS_TRIVIAL && FRONTEND_VERILOG_YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   3644

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  174
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  310
/* YYNRULES -- Number of rules.  */
#define YYNRULES  706
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1364

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   402


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   173,     2,   164,     2,   153,   135,     2,
     161,   162,   151,   149,   158,   150,   160,   152,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   165,   163,
     141,   159,   144,   171,   170,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   166,     2,   167,   133,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   168,   131,   169,   172,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   132,   134,   136,   137,
     138,   139,   140,   142,   143,   145,   146,   147,   148,   154,
     155,   156,   157
};

#if FRONTEND_VERILOG_YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   467,   467,   467,   480,   481,   482,   483,   484,   485,
     486,   487,   488,   489,   492,   492,   508,   511,   514,   521,
     514,   532,   532,   535,   536,   539,   545,   553,   556,   564,
     574,   575,   576,   580,   582,   580,   607,   607,   607,   607,
     610,   610,   613,   614,   614,   620,   620,   626,   629,   629,
     629,   632,   632,   635,   635,   638,   656,   659,   659,   673,
     678,   673,   688,   688,   704,   709,   711,   709,   728,   728,
     731,   731,   731,   731,   734,   736,   734,   757,   757,   760,
     760,   760,   760,   760,   760,   760,   761,   761,   764,   769,
     773,   764,   801,   806,   807,   810,   811,   816,   824,   825,
     828,   829,   830,   832,   833,   834,   835,   836,   839,   839,
     842,   842,   847,   847,   852,   853,   856,   859,   862,   868,
     869,   870,   873,   877,   880,   883,   886,   886,   890,   892,
     895,   898,   902,   905,   908,   911,   920,   923,   926,   929,
     931,   936,   941,   942,   943,   944,   945,   948,   949,   952,
     957,   963,   969,   975,   978,   984,   987,   992,   993,   996,
     998,   999,  1000,  1001,  1004,  1004,  1004,  1004,  1004,  1004,
    1004,  1004,  1004,  1004,  1005,  1005,  1005,  1006,  1006,  1006,
    1006,  1006,  1006,  1009,  1009,  1020,  1020,  1030,  1030,  1041,
    1041,  1053,  1053,  1065,  1065,  1082,  1082,  1107,  1112,  1115,
    1119,  1124,  1125,  1126,  1130,  1131,  1132,  1135,  1136,  1137,
    1141,  1146,  1152,  1153,  1156,  1157,  1158,  1159,  1162,  1163,
    1166,  1166,  1166,  1170,  1166,  1178,  1178,  1181,  1181,  1202,
    1202,  1216,  1217,  1222,  1225,  1226,  1229,  1313,  1387,  1390,
    1395,  1398,  1403,  1406,  1411,  1417,  1423,  1429,  1437,  1438,
    1439,  1442,  1450,  1457,  1466,  1478,  1498,  1504,  1514,  1515,
    1518,  1519,  1522,  1525,  1526,  1530,  1531,  1537,  1540,  1540,
    1543,  1546,  1546,  1549,  1555,  1556,  1560,  1561,  1562,  1566,
    1567,  1571,  1571,  1574,  1575,  1576,  1579,  1580,  1581,  1585,
    1586,  1589,  1590,  1593,  1594,  1597,  1597,  1597,  1601,  1605,
    1608,  1611,  1612,  1613,  1616,  1617,  1618,  1625,  1628,  1629,
    1636,  1636,  1642,  1644,  1646,  1649,  1654,  1659,  1665,  1667,
    1670,  1673,  1676,  1676,  1676,  1676,  1677,  1682,  1682,  1691,
    1691,  1700,  1700,  1703,  1709,  1722,  1739,  1742,  1742,  1745,
    1758,  1758,  1781,  1782,  1783,  1787,  1793,  1794,  1798,  1799,
    1800,  1803,  1804,  1808,  1823,  1824,  1828,  1829,  1832,  1844,
    1852,  1852,  1859,  1859,  1863,  1864,  1867,  1871,  1872,  1875,
    1876,  1877,  1880,  1881,  1884,  1888,  1889,  1892,  1892,  1901,
    1901,  1905,  1910,  1912,  1910,  1924,  1925,  1926,  1929,  1930,
    1933,  1946,  1950,  1946,  1956,  1956,  1964,  1964,  1974,  1975,
    1986,  1986,  1989,  2031,  2059,  2105,  2108,  2108,  2111,  2117,
    2118,  2122,  2135,  2139,  2144,  2153,  2162,  2163,  2167,  2167,
    2176,  2176,  2186,  2189,  2194,  2195,  2198,  2198,  2201,  2201,
    2212,  2212,  2223,  2224,  2227,  2228,  2231,  2232,  2232,  2240,
    2240,  2243,  2243,  2246,  2247,  2252,  2256,  2265,  2292,  2292,
    2295,  2300,  2306,  2314,  2321,  2330,  2338,  2341,  2346,  2349,
    2354,  2361,  2354,  2374,  2374,  2390,  2390,  2404,  2405,  2406,
    2407,  2408,  2409,  2412,  2413,  2414,  2417,  2423,  2429,  2436,
    2439,  2444,  2447,  2452,  2455,  2458,  2463,  2469,  2463,  2475,
    2475,  2478,  2478,  2481,  2482,  2485,  2495,  2495,  2498,  2511,
    2524,  2537,  2550,  2559,  2568,  2577,  2592,  2609,  2618,  2627,
    2636,  2645,  2654,  2667,  2682,  2688,  2691,  2694,  2700,  2705,
    2706,  2707,  2708,  2709,  2710,  2711,  2712,  2713,  2714,  2715,
    2716,  2721,  2722,  2725,  2733,  2736,  2774,  2774,  2774,  2774,
    2774,  2774,  2775,  2776,  2777,  2780,  2780,  2791,  2791,  2802,
    2804,  2802,  2829,  2834,  2836,  2829,  2847,  2847,  2861,  2861,
    2875,  2886,  2875,  2893,  2893,  2906,  2909,  2915,  2921,  2929,
    2932,  2936,  2940,  2947,  2950,  2953,  2958,  2962,  2966,  2969,
    2970,  2973,  2973,  2985,  2988,  2989,  2992,  2998,  2992,  3011,
    3012,  3015,  3021,  3015,  3030,  3031,  3034,  3039,  3046,  3049,
    3054,  3060,  3070,  3078,  3081,  3086,  3090,  3096,  3097,  3100,
    3101,  3104,  3105,  3108,  3113,  3114,  3115,  3118,  3118,  3119,
    3124,  3131,  3134,  3150,  3158,  3162,  3158,  3169,  3169,  3178,
    3178,  3187,  3187,  3199,  3201,  3199,  3217,  3217,  3224,  3227,
    3227,  3230,  3233,  3241,  3246,  3251,  3254,  3264,  3278,  3285,
    3297,  3302,  3302,  3313,  3317,  3321,  3324,  3329,  3332,  3335,
    3340,  3345,  3350,  3355,  3360,  3365,  3370,  3375,  3381,  3386,
    3393,  3398,  3403,  3408,  3413,  3418,  3423,  3428,  3433,  3438,
    3443,  3448,  3453,  3458,  3463,  3468,  3473,  3478,  3483,  3488,
    3493,  3498,  3503,  3508,  3513,  3518,  3524,  3530,  3536,  3542,
    3549,  3555,  3558,  3564,  3565,  3566,  3571
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "TOK_STRING", "TOK_ID",
  "TOK_CONSTVAL", "TOK_REALVAL", "TOK_PRIMITIVE", "TOK_SVA_LABEL",
  "TOK_SPECIFY_OPER", "TOK_MSG_TASKS", "TOK_BASE", "TOK_BASED_CONSTVAL",
  "TOK_UNBASED_UNSIZED_CONSTVAL", "TOK_USER_TYPE", "TOK_PKG_USER_TYPE",
  "TOK_ASSERT", "TOK_ASSUME", "TOK_RESTRICT", "TOK_COVER", "TOK_FINAL",
  "ATTR_BEGIN", "ATTR_END", "DEFATTR_BEGIN", "DEFATTR_END", "TOK_MODULE",
  "TOK_ENDMODULE", "TOK_PARAMETER", "TOK_LOCALPARAM", "TOK_DEFPARAM",
  "TOK_PACKAGE", "TOK_ENDPACKAGE", "TOK_PACKAGESEP", "TOK_INTERFACE",
  "TOK_ENDINTERFACE", "TOK_MODPORT", "TOK_VAR", "TOK_WILDCARD_CONNECT",
  "TOK_INPUT", "TOK_OUTPUT", "TOK_INOUT", "TOK_WIRE", "TOK_WAND",
  "TOK_WOR", "TOK_REG", "TOK_LOGIC", "TOK_INTEGER", "TOK_SIGNED",
  "TOK_ASSIGN", "TOK_ALWAYS", "TOK_INITIAL", "TOK_ALWAYS_FF",
  "TOK_ALWAYS_COMB", "TOK_ALWAYS_LATCH", "TOK_BEGIN", "TOK_END", "TOK_IF",
  "TOK_ELSE", "TOK_FOR", "TOK_WHILE", "TOK_REPEAT", "TOK_DPI_FUNCTION",
  "TOK_POSEDGE", "TOK_NEGEDGE", "TOK_OR", "TOK_AUTOMATIC", "TOK_CASE",
  "TOK_CASEX", "TOK_CASEZ", "TOK_ENDCASE", "TOK_DEFAULT", "TOK_FUNCTION",
  "TOK_ENDFUNCTION", "TOK_TASK", "TOK_ENDTASK", "TOK_SPECIFY",
  "TOK_IGNORED_SPECIFY", "TOK_ENDSPECIFY", "TOK_SPECPARAM",
  "TOK_SPECIFY_AND", "TOK_IGNORED_SPECIFY_AND", "TOK_GENERATE",
  "TOK_ENDGENERATE", "TOK_GENVAR", "TOK_REAL", "TOK_SYNOPSYS_FULL_CASE",
  "TOK_SYNOPSYS_PARALLEL_CASE", "TOK_SUPPLY0", "TOK_SUPPLY1",
  "TOK_TO_SIGNED", "TOK_TO_UNSIGNED", "TOK_POS_INDEXED", "TOK_NEG_INDEXED",
  "TOK_PROPERTY", "TOK_ENUM", "TOK_TYPEDEF", "TOK_RAND", "TOK_CONST",
  "TOK_CHECKER", "TOK_ENDCHECKER", "TOK_EVENTUALLY", "TOK_INCREMENT",
  "TOK_DECREMENT", "TOK_UNIQUE", "TOK_UNIQUE0", "TOK_PRIORITY",
  "TOK_STRUCT", "TOK_PACKED", "TOK_UNSIGNED", "TOK_INT", "TOK_BYTE",
  "TOK_SHORTINT", "TOK_LONGINT", "TOK_VOID", "TOK_UNION",
  "TOK_BIT_OR_ASSIGN", "TOK_BIT_AND_ASSIGN", "TOK_BIT_XOR_ASSIGN",
  "TOK_ADD_ASSIGN", "TOK_SUB_ASSIGN", "TOK_DIV_ASSIGN", "TOK_MOD_ASSIGN",
  "TOK_MUL_ASSIGN", "TOK_SHL_ASSIGN", "TOK_SHR_ASSIGN", "TOK_SSHL_ASSIGN",
  "TOK_SSHR_ASSIGN", "TOK_BIND", "TOK_TIME_SCALE", "OP_LOR", "OP_LAND",
  "'|'", "OP_NOR", "'^'", "OP_XNOR", "'&'", "OP_NAND", "OP_EQ", "OP_NE",
  "OP_EQX", "OP_NEX", "'<'", "OP_LE", "OP_GE", "'>'", "OP_SHL", "OP_SHR",
  "OP_SSHL", "OP_SSHR", "'+'", "'-'", "'*'", "'/'", "'%'", "OP_POW",
  "OP_CAST", "UNARY_OPS", "FAKE_THEN", "','", "'='", "'.'", "'('", "')'",
  "';'", "'#'", "':'", "'['", "']'", "'{'", "'}'", "'@'", "'?'", "'~'",
  "'!'", "$accept", "input", "$@1", "design", "attr", "$@2", "attr_opt",
  "defattr", "$@3", "$@4", "opt_attr_list", "attr_list", "attr_assign",
  "hierarchical_id", "hierarchical_type_id", "module", "$@5", "$@6",
  "module_para_opt", "$@7", "$@8", "module_para_list",
  "single_module_para", "$@9", "$@10", "module_args_opt", "module_args",
  "optional_comma", "module_arg_opt_assignment", "module_arg", "$@11",
  "$@12", "$@13", "$@14", "package", "$@15", "$@16", "package_body",
  "package_body_stmt", "interface", "$@17", "$@18", "interface_body",
  "interface_body_stmt", "bind_directive", "$@19", "$@20", "$@21",
  "bind_target", "opt_bind_target_instance_list",
  "bind_target_instance_list", "bind_target_instance", "mintypmax_expr",
  "non_opt_delay", "delay", "io_wire_type", "$@22", "non_io_wire_type",
  "$@23", "wire_type", "wire_type_token_io", "wire_type_signedness",
  "wire_type_const_rand", "opt_wire_type_token", "wire_type_token",
  "net_type", "logic_type", "integer_atom_type", "integer_vector_type",
  "non_opt_range", "non_opt_multirange", "range", "range_or_multirange",
  "module_body", "module_body_stmt", "checker_decl", "$@24",
  "task_func_decl", "$@25", "$@26", "$@27", "$@28", "$@29", "$@30",
  "func_return_type", "opt_type_vec", "opt_signedness_default_signed",
  "opt_signedness_default_unsigned", "dpi_function_arg",
  "opt_dpi_function_args", "dpi_function_args", "opt_automatic",
  "task_func_args_opt", "$@31", "$@32", "task_func_args", "task_func_port",
  "$@33", "$@34", "task_func_body", "specify_block", "specify_item_list",
  "specify_item", "specify_opt_triple", "specify_if", "specify_condition",
  "specify_target", "specify_edge", "specify_rise_fall", "specify_triple",
  "ignored_specify_block", "ignored_specify_item_opt",
  "ignored_specify_item", "specparam_declaration", "specparam_range",
  "list_of_specparam_assignments", "specparam_assignment",
  "ignspec_opt_cond", "path_declaration", "simple_path_declaration",
  "path_delay_value", "list_of_path_delay_extra_expressions",
  "specify_edge_identifier", "parallel_path_description",
  "full_path_description", "list_of_path_inputs", "more_path_inputs",
  "list_of_path_outputs", "opt_polarity_operator",
  "specify_input_terminal_descriptor",
  "specify_output_terminal_descriptor", "system_timing_declaration",
  "system_timing_arg", "system_timing_args", "ignspec_constant_expression",
  "ignspec_expr", "ignspec_id", "$@35", "param_signed", "param_integer",
  "param_real", "param_range", "param_integer_type", "param_range_type",
  "param_implicit_type", "param_type", "param_decl", "$@36",
  "localparam_decl", "$@37", "param_decl_list", "single_param_decl",
  "single_param_decl_ident", "defparam_decl", "defparam_decl_list",
  "single_defparam_decl", "enum_type", "$@38", "enum_base_type",
  "type_atom", "type_vec", "type_signing", "enum_name_list",
  "enum_name_decl", "opt_enum_init", "enum_var_list", "enum_var",
  "enum_decl", "struct_decl", "$@39", "struct_type", "$@40",
  "struct_union", "struct_body", "opt_packed", "opt_signed_struct",
  "struct_member_list", "struct_member", "member_name_list", "member_name",
  "$@41", "struct_member_type", "$@42", "member_type_token", "$@43",
  "$@44", "member_type", "struct_var_list", "struct_var", "wire_decl",
  "$@45", "$@46", "$@47", "$@48", "opt_supply_wires", "wire_name_list",
  "wire_name_and_opt_assign", "wire_name", "assign_stmt",
  "assign_expr_list", "assign_expr", "type_name", "typedef_decl",
  "typedef_base_type", "enum_struct_type", "cell_stmt", "$@49", "$@50",
  "tok_prim_wrapper", "cell_list", "single_cell", "single_cell_no_array",
  "$@51", "single_cell_arraylist", "$@52", "cell_list_no_array",
  "prim_list", "single_prim", "$@53", "cell_parameter_list_opt",
  "cell_parameter_list", "cell_parameter", "cell_port_list",
  "cell_port_list_rules", "cell_port", "always_comb_or_latch",
  "always_or_always_ff", "always_stmt", "$@54", "$@55", "$@56", "$@57",
  "always_cond", "always_events", "always_event", "opt_label",
  "opt_sva_label", "opt_property", "modport_stmt", "$@58", "$@59",
  "modport_args_opt", "modport_args", "modport_arg", "modport_member",
  "modport_type_token", "assert", "assert_property",
  "simple_behavioral_stmt", "asgn_binop", "inc_or_dec_op",
  "for_initialization", "behavioral_stmt", "$@60", "$@61", "$@62", "$@63",
  "$@64", "$@65", "$@66", "$@67", "$@68", "$@69", "$@70", "$@71",
  "if_attr", "case_attr", "case_type", "opt_synopsys_attr",
  "behavioral_stmt_list", "optional_else", "$@72", "case_body",
  "case_item", "$@73", "$@74", "gen_case_body", "gen_case_item", "$@75",
  "$@76", "case_select", "case_expr_list", "rvalue", "lvalue",
  "lvalue_concat_list", "opt_arg_list", "arg_list", "arg_list2",
  "single_arg", "module_gen_body", "gen_stmt_or_module_body_stmt",
  "genvar_identifier", "genvar_initialization", "gen_stmt", "$@77", "$@78",
  "$@79", "$@80", "$@81", "gen_block", "$@82", "$@83", "gen_stmt_block",
  "$@84", "opt_gen_else", "expr", "basic_expr", "$@85", "concat_list",
  "integral_number", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-1099)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-597)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -1099,   154,   349, -1099, -1099, -1099,   753, -1099, -1099,   685,
   -1099,   349,   349,   349,   349,   349,   349,   349,   349,   349,
     170,   176, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099,
   -1099, -1099, -1099, -1099,   311, -1099,    65,    95, -1099, -1099,
   -1099,   179,   164,   170, -1099, -1099, -1099, -1099,   343,   297,
     297,   394, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099,
   -1099, -1099, -1099,   263, -1099,   180, -1099,   588,   265, -1099,
   -1099, -1099, -1099, -1099, -1099,   329,  2560,   179,   179, -1099,
     164, -1099, -1099,   294,   112, -1099,   300,   464,   878,   878,
     536,   126, -1099,   806,   539,   170,   461,   170,   578,  2560,
     580,   450, -1099, -1099, -1099,   433,   125,   125, -1099,   304,
   -1099,   435, -1099,   620, -1099,   617, -1099,   490, -1099, -1099,
   -1099, -1099,   493, -1099, -1099, -1099, -1099, -1099, -1099, -1099,
   -1099,  2633,  2560, -1099, -1099,   120,   507, -1099,    34,   272,
    3353, -1099, -1099, -1099,   179, -1099,   660,   170, -1099, -1099,
   -1099, -1099, -1099, -1099,   179,   306, -1099, -1099, -1099, -1099,
     668, -1099,   306,   668, -1099, -1099,   675,   677, -1099, -1099,
     691, -1099,    65,   697,    95, -1099,   689, -1099, -1099, -1099,
   -1099, -1099,   546,   553,   714, -1099, -1099, -1099,   179, -1099,
   -1099, -1099, -1099,   716, -1099,   584,   592,   598,   603,  2917,
    2917,  2917,  2917,  2917,  2917,  2917,  2917,   265,  1327,    21,
     597,  2917,  2917,  2560, -1099,   179, -1099, -1099,   629,   170,
   -1099,  2560,  2560,  2560, -1099, -1099, -1099, -1099, -1099, -1099,
   -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099,
   -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099,
   -1099,   630, -1099,   631, -1099,   623, -1099,   450, -1099, -1099,
   -1099, -1099, -1099,    50, -1099,   633,   179,   215,   637,   640,
     804,   664, -1099, -1099, -1099,   179,   658, -1099, -1099,   115,
     662,   667,   669, -1099, -1099,   661, -1099,   829,   694, -1099,
    2560,  2560,  2560,  2560, -1099, -1099, -1099, -1099, -1099, -1099,
   -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099,
   -1099, -1099, -1099, -1099, -1099,  2560,   317,  2560,  2560,  2560,
    2560, -1099, -1099, -1099,   289,   681,  2560,   192, -1099,   676,
     678,   679,  2917,  2917,  2917,  2917,  2917,  2917,  2917,  2917,
    2917,  2917,  2917,  2917,  2917,  2917,  2917,  2917,  2917,  2917,
    2917,  2917,  2917,  2917,  2917,  2917,  2917,  2917,  2560,  2560,
   -1099,   680,   170,   553,   668, -1099,  2560, -1099, -1099, -1099,
     844,   686, -1099,   850,   658,   658, -1099,   695,   693,   171,
     854,   700, -1099,   614,   708, -1099, -1099,  2917, -1099,   714,
     699, -1099, -1099, -1099,   221, -1099, -1099,   125,   125, -1099,
     271,   179,   709,   711,   715,   717,   718, -1099,   705,   721,
     726, -1099,   725,   727,  2560,   724, -1099, -1099, -1099,  3422,
    3447,  3470,  3470,  1194,  1194,  3489,  3489,  2889,  2889,  2889,
    2889,   786,   786,   786,   786,   663,   663,   663,   663,   538,
     538,   468,   468,   468,   735,   736,   732,   738,   896, -1099,
     758, -1099, -1099,   232,   923, -1099,    -7, -1099,   640,   925,
     779,   781, -1099,   942, -1099,   642,   789, -1099, -1099,   791,
     947,   792, -1099,   636, -1099,   607,   179,   116,   794,   440,
    3396, -1099, -1099,   179,   829, -1099, -1099, -1099, -1099, -1099,
   -1099, -1099, -1099, -1099, -1099,  2560, -1099,   785,   170,   799,
   -1099, -1099, -1099, -1099, -1099,  2560,  1707, -1099, -1099,   361,
   -1099,   793,   600, -1099, -1099, -1099, -1099, -1099, -1099,   844,
   -1099,   796, -1099, -1099, -1099,   614,   805, -1099,   960,   352,
   -1099, -1099,   171,   803,  2560, -1099, -1099, -1099, -1099, -1099,
   -1099,   607,   876, -1099,   860,   976, -1099, -1099,   179, -1099,
     979,   820,  1043, -1099, -1099, -1099, -1099, -1099, -1099, -1099,
   -1099, -1099, -1099, -1099, -1099,   329,   823, -1099, -1099,  2560,
     831, -1099,   990,    -5, -1099, -1099,   834,   896, -1099,  3046,
     992, -1099, -1099, -1099,   640,   415,   478,   179,   109, -1099,
     179, -1099,   833, -1099,   160,   964, -1099,   444, -1099, -1099,
   -1099, -1099,   641, -1099,   837, -1099,   950,   618,   878,   878,
   -1099, -1099, -1099,   791,   860, -1099,   867, -1099, -1099, -1099,
   -1099, -1099, -1099, -1099,   314,   621, -1099, -1099, -1099,   170,
     399, -1099, -1099, -1099,    68, -1099, -1099, -1099, -1099, -1099,
    1004,  1006,   179, -1099, -1099, -1099, -1099, -1099, -1099,   851,
    1707, -1099, -1099, -1099, -1099,   793, -1099,   852,   855, -1099,
   -1099, -1099,   103,   372,    72, -1099,  1011, -1099,  3367, -1099,
   -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099,
    1013, -1099, -1099, -1099, -1099, -1099, -1099, -1099,   704, -1099,
     858, -1099, -1099, -1099,   862, -1099, -1099, -1099, -1099,   864,
   -1099, -1099, -1099, -1099, -1099, -1099,  1776, -1099, -1099,   866,
     875,   877,   981,   984,   985, -1099,  2560,    62, -1099, -1099,
    1153, -1099,    90,    90,    90,    57, -1099,   881,   883,   668,
     668, -1099,   314, -1099, -1099, -1099, -1099, -1099, -1099, -1099,
     791,   886,   179, -1099,   888,   400, -1099,   891,   444, -1099,
   -1099, -1099,   444,   884,  1849, -1099,  1155,   885,   895, -1099,
     894, -1099,   793,  2560, -1099,   898,   900,   980,   103,   901,
   -1099,   903, -1099,   476, -1099, -1099,   911, -1099,   893, -1099,
     912,  2560,  1070,   403, -1099,   916,  3174,   913, -1099, -1099,
   -1099, -1099,   820, -1099,   413, -1099,   987,   991,   994,   995,
    2560, -1099,   960, -1099,   915,   379,   920,   894,   793, -1099,
    2560,  2560,   909,   931,   894,    68,   820,   820,    34,   820,
   -1099, -1099,   929,   930,   936, -1099,   937,  2560,  2560, -1099,
   -1099, -1099, -1099,  2560, -1099,    89, -1099,    68, -1099,  2560,
   -1099, -1099, -1099,   820, -1099,   128, -1099, -1099,   939, -1099,
    1095, -1099, -1099, -1099,  2560,   940, -1099,   943,   104,   654,
    2560, -1099, -1099,   654,   179,  2560, -1099, -1099,   409,   945,
     949, -1099,  1453,   941, -1099,   422,  1070, -1099,  2560, -1099,
     722, -1099, -1099, -1099, -1099, -1099,   680,  1098, -1099,  1013,
   -1099,   948,   951,   952,   954,   956, -1099, -1099,  2560, -1099,
    2560,   953, -1099,  1106,   959,   961, -1099,  2560,   962, -1099,
    2560,  2560, -1099,  2560,  1918,  2028,  2097,  2170,   967,   971,
   -1099, -1099, -1099, -1099, -1099,   977, -1099, -1099,  1107,   973,
   -1099, -1099,   437,   439,   960,   972, -1099,  1373,   444, -1099,
     978, -1099,   799, -1099, -1099, -1099, -1099,  1118,   983,   974,
   -1099, -1099,  2560,   986,  2560, -1099,   988,   975, -1099, -1099,
    1070,   998,   216, -1099,  2702,  2702,  1070,  1070, -1099,   340,
   -1099,  2560, -1099, -1099, -1099, -1099, -1099,  1134, -1099,   447,
   -1099,  1134, -1099,  2239,  2349,  2418,  2560, -1099,   393,   989,
   -1099, -1099,   993,   179,   982, -1099, -1099, -1099, -1099, -1099,
   -1099, -1099,  2560,  1000,  2560,  1001,  2560,  1003,  1017,  1005,
   -1099, -1099,   122,  1019, -1099, -1099,  1142, -1099, -1099,   999,
   -1099,   997, -1099, -1099,  2560,  2560,  1020,    26, -1099, -1099,
   -1099,  2491,  1022,  3228,  1097,  1027,  2560,  2560,  1074, -1099,
    1181, -1099,  2560,  1040,   333,  1049, -1099, -1099,  1070,   398,
    1035,  2633, -1099,  1038, -1099, -1099, -1099,  1453,  1453,  1034,
    1036,  3100,   179,   480, -1099, -1099, -1099,  1098, -1099, -1099,
     481, -1099,  1044,  2560,  1045,  2560,  1047,  2560,  1048,  1051,
   -1099,  2560, -1099,  2560,   601,  2560,  1202,  2560,   444,   444,
    1053,  1062,  1064,  1065,  1072,  1069, -1099,  1073,   444, -1099,
   -1099, -1099, -1099,   960,  1075,  2560, -1099, -1099, -1099,  1565,
    1565, -1099, -1099,  1077, -1099,   793, -1099,  1154,  3302,  2560,
   -1099, -1099,  2560,  1079,  2775,  1076,  1083,  1099, -1099,  1070,
   -1099,  1070, -1099,  1102,  1038,  1711,  2560, -1099, -1099, -1099,
   -1099, -1099, -1099, -1099,  1134, -1099, -1099,  1134, -1099, -1099,
    1080,  1084,  1086,  1087,  1091,  1092,  1096,  1180,  1100, -1099,
     793, -1099, -1099,  1121, -1099, -1099, -1099,  1119, -1099,  1120,
   -1099,  1122, -1099, -1099, -1099,   651, -1099, -1099, -1099, -1099,
   -1099, -1099, -1099,  1097, -1099, -1099, -1099,  1129, -1099,   654,
    2633,  1131, -1099,  2560,  1093,  1123,   410, -1099, -1099, -1099,
    1070,  1132,  2560,  1038,  1135, -1099, -1099,  1136,  1137, -1099,
    1138, -1099,  1139, -1099, -1099, -1099, -1099,  1634, -1099, -1099,
    2560,  1140, -1099, -1099, -1099,  1201, -1099, -1099,  1192, -1099,
   -1099,  2560,  1569,  1147, -1099,  1070,  1070,  1070, -1099,  1145,
   -1099,  1116, -1099, -1099, -1099, -1099, -1099, -1099, -1099,   185,
   -1099,   308, -1099, -1099, -1099, -1099, -1099, -1099, -1099,  1634,
      69,  1146,  1074,  2560,  2560,  2560,  2844,   373,   362, -1099,
   -1099,  2560,  1149,  1097,  2560, -1099,  1151,   444, -1099,  1097,
    1141,  1156,  1157,   280,  2633,  1159, -1099,  1144,  2560,  1152,
    2560,  1161,   823, -1099, -1099, -1099, -1099, -1099,   444, -1099,
    2560, -1099, -1099, -1099,  1162,  2495, -1099,  2560,  1163,  2560,
    1218,  2560,   444, -1099,  1166,  2560,  2560,  1216,  1220,  1221,
    1223,  1227, -1099,  2560,  1228,   454,  1226,  2560, -1099,  1230,
   -1099,  1231, -1099,  1233,  2560, -1099,  2560, -1099, -1099, -1099,
   -1099,   479,   823,  2560, -1099,  1236,  2560,  1239,  2560,   489,
    2560, -1099,  1240,  2560,  1241,  2560,  1242,  2560,  1243,  2560,
    1244,  2560,  1245, -1099
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,    14,     1,    18,    74,     0,    88,     3,     0,
      17,    14,    14,    14,    14,    14,    14,    14,    14,    14,
      22,     0,    30,    31,   148,   147,   142,   340,   364,   143,
     146,   144,   145,   365,     0,   413,   204,   207,   416,   417,
     362,   156,     0,     0,    33,   327,   329,    65,     0,   219,
     219,    15,     5,     4,    10,    11,    12,     6,     7,     8,
       9,    27,    19,    21,    23,    25,    75,   344,     0,   205,
     206,   415,   208,   209,   414,   368,     0,   155,   158,   157,
       0,   409,   410,     0,    97,    89,    94,     0,   314,   314,
       0,     0,   218,   201,     0,    22,     0,     0,     0,     0,
       0,    39,   346,   347,   345,     0,   350,   350,    32,   371,
     363,     0,   650,   703,   649,     0,   704,     0,    14,    14,
     531,   532,     0,    14,    14,    14,    14,    14,    14,    14,
      14,     0,     0,    14,    14,   156,     0,    14,   645,     0,
     641,   648,   153,   154,   156,   412,     0,     0,    92,    34,
     312,   316,   313,   326,   156,   314,   323,   322,   324,   325,
       0,   315,   314,     0,    66,   185,     0,     0,   202,   203,
       0,   197,   204,     0,   207,   191,     0,    20,    24,    28,
      26,    29,     0,    49,     0,   348,   349,   342,   156,   369,
     370,   367,   379,     0,   705,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,   701,
       0,     0,     0,     0,   651,   602,   601,   647,     0,     0,
     644,     0,     0,     0,   152,    14,    14,    14,    14,    14,
      14,    14,    14,    14,    14,    14,    14,    14,    14,    14,
      14,    14,    14,    14,    14,    14,    14,    14,    14,    14,
      14,     0,    14,     0,    90,    93,    95,    39,   155,   317,
     321,   318,   335,     0,   331,   334,   319,     0,     0,   213,
       0,     0,   193,   200,   195,   198,   221,    16,    36,    14,
       0,   355,    54,   351,   343,   379,   372,     0,   382,   706,
       0,     0,     0,     0,   645,   668,   669,   670,   671,   666,
     667,   690,   691,   519,   520,   521,   522,   523,   524,   525,
     526,   527,   528,   529,   530,     0,   655,     0,     0,     0,
       0,   657,   659,   694,     0,     0,     0,   156,   643,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     411,   440,     0,    49,     0,   328,     0,   320,   330,    69,
     217,     0,   187,     0,   221,   221,   199,   222,     0,    14,
      57,     0,    48,   112,    54,    51,    78,     0,   353,    53,
       0,   366,   373,   377,     0,   375,   387,   350,   350,   380,
       0,   156,     0,     0,     0,     0,     0,   646,     0,     0,
     701,   702,     0,   152,   610,     0,   150,   151,   149,   693,
     692,   662,   663,   664,   665,   660,   661,   678,   679,   680,
     681,   676,   677,   682,   683,   672,   673,   674,   675,   684,
     685,   686,   687,   688,   689,     0,     0,     0,     0,    96,
       0,   332,   333,    14,   211,   216,     0,   186,   213,     0,
       0,     0,   220,    14,   232,     0,    37,    40,    47,    56,
       0,     0,   114,     0,   115,   125,   156,    14,     0,    14,
     354,   352,   341,   156,     0,   374,   385,   386,   383,   381,
     695,   653,   654,   696,   699,     0,   700,     0,     0,    54,
     609,   611,   613,   698,   697,     0,   443,   428,   432,     0,
     163,   480,     0,    68,    73,    72,    71,    70,   210,   215,
     212,     0,   189,   232,   232,   112,    54,   225,     0,    14,
      43,    45,    14,     0,     0,    58,    60,    64,   116,   117,
     118,   125,   124,   123,     0,     0,    52,    50,   156,    76,
       0,   109,   112,    77,    87,    79,    80,    82,    83,    85,
      81,    84,    86,   378,   376,   368,     0,   658,   600,    53,
       0,   642,     0,     0,   441,   444,     0,     0,    91,    14,
       0,    67,   214,   188,   213,    14,    14,   156,    14,   223,
     156,   230,     0,   192,     0,   112,   536,    14,   539,   540,
     538,   541,     0,   537,     0,   231,     0,     0,   314,   314,
      41,    38,    55,    56,   127,   122,   132,   138,   137,   136,
     130,   139,   135,   141,   121,   128,   134,   140,    62,     0,
       0,   337,   486,   108,     0,   458,   465,   459,   456,   457,
       0,     0,   156,   463,   460,   384,   656,   612,   652,     0,
     443,   439,    14,   433,   631,   480,   633,     0,     0,   573,
     574,   575,   235,   272,     0,   616,     0,   162,   112,   179,
     176,   159,   181,   164,   165,   182,   170,   166,   167,   169,
       0,   174,   175,   171,   172,   168,   173,   177,     0,   180,
       0,   160,   161,   479,     0,   194,   196,   227,   226,     0,
     404,   481,   100,   101,   102,   103,     0,   547,   549,     0,
       0,     0,   572,   570,   571,   544,     0,   156,    14,   603,
      14,   542,   485,   485,   485,   485,   543,     0,     0,     0,
       0,    61,   121,   126,   131,   133,   119,   120,   113,   129,
      56,     0,   156,   336,     0,     0,   406,     0,    14,   394,
     396,   391,    14,   472,     0,   442,   450,     0,   447,   448,
     608,    35,   480,     0,   624,     0,     0,     0,   235,     0,
     310,     0,   259,   272,   261,   262,     0,   263,     0,   264,
       0,     0,     0,     0,   268,     0,    14,     0,   418,   422,
     423,   360,   109,   358,     0,   356,     0,     0,     0,     0,
       0,   190,     0,   224,     0,     0,    98,   608,   480,   552,
       0,     0,     0,   605,   608,     0,   109,   109,     0,   109,
     484,   483,     0,     0,     0,   504,     0,     0,     0,    44,
      46,   111,    63,     0,   338,     0,   487,     0,   405,     0,
     466,   398,   398,   109,   464,     0,   461,   445,     0,   455,
       0,   451,   429,    14,   610,     0,   634,     0,     0,   250,
       0,   233,   234,   250,   156,     0,   258,   260,     0,     0,
       0,   273,     0,     0,   307,     0,     0,   265,     0,   178,
     112,   618,   614,   617,   615,   183,   440,     0,   420,     0,
     359,     0,     0,     0,     0,     0,   228,   104,     0,   105,
       0,     0,   550,   112,     0,     0,   604,     0,     0,   516,
       0,     0,   515,     0,     0,     0,     0,     0,     0,     0,
     339,   495,   496,   497,   489,    54,   491,   494,     0,     0,
     407,   408,     0,     0,     0,     0,   471,     0,    14,   446,
     454,   449,    54,   632,   616,   627,   620,     0,     0,     0,
     248,   249,     0,     0,     0,   311,     0,   308,   281,   282,
       0,     0,   297,   298,     0,     0,     0,     0,   304,     0,
     303,     0,   266,   269,   270,   619,   163,     0,   390,     0,
     388,   437,   357,     0,     0,     0,     0,   629,     0,     0,
     548,   580,     0,   156,     0,   556,   558,   606,   546,   517,
     514,   518,     0,     0,     0,     0,     0,     0,     0,     0,
     560,   563,    53,     0,   493,   488,     0,   395,   397,   392,
     400,   402,   469,   470,     0,     0,     0,     0,   473,   478,
     462,     0,     0,    14,   636,   621,     0,     0,   243,   240,
       0,   271,     0,     0,   297,     0,   295,   296,     0,   297,
     289,     0,   274,   277,   275,   301,   302,     0,     0,     0,
       0,    14,   428,     0,   424,   426,   427,     0,   361,   436,
       0,   434,     0,     0,     0,     0,     0,     0,     0,     0,
     590,     0,   106,     0,    14,     0,     0,     0,    14,    14,
       0,     0,     0,     0,     0,     0,   503,     0,    14,   578,
     492,   490,   399,     0,     0,     0,   476,   477,   468,     0,
       0,   467,   453,     0,   607,   480,   638,   640,    14,     0,
     623,   625,     0,     0,     0,     0,     0,     0,   289,     0,
     291,     0,   290,     0,     0,   308,     0,   278,   305,   306,
     300,   267,   184,   430,     0,   419,   389,   437,   421,    14,
       0,     0,     0,     0,     0,     0,     0,   591,     0,    99,
     480,   579,   533,   534,   553,   557,   559,     0,   498,     0,
     499,     0,   505,   502,   561,   585,   401,   393,   403,   474,
     475,   452,   635,   636,   628,   637,   622,     0,   242,   250,
       0,     0,   244,     0,     0,     0,     0,   293,   299,   292,
       0,     0,     0,   279,     0,   425,   435,     0,     0,   507,
       0,   508,     0,   512,   511,   630,   589,     0,   107,   551,
       0,     0,   500,   501,   506,   583,   576,   577,   586,   639,
      14,     0,     0,     0,   309,     0,     0,     0,   286,     0,
     276,     0,   280,    14,   438,   509,   510,   513,   597,   595,
     592,     0,   598,   535,    14,   581,   562,   564,   584,     0,
       0,     0,   243,     0,     0,     0,     0,   297,   297,   294,
     283,     0,     0,   636,     0,   594,     0,    14,   587,   636,
       0,     0,     0,     0,     0,     0,   251,   256,     0,     0,
       0,     0,   309,   431,   593,   599,   554,   582,    14,   626,
       0,   247,   246,   245,     0,   256,   236,     0,     0,     0,
       0,     0,    14,   588,   239,     0,     0,     0,     0,     0,
       0,     0,   555,     0,     0,     0,     0,     0,   288,     0,
     285,     0,   238,     0,     0,   252,     0,   257,   287,   284,
     237,     0,   257,     0,   253,     0,     0,     0,     0,     0,
       0,   254,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   255
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1099, -1099, -1099,  1160,    67, -1099, -1099,    86, -1099, -1099,
    1308, -1099,  1307,    -8,   -18, -1099, -1099, -1099,  1158, -1099,
   -1099, -1099,   874, -1099, -1099,  1046, -1099,  -383,  -479,   933,
   -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099,
   -1099, -1099, -1099, -1099,  -468, -1099, -1099, -1099, -1099, -1099,
   -1099,   -95,  -851,  -460,  -283, -1099, -1099,   505, -1099,  -349,
   -1099,   682,   870, -1099,   798, -1099,  -281,   -39, -1099,   -48,
    -129,   -40,  -139,   445,  -572, -1099, -1099,  -450, -1099, -1099,
   -1099, -1099, -1099, -1099, -1099, -1099,  1250,  1249,   897,  -300,
   -1099,  1363,   380, -1099, -1099, -1099,   836, -1099, -1099,   224,
   -1099,   657, -1099, -1099, -1099,   165, -1099,  -841, -1099,  1862,
   -1099, -1099,   653,  -567, -1099,   646,   554, -1099, -1099, -1099,
     466,  -996, -1099, -1099, -1099,   469, -1099,   197,  -926,  -886,
    -990, -1099,  -288, -1099,   462,  -696,  -542, -1099,   322, -1099,
   -1099, -1099, -1099, -1099, -1099,   -80,     2, -1099,    25, -1099,
    1271,  -313, -1099,   958, -1099,   696,  1433, -1099, -1099,   -59,
     -36,   -74, -1099,  1052, -1099, -1099,   551, -1099, -1099, -1099,
    1448, -1099,  1055,   904, -1099, -1099, -1099,  1175, -1099,   996,
   -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099,   404,  -455,
   -1099, -1099, -1099, -1099,   619, -1099,   367,  -482,  1008, -1099,
     628,  1392,    46,  1467, -1099, -1099, -1099, -1099, -1099, -1099,
    -909,  -356, -1099, -1099, -1099, -1099, -1099,   330, -1099,   590,
   -1099,   828, -1034, -1099,   626, -1099, -1099,  1009, -1099, -1099,
   -1099, -1099, -1099, -1099,  -333,  -645,  -554,    19, -1099, -1099,
   -1099, -1099, -1099,   482,   562, -1099, -1099, -1099, -1098,   771,
    -136, -1099,  -571, -1099, -1099, -1099, -1099, -1099, -1099, -1099,
   -1099, -1099, -1099, -1099, -1099, -1099, -1099,   889, -1099, -1099,
   -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099, -1099,
     234, -1099,    54,  -589,   594,  -269,   648, -1099,   926,   559,
     392,   564, -1099,  -547, -1099, -1099, -1099, -1099, -1099,  -512,
   -1099, -1099, -1074, -1099, -1099,   -76,  1018, -1099,   460,   -82
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,     2,     8,   595,    10,    51,   596,    20,    96,
      62,    63,    64,   135,    35,    12,    87,   257,   183,   379,
     533,   466,   467,   608,   609,   280,   384,   390,   535,   385,
     469,   470,   613,   740,    13,    90,   268,   453,   513,    14,
      21,   101,   479,   553,    15,    43,   146,   361,    85,   148,
     255,    86,   805,   597,   634,   472,   473,   474,   475,   642,
     541,   738,   544,   732,   624,   625,   626,    36,    37,    77,
      78,    79,    80,   579,   881,   672,   976,    16,   269,   458,
     584,   276,   374,   375,   173,   174,    71,    74,   455,   371,
     456,    93,   378,   463,   699,   526,   527,   802,   528,   529,
     674,   767,   768,  1324,   769,  1123,  1191,   952,  1285,  1286,
     675,   773,   774,   676,   782,   783,   784,   776,   777,   778,
    1052,  1137,   960,   869,   870,   961,  1049,  1196,  1050,   962,
    1197,   779,   968,   969,   873,   970,  1198,   864,   154,   155,
     156,   260,   157,   158,   159,   160,   598,    88,   599,    89,
     263,   264,   265,   679,   630,   631,   680,    67,   105,   161,
     162,   187,   282,   283,   388,   794,   795,   681,   682,   887,
     791,    75,    40,   110,   111,   191,   285,   286,   394,   395,
     483,   287,   288,   399,   400,   565,   401,   979,   980,   600,
     843,  1104,   841,   842,   932,  1019,  1020,  1021,   684,   745,
     746,    83,   601,   136,    42,   686,   886,   981,   792,  1063,
    1069,  1065,   576,  1066,  1204,   509,  1070,  1071,  1072,   448,
     573,   574,   757,   758,   759,   643,   644,   687,   753,   938,
     752,   748,   846,  1027,  1028,   581,   602,   822,   562,   744,
     929,   836,   925,   926,   927,   928,   603,   689,   604,   318,
     137,   994,   605,   814,   807,   808,   991,   903,  1221,  1312,
    1088,  1089,  1098,  1225,  1099,   606,   607,   690,  1175,  1084,
    1256,  1277,  1228,  1258,  1259,  1298,  1157,  1216,  1217,  1273,
    1250,  1251,   138,   720,   812,   855,   499,   500,   501,   786,
     882,   948,   949,   883,   858,  1187,  1034,  1080,   760,  1116,
     762,   944,  1117,  1118,  1184,  1287,   140,   325,   210,   141
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     139,   478,   220,   514,    17,   253,   215,   671,   106,   163,
     761,   554,    65,    17,    17,    17,    17,    17,    17,    17,
      17,    17,   954,   180,   558,   688,   721,    18,   104,   142,
     143,   107,   691,   188,   476,    84,    18,    18,    18,    18,
      18,    18,    18,    18,    18,   747,   591,   988,    19,   104,
     104,   451,   256,   217,   172,   208,   209,    19,    19,    19,
      19,    19,    19,    19,    19,    19,   468,   692,  1064,     9,
     153,   153,    61,    61,  1044,   171,   770,   820,     9,     9,
       9,     9,     9,     9,     9,     9,     9,    65,    11,    65,
    1109,   633,   508,   921,    98,   216,   775,    11,    11,    11,
      11,    11,    11,    11,    11,    11,   258,   765,   946,  1229,
     820,   670,    69,  -229,   259,  1207,   570,   856,  1128,   380,
     380,   780,   785,  1132,   683,   113,   921,   922,   923,   673,
     165,   115,  1261,   116,   731,   120,   121,   324,  1201,    84,
     258,   -14,    72,   589,    98,   329,   330,   331,   284,   935,
     821,   519,    98,   650,     3,   520,  1276,   651,   521,   766,
     922,   923,  1130,   902,   702,   703,   704,   143,    81,   956,
     120,   121,   185,    70,    61,   262,   587,   840,    82,   319,
      66,   844,   974,   821,  1110,   196,   197,   947,  1111,   320,
     199,   200,   201,   202,   203,   204,   205,   206,   215,  1294,
     211,   212,   214,    73,   219,  1299,   775,  1242,   364,  1272,
    1239,   327,    98,   365,   402,   403,   404,   405,   367,   468,
     825,   653,   100,  -545,    98,  -545,   909,   376,   213,   397,
    1158,   780,   688,   186,   407,  1205,   716,   716,   781,   406,
     785,   408,   409,   410,   410,  1199,  1268,  1269,   747,   104,
     415,   924,   398,   294,   294,   294,   294,   294,   294,   294,
     294,   832,   489,   511,  -241,   294,   294,   449,  1053,  1053,
     396,   -53,   100,   328,   884,   381,   381,   382,   -53,   936,
     100,   -14,   445,   446,   694,   166,   213,   216,   705,   937,
     452,   167,   332,   333,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   670,   359,
     896,   706,   113,   486,   487,    68,   963,     6,   115,   -42,
     116,   683,   633,   -42,   785,   735,   673,   545,   502,    99,
     100,  1289,  1291,  -596,   739,    76,   383,    91,  1231,   -13,
    -596,   189,   100,   150,    84,  1134,   633,   633,   213,   633,
     592,   736,    92,   221,   222,  1046,  1047,  1030,  -482,  -482,
    -482,  -482,     4,   364,  1048,     4,   770,    28,   368,   484,
     221,   222,     5,   633,   485,    33,   294,   294,   294,   294,
     294,   294,   294,   294,   294,   294,   294,   294,   294,   294,
     294,   294,   294,   294,   294,   294,   294,   294,   294,   294,
     294,   294,   190,   770,   152,    95,   829,   830,   963,   566,
    1057,    97,   737,   592,  1055,  1056,   593,   108,   771,   571,
     575,  -482,  -482,  -482,  -482,   258,   109,   223,     4,   224,
    1203,   294,  1303,   563,     6,   495,   465,     6,   697,   772,
     664,   700,   592,  1290,   223,   515,   413,   145,   612,   718,
    -482,  -482,  -482,  -482,  1288,   147,  1274,     4,   149,   548,
    1182,   958,   959,  1275,   549,   550,     7,   261,   516,   688,
     770,   555,  1046,  1047,   266,   177,   592,   695,   551,   671,
     327,  1048,  1127,   502,  -482,  -482,  -482,  -482,  1058,   517,
     258,     4,  1059,   751,   556,   627,   963,   688,   629,   888,
       6,  1046,  1047,  1161,   691,  1219,   594,  1165,  1166,   577,
     512,   884,  1046,  1047,   578,   560,   623,  1174,   729,   730,
     525,  1237,   771,   910,   911,     6,   913,   898,   901,     6,
     164,   899,  1013,   175,   383,   908,   552,  1046,  1047,   692,
     696,  1081,   568,   866,   664,  1082,  1131,   742,   837,  1032,
     934,   876,   743,   838,   688,   670,   877,     7,  1237,   104,
     104,   889,  1238,     6,   575,   627,   890,   627,   683,   594,
     876,   677,   179,   673,   181,   972,   627,   717,   215,   963,
     153,   153,  1308,   670,  1310,  1016,   623,  1016,   623,   465,
    1017,   184,  1018,   192,   678,  1067,   683,   623,   594,   592,
    1068,   673,  1334,  1319,   182,  1321,  1335,  -482,  -482,  -482,
    -482,   327,   250,   251,     4,   685,   327,    45,    46,   194,
     806,   193,   102,   103,    26,    22,    23,  1343,  1144,  1147,
     813,  1344,   594,  1145,  1148,   195,   668,  1350,   198,   719,
     670,  1351,  -110,  -110,  -110,   525,  1160,   722,   723,   724,
     725,    48,   218,   683,   254,   669,   621,    26,   673,   530,
     531,    49,   262,    50,   538,   539,   540,   216,   848,   270,
     851,   271,   912,   741,   659,   660,   661,   857,   719,   247,
     248,   249,   250,   251,   258,   272,     6,    29,    30,    31,
      32,   274,   629,   542,   543,   874,  1297,   278,    22,    23,
      44,   277,    45,    46,   279,    47,   950,   951,   281,   756,
     796,   797,   798,   799,   895,   955,   788,  1313,   289,   789,
      29,    30,    31,    32,   904,   905,  1226,  1227,   102,   103,
      26,  1322,   823,   824,   826,   290,    48,   585,   586,    45,
      46,   918,   919,   291,   460,   461,    49,   920,    50,   292,
    -110,  -110,  -110,   931,   293,   594,   321,    22,    23,  1138,
    1139,   635,   636,   637,   638,   639,  1179,  1180,   502,   411,
     412,   362,    34,    48,   953,   815,   790,   818,   677,   957,
     326,   358,   366,    49,   360,    50,   957,    24,    25,    26,
     369,   370,   957,    29,    30,    31,    32,   327,   372,   640,
     641,   678,   245,   246,   247,   248,   249,   250,   251,   377,
      22,    23,   806,   373,   989,   386,   387,   389,    28,   327,
     391,   813,   685,   393,   999,  1000,    33,  1001,  1003,  1005,
    1007,  1009,   414,   416,   447,   417,   418,    27,   454,   457,
     168,   169,    26,   880,   459,    34,   464,   462,   -59,    28,
     471,  1029,    29,    30,    31,    32,   477,    33,   482,   719,
     495,   490,   669,   491,    22,    23,  1038,   492,  1040,   493,
     494,    22,    23,   496,   319,   975,   503,   498,   957,   957,
     251,   719,    22,    23,   497,   874,   616,   505,   504,   506,
     507,   617,   618,   619,   620,   621,    26,  1074,  1076,  1078,
    1079,   734,   621,    26,    34,    29,    30,    31,    32,   170,
     756,   510,   102,   103,    26,   150,  1090,   518,  1092,   522,
    1094,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   523,   622,   524,   258,  -229,   532,  1106,  1107,
     534,   536,   537,  1086,   567,  1113,   547,   569,   580,   583,
    1120,  1121,   151,   588,   590,   611,  1125,    34,    61,    29,
      30,    31,    32,   615,   707,  1135,    29,    30,    31,    32,
     628,   957,   957,   632,   594,   646,   152,    29,    30,    31,
      32,    45,    46,   648,   649,   652,   693,  1150,   701,  1152,
     726,  1154,  -110,  -110,  -110,   806,   727,  1159,   749,  1162,
     750,  1164,   754,   763,  1143,   787,   764,   793,   708,   800,
    -565,    34,   709,   710,   711,   801,   803,   809,    34,  1178,
    -569,  -569,  -569,  1029,  1029,   677,   810,  -568,   811,    34,
    -566,  -567,   827,  1186,   828,   833,  1188,   852,  1192,   835,
     839,   640,   641,   853,   845,   854,   871,   861,   678,   859,
     957,   860,   863,   677,   865,   120,   121,   712,   713,   714,
      45,    46,   868,   872,   770,   878,   885,   897,   906,   685,
     891,  -110,  -110,  -110,   892,   900,   678,   893,   894,   907,
     914,   915,   635,   636,   637,   638,   639,   916,   917,   940,
     880,   939,   978,   943,   964,   945,   971,   685,   965,   983,
     992,   921,   984,   985,  1232,   986,   990,  1234,   987,   669,
     677,   995,   946,   996,   718,   998,  1241,   715,   668,  1010,
     640,   641,   716,  1011,  1022,  1012,  1015,  1037,  1062,  1031,
    1042,  1252,  1036,   678,  1253,  1087,  1102,   669,  1039,  1045,
    1041,   656,  1085,  1122,  1083,  1262,  1105,  1103,   112,    61,
     113,   114,  1091,  1093,   685,  1095,   115,  1097,   116,    22,
      23,    52,    53,    54,    55,    56,    57,    58,    59,    60,
    1096,  1101,  1108,  1252,  1114,   880,  1119,  1281,  1282,  1283,
    1124,  1126,   849,  1129,  1133,  1292,  1136,  1140,  1295,    24,
      25,    26,   117,  1141,   669,  1149,  1163,  1151,  1305,  1153,
    1155,  1183,   957,  1156,   957,  1167,   756,   295,   296,   297,
     298,   299,   300,   301,   302,  1168,  1169,  1194,  1170,   322,
     323,  1317,  1172,   957,  1171,   957,  1173,  1189,  1177,  1181,
    1326,  1193,  1208,  1195,   118,   119,  1200,  1209,  1210,  1215,
    1211,  1337,   327,  1212,  1235,  1213,   120,   121,  1255,  1214,
    1342,  1257,  1218,   122,    29,    30,    31,    32,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
    1220,  1271,  1222,  1223,  1236,  1224,   123,   124,   125,   126,
     127,   128,  1230,  1233,  1240,   816,  1243,  1260,  1244,  1300,
    1245,  1246,  1247,  1254,   129,   130,  1266,  1270,  1279,  1307,
     756,  1293,   817,  1296,   719,   850,   131,  1309,  1301,  1302,
    1315,  1260,  1306,   132,  1323,  1318,  1311,   133,   134,   231,
     232,   233,   234,   235,   236,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     419,   420,   421,   422,   423,   424,   425,   426,   427,   428,
     429,   430,   431,   432,   433,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,   444,   112,    61,   113,   114,
    1320,  1327,  1328,  1329,   115,  1330,   116,    22,    23,  1331,
    1333,  1336,  1338,  1339,  1346,  1023,  1340,  1348,  1353,  1355,
    1357,  1359,  1361,   176,   178,   480,   610,  1363,   993,   450,
     546,   614,   733,    94,   831,   363,   582,    24,    25,    26,
     117,  1061,   273,   275,   698,   862,   867,  1280,   875,  1043,
     973,  1054,  1267,  1060,   267,  1024,  1025,   557,   834,    38,
     982,   481,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,    39,   488,   112,    61,   113,   114,
     392,   933,   118,   119,   115,   930,   116,    22,    23,   645,
    1176,  1146,   144,    41,   120,   121,   977,  1206,   755,   941,
     564,   122,    29,    30,    31,    32,   315,   559,   561,   316,
    1014,   819,   317,  1278,  1100,   647,   728,    24,    25,    26,
     117,   997,   942,  1033,   123,   124,   125,   126,   127,   128,
    1185,  1035,     0,     0,     0,   966,   967,     0,     0,     0,
       0,     0,   129,   130,  1026,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   131,     0,     0,     0,     0,     0,
       0,   132,   118,   119,     0,   133,   134,     0,     0,     0,
       0,     0,     0,     0,   120,   121,     0,     0,     0,     0,
       0,   122,    29,    30,    31,    32,     0,     0,   112,    61,
     113,   114,     0,     0,     0,     0,   115,     0,   116,    22,
      23,     0,     0,     0,   123,   124,   125,   126,   127,   128,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   129,   130,     0,     0,     0,     0,     0,    24,
      25,    26,   117,     0,   131,     0,     0,     0,     0,     0,
       0,   132,     0,     0,     0,   133,   134,  1024,  1025,     0,
       0,     0,     0,     0,     0,     0,     0,   112,    61,   113,
     114,     0,  1248,     0,     0,   115,     0,   116,    22,    23,
       0,     0,     0,     0,   118,   119,     0,     0,     0,     0,
    1263,  1264,     0,     0,     0,     0,   120,   121,     0,     0,
       0,     0,     0,   122,    29,    30,    31,    32,    24,    25,
      26,   117,     0,     0,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   123,   124,   125,   126,
     127,   128,     0,     0,  1249,     0,     0,     0,     0,     0,
     112,    61,   113,   114,   129,   130,     0,     0,   115,     0,
     116,    22,    23,   118,   119,     0,   131,     0,   315,     0,
       0,   316,     0,   132,  1265,   120,   121,   133,   134,     0,
       0,     0,   122,    29,    30,    31,    32,     0,     0,     0,
       0,    24,    25,    26,   117,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   123,   124,   125,   126,   127,
     128,     0,     0,     0,     0,     0,     0,     0,     0,   112,
      61,   113,   114,   129,   130,     0,     0,   115,     0,   116,
      22,    23,     0,     0,     0,   131,   118,   119,     0,     0,
       0,     0,   132,     0,     0,     0,   133,   134,   120,   121,
       0,     0,     0,     0,     0,   122,    29,    30,    31,    32,
      24,    25,    26,   117,     0,     0,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   123,   124,
     125,   126,   127,   128,     0,     0,     0,     0,     0,     0,
       0,     0,   112,    61,   113,   114,   129,   130,     0,     0,
     115,     0,   116,    22,    23,   118,   119,   572,   131,     0,
     315,     0,     0,   316,     0,   132,  1202,   120,   121,   133,
     134,     0,     0,     0,   122,    29,    30,    31,    32,     0,
       0,     0,     0,    24,    25,    26,   117,     0,     0,     0,
       0,     0,     0,     0,   804,     0,     0,   123,   124,   125,
     126,   127,   128,     0,     0,     0,     0,     0,     0,     0,
       0,   112,    61,   113,   114,   129,   130,     0,     0,   115,
       0,   116,    22,    23,     0,     0,     0,   131,   118,   119,
       0,     0,     0,     0,   132,     0,     0,     0,   133,   134,
     120,   121,     0,     0,     0,     0,     0,   122,    29,    30,
      31,    32,    24,    25,    26,   117,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     123,   124,   125,   126,   127,   128,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   129,   130,
       0,     0,     0,     0,     0,     0,     0,   118,   119,     0,
     131,   847,     0,     0,     0,     0,     0,   132,  1002,   120,
     121,   133,   134,     0,     0,     0,   122,    29,    30,    31,
      32,   112,    61,   113,   114,     0,     0,     0,     0,   115,
       0,   116,    22,    23,     0,     0,     0,     0,     0,   123,
     124,   125,   126,   127,   128,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   129,   130,     0,
       0,     0,    24,    25,    26,   117,     0,     0,     0,   131,
       0,     0,     0,     0,     0,     0,   132,     0,     0,     0,
     133,   134,     0,     0,     0,     0,     0,     0,     0,     0,
     112,    61,   113,   114,     0,     0,     0,     0,   115,     0,
     116,    22,    23,     0,     0,     0,     0,   118,   119,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1004,   120,
     121,     0,     0,     0,     0,     0,   122,    29,    30,    31,
      32,    24,    25,    26,   117,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   123,
     124,   125,   126,   127,   128,     0,     0,     0,     0,     0,
       0,     0,     0,   112,    61,   113,   114,   129,   130,     0,
       0,   115,     0,   116,    22,    23,   118,   119,     0,   131,
       0,     0,     0,     0,     0,     0,   132,  1006,   120,   121,
     133,   134,     0,     0,     0,   122,    29,    30,    31,    32,
       0,     0,     0,     0,    24,    25,    26,   117,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   123,   124,
     125,   126,   127,   128,     0,     0,     0,     0,     0,     0,
       0,     0,   112,    61,   113,   114,   129,   130,     0,     0,
     115,     0,   116,    22,    23,     0,     0,     0,   131,   118,
     119,     0,     0,     0,     0,   132,     0,     0,     0,   133,
     134,   120,   121,     0,     0,     0,     0,     0,   122,    29,
      30,    31,    32,    24,    25,    26,   117,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   123,   124,   125,   126,   127,   128,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   129,
     130,     0,     0,     0,     0,     0,     0,     0,   118,   119,
       0,   131,  1008,     0,     0,     0,     0,     0,   132,  1073,
     120,   121,   133,   134,     0,     0,     0,   122,    29,    30,
      31,    32,   112,    61,   113,   114,     0,     0,     0,     0,
     115,     0,   116,    22,    23,     0,     0,     0,     0,     0,
     123,   124,   125,   126,   127,   128,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   129,   130,
       0,     0,     0,    24,    25,    26,   117,     0,     0,     0,
     131,     0,     0,     0,     0,     0,     0,   132,     0,     0,
       0,   133,   134,     0,     0,     0,     0,     0,     0,     0,
       0,   112,    61,   113,   114,     0,     0,     0,     0,   115,
       0,   116,    22,    23,     0,     0,     0,     0,   118,   119,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1075,
     120,   121,     0,     0,     0,     0,     0,   122,    29,    30,
      31,    32,    24,    25,    26,   117,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     123,   124,   125,   126,   127,   128,     0,     0,     0,     0,
       0,     0,     0,     0,   112,    61,   113,   114,   129,   130,
       0,     0,   115,     0,   116,    22,    23,   118,   119,     0,
     131,     0,     0,     0,     0,     0,     0,   132,  1077,   120,
     121,   133,   134,     0,     0,     0,   122,    29,    30,    31,
      32,     0,     0,     0,     0,    24,    25,    26,   117,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   123,
     124,   125,   126,   127,   128,     0,     0,     0,     0,     0,
       0,     0,     0,   112,    61,   113,   114,   129,   130,     0,
       0,   115,     0,   116,    22,    23,     0,     0,     0,   131,
     118,   119,     0,     0,     0,     0,   132,     0,     0,     0,
     133,   134,   120,   121,     0,     0,     0,     0,     0,   122,
      29,    30,    31,    32,    24,    25,    26,   117,     0,     0,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   123,   124,   125,   126,   127,   128,     0,     0,
       0,     0,     0,     0,     0,     0,   112,    61,   113,   114,
     129,   130,     0,     0,   115,     0,   116,   207,    23,   118,
     119,     0,   131,  1112,   315,     0,     0,   316,     0,   132,
    1316,   120,   121,   133,   134,     0,     0,     0,   122,    29,
      30,    31,    32,     0,     0,     0,     0,    24,    25,    26,
     117,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   123,   124,   125,   126,   127,   128,     0,     0,     0,
       0,     0,     0,     0,     0,   112,    61,   113,   114,   129,
     130,     0,     0,   115,     0,   116,    22,    23,     0,     0,
       0,   131,   118,   119,     0,     0,     0,     0,   132,     0,
       0,     0,   133,   134,   120,   121,     0,     0,     0,     0,
       0,   122,    29,    30,    31,    32,    24,    25,    26,   117,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   123,   124,   125,   126,   127,   128,
       0,     0,     0,     0,     0,     0,     0,     0,   112,    61,
     113,   114,   129,   130,     0,     0,   115,     0,   116,    22,
      23,   118,   119,     0,   131,     0,     0,     0,     0,     0,
       0,   132,     0,   120,   121,   133,   134,     0,     0,     0,
     122,    29,    30,    31,    32,     0,     0,     0,     0,    24,
      25,    26,   117,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   123,   124,   125,   126,   127,   128,     0,
       0,     0,     0,     0,     0,     0,     0,   112,    61,   113,
     114,   129,   130,     0,     0,   115,     0,   116,    22,    23,
       0,     0,     0,  1051,   118,   119,     0,     0,     0,     0,
     132,     0,     0,     0,   133,   134,   120,   121,     0,     0,
       0,     0,     0,   122,    29,    30,    31,    32,    24,    25,
      26,   117,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   123,   124,   125,   126,
     127,   128,     0,     0,     0,     0,     0,     0,     0,     0,
     112,    61,   113,   114,   129,   130,     0,     0,   115,     0,
     116,    22,    23,   118,   119,     0,  1190,     0,     0,     0,
       0,     0,     0,   132,     0,   120,   121,   133,   134,     0,
       0,     0,   122,    29,    30,    31,    32,     0,     0,     0,
       0,    24,    25,    26,   117,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   123,   124,   125,   126,   127,
     128,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   129,   130,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1284,   118,   119,     0,     0,
       0,     0,   132,     0,     0,     0,   133,   134,     0,     0,
       0,     0,     0,     0,     0,   122,    29,    30,    31,    32,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251,     0,     0,     0,   123,   124,
     125,   126,   127,   128,   592,     0,   654,     0,     0,     0,
       0,     0,  -482,  -482,  -482,  -482,   129,   130,     0,     4,
       0,     0,   655,     0,     0,   548,     0,     0,   131,     0,
       0,     0,     0,     0,     0,   132,     0,     0,     0,   133,
     134,     0,     0,     0,   551,     0,     0,     0,     0,     0,
     656,     0,   657,     0,   658,     0,     0,     0,   592,     0,
     654,     0,   659,   660,   661,     0,  -482,  -482,  -482,  -482,
       0,   662,   663,     4,   664,     0,     0,   665,     0,   548,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      27,     6,     0,     0,   666,     0,  1304,     0,   551,     0,
       0,     0,     0,     0,   656,     0,   657,     0,   658,     0,
       0,     0,  1314,     0,     0,     0,   659,   660,   661,     0,
       0,     0,     0,     7,     0,   662,   663,  1325,   664,     0,
       0,   665,   592,     0,   654,  1332,     0,     0,     0,     0,
    -482,  -482,  -482,  -482,    27,     6,  1341,     4,   666,  1142,
       0,     0,     0,   548,     0,  1345,     0,     0,  1347,   667,
    1349,     0,  1352,     0,     0,  1354,     0,  1356,     0,  1358,
       0,  1360,   551,  1362,     0,     0,     0,     7,   656,     0,
     657,     0,   658,     0,     0,     0,   592,     0,   654,     0,
     659,   660,   661,     0,  -482,  -482,  -482,  -482,     0,   662,
     663,     4,   664,     0,     0,   665,   879,   548,     0,     0,
       0,     0,     0,   667,     0,     0,     0,     0,    27,     6,
       0,     0,   666,     0,     0,     0,   551,     0,     0,     0,
       0,     0,   656,  1115,   657,     0,   658,     0,     0,     0,
       0,     0,     0,     0,   659,   660,   661,     0,     0,     0,
       0,     7,     0,   662,   663,     0,   664,     0,     0,   665,
     592,     0,   654,     0,     0,     0,     0,     0,  -482,  -482,
    -482,  -482,    27,     6,     0,     4,   666,     0,     0,     0,
       0,   548,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     551,     0,     0,     0,     0,     7,     0,     0,   657,     0,
     658,     0,     0,     0,     0,     0,     0,     0,   659,   660,
     661,   788,     0,     0,   789,     0,     0,   662,   663,     0,
     664,     0,     0,   665,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    45,    46,    27,     6,     0,     0,
     666,     0,     0,     0,     0,  -110,  -110,  -110,     0,     0,
       0,     0,     0,     0,     0,     0,   635,   636,   637,   638,
     639,     0,     0,     0,     0,     0,     0,     0,    48,     7,
       0,   790,     0,     0,     0,     0,     0,     0,    49,     0,
      50,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   640,   641,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    28,     0,     0,     0,     0,     0,     0,
       0,    33,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   251,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   252,   225,   226,   227,   228,   229,
     230,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   226,   227,   228,   229,   230,   231,   232,   233,
     234,   235,   236,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   247,   248,   249,   250,   251,   227,   228,
     229,   230,   231,   232,   233,   234,   235,   236,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   247,   248,
     249,   250,   251,   229,   230,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,   249,   250,   251,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     247,   248,   249,   250,   251
};

static const yytype_int16 yycheck[] =
{
      76,   384,   138,   453,     2,   144,   135,   579,    67,    89,
     655,   479,    20,    11,    12,    13,    14,    15,    16,    17,
      18,    19,   863,    99,   479,   579,   597,     2,    67,    77,
      78,    67,   579,   107,   383,    43,    11,    12,    13,    14,
      15,    16,    17,    18,    19,   634,   528,   898,     2,    88,
      89,   364,   147,   135,    93,   131,   132,    11,    12,    13,
      14,    15,    16,    17,    18,    19,   379,   579,   977,     2,
      88,    89,     4,     4,   960,    93,     4,    20,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    95,     2,    97,
      64,   551,   448,     4,    32,   135,   663,    11,    12,    13,
      14,    15,    16,    17,    18,    19,   154,     4,     4,  1183,
      20,   579,    47,     4,   154,  1149,   499,   762,  1044,     4,
       4,   663,   664,  1049,   579,     5,     4,    38,    39,   579,
       4,    11,  1230,    13,   613,   101,   102,   213,  1134,   147,
     188,    21,    47,   526,    32,   221,   222,   223,   188,    21,
      93,   158,    32,   158,     0,   162,  1254,   162,   458,    56,
      38,    39,  1048,   808,     4,     5,     6,   215,     4,   865,
     101,   102,    47,   108,     4,     4,   525,   748,    14,   158,
       4,   752,   878,    93,   158,   118,   119,    83,   162,   168,
     123,   124,   125,   126,   127,   128,   129,   130,   327,  1273,
     133,   134,   135,   108,   137,  1279,   773,  1203,   158,  1243,
    1200,   219,    32,   163,   290,   291,   292,   293,   266,   532,
     163,   577,   160,   161,    32,   163,   815,   275,   166,   288,
    1081,   773,   786,   108,   316,  1144,   168,   168,   166,   315,
     782,   317,   318,   319,   320,  1131,  1236,  1237,   837,   288,
     326,   162,   288,   199,   200,   201,   202,   203,   204,   205,
     206,   740,   401,    31,   161,   211,   212,   362,   964,   965,
     288,   162,   160,   219,   786,   160,   160,   162,   162,   151,
     160,   161,   358,   359,   584,   159,   166,   327,   128,   161,
     366,   165,   225,   226,   227,   228,   229,   230,   231,   232,
     233,   234,   235,   236,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   247,   248,   249,   250,   786,   252,
     802,   161,     5,   397,   398,    14,   868,    95,    11,   158,
      13,   786,   792,   162,   876,   616,   786,   476,   414,   159,
     160,  1267,  1268,   158,   625,   166,   279,     4,  1189,     0,
     165,    47,   160,    47,   362,  1051,   816,   817,   166,   819,
       8,    47,    65,    91,    92,   149,   150,   938,    16,    17,
      18,    19,    23,   158,   158,    23,     4,   106,   163,   158,
      91,    92,    33,   843,   163,   114,   332,   333,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   108,     4,   108,    21,   729,   730,   960,   495,
      80,   158,   108,     8,   966,   967,    74,   162,    56,   505,
     506,    16,    17,    18,    19,   483,   107,   165,    23,   167,
    1136,   387,   162,   483,    95,   165,   379,    95,   587,    77,
      78,   590,     8,    91,   165,   453,   167,   163,   534,   595,
      16,    17,    18,    19,    91,   165,   158,    23,     4,    29,
    1115,    62,    63,   165,    34,    35,   127,   155,   453,  1033,
       4,   479,   149,   150,   162,    24,     8,    72,    48,  1061,
     498,   158,   159,   569,    16,    17,    18,    19,   158,   453,
     548,    23,   162,   642,   479,   544,  1048,  1061,   548,   792,
      95,   149,   150,  1084,  1061,  1160,   164,  1088,  1089,   158,
     453,  1033,   149,   150,   163,   479,   544,  1098,   608,   609,
     463,   158,    56,   816,   817,    95,   819,   158,   807,    95,
       4,   162,   925,     4,   477,   814,   479,   149,   150,  1061,
      72,   158,   498,    77,    78,   162,   158,   158,   158,   942,
     843,   158,   163,   163,  1118,  1033,   163,   127,   158,   608,
     609,   158,   162,    95,   650,   614,   163,   616,  1033,   164,
     158,   579,     4,  1033,     4,   163,   625,   595,   717,  1131,
     608,   609,  1288,  1061,  1290,   158,   614,   158,   616,   532,
     163,   168,   163,   168,   579,   158,  1061,   625,   164,     8,
     163,  1061,   158,  1309,   164,  1311,   162,    16,    17,    18,
      19,   629,   154,   155,    23,   579,   634,    27,    28,    12,
     706,    11,    44,    45,    46,    14,    15,   158,   158,   158,
     716,   162,   164,   163,   163,   155,   579,   158,   155,   595,
    1118,   162,    38,    39,    40,   588,    55,    16,    17,    18,
      19,    61,   155,  1118,     4,   579,    45,    46,  1118,    27,
      28,    71,     4,    73,    38,    39,    40,   717,   754,     4,
     756,     4,   818,   629,    66,    67,    68,   763,   634,   151,
     152,   153,   154,   155,   742,     4,    95,   109,   110,   111,
     112,     4,   742,    96,    97,   781,  1277,   161,    14,    15,
      25,    22,    27,    28,   161,    30,    62,    63,     4,   652,
      16,    17,    18,    19,   800,   864,     4,  1298,    12,     7,
     109,   110,   111,   112,   810,   811,    85,    86,    44,    45,
      46,  1312,   723,   724,   725,   161,    61,   523,   524,    27,
      28,   827,   828,   161,   374,   375,    71,   833,    73,   161,
      38,    39,    40,   839,   161,   164,   169,    14,    15,  1057,
    1058,    49,    50,    51,    52,    53,  1109,  1110,   854,   319,
     320,   158,   161,    61,   860,   718,    64,   720,   786,   865,
     161,   161,   159,    71,   163,    73,   872,    44,    45,    46,
     163,   161,   878,   109,   110,   111,   112,   815,     4,    87,
      88,   786,   149,   150,   151,   152,   153,   154,   155,   161,
      14,    15,   898,   159,   900,   163,   159,   158,   106,   837,
     169,   907,   786,     4,   910,   911,   114,   913,   914,   915,
     916,   917,   161,   167,   164,   167,   167,    94,     4,   163,
      44,    45,    46,   786,     4,   161,   163,   162,     4,   106,
     160,   937,   109,   110,   111,   112,   158,   114,   169,   815,
     165,   162,   786,   162,    14,    15,   952,   162,   954,   162,
     162,    14,    15,   162,   158,   163,   162,   160,   964,   965,
     155,   837,    14,    15,   169,   971,    36,   165,   162,   161,
       4,    41,    42,    43,    44,    45,    46,   983,   984,   985,
     986,    44,    45,    46,   161,   109,   110,   111,   112,   113,
     853,   163,    44,    45,    46,    47,  1002,     4,  1004,     4,
    1006,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   163,    83,   163,   993,     4,   158,  1024,  1025,
     159,     4,   160,   993,   169,  1031,   162,   158,   165,   163,
    1036,  1037,    84,   158,     4,   162,  1042,   161,     4,   109,
     110,   111,   112,    97,    10,  1051,   109,   110,   111,   112,
       4,  1057,  1058,     4,   164,   162,   108,   109,   110,   111,
     112,    27,    28,   162,     4,   161,     4,  1073,   165,  1075,
     163,  1077,    38,    39,    40,  1081,    56,  1083,     4,  1085,
       4,  1087,   161,   161,  1062,     4,   161,     4,    54,   161,
      56,   161,    58,    59,    60,   163,   162,   161,   161,  1105,
      66,    67,    68,  1109,  1110,  1033,   161,    56,   161,   161,
      56,    56,   161,  1119,   161,   159,  1122,   162,  1124,   161,
     159,    87,    88,   158,   170,   161,   163,    77,  1033,   161,
    1136,   161,   161,  1061,   161,   101,   102,   103,   104,   105,
      27,    28,   161,   161,     4,   159,   163,   162,   169,  1033,
      93,    38,    39,    40,    93,   165,  1061,    93,    93,   158,
     161,   161,    49,    50,    51,    52,    53,   161,   161,     4,
    1033,   162,     4,   163,   159,   162,   165,  1061,   159,   161,
       4,     4,   161,   161,  1190,   161,   163,  1193,   162,  1033,
    1118,   162,     4,   162,  1260,   163,  1202,   163,  1061,   162,
      87,    88,   168,   162,   162,   158,   163,   163,     4,   161,
     165,  1217,   159,  1118,  1220,   163,     4,  1061,   162,   151,
     162,    54,   159,    79,   165,  1231,   159,   158,     3,     4,
       5,     6,   162,   162,  1118,   162,    11,   162,    13,    14,
      15,    11,    12,    13,    14,    15,    16,    17,    18,    19,
     163,   162,   162,  1259,   162,  1118,   159,  1263,  1264,  1265,
       9,   151,    37,   144,   159,  1271,   158,   163,  1274,    44,
      45,    46,    47,   167,  1118,   161,     4,   162,  1284,   162,
     162,    57,  1288,   162,  1290,   162,  1149,   199,   200,   201,
     202,   203,   204,   205,   206,   163,   162,   144,   163,   211,
     212,  1307,   163,  1309,   162,  1311,   163,   158,   163,   162,
    1316,   165,   162,   144,    89,    90,   144,   163,   162,    69,
     163,  1327,  1260,   162,   161,   163,   101,   102,    57,   163,
    1336,    69,   162,   108,   109,   110,   111,   112,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     159,   165,   163,   163,   161,   163,   131,   132,   133,   134,
     135,   136,   163,   162,   162,   142,   161,  1230,   162,   158,
     163,   163,   163,   163,   149,   150,   159,   162,   162,   165,
    1243,   162,   159,   162,  1260,   160,   161,   165,   162,   162,
     158,  1254,   163,   168,   158,   162,   165,   172,   173,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,   347,   348,   349,   350,   351,
     352,   353,   354,   355,   356,   357,     3,     4,     5,     6,
     162,   165,   162,   162,    11,   162,    13,    14,    15,   162,
     162,   165,   162,   162,   158,    22,   163,   158,   158,   158,
     158,   158,   158,    95,    97,   387,   532,   162,   903,   363,
     477,   541,   614,    50,   732,   257,   519,    44,    45,    46,
      47,   976,   172,   174,   588,   768,   773,  1262,   782,   960,
     876,   965,  1235,   971,   163,    62,    63,   479,   742,     6,
     889,   389,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,     6,   400,     3,     4,     5,     6,
     285,   842,    89,    90,    11,   837,    13,    14,    15,   565,
    1103,  1067,    80,     6,   101,   102,   886,  1147,   650,   853,
     484,   108,   109,   110,   111,   112,   159,   479,   479,   162,
     928,   720,   165,  1259,  1012,   569,   607,    44,    45,    46,
      47,   907,   854,   944,   131,   132,   133,   134,   135,   136,
    1118,   947,    -1,    -1,    -1,    62,    63,    -1,    -1,    -1,
      -1,    -1,   149,   150,   151,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   161,    -1,    -1,    -1,    -1,    -1,
      -1,   168,    89,    90,    -1,   172,   173,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   101,   102,    -1,    -1,    -1,    -1,
      -1,   108,   109,   110,   111,   112,    -1,    -1,     3,     4,
       5,     6,    -1,    -1,    -1,    -1,    11,    -1,    13,    14,
      15,    -1,    -1,    -1,   131,   132,   133,   134,   135,   136,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   149,   150,    -1,    -1,    -1,    -1,    -1,    44,
      45,    46,    47,    -1,   161,    -1,    -1,    -1,    -1,    -1,
      -1,   168,    -1,    -1,    -1,   172,   173,    62,    63,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
       6,    -1,     8,    -1,    -1,    11,    -1,    13,    14,    15,
      -1,    -1,    -1,    -1,    89,    90,    -1,    -1,    -1,    -1,
      91,    92,    -1,    -1,    -1,    -1,   101,   102,    -1,    -1,
      -1,    -1,    -1,   108,   109,   110,   111,   112,    44,    45,
      46,    47,    -1,    -1,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   131,   132,   133,   134,
     135,   136,    -1,    -1,    70,    -1,    -1,    -1,    -1,    -1,
       3,     4,     5,     6,   149,   150,    -1,    -1,    11,    -1,
      13,    14,    15,    89,    90,    -1,   161,    -1,   159,    -1,
      -1,   162,    -1,   168,   165,   101,   102,   172,   173,    -1,
      -1,    -1,   108,   109,   110,   111,   112,    -1,    -1,    -1,
      -1,    44,    45,    46,    47,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,   134,   135,
     136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,     5,     6,   149,   150,    -1,    -1,    11,    -1,    13,
      14,    15,    -1,    -1,    -1,   161,    89,    90,    -1,    -1,
      -1,    -1,   168,    -1,    -1,    -1,   172,   173,   101,   102,
      -1,    -1,    -1,    -1,    -1,   108,   109,   110,   111,   112,
      44,    45,    46,    47,    -1,    -1,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   131,   132,
     133,   134,   135,   136,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     3,     4,     5,     6,   149,   150,    -1,    -1,
      11,    -1,    13,    14,    15,    89,    90,   160,   161,    -1,
     159,    -1,    -1,   162,    -1,   168,   165,   101,   102,   172,
     173,    -1,    -1,    -1,   108,   109,   110,   111,   112,    -1,
      -1,    -1,    -1,    44,    45,    46,    47,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   128,    -1,    -1,   131,   132,   133,
     134,   135,   136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     3,     4,     5,     6,   149,   150,    -1,    -1,    11,
      -1,    13,    14,    15,    -1,    -1,    -1,   161,    89,    90,
      -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,   172,   173,
     101,   102,    -1,    -1,    -1,    -1,    -1,   108,   109,   110,
     111,   112,    44,    45,    46,    47,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    90,    -1,
     161,   162,    -1,    -1,    -1,    -1,    -1,   168,   100,   101,
     102,   172,   173,    -1,    -1,    -1,   108,   109,   110,   111,
     112,     3,     4,     5,     6,    -1,    -1,    -1,    -1,    11,
      -1,    13,    14,    15,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,    -1,
      -1,    -1,    44,    45,    46,    47,    -1,    -1,    -1,   161,
      -1,    -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,
     172,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,     4,     5,     6,    -1,    -1,    -1,    -1,    11,    -1,
      13,    14,    15,    -1,    -1,    -1,    -1,    89,    90,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,   101,
     102,    -1,    -1,    -1,    -1,    -1,   108,   109,   110,   111,
     112,    44,    45,    46,    47,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,     6,   149,   150,    -1,
      -1,    11,    -1,    13,    14,    15,    89,    90,    -1,   161,
      -1,    -1,    -1,    -1,    -1,    -1,   168,   100,   101,   102,
     172,   173,    -1,    -1,    -1,   108,   109,   110,   111,   112,
      -1,    -1,    -1,    -1,    44,    45,    46,    47,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,   132,
     133,   134,   135,   136,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     3,     4,     5,     6,   149,   150,    -1,    -1,
      11,    -1,    13,    14,    15,    -1,    -1,    -1,   161,    89,
      90,    -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,   172,
     173,   101,   102,    -1,    -1,    -1,    -1,    -1,   108,   109,
     110,   111,   112,    44,    45,    46,    47,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,   134,   135,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,
     150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    90,
      -1,   161,   162,    -1,    -1,    -1,    -1,    -1,   168,   100,
     101,   102,   172,   173,    -1,    -1,    -1,   108,   109,   110,
     111,   112,     3,     4,     5,     6,    -1,    -1,    -1,    -1,
      11,    -1,    13,    14,    15,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,
      -1,    -1,    -1,    44,    45,    46,    47,    -1,    -1,    -1,
     161,    -1,    -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,
      -1,   172,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     3,     4,     5,     6,    -1,    -1,    -1,    -1,    11,
      -1,    13,    14,    15,    -1,    -1,    -1,    -1,    89,    90,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   100,
     101,   102,    -1,    -1,    -1,    -1,    -1,   108,   109,   110,
     111,   112,    44,    45,    46,    47,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     131,   132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     3,     4,     5,     6,   149,   150,
      -1,    -1,    11,    -1,    13,    14,    15,    89,    90,    -1,
     161,    -1,    -1,    -1,    -1,    -1,    -1,   168,   100,   101,
     102,   172,   173,    -1,    -1,    -1,   108,   109,   110,   111,
     112,    -1,    -1,    -1,    -1,    44,    45,    46,    47,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   131,
     132,   133,   134,   135,   136,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,     6,   149,   150,    -1,
      -1,    11,    -1,    13,    14,    15,    -1,    -1,    -1,   161,
      89,    90,    -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,
     172,   173,   101,   102,    -1,    -1,    -1,    -1,    -1,   108,
     109,   110,   111,   112,    44,    45,    46,    47,    -1,    -1,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   131,   132,   133,   134,   135,   136,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,     6,
     149,   150,    -1,    -1,    11,    -1,    13,    14,    15,    89,
      90,    -1,   161,   162,   159,    -1,    -1,   162,    -1,   168,
     165,   101,   102,   172,   173,    -1,    -1,    -1,   108,   109,
     110,   111,   112,    -1,    -1,    -1,    -1,    44,    45,    46,
      47,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   131,   132,   133,   134,   135,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,     4,     5,     6,   149,
     150,    -1,    -1,    11,    -1,    13,    14,    15,    -1,    -1,
      -1,   161,    89,    90,    -1,    -1,    -1,    -1,   168,    -1,
      -1,    -1,   172,   173,   101,   102,    -1,    -1,    -1,    -1,
      -1,   108,   109,   110,   111,   112,    44,    45,    46,    47,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   131,   132,   133,   134,   135,   136,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,
       5,     6,   149,   150,    -1,    -1,    11,    -1,    13,    14,
      15,    89,    90,    -1,   161,    -1,    -1,    -1,    -1,    -1,
      -1,   168,    -1,   101,   102,   172,   173,    -1,    -1,    -1,
     108,   109,   110,   111,   112,    -1,    -1,    -1,    -1,    44,
      45,    46,    47,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   131,   132,   133,   134,   135,   136,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
       6,   149,   150,    -1,    -1,    11,    -1,    13,    14,    15,
      -1,    -1,    -1,   161,    89,    90,    -1,    -1,    -1,    -1,
     168,    -1,    -1,    -1,   172,   173,   101,   102,    -1,    -1,
      -1,    -1,    -1,   108,   109,   110,   111,   112,    44,    45,
      46,    47,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   131,   132,   133,   134,
     135,   136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,     4,     5,     6,   149,   150,    -1,    -1,    11,    -1,
      13,    14,    15,    89,    90,    -1,   161,    -1,    -1,    -1,
      -1,    -1,    -1,   168,    -1,   101,   102,   172,   173,    -1,
      -1,    -1,   108,   109,   110,   111,   112,    -1,    -1,    -1,
      -1,    44,    45,    46,    47,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   131,   132,   133,   134,   135,
     136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,   150,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   161,    89,    90,    -1,    -1,
      -1,    -1,   168,    -1,    -1,    -1,   172,   173,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   108,   109,   110,   111,   112,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,    -1,    -1,    -1,   131,   132,
     133,   134,   135,   136,     8,    -1,    10,    -1,    -1,    -1,
      -1,    -1,    16,    17,    18,    19,   149,   150,    -1,    23,
      -1,    -1,    26,    -1,    -1,    29,    -1,    -1,   161,    -1,
      -1,    -1,    -1,    -1,    -1,   168,    -1,    -1,    -1,   172,
     173,    -1,    -1,    -1,    48,    -1,    -1,    -1,    -1,    -1,
      54,    -1,    56,    -1,    58,    -1,    -1,    -1,     8,    -1,
      10,    -1,    66,    67,    68,    -1,    16,    17,    18,    19,
      -1,    75,    76,    23,    78,    -1,    -1,    81,    -1,    29,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      94,    95,    -1,    -1,    98,    -1,  1284,    -1,    48,    -1,
      -1,    -1,    -1,    -1,    54,    -1,    56,    -1,    58,    -1,
      -1,    -1,  1300,    -1,    -1,    -1,    66,    67,    68,    -1,
      -1,    -1,    -1,   127,    -1,    75,    76,  1315,    78,    -1,
      -1,    81,     8,    -1,    10,  1323,    -1,    -1,    -1,    -1,
      16,    17,    18,    19,    94,    95,  1334,    23,    98,    99,
      -1,    -1,    -1,    29,    -1,  1343,    -1,    -1,  1346,   163,
    1348,    -1,  1350,    -1,    -1,  1353,    -1,  1355,    -1,  1357,
      -1,  1359,    48,  1361,    -1,    -1,    -1,   127,    54,    -1,
      56,    -1,    58,    -1,    -1,    -1,     8,    -1,    10,    -1,
      66,    67,    68,    -1,    16,    17,    18,    19,    -1,    75,
      76,    23,    78,    -1,    -1,    81,    82,    29,    -1,    -1,
      -1,    -1,    -1,   163,    -1,    -1,    -1,    -1,    94,    95,
      -1,    -1,    98,    -1,    -1,    -1,    48,    -1,    -1,    -1,
      -1,    -1,    54,    55,    56,    -1,    58,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    66,    67,    68,    -1,    -1,    -1,
      -1,   127,    -1,    75,    76,    -1,    78,    -1,    -1,    81,
       8,    -1,    10,    -1,    -1,    -1,    -1,    -1,    16,    17,
      18,    19,    94,    95,    -1,    23,    98,    -1,    -1,    -1,
      -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      48,    -1,    -1,    -1,    -1,   127,    -1,    -1,    56,    -1,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,     4,    -1,    -1,     7,    -1,    -1,    75,    76,    -1,
      78,    -1,    -1,    81,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    27,    28,    94,    95,    -1,    -1,
      98,    -1,    -1,    -1,    -1,    38,    39,    40,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    49,    50,    51,    52,
      53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,   127,
      -1,    64,    -1,    -1,    -1,    -1,    -1,    -1,    71,    -1,
      73,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    87,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   106,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   114,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   171,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   139,   140,   141,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   131,   132,
     133,   134,   135,   136,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   175,   176,     0,    23,    33,    95,   127,   177,   178,
     179,   181,   189,   208,   213,   218,   251,   320,   322,   376,
     182,   214,    14,    15,    44,    45,    46,    94,   106,   109,
     110,   111,   112,   114,   161,   188,   241,   242,   330,   344,
     346,   377,   378,   219,    25,    27,    28,    30,    61,    71,
      73,   180,   177,   177,   177,   177,   177,   177,   177,   177,
     177,     4,   184,   185,   186,   187,     4,   331,    14,    47,
     108,   260,    47,   108,   261,   345,   166,   243,   244,   245,
     246,     4,    14,   375,   187,   222,   225,   190,   321,   323,
     209,     4,    65,   265,   265,    21,   183,   158,    32,   159,
     160,   215,    44,    45,   241,   332,   333,   334,   162,   107,
     347,   348,     3,     5,     6,    11,    13,    47,    89,    90,
     101,   102,   108,   131,   132,   133,   134,   135,   136,   149,
     150,   161,   168,   172,   173,   187,   377,   424,   456,   479,
     480,   483,   243,   243,   375,   163,   220,   165,   223,     4,
      47,    84,   108,   188,   312,   313,   314,   316,   317,   318,
     319,   333,   334,   319,     4,     4,   159,   165,    44,    45,
     113,   188,   241,   258,   259,     4,   184,    24,   186,     4,
     479,     4,   164,   192,   168,    47,   108,   335,   335,    47,
     108,   349,   168,    11,    12,   155,   178,   178,   155,   178,
     178,   178,   178,   178,   178,   178,   178,    14,   479,   479,
     482,   178,   178,   166,   178,   244,   245,   483,   155,   178,
     424,    91,    92,   165,   167,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   171,   246,     4,   224,   225,   191,   243,   245,
     315,   312,     4,   324,   325,   326,   312,   324,   210,   252,
       4,     4,     4,   260,     4,   261,   255,    22,   161,   161,
     199,     4,   336,   337,   245,   350,   351,   355,   356,    12,
     161,   161,   161,   161,   456,   480,   480,   480,   480,   480,
     480,   480,   480,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   159,   162,   165,   423,   158,
     168,   169,   480,   480,   479,   481,   161,   187,   456,   479,
     479,   479,   178,   178,   178,   178,   178,   178,   178,   178,
     178,   178,   178,   178,   178,   178,   178,   178,   178,   178,
     178,   178,   178,   178,   178,   178,   178,   178,   161,   178,
     163,   221,   158,   192,   158,   163,   159,   243,   163,   163,
     161,   263,     4,   159,   256,   257,   243,   161,   266,   193,
       4,   160,   162,   178,   200,   203,   163,   159,   338,   158,
     201,   169,   351,     4,   352,   353,   188,   333,   334,   357,
     358,   360,   479,   479,   479,   479,   479,   483,   479,   479,
     479,   482,   482,   167,   161,   479,   167,   167,   167,   480,
     480,   480,   480,   480,   480,   480,   480,   480,   480,   480,
     480,   480,   480,   480,   480,   480,   480,   480,   480,   480,
     480,   480,   480,   480,   480,   479,   479,   164,   393,   225,
     199,   325,   479,   211,     4,   262,   264,   163,   253,     4,
     266,   266,   162,   267,   163,   178,   195,   196,   325,   204,
     205,   160,   229,   230,   231,   232,   233,   158,   201,   216,
     480,   337,   169,   354,   158,   163,   335,   335,   346,   246,
     162,   162,   162,   162,   162,   165,   162,   169,   160,   460,
     461,   462,   479,   162,   162,   165,   161,     4,   385,   389,
     163,    31,   178,   212,   251,   320,   322,   376,     4,   158,
     162,   263,     4,   163,   163,   178,   269,   270,   272,   273,
      27,    28,   158,   194,   159,   202,     4,   160,    38,    39,
      40,   234,    96,    97,   236,   246,   203,   162,    29,    34,
      35,    48,   178,   217,   218,   320,   322,   327,   363,   372,
     376,   401,   412,   245,   353,   359,   479,   169,   456,   158,
     201,   479,   160,   394,   395,   479,   386,   158,   163,   247,
     165,   409,   262,   163,   254,   273,   273,   233,   158,   201,
       4,   371,     8,    74,   164,   178,   181,   227,   320,   322,
     363,   376,   410,   420,   422,   426,   439,   440,   197,   198,
     196,   162,   479,   206,   236,    97,    36,    41,    42,    43,
      44,    45,    83,   188,   238,   239,   240,   241,     4,   245,
     328,   329,     4,   227,   228,    49,    50,    51,    52,    53,
      87,    88,   233,   399,   400,   347,   162,   462,   162,     4,
     158,   162,   161,   385,    10,    26,    54,    56,    58,    66,
      67,    68,    75,    76,    78,    81,    98,   163,   178,   181,
     218,   248,   249,   251,   274,   284,   287,   320,   322,   327,
     330,   341,   342,   363,   372,   376,   379,   401,   410,   421,
     441,   467,   473,     4,   263,    72,    72,   246,   270,   268,
     246,   165,     4,     5,     6,   128,   161,    10,    54,    58,
      59,    60,   103,   104,   105,   163,   168,   187,   424,   456,
     457,   426,    16,    17,    18,    19,   163,    56,   441,   319,
     319,   202,   237,   238,    44,   240,    47,   108,   235,   240,
     207,   456,   158,   163,   413,   373,   374,   457,   405,     4,
       4,   246,   404,   402,   161,   395,   178,   396,   397,   398,
     472,   409,   474,   161,   161,     4,    56,   275,   276,   278,
       4,    56,    77,   285,   286,   287,   291,   292,   293,   305,
     310,   166,   288,   289,   290,   310,   463,     4,     4,     7,
      64,   344,   382,     4,   339,   340,    16,    17,    18,    19,
     161,   163,   271,   162,   128,   226,   479,   428,   429,   161,
     161,   161,   458,   479,   427,   178,   142,   159,   178,   423,
      20,    93,   411,   411,   411,   163,   411,   161,   161,   325,
     325,   235,   202,   159,   329,   161,   415,   158,   163,   159,
     426,   366,   367,   364,   426,   170,   406,   162,   479,    37,
     160,   479,   162,   158,   161,   459,   409,   479,   468,   161,
     161,    77,   275,   161,   311,   161,    77,   286,   161,   297,
     298,   163,   161,   308,   479,   289,   158,   163,   159,    82,
     178,   248,   464,   467,   473,   163,   380,   343,   228,   158,
     163,    93,    93,    93,    93,   479,   371,   162,   158,   162,
     165,   459,   409,   431,   479,   479,   169,   158,   459,   457,
     228,   228,   424,   228,   161,   161,   161,   161,   479,   479,
     479,     4,    38,    39,   162,   416,   417,   418,   419,   414,
     374,   479,   368,   368,   228,    21,   151,   161,   403,   162,
       4,   398,   460,   163,   475,   162,     4,    83,   465,   466,
      62,    63,   281,   479,   281,   246,   309,   479,    62,    63,
     296,   299,   303,   310,   159,   159,    62,    63,   306,   307,
     309,   165,   163,   290,   309,   163,   250,   393,     4,   361,
     362,   381,   340,   161,   161,   161,   161,   162,   226,   479,
     163,   430,     4,   231,   425,   162,   162,   458,   163,   479,
     479,   479,   100,   479,   100,   479,   100,   479,   162,   479,
     162,   162,   158,   201,   418,   163,   158,   163,   163,   369,
     370,   371,   162,    22,    62,    63,   151,   407,   408,   479,
     426,   161,   201,   463,   470,   465,   159,   163,   479,   162,
     479,   162,   165,   299,   303,   151,   149,   150,   158,   300,
     302,   161,   294,   309,   294,   310,   310,    80,   158,   162,
     308,   247,     4,   383,   384,   385,   387,   158,   163,   384,
     390,   391,   392,   100,   479,   100,   479,   100,   479,   479,
     471,   158,   162,   165,   443,   159,   245,   163,   434,   435,
     479,   162,   479,   162,   479,   162,   163,   162,   436,   438,
     417,   162,     4,   158,   365,   159,   479,   479,   162,    64,
     158,   162,   162,   479,   162,    55,   473,   476,   477,   159,
     479,   479,    79,   279,     9,   479,   151,   159,   302,   144,
     303,   158,   302,   159,   309,   479,   158,   295,   306,   306,
     163,   167,    99,   243,   158,   163,   362,   158,   163,   161,
     479,   162,   479,   162,   479,   162,   162,   450,   226,   479,
      55,   426,   479,     4,   479,   426,   426,   162,   163,   162,
     163,   162,   163,   163,   426,   442,   370,   163,   479,   408,
     408,   162,   409,    57,   478,   464,   479,   469,   479,   158,
     161,   280,   479,   165,   144,   144,   301,   304,   310,   303,
     144,   295,   165,   309,   388,   384,   391,   396,   162,   163,
     162,   163,   162,   163,   163,    69,   451,   452,   162,   409,
     159,   432,   163,   163,   163,   437,    85,    86,   446,   476,
     163,   281,   479,   162,   479,   161,   161,   158,   162,   304,
     162,   479,   295,   161,   162,   163,   163,   163,     8,    70,
     454,   455,   479,   479,   163,    57,   444,    69,   447,   448,
     178,   422,   479,    91,    92,   165,   159,   301,   304,   304,
     162,   165,   396,   453,   158,   165,   422,   445,   454,   162,
     279,   479,   479,   479,   161,   282,   283,   479,    91,   302,
      91,   302,   479,   162,   476,   479,   162,   426,   449,   476,
     158,   162,   162,   162,   283,   479,   163,   165,   309,   165,
     309,   165,   433,   426,   283,   158,   165,   479,   162,   309,
     162,   309,   426,   158,   277,   283,   479,   165,   162,   162,
     162,   162,   283,   162,   158,   162,   165,   479,   162,   162,
     163,   283,   479,   158,   162,   283,   158,   283,   158,   283,
     158,   162,   283,   158,   283,   158,   283,   158,   283,   158,
     283,   158,   283,   162
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   174,   176,   175,   177,   177,   177,   177,   177,   177,
     177,   177,   177,   177,   179,   178,   180,   180,   182,   183,
     181,   184,   184,   185,   185,   186,   186,   187,   187,   187,
     188,   188,   188,   190,   191,   189,   193,   194,   192,   192,
     195,   195,   196,   197,   196,   198,   196,   196,   199,   199,
     199,   200,   200,   201,   201,   202,   202,   204,   203,   205,
     206,   203,   207,   203,   203,   209,   210,   208,   211,   211,
     212,   212,   212,   212,   214,   215,   213,   216,   216,   217,
     217,   217,   217,   217,   217,   217,   217,   217,   219,   220,
     221,   218,   222,   223,   223,   224,   224,   225,   226,   226,
     227,   227,   227,   227,   227,   227,   227,   227,   228,   228,
     230,   229,   232,   231,   233,   233,   234,   234,   234,   235,
     235,   235,   236,   236,   236,   236,   237,   237,   238,   238,
     238,   238,   238,   238,   238,   238,   239,   239,   239,   240,
     240,   240,   241,   241,   241,   241,   241,   242,   242,   243,
     243,   243,   243,   244,   244,   245,   245,   246,   246,   247,
     247,   247,   247,   247,   248,   248,   248,   248,   248,   248,
     248,   248,   248,   248,   248,   248,   248,   248,   248,   248,
     248,   248,   248,   250,   249,   252,   251,   253,   251,   254,
     251,   255,   251,   256,   251,   257,   251,   258,   258,   258,
     258,   259,   259,   259,   260,   260,   260,   261,   261,   261,
     262,   262,   263,   263,   264,   264,   264,   264,   265,   265,
     266,   266,   267,   268,   266,   269,   269,   271,   270,   272,
     270,   273,   273,   274,   275,   275,   276,   276,   277,   277,
     278,   278,   279,   279,   280,   280,   280,   280,   281,   281,
     281,   282,   282,   282,   282,   282,   283,   283,   284,   284,
     285,   285,   286,   286,   286,   287,   287,   288,   289,   289,
     290,   291,   291,   292,   293,   293,   294,   294,   294,   295,
     295,   296,   296,   297,   297,   297,   298,   298,   298,   299,
     299,   300,   300,   301,   301,   302,   302,   302,   303,   304,
     305,   306,   306,   306,   307,   307,   307,   308,   309,   309,
     311,   310,   312,   312,   312,   313,   314,   315,   316,   317,
     317,   318,   319,   319,   319,   319,   319,   321,   320,   323,
     322,   324,   324,   325,   325,   326,   327,   328,   328,   329,
     331,   330,   332,   332,   332,   333,   334,   334,   335,   335,
     335,   336,   336,   337,   338,   338,   339,   339,   340,   341,
     343,   342,   345,   344,   346,   346,   347,   348,   348,   349,
     349,   349,   350,   350,   351,   352,   352,   354,   353,   356,
     355,   357,   358,   359,   357,   360,   360,   360,   361,   361,
     362,   364,   365,   363,   366,   363,   367,   363,   368,   368,
     369,   369,   370,   370,   371,   372,   373,   373,   374,   375,
     375,   376,   376,   377,   377,   377,   378,   378,   380,   379,
     381,   379,   382,   382,   383,   383,   384,   384,   386,   385,
     388,   387,   389,   389,   390,   390,   391,   392,   391,   393,
     393,   394,   394,   395,   395,   395,   395,   396,   397,   397,
     398,   398,   398,   398,   398,   398,   399,   399,   400,   400,
     402,   403,   401,   404,   401,   405,   401,   406,   406,   406,
     406,   406,   406,   407,   407,   407,   408,   408,   408,   409,
     409,   410,   410,   411,   411,   411,   413,   414,   412,   415,
     415,   416,   416,   417,   417,   418,   419,   419,   420,   420,
     420,   420,   420,   420,   420,   420,   420,   421,   421,   421,
     421,   421,   421,   421,   422,   422,   422,   422,   422,   423,
     423,   423,   423,   423,   423,   423,   423,   423,   423,   423,
     423,   424,   424,   425,   425,   425,   426,   426,   426,   426,
     426,   426,   426,   426,   426,   427,   426,   428,   426,   429,
     430,   426,   431,   432,   433,   426,   434,   426,   435,   426,
     436,   437,   426,   438,   426,   439,   439,   439,   439,   440,
     440,   440,   440,   441,   441,   441,   442,   442,   442,   443,
     443,   445,   444,   444,   446,   446,   448,   449,   447,   450,
     450,   452,   453,   451,   454,   454,   455,   455,   455,   455,
     456,   456,   456,   457,   457,   458,   458,   459,   459,   460,
     460,   461,   461,   462,   463,   463,   463,   464,   464,   464,
     465,   466,   466,   466,   468,   469,   467,   470,   467,   471,
     467,   472,   467,   474,   475,   473,   477,   476,   476,   478,
     478,   479,   479,   479,   479,   480,   480,   480,   480,   480,
     480,   481,   480,   480,   480,   480,   480,   480,   480,   480,
     480,   480,   480,   480,   480,   480,   480,   480,   480,   480,
     480,   480,   480,   480,   480,   480,   480,   480,   480,   480,
     480,   480,   480,   480,   480,   480,   480,   480,   480,   480,
     480,   480,   480,   480,   480,   480,   480,   480,   480,   480,
     480,   482,   482,   483,   483,   483,   483
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     0,     0,     2,     4,     0,     0,     0,
       5,     1,     0,     1,     3,     1,     3,     1,     3,     3,
       1,     1,     3,     0,     0,    11,     0,     0,     6,     0,
       1,     3,     0,     0,     5,     0,     5,     1,     2,     0,
       4,     1,     3,     1,     0,     2,     0,     0,     3,     0,
       0,     5,     0,     6,     3,     0,     0,     9,     2,     0,
       1,     1,     1,     1,     0,     0,     9,     2,     0,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     0,
       0,     9,     2,     2,     0,     1,     3,     1,     1,     5,
       2,     2,     2,     2,     4,     4,     6,     8,     1,     0,
       0,     5,     0,     4,     1,     1,     1,     1,     1,     1,
       1,     0,     2,     1,     1,     0,     1,     0,     1,     2,
       1,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     5,
       5,     5,     3,     2,     2,     1,     0,     1,     1,     2,
       2,     2,     2,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     1,
       1,     1,     1,     0,     6,     0,     7,     0,     9,     0,
      11,     0,     9,     0,    10,     0,    10,     1,     2,     3,
       2,     0,     1,     1,     0,     1,     1,     0,     1,     1,
       2,     1,     3,     0,     3,     2,     1,     0,     1,     0,
       2,     0,     0,     0,     6,     1,     3,     0,     5,     0,
       2,     2,     0,     3,     2,     0,    10,    14,     2,     0,
       4,     0,     2,     0,     1,     5,     5,     5,     1,     1,
       0,     1,     5,     7,    13,    25,     1,     5,     3,     2,
       2,     1,     1,     1,     1,     3,     4,     5,     1,     3,
       3,     4,     0,     2,     4,     4,     4,     1,     2,     2,
       3,     1,     1,     7,    12,    11,     6,    12,    11,     2,
       3,     2,     3,     1,     3,     1,     1,     0,     1,     1,
       5,     2,     2,     1,     1,     3,     3,     1,     1,     5,
       0,     3,     1,     1,     0,     1,     1,     1,     2,     2,
       3,     2,     1,     1,     1,     1,     1,     0,     6,     0,
       6,     1,     3,     3,     1,     1,     3,     1,     3,     4,
       0,     7,     2,     3,     0,     1,     1,     1,     1,     1,
       0,     1,     3,     2,     2,     0,     1,     3,     1,     3,
       0,     5,     0,     3,     1,     1,     4,     2,     0,     1,
       1,     0,     1,     2,     3,     1,     3,     0,     3,     0,
       2,     2,     0,     0,     4,     2,     2,     1,     1,     3,
       1,     0,     0,     8,     0,     6,     0,     6,     0,     3,
       1,     3,     1,     3,     2,     4,     1,     3,     3,     1,
       1,     6,     4,     1,     2,     2,     1,     1,     0,     6,
       0,     6,     1,     1,     1,     3,     1,     1,     0,     5,
       0,     6,     1,     3,     1,     3,     1,     0,     4,     4,
       0,     1,     3,     0,     1,     4,     5,     1,     1,     3,
       1,     2,     6,     5,     3,     2,     1,     1,     1,     1,
       0,     0,     6,     0,     4,     0,     4,     4,     4,     3,
       3,     2,     0,     1,     3,     3,     2,     2,     1,     2,
       0,     2,     0,     1,     1,     0,     0,     0,     6,     2,
       4,     1,     3,     2,     1,     1,     1,     1,     7,     7,
       8,     8,     7,     6,     3,     7,     8,     7,     7,     8,
       8,     7,     7,     8,     5,     4,     4,     5,     5,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     3,     5,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     0,     5,     0,     5,     0,
       0,     8,     0,     0,     0,    13,     0,     7,     0,     7,
       0,     0,     9,     0,     9,     1,     2,     2,     2,     1,
       2,     2,     2,     1,     1,     1,     2,     2,     0,     2,
       0,     0,     3,     0,     2,     0,     0,     0,     4,     2,
       0,     0,     0,     4,     2,     1,     1,     1,     1,     3,
       6,     2,     2,     1,     3,     1,     3,     4,     0,     1,
       0,     1,     3,     1,     2,     2,     0,     1,     1,     2,
       1,     2,     4,     3,     0,     0,    11,     0,     7,     0,
       7,     0,     4,     0,     0,     7,     0,     2,     1,     2,
       0,     1,     6,     3,     2,     1,     4,     2,     1,     1,
       1,     0,     7,     5,     5,     3,     7,     3,     6,     3,
       4,     4,     4,     4,     4,     4,     3,     3,     3,     3,
       3,     3,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       3,     3,     4,     4,     3,     5,     5,     5,     5,     5,
       5,     1,     3,     1,     1,     2,     3
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = FRONTEND_VERILOG_YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == FRONTEND_VERILOG_YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        YY_LAC_DISCARD ("YYBACKUP");                              \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use FRONTEND_VERILOG_YYerror or FRONTEND_VERILOG_YYUNDEF. */
#define YYERRCODE FRONTEND_VERILOG_YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if FRONTEND_VERILOG_YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined FRONTEND_VERILOG_YYLTYPE_IS_TRIVIAL && FRONTEND_VERILOG_YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]));
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !FRONTEND_VERILOG_YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !FRONTEND_VERILOG_YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Given a state stack such that *YYBOTTOM is its bottom, such that
   *YYTOP is either its top or is YYTOP_EMPTY to indicate an empty
   stack, and such that *YYCAPACITY is the maximum number of elements it
   can hold without a reallocation, make sure there is enough room to
   store YYADD more elements.  If not, allocate a new stack using
   YYSTACK_ALLOC, copy the existing elements, and adjust *YYBOTTOM,
   *YYTOP, and *YYCAPACITY to reflect the new capacity and memory
   location.  If *YYBOTTOM != YYBOTTOM_NO_FREE, then free the old stack
   using YYSTACK_FREE.  Return 0 if successful or if no reallocation is
   required.  Return YYENOMEM if memory is exhausted.  */
static int
yy_lac_stack_realloc (YYPTRDIFF_T *yycapacity, YYPTRDIFF_T yyadd,
#if FRONTEND_VERILOG_YYDEBUG
                      char const *yydebug_prefix,
                      char const *yydebug_suffix,
#endif
                      yy_state_t **yybottom,
                      yy_state_t *yybottom_no_free,
                      yy_state_t **yytop, yy_state_t *yytop_empty)
{
  YYPTRDIFF_T yysize_old =
    *yytop == yytop_empty ? 0 : *yytop - *yybottom + 1;
  YYPTRDIFF_T yysize_new = yysize_old + yyadd;
  if (*yycapacity < yysize_new)
    {
      YYPTRDIFF_T yyalloc = 2 * yysize_new;
      yy_state_t *yybottom_new;
      /* Use YYMAXDEPTH for maximum stack size given that the stack
         should never need to grow larger than the main state stack
         needs to grow without LAC.  */
      if (YYMAXDEPTH < yysize_new)
        {
          YYDPRINTF ((stderr, "%smax size exceeded%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (YYMAXDEPTH < yyalloc)
        yyalloc = YYMAXDEPTH;
      yybottom_new =
        YY_CAST (yy_state_t *,
                 YYSTACK_ALLOC (YY_CAST (YYSIZE_T,
                                         yyalloc * YYSIZEOF (*yybottom_new))));
      if (!yybottom_new)
        {
          YYDPRINTF ((stderr, "%srealloc failed%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (*yytop != yytop_empty)
        {
          YYCOPY (yybottom_new, *yybottom, yysize_old);
          *yytop = yybottom_new + (yysize_old - 1);
        }
      if (*yybottom != yybottom_no_free)
        YYSTACK_FREE (*yybottom);
      *yybottom = yybottom_new;
      *yycapacity = yyalloc;
    }
  return 0;
}

/* Establish the initial context for the current lookahead if no initial
   context is currently established.

   We define a context as a snapshot of the parser stacks.  We define
   the initial context for a lookahead as the context in which the
   parser initially examines that lookahead in order to select a
   syntactic action.  Thus, if the lookahead eventually proves
   syntactically unacceptable (possibly in a later context reached via a
   series of reductions), the initial context can be used to determine
   the exact set of tokens that would be syntactically acceptable in the
   lookahead's place.  Moreover, it is the context after which any
   further semantic actions would be erroneous because they would be
   determined by a syntactically unacceptable token.

   YY_LAC_ESTABLISH should be invoked when a reduction is about to be
   performed in an inconsistent state (which, for the purposes of LAC,
   includes consistent states that don't know they're consistent because
   their default reductions have been disabled).  Iff there is a
   lookahead token, it should also be invoked before reporting a syntax
   error.  This latter case is for the sake of the debugging output.

   For parse.lac=full, the implementation of YY_LAC_ESTABLISH is as
   follows.  If no initial context is currently established for the
   current lookahead, then check if that lookahead can eventually be
   shifted if syntactic actions continue from the current context.
   Report a syntax error if it cannot.  */
#define YY_LAC_ESTABLISH                                                \
do {                                                                    \
  if (!yy_lac_established)                                              \
    {                                                                   \
      YYDPRINTF ((stderr,                                               \
                  "LAC: initial context established for %s\n",          \
                  yysymbol_name (yytoken)));                            \
      yy_lac_established = 1;                                           \
      switch (yy_lac (yyesa, &yyes, &yyes_capacity, yyssp, yytoken))    \
        {                                                               \
        case YYENOMEM:                                                  \
          YYNOMEM;                                                      \
        case 1:                                                         \
          goto yyerrlab;                                                \
        }                                                               \
    }                                                                   \
} while (0)

/* Discard any previous initial lookahead context because of Event,
   which may be a lookahead change or an invalidation of the currently
   established initial context for the current lookahead.

   The most common example of a lookahead change is a shift.  An example
   of both cases is syntax error recovery.  That is, a syntax error
   occurs when the lookahead is syntactically erroneous for the
   currently established initial context, so error recovery manipulates
   the parser stacks to try to find a new initial context in which the
   current lookahead is syntactically acceptable.  If it fails to find
   such a context, it discards the lookahead.  */
#if FRONTEND_VERILOG_YYDEBUG
# define YY_LAC_DISCARD(Event)                                           \
do {                                                                     \
  if (yy_lac_established)                                                \
    {                                                                    \
      YYDPRINTF ((stderr, "LAC: initial context discarded due to "       \
                  Event "\n"));                                          \
      yy_lac_established = 0;                                            \
    }                                                                    \
} while (0)
#else
# define YY_LAC_DISCARD(Event) yy_lac_established = 0
#endif

/* Given the stack whose top is *YYSSP, return 0 iff YYTOKEN can
   eventually (after perhaps some reductions) be shifted, return 1 if
   not, or return YYENOMEM if memory is exhausted.  As preconditions and
   postconditions: *YYES_CAPACITY is the allocated size of the array to
   which *YYES points, and either *YYES = YYESA or *YYES points to an
   array allocated with YYSTACK_ALLOC.  yy_lac may overwrite the
   contents of either array, alter *YYES and *YYES_CAPACITY, and free
   any old *YYES other than YYESA.  */
static int
yy_lac (yy_state_t *yyesa, yy_state_t **yyes,
        YYPTRDIFF_T *yyes_capacity, yy_state_t *yyssp, yysymbol_kind_t yytoken)
{
  yy_state_t *yyes_prev = yyssp;
  yy_state_t *yyesp = yyes_prev;
  /* Reduce until we encounter a shift and thereby accept the token.  */
  YYDPRINTF ((stderr, "LAC: checking lookahead %s:", yysymbol_name (yytoken)));
  if (yytoken == YYSYMBOL_YYUNDEF)
    {
      YYDPRINTF ((stderr, " Always Err\n"));
      return 1;
    }
  while (1)
    {
      int yyrule = yypact[+*yyesp];
      if (yypact_value_is_default (yyrule)
          || (yyrule += yytoken) < 0 || YYLAST < yyrule
          || yycheck[yyrule] != yytoken)
        {
          /* Use the default action.  */
          yyrule = yydefact[+*yyesp];
          if (yyrule == 0)
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
        }
      else
        {
          /* Use the action from yytable.  */
          yyrule = yytable[yyrule];
          if (yytable_value_is_error (yyrule))
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
          if (0 < yyrule)
            {
              YYDPRINTF ((stderr, " S%d\n", yyrule));
              return 0;
            }
          yyrule = -yyrule;
        }
      /* By now we know we have to simulate a reduce.  */
      YYDPRINTF ((stderr, " R%d", yyrule - 1));
      {
        /* Pop the corresponding number of values from the stack.  */
        YYPTRDIFF_T yylen = yyr2[yyrule];
        /* First pop from the LAC stack as many tokens as possible.  */
        if (yyesp != yyes_prev)
          {
            YYPTRDIFF_T yysize = yyesp - *yyes + 1;
            if (yylen < yysize)
              {
                yyesp -= yylen;
                yylen = 0;
              }
            else
              {
                yyesp = yyes_prev;
                yylen -= yysize;
              }
          }
        /* Only afterwards look at the main stack.  */
        if (yylen)
          yyesp = yyes_prev -= yylen;
      }
      /* Push the resulting state of the reduction.  */
      {
        yy_state_fast_t yystate;
        {
          const int yylhs = yyr1[yyrule] - YYNTOKENS;
          const int yyi = yypgoto[yylhs] + *yyesp;
          yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyesp
                     ? yytable[yyi]
                     : yydefgoto[yylhs]);
        }
        if (yyesp == yyes_prev)
          {
            yyesp = *yyes;
            YY_IGNORE_USELESS_CAST_BEGIN
            *yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        else
          {
            if (yy_lac_stack_realloc (yyes_capacity, 1,
#if FRONTEND_VERILOG_YYDEBUG
                                      " (", ")",
#endif
                                      yyes, yyesa, &yyesp, yyes_prev))
              {
                YYDPRINTF ((stderr, "\n"));
                return YYENOMEM;
              }
            YY_IGNORE_USELESS_CAST_BEGIN
            *++yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        YYDPRINTF ((stderr, " G%d", yystate));
      }
    }
}

/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yy_state_t *yyesa;
  yy_state_t **yyes;
  YYPTRDIFF_T *yyes_capacity;
  yysymbol_kind_t yytoken;
  YYLTYPE *yylloc;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;

  int yyx;
  for (yyx = 0; yyx < YYNTOKENS; ++yyx)
    {
      yysymbol_kind_t yysym = YY_CAST (yysymbol_kind_t, yyx);
      if (yysym != YYSYMBOL_YYerror && yysym != YYSYMBOL_YYUNDEF)
        switch (yy_lac (yyctx->yyesa, yyctx->yyes, yyctx->yyes_capacity, yyctx->yyssp, yysym))
          {
          case YYENOMEM:
            return YYENOMEM;
          case 1:
            continue;
          default:
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = yysym;
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
       In the first two cases, it might appear that the current syntax
       error should have been detected in the previous state when yy_lac
       was invoked.  However, at that time, there might have been a
       different syntax error that discarded a different initial context
       during error recovery, leaving behind the current lookahead.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      YYDPRINTF ((stderr, "Constructing syntax error message\n"));
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else if (yyn == 0)
        YYDPRINTF ((stderr, "No expected tokens.\n"));
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.  In order to see if a particular token T is a
   valid looakhead, invoke yy_lac (YYESA, YYES, YYES_CAPACITY, YYSSP, T).

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store or if
   yy_lac returned YYENOMEM.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined FRONTEND_VERILOG_YYLTYPE_IS_TRIVIAL && FRONTEND_VERILOG_YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

    yy_state_t yyesa[20];
    yy_state_t *yyes = yyesa;
    YYPTRDIFF_T yyes_capacity = 20 < YYMAXDEPTH ? 20 : YYMAXDEPTH;

  /* Whether LAC context is established.  A Boolean.  */
  int yy_lac_established = 0;
  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = FRONTEND_VERILOG_YYEMPTY; /* Cause a token to be read.  */

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == FRONTEND_VERILOG_YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc);
    }

  if (yychar <= FRONTEND_VERILOG_YYEOF)
    {
      yychar = FRONTEND_VERILOG_YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == FRONTEND_VERILOG_YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = FRONTEND_VERILOG_YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    {
      YY_LAC_ESTABLISH;
      goto yydefault;
    }
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      YY_LAC_ESTABLISH;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = FRONTEND_VERILOG_YYEMPTY;
  YY_LAC_DISCARD ("shift");
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  {
    int yychar_backup = yychar;
    switch (yyn)
      {
  case 2: /* $@1: %empty  */
#line 467 "frontends/verilog/verilog_parser.y"
       {
	(void)frontend_verilog_yynerrs;
	ast_stack.clear();
	ast_stack.push_back(current_ast);
}
#line 4031 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 3: /* input: $@1 design  */
#line 471 "frontends/verilog/verilog_parser.y"
         {
	ast_stack.pop_back();
	log_assert(GetSize(ast_stack) == 0);
	for (auto &it : default_attr_list)
		delete it.second;
	default_attr_list.clear();
}
#line 4043 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 14: /* $@2: %empty  */
#line 492 "frontends/verilog/verilog_parser.y"
        {
		if (attr_list != nullptr)
			attr_list_stack.push(attr_list);
		attr_list = new dict<IdString, AstNode*>;
		for (auto &it : default_attr_list)
			(*attr_list)[it.first] = it.second->clone();
	}
#line 4055 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 15: /* attr: $@2 attr_opt  */
#line 498 "frontends/verilog/verilog_parser.y"
                   {
		(yyval.al) = attr_list;
		if (!attr_list_stack.empty()) {
			attr_list = attr_list_stack.top();
			attr_list_stack.pop();
		} else
			attr_list = nullptr;
	}
#line 4068 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 16: /* attr_opt: attr_opt ATTR_BEGIN opt_attr_list ATTR_END  */
#line 508 "frontends/verilog/verilog_parser.y"
                                                   {
		SET_RULE_LOC((yyloc), (yylsp[-2]), (yyloc));
	}
#line 4076 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 18: /* $@3: %empty  */
#line 514 "frontends/verilog/verilog_parser.y"
                      {
		if (attr_list != nullptr)
			attr_list_stack.push(attr_list);
		attr_list = new dict<IdString, AstNode*>;
		for (auto &it : default_attr_list)
			delete it.second;
		default_attr_list.clear();
	}
#line 4089 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 19: /* $@4: %empty  */
#line 521 "frontends/verilog/verilog_parser.y"
                        {
		attr_list->swap(default_attr_list);
		delete attr_list;
		if (!attr_list_stack.empty()) {
			attr_list = attr_list_stack.top();
			attr_list_stack.pop();
		} else
			attr_list = nullptr;
	}
#line 4103 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 25: /* attr_assign: hierarchical_id  */
#line 539 "frontends/verilog/verilog_parser.y"
                        {
		if (attr_list->count(*(yyvsp[0].string)) != 0)
			delete (*attr_list)[*(yyvsp[0].string)];
		(*attr_list)[*(yyvsp[0].string)] = AstNode::mkconst_int(1, false);
		delete (yyvsp[0].string);
	}
#line 4114 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 26: /* attr_assign: hierarchical_id '=' expr  */
#line 545 "frontends/verilog/verilog_parser.y"
                                 {
		if (attr_list->count(*(yyvsp[-2].string)) != 0)
			delete (*attr_list)[*(yyvsp[-2].string)];
		(*attr_list)[*(yyvsp[-2].string)] = (yyvsp[0].ast);
		delete (yyvsp[-2].string);
	}
#line 4125 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 27: /* hierarchical_id: TOK_ID  */
#line 553 "frontends/verilog/verilog_parser.y"
               {
		(yyval.string) = (yyvsp[0].string);
	}
#line 4133 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 28: /* hierarchical_id: hierarchical_id TOK_PACKAGESEP TOK_ID  */
#line 556 "frontends/verilog/verilog_parser.y"
                                              {
		if ((yyvsp[0].string)->compare(0, 1, "\\") == 0)
			*(yyvsp[-2].string) += "::" + (yyvsp[0].string)->substr(1);
		else
			*(yyvsp[-2].string) += "::" + *(yyvsp[0].string);
		delete (yyvsp[0].string);
		(yyval.string) = (yyvsp[-2].string);
	}
#line 4146 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 29: /* hierarchical_id: hierarchical_id '.' TOK_ID  */
#line 564 "frontends/verilog/verilog_parser.y"
                                   {
		if ((yyvsp[0].string)->compare(0, 1, "\\") == 0)
			*(yyvsp[-2].string) += "." + (yyvsp[0].string)->substr(1);
		else
			*(yyvsp[-2].string) += "." + *(yyvsp[0].string);
		delete (yyvsp[0].string);
		(yyval.string) = (yyvsp[-2].string);
	}
#line 4159 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 32: /* hierarchical_type_id: '(' TOK_USER_TYPE ')'  */
#line 576 "frontends/verilog/verilog_parser.y"
                                { (yyval.string) = (yyvsp[-1].string); }
#line 4165 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 33: /* $@5: %empty  */
#line 580 "frontends/verilog/verilog_parser.y"
                        {
		enterTypeScope();
	}
#line 4173 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 34: /* $@6: %empty  */
#line 582 "frontends/verilog/verilog_parser.y"
                 {
		do_not_require_port_stubs = false;
		AstNode *mod = new AstNode(AST_MODULE);
		ast_stack.back()->children.push_back(mod);
		ast_stack.push_back(mod);
		current_ast_mod = mod;
		port_stubs.clear();
		port_counter = 0;
		mod->str = *(yyvsp[0].string);
		append_attr(mod, (yyvsp[-3].al));
	}
#line 4189 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 35: /* module: attr TOK_MODULE $@5 TOK_ID $@6 module_para_opt module_args_opt ';' module_body TOK_ENDMODULE opt_label  */
#line 592 "frontends/verilog/verilog_parser.y"
                                                                                  {
		if (port_stubs.size() != 0)
			frontend_verilog_yyerror("Missing details for module port `%s'.",
					port_stubs.begin()->first.c_str());
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-9]), (yyloc));
		ast_stack.pop_back();
		log_assert(ast_stack.size() == 1);
		checkLabelsMatch("Module name", (yyvsp[-7].string), (yyvsp[0].string));
		current_ast_mod = NULL;
		delete (yyvsp[-7].string);
		delete (yyvsp[0].string);
		exitTypeScope();
	}
#line 4207 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 36: /* $@7: %empty  */
#line 607 "frontends/verilog/verilog_parser.y"
                { astbuf1 = nullptr; }
#line 4213 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 37: /* $@8: %empty  */
#line 607 "frontends/verilog/verilog_parser.y"
                                                        { if (astbuf1) delete astbuf1; }
#line 4219 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 43: /* $@9: %empty  */
#line 614 "frontends/verilog/verilog_parser.y"
                           {
		if (astbuf1) delete astbuf1;
		astbuf1 = new AstNode(AST_PARAMETER);
		astbuf1->children.push_back(AstNode::mkconst_int(0, true));
		append_attr(astbuf1, (yyvsp[-1].al));
	}
#line 4230 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 45: /* $@10: %empty  */
#line 620 "frontends/verilog/verilog_parser.y"
                            {
		if (astbuf1) delete astbuf1;
		astbuf1 = new AstNode(AST_LOCALPARAM);
		astbuf1->children.push_back(AstNode::mkconst_int(0, true));
		append_attr(astbuf1, (yyvsp[-1].al));
	}
#line 4241 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 55: /* module_arg_opt_assignment: '=' expr  */
#line 638 "frontends/verilog/verilog_parser.y"
                 {
		if (ast_stack.back()->children.size() > 0 && ast_stack.back()->children.back()->type == AST_WIRE) {
			if (ast_stack.back()->children.back()->is_input) {
				AstNode *n = ast_stack.back()->children.back();
				if (n->attributes.count(ID::defaultvalue))
					delete n->attributes.at(ID::defaultvalue);
				n->attributes[ID::defaultvalue] = (yyvsp[0].ast);
			} else {
				AstNode *wire = new AstNode(AST_IDENTIFIER);
				wire->str = ast_stack.back()->children.back()->str;
				if (ast_stack.back()->children.back()->is_reg || ast_stack.back()->children.back()->is_logic)
					ast_stack.back()->children.push_back(new AstNode(AST_INITIAL, new AstNode(AST_BLOCK, new AstNode(AST_ASSIGN_LE, wire, (yyvsp[0].ast)))));
				else
					ast_stack.back()->children.push_back(new AstNode(AST_ASSIGN, wire, (yyvsp[0].ast)));
			}
		} else
			frontend_verilog_yyerror("SystemVerilog interface in module port list cannot have a default value.");
	}
#line 4264 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 57: /* $@11: %empty  */
#line 659 "frontends/verilog/verilog_parser.y"
               {
		if (ast_stack.back()->children.size() > 0 && ast_stack.back()->children.back()->type == AST_WIRE) {
			AstNode *node = ast_stack.back()->children.back()->clone();
			node->str = *(yyvsp[0].string);
			node->port_id = ++port_counter;
			ast_stack.back()->children.push_back(node);
			SET_AST_NODE_LOC(node, (yylsp[0]), (yylsp[0]));
		} else {
			if (port_stubs.count(*(yyvsp[0].string)) != 0)
				frontend_verilog_yyerror("Duplicate module port `%s'.", (yyvsp[0].string)->c_str());
			port_stubs[*(yyvsp[0].string)] = ++port_counter;
		}
		delete (yyvsp[0].string);
	}
#line 4283 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 59: /* $@12: %empty  */
#line 673 "frontends/verilog/verilog_parser.y"
               {
		astbuf1 = new AstNode(AST_INTERFACEPORT);
		astbuf1->children.push_back(new AstNode(AST_INTERFACEPORTTYPE));
		astbuf1->children[0]->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
	}
#line 4294 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 60: /* $@13: %empty  */
#line 678 "frontends/verilog/verilog_parser.y"
                 {  /* SV interfaces */
		if (!sv_mode)
			frontend_verilog_yyerror("Interface found in port list (%s). This is not supported unless read_verilog is called with -sv!", (yyvsp[0].string)->c_str());
		astbuf2 = astbuf1->clone(); // really only needed if multiple instances of same type.
		astbuf2->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
		astbuf2->port_id = ++port_counter;
		ast_stack.back()->children.push_back(astbuf2);
		delete astbuf1; // really only needed if multiple instances of same type.
	}
#line 4309 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 62: /* $@14: %empty  */
#line 688 "frontends/verilog/verilog_parser.y"
                                                  {
		AstNode *node = (yyvsp[-2].ast);
		node->str = *(yyvsp[0].string);
		SET_AST_NODE_LOC(node, (yylsp[0]), (yylsp[0]));
		node->port_id = ++port_counter;
		AstNode *range = checkRange(node, (yyvsp[-1].ast));
		if (range != NULL)
			node->children.push_back(range);
		if (!node->is_input && !node->is_output)
			frontend_verilog_yyerror("Module port `%s' is neither input nor output.", (yyvsp[0].string)->c_str());
		if (node->is_reg && node->is_input && !node->is_output && !sv_mode)
			frontend_verilog_yyerror("Input port `%s' is declared as register.", (yyvsp[0].string)->c_str());
		ast_stack.back()->children.push_back(node);
		append_attr(node, (yyvsp[-3].al));
		delete (yyvsp[0].string);
	}
#line 4330 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 64: /* module_arg: '.' '.' '.'  */
#line 704 "frontends/verilog/verilog_parser.y"
                    {
		do_not_require_port_stubs = true;
	}
#line 4338 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 65: /* $@15: %empty  */
#line 709 "frontends/verilog/verilog_parser.y"
                         {
		enterTypeScope();
	}
#line 4346 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 66: /* $@16: %empty  */
#line 711 "frontends/verilog/verilog_parser.y"
                 {
		AstNode *mod = new AstNode(AST_PACKAGE);
		ast_stack.back()->children.push_back(mod);
		ast_stack.push_back(mod);
		current_ast_mod = mod;
		mod->str = *(yyvsp[0].string);
		append_attr(mod, (yyvsp[-3].al));
	}
#line 4359 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 67: /* package: attr TOK_PACKAGE $@15 TOK_ID $@16 ';' package_body TOK_ENDPACKAGE opt_label  */
#line 718 "frontends/verilog/verilog_parser.y"
                                                    {
		ast_stack.pop_back();
		checkLabelsMatch("Package name", (yyvsp[-5].string), (yyvsp[0].string));
		current_ast_mod = NULL;
		delete (yyvsp[-5].string);
		delete (yyvsp[0].string);
		exitTypeScope();
	}
#line 4372 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 74: /* $@17: %empty  */
#line 734 "frontends/verilog/verilog_parser.y"
                      {
		enterTypeScope();
	}
#line 4380 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 75: /* $@18: %empty  */
#line 736 "frontends/verilog/verilog_parser.y"
                 {
		do_not_require_port_stubs = false;
		AstNode *intf = new AstNode(AST_INTERFACE);
		ast_stack.back()->children.push_back(intf);
		ast_stack.push_back(intf);
		current_ast_mod = intf;
		port_stubs.clear();
		port_counter = 0;
		intf->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
	}
#line 4396 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 76: /* interface: TOK_INTERFACE $@17 TOK_ID $@18 module_para_opt module_args_opt ';' interface_body TOK_ENDINTERFACE  */
#line 746 "frontends/verilog/verilog_parser.y"
                                                                              {
		if (port_stubs.size() != 0)
			frontend_verilog_yyerror("Missing details for module port `%s'.",
				port_stubs.begin()->first.c_str());
		ast_stack.pop_back();
		log_assert(ast_stack.size() == 1);
		current_ast_mod = NULL;
		exitTypeScope();
	}
#line 4410 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 88: /* $@19: %empty  */
#line 764 "frontends/verilog/verilog_parser.y"
                 {
		AstNode *bnode = new AstNode(AST_BIND);
		ast_stack.back()->children.push_back(bnode);
		ast_stack.push_back(bnode);
	}
#line 4420 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 89: /* $@20: %empty  */
#line 769 "frontends/verilog/verilog_parser.y"
                    {
		// bind_target should have added at least one child
		log_assert(ast_stack.back()->children.size() >= 1);
	}
#line 4429 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 90: /* $@21: %empty  */
#line 773 "frontends/verilog/verilog_parser.y"
               {
		// The single_cell parser in cell_list_no_array uses astbuf1 as
		// a sort of template for constructing cells.
		astbuf1 = new AstNode(AST_CELL);
		astbuf1->children.push_back(new AstNode(AST_CELLTYPE));
		astbuf1->children[0]->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
	}
#line 4442 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 91: /* bind_directive: TOK_BIND $@19 bind_target $@20 TOK_ID $@21 cell_parameter_list_opt cell_list_no_array ';'  */
#line 781 "frontends/verilog/verilog_parser.y"
                                                       {
		// cell_list should have added at least one more child
		log_assert(ast_stack.back()->children.size() >= 2);
		delete astbuf1;
		ast_stack.pop_back();
	}
#line 4453 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 97: /* bind_target_instance: hierarchical_id  */
#line 816 "frontends/verilog/verilog_parser.y"
                        {
		auto *node = new AstNode(AST_IDENTIFIER);
		node->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
		ast_stack.back()->children.push_back(node);
	}
#line 4464 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 98: /* mintypmax_expr: expr  */
#line 824 "frontends/verilog/verilog_parser.y"
             { delete (yyvsp[0].ast); }
#line 4470 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 99: /* mintypmax_expr: expr ':' expr ':' expr  */
#line 825 "frontends/verilog/verilog_parser.y"
                               { delete (yyvsp[-4].ast); delete (yyvsp[-2].ast); delete (yyvsp[0].ast); }
#line 4476 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 100: /* non_opt_delay: '#' TOK_ID  */
#line 828 "frontends/verilog/verilog_parser.y"
                   { delete (yyvsp[0].string); }
#line 4482 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 101: /* non_opt_delay: '#' TOK_CONSTVAL  */
#line 829 "frontends/verilog/verilog_parser.y"
                         { delete (yyvsp[0].string); }
#line 4488 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 102: /* non_opt_delay: '#' TOK_REALVAL  */
#line 830 "frontends/verilog/verilog_parser.y"
                        { delete (yyvsp[0].string); }
#line 4494 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 110: /* $@22: %empty  */
#line 842 "frontends/verilog/verilog_parser.y"
        { astbuf3 = new AstNode(AST_WIRE); current_wire_rand = false; current_wire_const = false; }
#line 4500 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 111: /* io_wire_type: $@22 wire_type_token_io wire_type_const_rand opt_wire_type_token wire_type_signedness  */
#line 844 "frontends/verilog/verilog_parser.y"
        { (yyval.ast) = astbuf3; SET_RULE_LOC((yyloc), (yylsp[-3]), (yyloc)); }
#line 4506 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 112: /* $@23: %empty  */
#line 847 "frontends/verilog/verilog_parser.y"
        { astbuf3 = new AstNode(AST_WIRE); current_wire_rand = false; current_wire_const = false; }
#line 4512 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 113: /* non_io_wire_type: $@23 wire_type_const_rand wire_type_token wire_type_signedness  */
#line 849 "frontends/verilog/verilog_parser.y"
        { (yyval.ast) = astbuf3; SET_RULE_LOC((yyloc), (yylsp[-2]), (yyloc)); }
#line 4518 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 116: /* wire_type_token_io: TOK_INPUT  */
#line 856 "frontends/verilog/verilog_parser.y"
                  {
		astbuf3->is_input = true;
	}
#line 4526 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 117: /* wire_type_token_io: TOK_OUTPUT  */
#line 859 "frontends/verilog/verilog_parser.y"
                   {
		astbuf3->is_output = true;
	}
#line 4534 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 118: /* wire_type_token_io: TOK_INOUT  */
#line 862 "frontends/verilog/verilog_parser.y"
                  {
		astbuf3->is_input = true;
		astbuf3->is_output = true;
	}
#line 4543 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 119: /* wire_type_signedness: TOK_SIGNED  */
#line 868 "frontends/verilog/verilog_parser.y"
                     { astbuf3->is_signed = true;  }
#line 4549 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 120: /* wire_type_signedness: TOK_UNSIGNED  */
#line 869 "frontends/verilog/verilog_parser.y"
                     { astbuf3->is_signed = false; }
#line 4555 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 122: /* wire_type_const_rand: TOK_RAND TOK_CONST  */
#line 873 "frontends/verilog/verilog_parser.y"
                           {
	    current_wire_rand = true;
	    current_wire_const = true;
	}
#line 4564 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 123: /* wire_type_const_rand: TOK_CONST  */
#line 877 "frontends/verilog/verilog_parser.y"
                  {
	    current_wire_const = true;
	}
#line 4572 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 124: /* wire_type_const_rand: TOK_RAND  */
#line 880 "frontends/verilog/verilog_parser.y"
                 {
	    current_wire_rand = true;
	}
#line 4580 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 128: /* wire_type_token: net_type  */
#line 890 "frontends/verilog/verilog_parser.y"
                 {
	}
#line 4587 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 129: /* wire_type_token: net_type logic_type  */
#line 892 "frontends/verilog/verilog_parser.y"
                            {
	}
#line 4594 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 130: /* wire_type_token: TOK_REG  */
#line 895 "frontends/verilog/verilog_parser.y"
                {
		astbuf3->is_reg = true;
	}
#line 4602 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 131: /* wire_type_token: TOK_VAR TOK_REG  */
#line 898 "frontends/verilog/verilog_parser.y"
                        {
		astbuf3->is_reg = true;
	}
#line 4610 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 132: /* wire_type_token: TOK_VAR  */
#line 902 "frontends/verilog/verilog_parser.y"
                {
		astbuf3->is_logic = true;
	}
#line 4618 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 133: /* wire_type_token: TOK_VAR logic_type  */
#line 905 "frontends/verilog/verilog_parser.y"
                           {
		astbuf3->is_logic = true;
	}
#line 4626 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 134: /* wire_type_token: logic_type  */
#line 908 "frontends/verilog/verilog_parser.y"
                   {
		astbuf3->is_logic = true;
	}
#line 4634 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 135: /* wire_type_token: TOK_GENVAR  */
#line 911 "frontends/verilog/verilog_parser.y"
                   {
		astbuf3->type = AST_GENVAR;
		astbuf3->is_reg = true;
		astbuf3->is_signed = true;
		astbuf3->range_left = 31;
		astbuf3->range_right = 0;
	}
#line 4646 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 136: /* net_type: TOK_WOR  */
#line 920 "frontends/verilog/verilog_parser.y"
                {
		astbuf3->is_wor = true;
	}
#line 4654 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 137: /* net_type: TOK_WAND  */
#line 923 "frontends/verilog/verilog_parser.y"
                 {
		astbuf3->is_wand = true;
	}
#line 4662 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 139: /* logic_type: TOK_LOGIC  */
#line 929 "frontends/verilog/verilog_parser.y"
                  {
	}
#line 4669 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 140: /* logic_type: integer_atom_type  */
#line 931 "frontends/verilog/verilog_parser.y"
                          {
		astbuf3->range_left = (yyvsp[0].integer) - 1;
		astbuf3->range_right = 0;
		astbuf3->is_signed = true;
	}
#line 4679 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 141: /* logic_type: hierarchical_type_id  */
#line 936 "frontends/verilog/verilog_parser.y"
                             {
		addWiretypeNode((yyvsp[0].string), astbuf3);
	}
#line 4687 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 142: /* integer_atom_type: TOK_INTEGER  */
#line 941 "frontends/verilog/verilog_parser.y"
                        { (yyval.integer) = 32; }
#line 4693 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 143: /* integer_atom_type: TOK_INT  */
#line 942 "frontends/verilog/verilog_parser.y"
                        { (yyval.integer) = 32; }
#line 4699 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 144: /* integer_atom_type: TOK_SHORTINT  */
#line 943 "frontends/verilog/verilog_parser.y"
                        { (yyval.integer) = 16; }
#line 4705 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 145: /* integer_atom_type: TOK_LONGINT  */
#line 944 "frontends/verilog/verilog_parser.y"
                        { (yyval.integer) = 64; }
#line 4711 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 146: /* integer_atom_type: TOK_BYTE  */
#line 945 "frontends/verilog/verilog_parser.y"
                        { (yyval.integer) =  8; }
#line 4717 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 147: /* integer_vector_type: TOK_LOGIC  */
#line 948 "frontends/verilog/verilog_parser.y"
                  { (yyval.integer) = TOK_LOGIC; }
#line 4723 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 148: /* integer_vector_type: TOK_REG  */
#line 949 "frontends/verilog/verilog_parser.y"
                  { (yyval.integer) = TOK_REG; }
#line 4729 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 149: /* non_opt_range: '[' expr ':' expr ']'  */
#line 952 "frontends/verilog/verilog_parser.y"
                              {
		(yyval.ast) = new AstNode(AST_RANGE);
		(yyval.ast)->children.push_back((yyvsp[-3].ast));
		(yyval.ast)->children.push_back((yyvsp[-1].ast));
	}
#line 4739 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 150: /* non_opt_range: '[' expr TOK_POS_INDEXED expr ']'  */
#line 957 "frontends/verilog/verilog_parser.y"
                                          {
		(yyval.ast) = new AstNode(AST_RANGE);
		AstNode *expr = new AstNode(AST_SELFSZ, (yyvsp[-3].ast));
		(yyval.ast)->children.push_back(new AstNode(AST_SUB, new AstNode(AST_ADD, expr->clone(), (yyvsp[-1].ast)), AstNode::mkconst_int(1, true)));
		(yyval.ast)->children.push_back(new AstNode(AST_ADD, expr, AstNode::mkconst_int(0, true)));
	}
#line 4750 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 151: /* non_opt_range: '[' expr TOK_NEG_INDEXED expr ']'  */
#line 963 "frontends/verilog/verilog_parser.y"
                                          {
		(yyval.ast) = new AstNode(AST_RANGE);
		AstNode *expr = new AstNode(AST_SELFSZ, (yyvsp[-3].ast));
		(yyval.ast)->children.push_back(new AstNode(AST_ADD, expr, AstNode::mkconst_int(0, true)));
		(yyval.ast)->children.push_back(new AstNode(AST_SUB, new AstNode(AST_ADD, expr->clone(), AstNode::mkconst_int(1, true)), (yyvsp[-1].ast)));
	}
#line 4761 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 152: /* non_opt_range: '[' expr ']'  */
#line 969 "frontends/verilog/verilog_parser.y"
                     {
		(yyval.ast) = new AstNode(AST_RANGE);
		(yyval.ast)->children.push_back((yyvsp[-1].ast));
	}
#line 4770 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 153: /* non_opt_multirange: non_opt_range non_opt_range  */
#line 975 "frontends/verilog/verilog_parser.y"
                                    {
		(yyval.ast) = new AstNode(AST_MULTIRANGE, (yyvsp[-1].ast), (yyvsp[0].ast));
	}
#line 4778 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 154: /* non_opt_multirange: non_opt_multirange non_opt_range  */
#line 978 "frontends/verilog/verilog_parser.y"
                                         {
		(yyval.ast) = (yyvsp[-1].ast);
		(yyval.ast)->children.push_back((yyvsp[0].ast));
	}
#line 4787 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 155: /* range: non_opt_range  */
#line 984 "frontends/verilog/verilog_parser.y"
                      {
		(yyval.ast) = (yyvsp[0].ast);
	}
#line 4795 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 156: /* range: %empty  */
#line 987 "frontends/verilog/verilog_parser.y"
               {
		(yyval.ast) = NULL;
	}
#line 4803 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 157: /* range_or_multirange: range  */
#line 992 "frontends/verilog/verilog_parser.y"
              { (yyval.ast) = (yyvsp[0].ast); }
#line 4809 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 158: /* range_or_multirange: non_opt_multirange  */
#line 993 "frontends/verilog/verilog_parser.y"
                           { (yyval.ast) = (yyvsp[0].ast); }
#line 4815 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 183: /* $@24: %empty  */
#line 1009 "frontends/verilog/verilog_parser.y"
                               {
		AstNode *node = new AstNode(AST_GENBLOCK);
		node->str = *(yyvsp[-1].string);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
	}
#line 4826 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 184: /* checker_decl: TOK_CHECKER TOK_ID ';' $@24 module_body TOK_ENDCHECKER  */
#line 1014 "frontends/verilog/verilog_parser.y"
                                     {
		delete (yyvsp[-4].string);
		ast_stack.pop_back();
	}
#line 4835 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 185: /* $@25: %empty  */
#line 1020 "frontends/verilog/verilog_parser.y"
                                            {
		current_function_or_task = new AstNode(AST_DPI_FUNCTION, AstNode::mkconst_str(*(yyvsp[-1].string)), AstNode::mkconst_str(*(yyvsp[0].string)));
		current_function_or_task->str = *(yyvsp[0].string);
		append_attr(current_function_or_task, (yyvsp[-3].al));
		ast_stack.back()->children.push_back(current_function_or_task);
		delete (yyvsp[-1].string);
		delete (yyvsp[0].string);
	}
#line 4848 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 186: /* task_func_decl: attr TOK_DPI_FUNCTION TOK_ID TOK_ID $@25 opt_dpi_function_args ';'  */
#line 1027 "frontends/verilog/verilog_parser.y"
                                    {
		current_function_or_task = NULL;
	}
#line 4856 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 187: /* $@26: %empty  */
#line 1030 "frontends/verilog/verilog_parser.y"
                                                       {
		current_function_or_task = new AstNode(AST_DPI_FUNCTION, AstNode::mkconst_str(*(yyvsp[-1].string)), AstNode::mkconst_str(*(yyvsp[-3].string)));
		current_function_or_task->str = *(yyvsp[0].string);
		append_attr(current_function_or_task, (yyvsp[-5].al));
		ast_stack.back()->children.push_back(current_function_or_task);
		delete (yyvsp[-3].string);
		delete (yyvsp[-1].string);
		delete (yyvsp[0].string);
	}
#line 4870 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 188: /* task_func_decl: attr TOK_DPI_FUNCTION TOK_ID '=' TOK_ID TOK_ID $@26 opt_dpi_function_args ';'  */
#line 1038 "frontends/verilog/verilog_parser.y"
                                    {
		current_function_or_task = NULL;
	}
#line 4878 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 189: /* $@27: %empty  */
#line 1041 "frontends/verilog/verilog_parser.y"
                                                                  {
		current_function_or_task = new AstNode(AST_DPI_FUNCTION, AstNode::mkconst_str(*(yyvsp[-1].string)), AstNode::mkconst_str(*(yyvsp[-5].string) + ":" + RTLIL::unescape_id(*(yyvsp[-3].string))));
		current_function_or_task->str = *(yyvsp[0].string);
		append_attr(current_function_or_task, (yyvsp[-7].al));
		ast_stack.back()->children.push_back(current_function_or_task);
		delete (yyvsp[-5].string);
		delete (yyvsp[-3].string);
		delete (yyvsp[-1].string);
		delete (yyvsp[0].string);
	}
#line 4893 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 190: /* task_func_decl: attr TOK_DPI_FUNCTION TOK_ID ':' TOK_ID '=' TOK_ID TOK_ID $@27 opt_dpi_function_args ';'  */
#line 1050 "frontends/verilog/verilog_parser.y"
                                    {
		current_function_or_task = NULL;
	}
#line 4901 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 191: /* $@28: %empty  */
#line 1053 "frontends/verilog/verilog_parser.y"
                                           {
		current_function_or_task = new AstNode(AST_TASK);
		current_function_or_task->str = *(yyvsp[0].string);
		append_attr(current_function_or_task, (yyvsp[-3].al));
		ast_stack.back()->children.push_back(current_function_or_task);
		ast_stack.push_back(current_function_or_task);
		current_function_or_task_port_id = 1;
		delete (yyvsp[0].string);
	}
#line 4915 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 192: /* task_func_decl: attr TOK_TASK opt_automatic TOK_ID $@28 task_func_args_opt ';' task_func_body TOK_ENDTASK  */
#line 1061 "frontends/verilog/verilog_parser.y"
                                                            {
		current_function_or_task = NULL;
		ast_stack.pop_back();
	}
#line 4924 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 193: /* $@29: %empty  */
#line 1065 "frontends/verilog/verilog_parser.y"
                                                        {
		// The difference between void functions and tasks is that
		// always_comb's implicit sensitivity list behaves as if functions were
		// inlined, but ignores signals read only in tasks. This only matters
		// for event based simulation, and for synthesis we can treat a void
		// function like a task.
		current_function_or_task = new AstNode(AST_TASK);
		current_function_or_task->str = *(yyvsp[0].string);
		append_attr(current_function_or_task, (yyvsp[-4].al));
		ast_stack.back()->children.push_back(current_function_or_task);
		ast_stack.push_back(current_function_or_task);
		current_function_or_task_port_id = 1;
		delete (yyvsp[0].string);
	}
#line 4943 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 194: /* task_func_decl: attr TOK_FUNCTION opt_automatic TOK_VOID TOK_ID $@29 task_func_args_opt ';' task_func_body TOK_ENDFUNCTION  */
#line 1078 "frontends/verilog/verilog_parser.y"
                                                                {
		current_function_or_task = NULL;
		ast_stack.pop_back();
	}
#line 4952 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 195: /* $@30: %empty  */
#line 1082 "frontends/verilog/verilog_parser.y"
                                                                {
		current_function_or_task = new AstNode(AST_FUNCTION);
		current_function_or_task->str = *(yyvsp[0].string);
		append_attr(current_function_or_task, (yyvsp[-4].al));
		ast_stack.back()->children.push_back(current_function_or_task);
		ast_stack.push_back(current_function_or_task);
		AstNode *outreg = new AstNode(AST_WIRE);
		outreg->str = *(yyvsp[0].string);
		outreg->is_signed = false;
		outreg->is_reg = true;
		if ((yyvsp[-1].ast) != NULL) {
			outreg->children.push_back((yyvsp[-1].ast));
			outreg->is_signed = (yyvsp[-1].ast)->is_signed;
			(yyvsp[-1].ast)->is_signed = false;
			outreg->is_custom_type = (yyvsp[-1].ast)->type == AST_WIRETYPE;
		}
		current_function_or_task->children.push_back(outreg);
		current_function_or_task_port_id = 1;
		delete (yyvsp[0].string);
	}
#line 4977 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 196: /* task_func_decl: attr TOK_FUNCTION opt_automatic func_return_type TOK_ID $@30 task_func_args_opt ';' task_func_body TOK_ENDFUNCTION  */
#line 1101 "frontends/verilog/verilog_parser.y"
                                                                {
		current_function_or_task = NULL;
		ast_stack.pop_back();
	}
#line 4986 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 197: /* func_return_type: hierarchical_type_id  */
#line 1107 "frontends/verilog/verilog_parser.y"
                             {
		(yyval.ast) = new AstNode(AST_WIRETYPE);
		(yyval.ast)->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
	}
#line 4996 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 198: /* func_return_type: opt_type_vec opt_signedness_default_unsigned  */
#line 1112 "frontends/verilog/verilog_parser.y"
                                                     {
		(yyval.ast) = makeRange(0, 0, (yyvsp[0].boolean));
	}
#line 5004 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 199: /* func_return_type: opt_type_vec opt_signedness_default_unsigned non_opt_range  */
#line 1115 "frontends/verilog/verilog_parser.y"
                                                                   {
		(yyval.ast) = (yyvsp[0].ast);
		(yyval.ast)->is_signed = (yyvsp[-1].boolean);
	}
#line 5013 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 200: /* func_return_type: integer_atom_type opt_signedness_default_signed  */
#line 1119 "frontends/verilog/verilog_parser.y"
                                                        {
		(yyval.ast) = makeRange((yyvsp[-1].integer) - 1, 0, (yyvsp[0].boolean));
	}
#line 5021 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 204: /* opt_signedness_default_signed: %empty  */
#line 1130 "frontends/verilog/verilog_parser.y"
                        { (yyval.boolean) = true; }
#line 5027 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 205: /* opt_signedness_default_signed: TOK_SIGNED  */
#line 1131 "frontends/verilog/verilog_parser.y"
                        { (yyval.boolean) = true; }
#line 5033 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 206: /* opt_signedness_default_signed: TOK_UNSIGNED  */
#line 1132 "frontends/verilog/verilog_parser.y"
                        { (yyval.boolean) = false; }
#line 5039 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 207: /* opt_signedness_default_unsigned: %empty  */
#line 1135 "frontends/verilog/verilog_parser.y"
                        { (yyval.boolean) = false; }
#line 5045 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 208: /* opt_signedness_default_unsigned: TOK_SIGNED  */
#line 1136 "frontends/verilog/verilog_parser.y"
                        { (yyval.boolean) = true; }
#line 5051 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 209: /* opt_signedness_default_unsigned: TOK_UNSIGNED  */
#line 1137 "frontends/verilog/verilog_parser.y"
                        { (yyval.boolean) = false; }
#line 5057 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 210: /* dpi_function_arg: TOK_ID TOK_ID  */
#line 1141 "frontends/verilog/verilog_parser.y"
                      {
		current_function_or_task->children.push_back(AstNode::mkconst_str(*(yyvsp[-1].string)));
		delete (yyvsp[-1].string);
		delete (yyvsp[0].string);
	}
#line 5067 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 211: /* dpi_function_arg: TOK_ID  */
#line 1146 "frontends/verilog/verilog_parser.y"
               {
		current_function_or_task->children.push_back(AstNode::mkconst_str(*(yyvsp[0].string)));
		delete (yyvsp[0].string);
	}
#line 5076 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 222: /* $@31: %empty  */
#line 1166 "frontends/verilog/verilog_parser.y"
                               {
		albuf = nullptr;
		astbuf1 = nullptr;
		astbuf2 = nullptr;
	}
#line 5086 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 223: /* $@32: %empty  */
#line 1170 "frontends/verilog/verilog_parser.y"
                                        {
		delete astbuf1;
		if (astbuf2 != NULL)
			delete astbuf2;
		free_attr(albuf);
	}
#line 5097 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 227: /* $@33: %empty  */
#line 1181 "frontends/verilog/verilog_parser.y"
                                           {
		bool prev_was_input = true;
		bool prev_was_output = false;
		if (albuf) {
			prev_was_input = astbuf1->is_input;
			prev_was_output = astbuf1->is_output;
			delete astbuf1;
			if (astbuf2 != NULL)
				delete astbuf2;
			free_attr(albuf);
		}
		albuf = (yyvsp[-2].al);
		astbuf1 = (yyvsp[-1].ast);
		astbuf2 = checkRange(astbuf1, (yyvsp[0].ast));
		if (!astbuf1->is_input && !astbuf1->is_output) {
			if (!sv_mode)
				frontend_verilog_yyerror("task/function argument direction missing");
			astbuf1->is_input = prev_was_input;
			astbuf1->is_output = prev_was_output;
		}
	}
#line 5123 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 229: /* $@34: %empty  */
#line 1202 "frontends/verilog/verilog_parser.y"
        {
		if (!astbuf1) {
			if (!sv_mode)
				frontend_verilog_yyerror("task/function argument direction missing");
			albuf = new dict<IdString, AstNode*>;
			astbuf1 = new AstNode(AST_WIRE);
			current_wire_rand = false;
			current_wire_const = false;
			astbuf1->is_input = true;
			astbuf2 = NULL;
		}
	}
#line 5140 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 236: /* specify_item: specify_if '(' specify_edge expr TOK_SPECIFY_OPER specify_target ')' '=' specify_rise_fall ';'  */
#line 1229 "frontends/verilog/verilog_parser.y"
                                                                                                       {
		AstNode *en_expr = (yyvsp[-9].ast);
		char specify_edge = (yyvsp[-7].ch);
		AstNode *src_expr = (yyvsp[-6].ast);
		string *oper = (yyvsp[-5].string);
		specify_target *target = (yyvsp[-4].specify_target_ptr);
		specify_rise_fall *timing = (yyvsp[-1].specify_rise_fall_ptr);

		if (specify_edge != 0 && target->dat == nullptr)
			frontend_verilog_yyerror("Found specify edge but no data spec.\n");

		AstNode *cell = new AstNode(AST_CELL);
		ast_stack.back()->children.push_back(cell);
		cell->str = stringf("$specify$%d", autoidx++);
		cell->children.push_back(new AstNode(AST_CELLTYPE));
		cell->children.back()->str = target->dat ? "$specify3" : "$specify2";
		SET_AST_NODE_LOC(cell, en_expr ? (yylsp[-9]) : (yylsp[-8]), (yylsp[0]));

		char oper_polarity = 0;
		char oper_type = oper->at(0);

		if (oper->size() == 3) {
			oper_polarity = oper->at(0);
			oper_type = oper->at(1);
		}

		cell->children.push_back(new AstNode(AST_PARASET, AstNode::mkconst_int(oper_type == '*', false, 1)));
		cell->children.back()->str = "\\FULL";

		cell->children.push_back(new AstNode(AST_PARASET, AstNode::mkconst_int(oper_polarity != 0, false, 1)));
		cell->children.back()->str = "\\SRC_DST_PEN";

		cell->children.push_back(new AstNode(AST_PARASET, AstNode::mkconst_int(oper_polarity == '+', false, 1)));
		cell->children.back()->str = "\\SRC_DST_POL";

		cell->children.push_back(new AstNode(AST_PARASET, timing->rise.t_min));
		cell->children.back()->str = "\\T_RISE_MIN";

		cell->children.push_back(new AstNode(AST_PARASET, timing->rise.t_avg));
		cell->children.back()->str = "\\T_RISE_TYP";

		cell->children.push_back(new AstNode(AST_PARASET, timing->rise.t_max));
		cell->children.back()->str = "\\T_RISE_MAX";

		cell->children.push_back(new AstNode(AST_PARASET, timing->fall.t_min));
		cell->children.back()->str = "\\T_FALL_MIN";

		cell->children.push_back(new AstNode(AST_PARASET, timing->fall.t_avg));
		cell->children.back()->str = "\\T_FALL_TYP";

		cell->children.push_back(new AstNode(AST_PARASET, timing->fall.t_max));
		cell->children.back()->str = "\\T_FALL_MAX";

		cell->children.push_back(new AstNode(AST_ARGUMENT, en_expr ? en_expr : AstNode::mkconst_int(1, false, 1)));
		cell->children.back()->str = "\\EN";

		cell->children.push_back(new AstNode(AST_ARGUMENT, src_expr));
		cell->children.back()->str = "\\SRC";

		cell->children.push_back(new AstNode(AST_ARGUMENT, target->dst));
		cell->children.back()->str = "\\DST";

		if (target->dat)
		{
			cell->children.push_back(new AstNode(AST_PARASET, AstNode::mkconst_int(specify_edge != 0, false, 1)));
			cell->children.back()->str = "\\EDGE_EN";

			cell->children.push_back(new AstNode(AST_PARASET, AstNode::mkconst_int(specify_edge == 'p', false, 1)));
			cell->children.back()->str = "\\EDGE_POL";

			cell->children.push_back(new AstNode(AST_PARASET, AstNode::mkconst_int(target->polarity_op != 0, false, 1)));
			cell->children.back()->str = "\\DAT_DST_PEN";

			cell->children.push_back(new AstNode(AST_PARASET, AstNode::mkconst_int(target->polarity_op == '+', false, 1)));
			cell->children.back()->str = "\\DAT_DST_POL";

			cell->children.push_back(new AstNode(AST_ARGUMENT, target->dat));
			cell->children.back()->str = "\\DAT";
		}

		delete oper;
		delete target;
		delete timing;
	}
#line 5229 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 237: /* specify_item: TOK_ID '(' specify_edge expr specify_condition ',' specify_edge expr specify_condition ',' specify_triple specify_opt_triple ')' ';'  */
#line 1313 "frontends/verilog/verilog_parser.y"
                                                                                                                                             {
		if (*(yyvsp[-13].string) != "$setup" && *(yyvsp[-13].string) != "$hold" && *(yyvsp[-13].string) != "$setuphold" && *(yyvsp[-13].string) != "$removal" && *(yyvsp[-13].string) != "$recovery" &&
				*(yyvsp[-13].string) != "$recrem" && *(yyvsp[-13].string) != "$skew" && *(yyvsp[-13].string) != "$timeskew" && *(yyvsp[-13].string) != "$fullskew" && *(yyvsp[-13].string) != "$nochange")
			frontend_verilog_yyerror("Unsupported specify rule type: %s\n", (yyvsp[-13].string)->c_str());

		AstNode *src_pen = AstNode::mkconst_int((yyvsp[-11].ch) != 0, false, 1);
		AstNode *src_pol = AstNode::mkconst_int((yyvsp[-11].ch) == 'p', false, 1);
		AstNode *src_expr = (yyvsp[-10].ast), *src_en = (yyvsp[-9].ast) ? (yyvsp[-9].ast) : AstNode::mkconst_int(1, false, 1);

		AstNode *dst_pen = AstNode::mkconst_int((yyvsp[-7].ch) != 0, false, 1);
		AstNode *dst_pol = AstNode::mkconst_int((yyvsp[-7].ch) == 'p', false, 1);
		AstNode *dst_expr = (yyvsp[-6].ast), *dst_en = (yyvsp[-5].ast) ? (yyvsp[-5].ast) : AstNode::mkconst_int(1, false, 1);

		specify_triple *limit = (yyvsp[-3].specify_triple_ptr);
		specify_triple *limit2 = (yyvsp[-2].specify_triple_ptr);

		AstNode *cell = new AstNode(AST_CELL);
		ast_stack.back()->children.push_back(cell);
		cell->str = stringf("$specify$%d", autoidx++);
		cell->children.push_back(new AstNode(AST_CELLTYPE));
		cell->children.back()->str = "$specrule";
		SET_AST_NODE_LOC(cell, (yylsp[-13]), (yylsp[0]));

		cell->children.push_back(new AstNode(AST_PARASET, AstNode::mkconst_str(*(yyvsp[-13].string))));
		cell->children.back()->str = "\\TYPE";

		cell->children.push_back(new AstNode(AST_PARASET, limit->t_min));
		cell->children.back()->str = "\\T_LIMIT_MIN";

		cell->children.push_back(new AstNode(AST_PARASET, limit->t_avg));
		cell->children.back()->str = "\\T_LIMIT_TYP";

		cell->children.push_back(new AstNode(AST_PARASET, limit->t_max));
		cell->children.back()->str = "\\T_LIMIT_MAX";

		cell->children.push_back(new AstNode(AST_PARASET, limit2 ? limit2->t_min : AstNode::mkconst_int(0, true)));
		cell->children.back()->str = "\\T_LIMIT2_MIN";

		cell->children.push_back(new AstNode(AST_PARASET, limit2 ? limit2->t_avg : AstNode::mkconst_int(0, true)));
		cell->children.back()->str = "\\T_LIMIT2_TYP";

		cell->children.push_back(new AstNode(AST_PARASET, limit2 ? limit2->t_max : AstNode::mkconst_int(0, true)));
		cell->children.back()->str = "\\T_LIMIT2_MAX";

		cell->children.push_back(new AstNode(AST_PARASET, src_pen));
		cell->children.back()->str = "\\SRC_PEN";

		cell->children.push_back(new AstNode(AST_PARASET, src_pol));
		cell->children.back()->str = "\\SRC_POL";

		cell->children.push_back(new AstNode(AST_PARASET, dst_pen));
		cell->children.back()->str = "\\DST_PEN";

		cell->children.push_back(new AstNode(AST_PARASET, dst_pol));
		cell->children.back()->str = "\\DST_POL";

		cell->children.push_back(new AstNode(AST_ARGUMENT, src_en));
		cell->children.back()->str = "\\SRC_EN";

		cell->children.push_back(new AstNode(AST_ARGUMENT, src_expr));
		cell->children.back()->str = "\\SRC";

		cell->children.push_back(new AstNode(AST_ARGUMENT, dst_en));
		cell->children.back()->str = "\\DST_EN";

		cell->children.push_back(new AstNode(AST_ARGUMENT, dst_expr));
		cell->children.back()->str = "\\DST";

		delete (yyvsp[-13].string);
		delete limit;
		delete limit2;
	}
#line 5306 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 238: /* specify_opt_triple: ',' specify_triple  */
#line 1387 "frontends/verilog/verilog_parser.y"
                           {
		(yyval.specify_triple_ptr) = (yyvsp[0].specify_triple_ptr);
	}
#line 5314 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 239: /* specify_opt_triple: %empty  */
#line 1390 "frontends/verilog/verilog_parser.y"
               {
		(yyval.specify_triple_ptr) = nullptr;
	}
#line 5322 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 240: /* specify_if: TOK_IF '(' expr ')'  */
#line 1395 "frontends/verilog/verilog_parser.y"
                            {
		(yyval.ast) = (yyvsp[-1].ast);
	}
#line 5330 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 241: /* specify_if: %empty  */
#line 1398 "frontends/verilog/verilog_parser.y"
               {
		(yyval.ast) = nullptr;
	}
#line 5338 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 242: /* specify_condition: TOK_SPECIFY_AND expr  */
#line 1403 "frontends/verilog/verilog_parser.y"
                             {
		(yyval.ast) = (yyvsp[0].ast);
	}
#line 5346 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 243: /* specify_condition: %empty  */
#line 1406 "frontends/verilog/verilog_parser.y"
               {
		(yyval.ast) = nullptr;
	}
#line 5354 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 244: /* specify_target: expr  */
#line 1411 "frontends/verilog/verilog_parser.y"
             {
		(yyval.specify_target_ptr) = new specify_target;
		(yyval.specify_target_ptr)->polarity_op = 0;
		(yyval.specify_target_ptr)->dst = (yyvsp[0].ast);
		(yyval.specify_target_ptr)->dat = nullptr;
	}
#line 5365 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 245: /* specify_target: '(' expr ':' expr ')'  */
#line 1417 "frontends/verilog/verilog_parser.y"
                             {
		(yyval.specify_target_ptr) = new specify_target;
		(yyval.specify_target_ptr)->polarity_op = 0;
		(yyval.specify_target_ptr)->dst = (yyvsp[-3].ast);
		(yyval.specify_target_ptr)->dat = (yyvsp[-1].ast);
	}
#line 5376 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 246: /* specify_target: '(' expr TOK_NEG_INDEXED expr ')'  */
#line 1423 "frontends/verilog/verilog_parser.y"
                                         {
		(yyval.specify_target_ptr) = new specify_target;
		(yyval.specify_target_ptr)->polarity_op = '-';
		(yyval.specify_target_ptr)->dst = (yyvsp[-3].ast);
		(yyval.specify_target_ptr)->dat = (yyvsp[-1].ast);
	}
#line 5387 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 247: /* specify_target: '(' expr TOK_POS_INDEXED expr ')'  */
#line 1429 "frontends/verilog/verilog_parser.y"
                                         {
		(yyval.specify_target_ptr) = new specify_target;
		(yyval.specify_target_ptr)->polarity_op = '+';
		(yyval.specify_target_ptr)->dst = (yyvsp[-3].ast);
		(yyval.specify_target_ptr)->dat = (yyvsp[-1].ast);
	}
#line 5398 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 248: /* specify_edge: TOK_POSEDGE  */
#line 1437 "frontends/verilog/verilog_parser.y"
                    { (yyval.ch) = 'p'; }
#line 5404 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 249: /* specify_edge: TOK_NEGEDGE  */
#line 1438 "frontends/verilog/verilog_parser.y"
                    { (yyval.ch) = 'n'; }
#line 5410 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 250: /* specify_edge: %empty  */
#line 1439 "frontends/verilog/verilog_parser.y"
               { (yyval.ch) = 0; }
#line 5416 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 251: /* specify_rise_fall: specify_triple  */
#line 1442 "frontends/verilog/verilog_parser.y"
                       {
		(yyval.specify_rise_fall_ptr) = new specify_rise_fall;
		(yyval.specify_rise_fall_ptr)->rise = *(yyvsp[0].specify_triple_ptr);
		(yyval.specify_rise_fall_ptr)->fall.t_min = (yyvsp[0].specify_triple_ptr)->t_min->clone();
		(yyval.specify_rise_fall_ptr)->fall.t_avg = (yyvsp[0].specify_triple_ptr)->t_avg->clone();
		(yyval.specify_rise_fall_ptr)->fall.t_max = (yyvsp[0].specify_triple_ptr)->t_max->clone();
		delete (yyvsp[0].specify_triple_ptr);
	}
#line 5429 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 252: /* specify_rise_fall: '(' specify_triple ',' specify_triple ')'  */
#line 1450 "frontends/verilog/verilog_parser.y"
                                                  {
		(yyval.specify_rise_fall_ptr) = new specify_rise_fall;
		(yyval.specify_rise_fall_ptr)->rise = *(yyvsp[-3].specify_triple_ptr);
		(yyval.specify_rise_fall_ptr)->fall = *(yyvsp[-1].specify_triple_ptr);
		delete (yyvsp[-3].specify_triple_ptr);
		delete (yyvsp[-1].specify_triple_ptr);
	}
#line 5441 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 253: /* specify_rise_fall: '(' specify_triple ',' specify_triple ',' specify_triple ')'  */
#line 1457 "frontends/verilog/verilog_parser.y"
                                                                     {
		(yyval.specify_rise_fall_ptr) = new specify_rise_fall;
		(yyval.specify_rise_fall_ptr)->rise = *(yyvsp[-5].specify_triple_ptr);
		(yyval.specify_rise_fall_ptr)->fall = *(yyvsp[-3].specify_triple_ptr);
		delete (yyvsp[-5].specify_triple_ptr);
		delete (yyvsp[-3].specify_triple_ptr);
		delete (yyvsp[-1].specify_triple_ptr);
		log_file_warning(current_filename, get_line_num(), "Path delay expressions beyond rise/fall not currently supported. Ignoring.\n");
	}
#line 5455 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 254: /* specify_rise_fall: '(' specify_triple ',' specify_triple ',' specify_triple ',' specify_triple ',' specify_triple ',' specify_triple ')'  */
#line 1466 "frontends/verilog/verilog_parser.y"
                                                                                                                              {
		(yyval.specify_rise_fall_ptr) = new specify_rise_fall;
		(yyval.specify_rise_fall_ptr)->rise = *(yyvsp[-11].specify_triple_ptr);
		(yyval.specify_rise_fall_ptr)->fall = *(yyvsp[-9].specify_triple_ptr);
		delete (yyvsp[-11].specify_triple_ptr);
		delete (yyvsp[-9].specify_triple_ptr);
		delete (yyvsp[-7].specify_triple_ptr);
		delete (yyvsp[-5].specify_triple_ptr);
		delete (yyvsp[-3].specify_triple_ptr);
		delete (yyvsp[-1].specify_triple_ptr);
		log_file_warning(current_filename, get_line_num(), "Path delay expressions beyond rise/fall not currently supported. Ignoring.\n");
	}
#line 5472 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 255: /* specify_rise_fall: '(' specify_triple ',' specify_triple ',' specify_triple ',' specify_triple ',' specify_triple ',' specify_triple ',' specify_triple ',' specify_triple ',' specify_triple ',' specify_triple ',' specify_triple ',' specify_triple ')'  */
#line 1478 "frontends/verilog/verilog_parser.y"
                                                                                                                                                                                                                                                {
		(yyval.specify_rise_fall_ptr) = new specify_rise_fall;
		(yyval.specify_rise_fall_ptr)->rise = *(yyvsp[-23].specify_triple_ptr);
		(yyval.specify_rise_fall_ptr)->fall = *(yyvsp[-21].specify_triple_ptr);
		delete (yyvsp[-23].specify_triple_ptr);
		delete (yyvsp[-21].specify_triple_ptr);
		delete (yyvsp[-19].specify_triple_ptr);
		delete (yyvsp[-17].specify_triple_ptr);
		delete (yyvsp[-15].specify_triple_ptr);
		delete (yyvsp[-13].specify_triple_ptr);
		delete (yyvsp[-11].specify_triple_ptr);
		delete (yyvsp[-9].specify_triple_ptr);
		delete (yyvsp[-7].specify_triple_ptr);
		delete (yyvsp[-5].specify_triple_ptr);
		delete (yyvsp[-3].specify_triple_ptr);
		delete (yyvsp[-1].specify_triple_ptr);
		log_file_warning(current_filename, get_line_num(), "Path delay expressions beyond rise/fall not currently supported. Ignoring.\n");
	}
#line 5495 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 256: /* specify_triple: expr  */
#line 1498 "frontends/verilog/verilog_parser.y"
             {
		(yyval.specify_triple_ptr) = new specify_triple;
		(yyval.specify_triple_ptr)->t_min = (yyvsp[0].ast);
		(yyval.specify_triple_ptr)->t_avg = (yyvsp[0].ast)->clone();
		(yyval.specify_triple_ptr)->t_max = (yyvsp[0].ast)->clone();
	}
#line 5506 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 257: /* specify_triple: expr ':' expr ':' expr  */
#line 1504 "frontends/verilog/verilog_parser.y"
                               {
		(yyval.specify_triple_ptr) = new specify_triple;
		(yyval.specify_triple_ptr)->t_min = (yyvsp[-4].ast);
		(yyval.specify_triple_ptr)->t_avg = (yyvsp[-2].ast);
		(yyval.specify_triple_ptr)->t_max = (yyvsp[0].ast);
	}
#line 5517 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 307: /* ignspec_constant_expression: expr  */
#line 1625 "frontends/verilog/verilog_parser.y"
             { delete (yyvsp[0].ast); }
#line 5523 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 308: /* ignspec_expr: expr  */
#line 1628 "frontends/verilog/verilog_parser.y"
             { delete (yyvsp[0].ast); }
#line 5529 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 309: /* ignspec_expr: expr ':' expr ':' expr  */
#line 1629 "frontends/verilog/verilog_parser.y"
                               {
		delete (yyvsp[-4].ast);
		delete (yyvsp[-2].ast);
		delete (yyvsp[0].ast);
	}
#line 5539 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 310: /* $@35: %empty  */
#line 1636 "frontends/verilog/verilog_parser.y"
               { delete (yyvsp[0].string); }
#line 5545 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 311: /* ignspec_id: TOK_ID $@35 range_or_multirange  */
#line 1637 "frontends/verilog/verilog_parser.y"
                            { delete (yyvsp[0].ast); }
#line 5551 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 312: /* param_signed: TOK_SIGNED  */
#line 1642 "frontends/verilog/verilog_parser.y"
                   {
		astbuf1->is_signed = true;
	}
#line 5559 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 313: /* param_signed: TOK_UNSIGNED  */
#line 1644 "frontends/verilog/verilog_parser.y"
                         {
		astbuf1->is_signed = false;
	}
#line 5567 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 315: /* param_integer: type_atom  */
#line 1649 "frontends/verilog/verilog_parser.y"
                  {
		astbuf1->is_reg = false;
	}
#line 5575 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 316: /* param_real: TOK_REAL  */
#line 1654 "frontends/verilog/verilog_parser.y"
                 {
		astbuf1->children.push_back(new AstNode(AST_REALVALUE));
	}
#line 5583 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 317: /* param_range: range  */
#line 1659 "frontends/verilog/verilog_parser.y"
              {
		if ((yyvsp[0].ast) != NULL) {
			astbuf1->children.push_back((yyvsp[0].ast));
		}
	}
#line 5593 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 319: /* param_range_type: type_vec param_signed  */
#line 1667 "frontends/verilog/verilog_parser.y"
                              {
		addRange(astbuf1, 0, 0);
	}
#line 5601 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 320: /* param_range_type: type_vec param_signed non_opt_range  */
#line 1670 "frontends/verilog/verilog_parser.y"
                                            {
		astbuf1->children.push_back((yyvsp[0].ast));
	}
#line 5609 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 326: /* param_type: hierarchical_type_id  */
#line 1677 "frontends/verilog/verilog_parser.y"
                             {
		addWiretypeNode((yyvsp[0].string), astbuf1);
	}
#line 5617 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 327: /* $@36: %empty  */
#line 1682 "frontends/verilog/verilog_parser.y"
                           {
		astbuf1 = new AstNode(AST_PARAMETER);
		astbuf1->children.push_back(AstNode::mkconst_int(0, true));
		append_attr(astbuf1, (yyvsp[-1].al));
	}
#line 5627 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 328: /* param_decl: attr TOK_PARAMETER $@36 param_type param_decl_list ';'  */
#line 1686 "frontends/verilog/verilog_parser.y"
                                         {
		delete astbuf1;
	}
#line 5635 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 329: /* $@37: %empty  */
#line 1691 "frontends/verilog/verilog_parser.y"
                            {
		astbuf1 = new AstNode(AST_LOCALPARAM);
		astbuf1->children.push_back(AstNode::mkconst_int(0, true));
		append_attr(astbuf1, (yyvsp[-1].al));
	}
#line 5645 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 330: /* localparam_decl: attr TOK_LOCALPARAM $@37 param_type param_decl_list ';'  */
#line 1695 "frontends/verilog/verilog_parser.y"
                                         {
		delete astbuf1;
	}
#line 5653 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 333: /* single_param_decl: single_param_decl_ident '=' expr  */
#line 1703 "frontends/verilog/verilog_parser.y"
                                         {
		AstNode *decl = ast_stack.back()->children.back();
		log_assert(decl->type == AST_PARAMETER || decl->type == AST_LOCALPARAM);
		delete decl->children[0];
		decl->children[0] = (yyvsp[0].ast);
	}
#line 5664 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 334: /* single_param_decl: single_param_decl_ident  */
#line 1709 "frontends/verilog/verilog_parser.y"
                                {
		AstNode *decl = ast_stack.back()->children.back();
		if (decl->type != AST_PARAMETER) {
			log_assert(decl->type == AST_LOCALPARAM);
			frontend_verilog_yyerror("localparam initialization is missing!");
		}
		if (!sv_mode)
			frontend_verilog_yyerror("Parameter defaults can only be omitted in SystemVerilog mode!");
		delete decl->children[0];
		decl->children.erase(decl->children.begin());
	}
#line 5680 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 335: /* single_param_decl_ident: TOK_ID  */
#line 1722 "frontends/verilog/verilog_parser.y"
               {
		AstNode *node;
		if (astbuf1 == nullptr) {
			if (!sv_mode)
				frontend_verilog_yyerror("In pure Verilog (not SystemVerilog), parameter/localparam with an initializer must use the parameter/localparam keyword");
			node = new AstNode(AST_PARAMETER);
			node->children.push_back(AstNode::mkconst_int(0, true));
		} else {
			node = astbuf1->clone();
		}
		node->str = *(yyvsp[0].string);
		ast_stack.back()->children.push_back(node);
		delete (yyvsp[0].string);
		SET_AST_NODE_LOC(node, (yylsp[0]), (yylsp[0]));
	}
#line 5700 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 339: /* single_defparam_decl: range rvalue '=' expr  */
#line 1745 "frontends/verilog/verilog_parser.y"
                              {
		AstNode *node = new AstNode(AST_DEFPARAM);
		node->children.push_back((yyvsp[-2].ast));
		node->children.push_back((yyvsp[0].ast));
		if ((yyvsp[-3].ast) != NULL)
			node->children.push_back((yyvsp[-3].ast));
		ast_stack.back()->children.push_back(node);
	}
#line 5713 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 340: /* $@38: %empty  */
#line 1758 "frontends/verilog/verilog_parser.y"
                    {
		static int enum_count;
		// create parent node for the enum
		astbuf2 = new AstNode(AST_ENUM);
		ast_stack.back()->children.push_back(astbuf2);
		astbuf2->str = std::string("$enum");
		astbuf2->str += std::to_string(enum_count++);
		// create the template for the names
		astbuf1 = new AstNode(AST_ENUM_ITEM);
		astbuf1->children.push_back(AstNode::mkconst_int(0, true));
	}
#line 5729 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 341: /* enum_type: TOK_ENUM $@38 enum_base_type '{' enum_name_list optional_comma '}'  */
#line 1768 "frontends/verilog/verilog_parser.y"
                                                               {
		// create template for the enum vars
		auto tnode = astbuf1->clone();
		delete astbuf1;
		astbuf1 = tnode;
		tnode->type = AST_WIRE;
		tnode->attributes[ID::enum_type] = AstNode::mkconst_str(astbuf2->str);
		// drop constant but keep any range
		delete tnode->children[0];
		tnode->children.erase(tnode->children.begin());
		(yyval.ast) = astbuf1;
	}
#line 5746 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 343: /* enum_base_type: type_vec type_signing range  */
#line 1782 "frontends/verilog/verilog_parser.y"
                                        { if ((yyvsp[0].ast)) astbuf1->children.push_back((yyvsp[0].ast)); }
#line 5752 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 344: /* enum_base_type: %empty  */
#line 1783 "frontends/verilog/verilog_parser.y"
                                        { astbuf1->is_reg = true; addRange(astbuf1); }
#line 5758 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 345: /* type_atom: integer_atom_type  */
#line 1787 "frontends/verilog/verilog_parser.y"
                          {
		astbuf1->is_reg = true;
		astbuf1->is_signed = true;
		addRange(astbuf1, (yyvsp[0].integer) - 1, 0);
	}
#line 5768 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 346: /* type_vec: TOK_REG  */
#line 1793 "frontends/verilog/verilog_parser.y"
                                { astbuf1->is_reg   = true; }
#line 5774 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 347: /* type_vec: TOK_LOGIC  */
#line 1794 "frontends/verilog/verilog_parser.y"
                                { astbuf1->is_logic = true; }
#line 5780 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 348: /* type_signing: TOK_SIGNED  */
#line 1798 "frontends/verilog/verilog_parser.y"
                                { astbuf1->is_signed = true; }
#line 5786 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 349: /* type_signing: TOK_UNSIGNED  */
#line 1799 "frontends/verilog/verilog_parser.y"
                                { astbuf1->is_signed = false; }
#line 5792 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 353: /* enum_name_decl: TOK_ID opt_enum_init  */
#line 1808 "frontends/verilog/verilog_parser.y"
                             {
		// put in fn
		log_assert(astbuf1);
		log_assert(astbuf2);
		auto node = astbuf1->clone();
		node->str = *(yyvsp[-1].string);
		delete (yyvsp[-1].string);
		SET_AST_NODE_LOC(node, (yylsp[-1]), (yylsp[-1]));
		delete node->children[0];
		node->children[0] = (yyvsp[0].ast) ? (yyvsp[0].ast) : new AstNode(AST_NONE);
		astbuf2->children.push_back(node);
	}
#line 5809 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 354: /* opt_enum_init: '=' basic_expr  */
#line 1823 "frontends/verilog/verilog_parser.y"
                                { (yyval.ast) = (yyvsp[0].ast); }
#line 5815 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 355: /* opt_enum_init: %empty  */
#line 1824 "frontends/verilog/verilog_parser.y"
                                { (yyval.ast) = NULL; }
#line 5821 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 358: /* enum_var: TOK_ID  */
#line 1832 "frontends/verilog/verilog_parser.y"
                 {
		log_assert(astbuf1);
		log_assert(astbuf2);
		auto node = astbuf1->clone();
		ast_stack.back()->children.push_back(node);
		node->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
		SET_AST_NODE_LOC(node, (yylsp[0]), (yylsp[0]));
		node->is_enum = true;
	}
#line 5836 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 359: /* enum_decl: enum_type enum_var_list ';'  */
#line 1844 "frontends/verilog/verilog_parser.y"
                                                { delete (yyvsp[-2].ast); }
#line 5842 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 360: /* $@39: %empty  */
#line 1852 "frontends/verilog/verilog_parser.y"
                         {
		append_attr((yyvsp[0].ast), (yyvsp[-1].al));
	}
#line 5850 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 361: /* struct_decl: attr struct_type $@39 struct_var_list ';'  */
#line 1854 "frontends/verilog/verilog_parser.y"
                              {
		delete astbuf2;
	}
#line 5858 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 362: /* $@40: %empty  */
#line 1859 "frontends/verilog/verilog_parser.y"
                          { astbuf2 = (yyvsp[0].ast); astbuf2->is_custom_type = true; }
#line 5864 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 363: /* struct_type: struct_union $@40 struct_body  */
#line 1859 "frontends/verilog/verilog_parser.y"
                                                                                        { (yyval.ast) = astbuf2; }
#line 5870 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 364: /* struct_union: TOK_STRUCT  */
#line 1863 "frontends/verilog/verilog_parser.y"
                                { (yyval.ast) = new AstNode(AST_STRUCT); }
#line 5876 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 365: /* struct_union: TOK_UNION  */
#line 1864 "frontends/verilog/verilog_parser.y"
                                { (yyval.ast) = new AstNode(AST_UNION); }
#line 5882 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 368: /* opt_packed: %empty  */
#line 1872 "frontends/verilog/verilog_parser.y"
               { frontend_verilog_yyerror("Only PACKED supported at this time"); }
#line 5888 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 369: /* opt_signed_struct: TOK_SIGNED  */
#line 1875 "frontends/verilog/verilog_parser.y"
                                { astbuf2->is_signed = true; }
#line 5894 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 370: /* opt_signed_struct: TOK_UNSIGNED  */
#line 1876 "frontends/verilog/verilog_parser.y"
                                { astbuf2->is_signed = false; }
#line 5900 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 374: /* struct_member: struct_member_type member_name_list ';'  */
#line 1884 "frontends/verilog/verilog_parser.y"
                                                                { delete astbuf1; }
#line 5906 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 377: /* $@41: %empty  */
#line 1892 "frontends/verilog/verilog_parser.y"
                    {
			astbuf1->str = (yyvsp[0].string)->substr(1);
			delete (yyvsp[0].string);
			astbuf3 = astbuf1->clone();
			SET_AST_NODE_LOC(astbuf3, (yylsp[0]), (yylsp[0]));
			astbuf2->children.push_back(astbuf3);
		}
#line 5918 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 378: /* member_name: TOK_ID $@41 range  */
#line 1898 "frontends/verilog/verilog_parser.y"
                        { if ((yyvsp[0].ast)) astbuf3->children.push_back((yyvsp[0].ast)); }
#line 5924 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 379: /* $@42: %empty  */
#line 1901 "frontends/verilog/verilog_parser.y"
                    { astbuf1 = new AstNode(AST_STRUCT_ITEM); }
#line 5930 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 381: /* member_type_token: member_type range_or_multirange  */
#line 1905 "frontends/verilog/verilog_parser.y"
                                        {
		AstNode *range = checkRange(astbuf1, (yyvsp[0].ast));
		if (range)
			astbuf1->children.push_back(range);
	}
#line 5940 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 382: /* $@43: %empty  */
#line 1910 "frontends/verilog/verilog_parser.y"
          {
		delete astbuf1;
	}
#line 5948 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 383: /* $@44: %empty  */
#line 1912 "frontends/verilog/verilog_parser.y"
                       {
			// stash state on ast_stack
			ast_stack.push_back(astbuf2);
			astbuf2 = (yyvsp[0].ast);
		}
#line 5958 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 384: /* member_type_token: $@43 struct_union $@44 struct_body  */
#line 1916 "frontends/verilog/verilog_parser.y"
                               {
		        astbuf1 = astbuf2;
			// recover state
			astbuf2 = ast_stack.back();
			ast_stack.pop_back();
		}
#line 5969 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 387: /* member_type: hierarchical_type_id  */
#line 1926 "frontends/verilog/verilog_parser.y"
                               { addWiretypeNode((yyvsp[0].string), astbuf1); }
#line 5975 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 390: /* struct_var: TOK_ID  */
#line 1933 "frontends/verilog/verilog_parser.y"
                        {	auto *var_node = astbuf2->clone();
				var_node->str = *(yyvsp[0].string);
				delete (yyvsp[0].string);
				SET_AST_NODE_LOC(var_node, (yylsp[0]), (yylsp[0]));
				ast_stack.back()->children.push_back(var_node);
			}
#line 5986 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 391: /* $@45: %empty  */
#line 1946 "frontends/verilog/verilog_parser.y"
                                           {
		albuf = (yyvsp[-2].al);
		astbuf1 = (yyvsp[-1].ast);
		astbuf2 = checkRange(astbuf1, (yyvsp[0].ast));
	}
#line 5996 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 392: /* $@46: %empty  */
#line 1950 "frontends/verilog/verilog_parser.y"
                               {
		delete astbuf1;
		if (astbuf2 != NULL)
			delete astbuf2;
		free_attr(albuf);
	}
#line 6007 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 394: /* $@47: %empty  */
#line 1956 "frontends/verilog/verilog_parser.y"
                                {
		ast_stack.back()->children.push_back(new AstNode(AST_WIRE));
		ast_stack.back()->children.back()->str = *(yyvsp[0].string);
		append_attr(ast_stack.back()->children.back(), (yyvsp[-2].al));
		ast_stack.back()->children.push_back(new AstNode(AST_ASSIGN, new AstNode(AST_IDENTIFIER), AstNode::mkconst_int(0, false, 1)));
		ast_stack.back()->children.back()->children[0]->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
	}
#line 6020 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 396: /* $@48: %empty  */
#line 1964 "frontends/verilog/verilog_parser.y"
                                {
		ast_stack.back()->children.push_back(new AstNode(AST_WIRE));
		ast_stack.back()->children.back()->str = *(yyvsp[0].string);
		append_attr(ast_stack.back()->children.back(), (yyvsp[-2].al));
		ast_stack.back()->children.push_back(new AstNode(AST_ASSIGN, new AstNode(AST_IDENTIFIER), AstNode::mkconst_int(1, false, 1)));
		ast_stack.back()->children.back()->children[0]->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
	}
#line 6033 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 399: /* opt_supply_wires: opt_supply_wires ',' TOK_ID  */
#line 1975 "frontends/verilog/verilog_parser.y"
                                    {
		AstNode *wire_node = ast_stack.back()->children.at(GetSize(ast_stack.back()->children)-2)->clone();
		AstNode *assign_node = ast_stack.back()->children.at(GetSize(ast_stack.back()->children)-1)->clone();
		wire_node->str = *(yyvsp[0].string);
		assign_node->children[0]->str = *(yyvsp[0].string);
		ast_stack.back()->children.push_back(wire_node);
		ast_stack.back()->children.push_back(assign_node);
		delete (yyvsp[0].string);
	}
#line 6047 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 402: /* wire_name_and_opt_assign: wire_name  */
#line 1989 "frontends/verilog/verilog_parser.y"
                  {
		bool attr_anyconst = false;
		bool attr_anyseq = false;
		bool attr_allconst = false;
		bool attr_allseq = false;
		if (ast_stack.back()->children.back()->get_bool_attribute(ID::anyconst)) {
			delete ast_stack.back()->children.back()->attributes.at(ID::anyconst);
			ast_stack.back()->children.back()->attributes.erase(ID::anyconst);
			attr_anyconst = true;
		}
		if (ast_stack.back()->children.back()->get_bool_attribute(ID::anyseq)) {
			delete ast_stack.back()->children.back()->attributes.at(ID::anyseq);
			ast_stack.back()->children.back()->attributes.erase(ID::anyseq);
			attr_anyseq = true;
		}
		if (ast_stack.back()->children.back()->get_bool_attribute(ID::allconst)) {
			delete ast_stack.back()->children.back()->attributes.at(ID::allconst);
			ast_stack.back()->children.back()->attributes.erase(ID::allconst);
			attr_allconst = true;
		}
		if (ast_stack.back()->children.back()->get_bool_attribute(ID::allseq)) {
			delete ast_stack.back()->children.back()->attributes.at(ID::allseq);
			ast_stack.back()->children.back()->attributes.erase(ID::allseq);
			attr_allseq = true;
		}
		if (current_wire_rand || attr_anyconst || attr_anyseq || attr_allconst || attr_allseq) {
			AstNode *wire = new AstNode(AST_IDENTIFIER);
			AstNode *fcall = new AstNode(AST_FCALL);
			wire->str = ast_stack.back()->children.back()->str;
			fcall->str = current_wire_const ? "\\$anyconst" : "\\$anyseq";
			if (attr_anyconst)
				fcall->str = "\\$anyconst";
			if (attr_anyseq)
				fcall->str = "\\$anyseq";
			if (attr_allconst)
				fcall->str = "\\$allconst";
			if (attr_allseq)
				fcall->str = "\\$allseq";
			fcall->attributes[ID::reg] = AstNode::mkconst_str(RTLIL::unescape_id(wire->str));
			ast_stack.back()->children.push_back(new AstNode(AST_ASSIGN, wire, fcall));
		}
	}
#line 6094 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 403: /* wire_name_and_opt_assign: wire_name '=' expr  */
#line 2031 "frontends/verilog/verilog_parser.y"
                           {
		AstNode *wire = new AstNode(AST_IDENTIFIER);
		wire->str = ast_stack.back()->children.back()->str;
		if (astbuf1->is_input) {
			if (astbuf1->attributes.count(ID::defaultvalue))
				delete astbuf1->attributes.at(ID::defaultvalue);
			astbuf1->attributes[ID::defaultvalue] = (yyvsp[0].ast);
		}
		else if (astbuf1->is_reg || astbuf1->is_logic){
			AstNode *assign = new AstNode(AST_ASSIGN_LE, wire, (yyvsp[0].ast));
			AstNode *block = new AstNode(AST_BLOCK, assign);
			AstNode *init = new AstNode(AST_INITIAL, block);

			SET_AST_NODE_LOC(assign, (yylsp[-2]), (yylsp[0]));
			SET_AST_NODE_LOC(block, (yylsp[-2]), (yylsp[0]));
			SET_AST_NODE_LOC(init, (yylsp[-2]), (yylsp[0]));

			ast_stack.back()->children.push_back(init);
		}
		else {
			AstNode *assign = new AstNode(AST_ASSIGN, wire, (yyvsp[0].ast));
			SET_AST_NODE_LOC(assign, (yylsp[-2]), (yylsp[0]));
			ast_stack.back()->children.push_back(assign);
		}

	}
#line 6125 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 404: /* wire_name: TOK_ID range_or_multirange  */
#line 2059 "frontends/verilog/verilog_parser.y"
                                   {
		if (astbuf1 == nullptr)
			frontend_verilog_yyerror("Internal error - should not happen - no AST_WIRE node.");
		AstNode *node = astbuf1->clone();
		node->str = *(yyvsp[-1].string);
		append_attr_clone(node, albuf);
		if (astbuf2 != NULL)
			node->children.push_back(astbuf2->clone());
		if ((yyvsp[0].ast) != NULL) {
			if (node->is_input || node->is_output)
				frontend_verilog_yyerror("input/output/inout ports cannot have unpacked dimensions.");
			if (!astbuf2 && !node->is_custom_type) {
				addRange(node, 0, 0, false);
			}
			rewriteAsMemoryNode(node, (yyvsp[0].ast));
		}
		if (current_function_or_task) {
			if (node->is_input || node->is_output)
				node->port_id = current_function_or_task_port_id++;
		} else if (ast_stack.back()->type == AST_GENBLOCK) {
			if (node->is_input || node->is_output)
				frontend_verilog_yyerror("Cannot declare module port `%s' within a generate block.", (yyvsp[-1].string)->c_str());
		} else {
			if (do_not_require_port_stubs && (node->is_input || node->is_output) && port_stubs.count(*(yyvsp[-1].string)) == 0) {
				port_stubs[*(yyvsp[-1].string)] = ++port_counter;
			}
			if (port_stubs.count(*(yyvsp[-1].string)) != 0) {
				if (!node->is_input && !node->is_output)
					frontend_verilog_yyerror("Module port `%s' is neither input nor output.", (yyvsp[-1].string)->c_str());
				if (node->is_reg && node->is_input && !node->is_output && !sv_mode)
					frontend_verilog_yyerror("Input port `%s' is declared as register.", (yyvsp[-1].string)->c_str());
				node->port_id = port_stubs[*(yyvsp[-1].string)];
				port_stubs.erase(*(yyvsp[-1].string));
			} else {
				if (node->is_input || node->is_output)
					frontend_verilog_yyerror("Module port `%s' is not declared in module header.", (yyvsp[-1].string)->c_str());
			}
		}
		//FIXME: for some reason, TOK_ID has a location which always points to one column *after* the real last column...
		SET_AST_NODE_LOC(node, (yylsp[-1]), (yylsp[-1]));
		ast_stack.back()->children.push_back(node);

		delete (yyvsp[-1].string);
	}
#line 6174 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 408: /* assign_expr: lvalue '=' expr  */
#line 2111 "frontends/verilog/verilog_parser.y"
                        {
		AstNode *node = new AstNode(AST_ASSIGN, (yyvsp[-2].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC(node, (yyloc), (yyloc));
		ast_stack.back()->children.push_back(node);
	}
#line 6184 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 410: /* type_name: TOK_USER_TYPE  */
#line 2118 "frontends/verilog/verilog_parser.y"
                                { if (isInLocalScope((yyvsp[0].string))) frontend_verilog_yyerror("Duplicate declaration of TYPEDEF '%s'", (yyvsp[0].string)->c_str()+1); }
#line 6190 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 411: /* typedef_decl: TOK_TYPEDEF typedef_base_type range_or_multirange type_name range_or_multirange ';'  */
#line 2122 "frontends/verilog/verilog_parser.y"
                                                                                            {
		astbuf1 = (yyvsp[-4].ast);
		astbuf2 = checkRange(astbuf1, (yyvsp[-3].ast));
		if (astbuf2)
			astbuf1->children.push_back(astbuf2);

		if ((yyvsp[-1].ast) != NULL) {
			if (!astbuf2 && !astbuf1->is_custom_type) {
				addRange(astbuf1, 0, 0, false);
			}
			rewriteAsMemoryNode(astbuf1, (yyvsp[-1].ast));
		}
		addTypedefNode((yyvsp[-2].string), astbuf1); }
#line 6208 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 412: /* typedef_decl: TOK_TYPEDEF enum_struct_type type_name ';'  */
#line 2135 "frontends/verilog/verilog_parser.y"
                                                       { addTypedefNode((yyvsp[-1].string), (yyvsp[-2].ast)); }
#line 6214 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 413: /* typedef_base_type: hierarchical_type_id  */
#line 2139 "frontends/verilog/verilog_parser.y"
                             {
		(yyval.ast) = new AstNode(AST_WIRE);
		(yyval.ast)->is_logic = true;
		addWiretypeNode((yyvsp[0].string), (yyval.ast));
	}
#line 6224 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 414: /* typedef_base_type: integer_vector_type opt_signedness_default_unsigned  */
#line 2144 "frontends/verilog/verilog_parser.y"
                                                            {
		(yyval.ast) = new AstNode(AST_WIRE);
		if ((yyvsp[-1].integer) == TOK_REG) {
			(yyval.ast)->is_reg = true;
		} else {
			(yyval.ast)->is_logic = true;
		}
		(yyval.ast)->is_signed = (yyvsp[0].boolean);
	}
#line 6238 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 415: /* typedef_base_type: integer_atom_type opt_signedness_default_signed  */
#line 2153 "frontends/verilog/verilog_parser.y"
                                                        {
		(yyval.ast) = new AstNode(AST_WIRE);
		(yyval.ast)->is_logic = true;
		(yyval.ast)->is_signed = (yyvsp[0].boolean);
		(yyval.ast)->range_left = (yyvsp[-1].integer) - 1;
		(yyval.ast)->range_right = 0;
	}
#line 6250 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 418: /* $@49: %empty  */
#line 2167 "frontends/verilog/verilog_parser.y"
                    {
		astbuf1 = new AstNode(AST_CELL);
		append_attr(astbuf1, (yyvsp[-1].al));
		astbuf1->children.push_back(new AstNode(AST_CELLTYPE));
		astbuf1->children[0]->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
	}
#line 6262 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 419: /* cell_stmt: attr TOK_ID $@49 cell_parameter_list_opt cell_list ';'  */
#line 2173 "frontends/verilog/verilog_parser.y"
                                                {
		delete astbuf1;
	}
#line 6270 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 420: /* $@50: %empty  */
#line 2176 "frontends/verilog/verilog_parser.y"
                                    {
		astbuf1 = new AstNode(AST_PRIMITIVE);
		astbuf1->str = *(yyvsp[-1].string);
		append_attr(astbuf1, (yyvsp[-2].al));
		delete (yyvsp[-1].string);
	}
#line 6281 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 421: /* cell_stmt: attr tok_prim_wrapper delay $@50 prim_list ';'  */
#line 2181 "frontends/verilog/verilog_parser.y"
                        {
		delete astbuf1;
	}
#line 6289 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 422: /* tok_prim_wrapper: TOK_PRIMITIVE  */
#line 2186 "frontends/verilog/verilog_parser.y"
                      {
		(yyval.string) = (yyvsp[0].string);
	}
#line 6297 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 423: /* tok_prim_wrapper: TOK_OR  */
#line 2189 "frontends/verilog/verilog_parser.y"
               {
		(yyval.string) = new std::string("or");
	}
#line 6305 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 428: /* $@51: %empty  */
#line 2201 "frontends/verilog/verilog_parser.y"
               {
		astbuf2 = astbuf1->clone();
		if (astbuf2->type != AST_PRIMITIVE)
			astbuf2->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
		ast_stack.back()->children.push_back(astbuf2);
	}
#line 6317 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 429: /* single_cell_no_array: TOK_ID $@51 '(' cell_port_list ')'  */
#line 2207 "frontends/verilog/verilog_parser.y"
                                 {
		SET_AST_NODE_LOC(astbuf2, (yylsp[-4]), (yyloc));
	}
#line 6325 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 430: /* $@52: %empty  */
#line 2212 "frontends/verilog/verilog_parser.y"
                             {
		astbuf2 = astbuf1->clone();
		if (astbuf2->type != AST_PRIMITIVE)
			astbuf2->str = *(yyvsp[-1].string);
		delete (yyvsp[-1].string);
		ast_stack.back()->children.push_back(new AstNode(AST_CELLARRAY, (yyvsp[0].ast), astbuf2));
	}
#line 6337 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 431: /* single_cell_arraylist: TOK_ID non_opt_range $@52 '(' cell_port_list ')'  */
#line 2218 "frontends/verilog/verilog_parser.y"
                                {
		SET_AST_NODE_LOC(astbuf2, (yylsp[-5]), (yyloc));
	}
#line 6345 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 437: /* $@53: %empty  */
#line 2232 "frontends/verilog/verilog_parser.y"
                      {
		astbuf2 = astbuf1->clone();
		ast_stack.back()->children.push_back(astbuf2);
	}
#line 6354 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 438: /* single_prim: $@53 '(' cell_port_list ')'  */
#line 2235 "frontends/verilog/verilog_parser.y"
                                 {
		SET_AST_NODE_LOC(astbuf2, (yylsp[-3]), (yyloc));
	}
#line 6362 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 444: /* cell_parameter: expr  */
#line 2247 "frontends/verilog/verilog_parser.y"
             {
		AstNode *node = new AstNode(AST_PARASET);
		astbuf1->children.push_back(node);
		node->children.push_back((yyvsp[0].ast));
	}
#line 6372 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 445: /* cell_parameter: '.' TOK_ID '(' ')'  */
#line 2252 "frontends/verilog/verilog_parser.y"
                           {
		// delete unused TOK_ID
		delete (yyvsp[-2].string);
	}
#line 6381 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 446: /* cell_parameter: '.' TOK_ID '(' expr ')'  */
#line 2256 "frontends/verilog/verilog_parser.y"
                                {
		AstNode *node = new AstNode(AST_PARASET);
		node->str = *(yyvsp[-3].string);
		astbuf1->children.push_back(node);
		node->children.push_back((yyvsp[-1].ast));
		delete (yyvsp[-3].string);
	}
#line 6393 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 447: /* cell_port_list: cell_port_list_rules  */
#line 2265 "frontends/verilog/verilog_parser.y"
                             {
		// remove empty args from end of list
		while (!astbuf2->children.empty()) {
			AstNode *node = astbuf2->children.back();
			if (node->type != AST_ARGUMENT) break;
			if (!node->children.empty()) break;
			if (!node->str.empty()) break;
			astbuf2->children.pop_back();
			delete node;
		}

		// check port types
		bool has_positional_args = false;
		bool has_named_args = false;
		for (auto node : astbuf2->children) {
			if (node->type != AST_ARGUMENT) continue;
			if (node->str.empty())
				has_positional_args = true;
			else
				has_named_args = true;
		}

		if (has_positional_args && has_named_args)
			frontend_verilog_yyerror("Mix of positional and named cell ports.");
	}
#line 6423 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 450: /* cell_port: attr  */
#line 2295 "frontends/verilog/verilog_parser.y"
             {
		AstNode *node = new AstNode(AST_ARGUMENT);
		astbuf2->children.push_back(node);
		free_attr((yyvsp[0].al));
	}
#line 6433 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 451: /* cell_port: attr expr  */
#line 2300 "frontends/verilog/verilog_parser.y"
                  {
		AstNode *node = new AstNode(AST_ARGUMENT);
		astbuf2->children.push_back(node);
		node->children.push_back((yyvsp[0].ast));
		free_attr((yyvsp[-1].al));
	}
#line 6444 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 452: /* cell_port: attr '.' TOK_ID '(' expr ')'  */
#line 2306 "frontends/verilog/verilog_parser.y"
                                     {
		AstNode *node = new AstNode(AST_ARGUMENT);
		node->str = *(yyvsp[-3].string);
		astbuf2->children.push_back(node);
		node->children.push_back((yyvsp[-1].ast));
		delete (yyvsp[-3].string);
		free_attr((yyvsp[-5].al));
	}
#line 6457 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 453: /* cell_port: attr '.' TOK_ID '(' ')'  */
#line 2314 "frontends/verilog/verilog_parser.y"
                                {
		AstNode *node = new AstNode(AST_ARGUMENT);
		node->str = *(yyvsp[-2].string);
		astbuf2->children.push_back(node);
		delete (yyvsp[-2].string);
		free_attr((yyvsp[-4].al));
	}
#line 6469 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 454: /* cell_port: attr '.' TOK_ID  */
#line 2321 "frontends/verilog/verilog_parser.y"
                        {
		AstNode *node = new AstNode(AST_ARGUMENT);
		node->str = *(yyvsp[0].string);
		astbuf2->children.push_back(node);
		node->children.push_back(new AstNode(AST_IDENTIFIER));
		node->children.back()->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
		free_attr((yyvsp[-2].al));
	}
#line 6483 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 455: /* cell_port: attr TOK_WILDCARD_CONNECT  */
#line 2330 "frontends/verilog/verilog_parser.y"
                                  {
		if (!sv_mode)
			frontend_verilog_yyerror("Wildcard port connections are only supported in SystemVerilog mode.");
		astbuf2->attributes[ID::wildcard_port_conns] = AstNode::mkconst_int(1, false);
		free_attr((yyvsp[-1].al));
	}
#line 6494 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 456: /* always_comb_or_latch: TOK_ALWAYS_COMB  */
#line 2338 "frontends/verilog/verilog_parser.y"
                        {
		(yyval.boolean) = false;
	}
#line 6502 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 457: /* always_comb_or_latch: TOK_ALWAYS_LATCH  */
#line 2341 "frontends/verilog/verilog_parser.y"
                         {
		(yyval.boolean) = true;
	}
#line 6510 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 458: /* always_or_always_ff: TOK_ALWAYS  */
#line 2346 "frontends/verilog/verilog_parser.y"
                   {
		(yyval.boolean) = false;
	}
#line 6518 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 459: /* always_or_always_ff: TOK_ALWAYS_FF  */
#line 2349 "frontends/verilog/verilog_parser.y"
                      {
		(yyval.boolean) = true;
	}
#line 6526 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 460: /* $@54: %empty  */
#line 2354 "frontends/verilog/verilog_parser.y"
                                 {
		AstNode *node = new AstNode(AST_ALWAYS);
		append_attr(node, (yyvsp[-1].al));
		if ((yyvsp[0].boolean))
			node->attributes[ID::always_ff] = AstNode::mkconst_int(1, false);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
	}
#line 6539 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 461: /* $@55: %empty  */
#line 2361 "frontends/verilog/verilog_parser.y"
                      {
		AstNode *block = new AstNode(AST_BLOCK);
		ast_stack.back()->children.push_back(block);
		ast_stack.push_back(block);
	}
#line 6549 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 462: /* always_stmt: attr always_or_always_ff $@54 always_cond $@55 behavioral_stmt  */
#line 2365 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[0]), (yylsp[0]));
		ast_stack.pop_back();

		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-4]), (yyloc));
		ast_stack.pop_back();

		SET_RULE_LOC((yyloc), (yylsp[-4]), (yyloc));
	}
#line 6563 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 463: /* $@56: %empty  */
#line 2374 "frontends/verilog/verilog_parser.y"
                                  {
		AstNode *node = new AstNode(AST_ALWAYS);
		append_attr(node, (yyvsp[-1].al));
		if ((yyvsp[0].boolean))
			node->attributes[ID::always_latch] = AstNode::mkconst_int(1, false);
		else
			node->attributes[ID::always_comb] = AstNode::mkconst_int(1, false);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
		AstNode *block = new AstNode(AST_BLOCK);
		ast_stack.back()->children.push_back(block);
		ast_stack.push_back(block);
	}
#line 6581 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 464: /* always_stmt: attr always_comb_or_latch $@56 behavioral_stmt  */
#line 2386 "frontends/verilog/verilog_parser.y"
                          {
		ast_stack.pop_back();
		ast_stack.pop_back();
	}
#line 6590 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 465: /* $@57: %empty  */
#line 2390 "frontends/verilog/verilog_parser.y"
                         {
		AstNode *node = new AstNode(AST_INITIAL);
		append_attr(node, (yyvsp[-1].al));
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
		AstNode *block = new AstNode(AST_BLOCK);
		ast_stack.back()->children.push_back(block);
		ast_stack.push_back(block);
	}
#line 6604 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 466: /* always_stmt: attr TOK_INITIAL $@57 behavioral_stmt  */
#line 2398 "frontends/verilog/verilog_parser.y"
                          {
		ast_stack.pop_back();
		ast_stack.pop_back();
	}
#line 6613 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 476: /* always_event: TOK_POSEDGE expr  */
#line 2417 "frontends/verilog/verilog_parser.y"
                         {
		AstNode *node = new AstNode(AST_POSEDGE);
		SET_AST_NODE_LOC(node, (yylsp[-1]), (yylsp[-1]));
		ast_stack.back()->children.push_back(node);
		node->children.push_back((yyvsp[0].ast));
	}
#line 6624 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 477: /* always_event: TOK_NEGEDGE expr  */
#line 2423 "frontends/verilog/verilog_parser.y"
                         {
		AstNode *node = new AstNode(AST_NEGEDGE);
		SET_AST_NODE_LOC(node, (yylsp[-1]), (yylsp[-1]));
		ast_stack.back()->children.push_back(node);
		node->children.push_back((yyvsp[0].ast));
	}
#line 6635 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 478: /* always_event: expr  */
#line 2429 "frontends/verilog/verilog_parser.y"
             {
		AstNode *node = new AstNode(AST_EDGE);
		ast_stack.back()->children.push_back(node);
		node->children.push_back((yyvsp[0].ast));
	}
#line 6645 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 479: /* opt_label: ':' TOK_ID  */
#line 2436 "frontends/verilog/verilog_parser.y"
                   {
		(yyval.string) = (yyvsp[0].string);
	}
#line 6653 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 480: /* opt_label: %empty  */
#line 2439 "frontends/verilog/verilog_parser.y"
               {
		(yyval.string) = NULL;
	}
#line 6661 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 481: /* opt_sva_label: TOK_SVA_LABEL ':'  */
#line 2444 "frontends/verilog/verilog_parser.y"
                          {
		(yyval.string) = (yyvsp[-1].string);
	}
#line 6669 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 482: /* opt_sva_label: %empty  */
#line 2447 "frontends/verilog/verilog_parser.y"
               {
		(yyval.string) = NULL;
	}
#line 6677 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 483: /* opt_property: TOK_PROPERTY  */
#line 2452 "frontends/verilog/verilog_parser.y"
                     {
		(yyval.boolean) = true;
	}
#line 6685 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 484: /* opt_property: TOK_FINAL  */
#line 2455 "frontends/verilog/verilog_parser.y"
                  {
		(yyval.boolean) = false;
	}
#line 6693 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 485: /* opt_property: %empty  */
#line 2458 "frontends/verilog/verilog_parser.y"
               {
		(yyval.boolean) = false;
	}
#line 6701 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 486: /* $@58: %empty  */
#line 2463 "frontends/verilog/verilog_parser.y"
                       {
        AstNode *modport = new AstNode(AST_MODPORT);
        ast_stack.back()->children.push_back(modport);
        ast_stack.push_back(modport);
        modport->str = *(yyvsp[0].string);
        delete (yyvsp[0].string);
    }
#line 6713 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 487: /* $@59: %empty  */
#line 2469 "frontends/verilog/verilog_parser.y"
                        {
        ast_stack.pop_back();
        log_assert(ast_stack.size() == 2);
    }
#line 6722 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 495: /* modport_member: TOK_ID  */
#line 2485 "frontends/verilog/verilog_parser.y"
           {
        AstNode *modport_member = new AstNode(AST_MODPORTMEMBER);
        ast_stack.back()->children.push_back(modport_member);
        modport_member->str = *(yyvsp[0].string);
        modport_member->is_input = current_modport_input;
        modport_member->is_output = current_modport_output;
        delete (yyvsp[0].string);
    }
#line 6735 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 496: /* modport_type_token: TOK_INPUT  */
#line 2495 "frontends/verilog/verilog_parser.y"
              {current_modport_input = 1; current_modport_output = 0;}
#line 6741 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 497: /* modport_type_token: TOK_OUTPUT  */
#line 2495 "frontends/verilog/verilog_parser.y"
                                                                                    {current_modport_input = 0; current_modport_output = 1;}
#line 6747 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 498: /* assert: opt_sva_label TOK_ASSERT opt_property '(' expr ')' ';'  */
#line 2498 "frontends/verilog/verilog_parser.y"
                                                               {
		if (noassert_mode) {
			delete (yyvsp[-2].ast);
		} else {
			AstNode *node = new AstNode(assume_asserts_mode ? AST_ASSUME : AST_ASSERT, (yyvsp[-2].ast));
			SET_AST_NODE_LOC(node, ((yyvsp[-6].string) != nullptr ? (yylsp[-6]) : (yylsp[-5])), (yylsp[-1]));
			if ((yyvsp[-6].string) != nullptr)
				node->str = *(yyvsp[-6].string);
			ast_stack.back()->children.push_back(node);
		}
		if ((yyvsp[-6].string) != nullptr)
			delete (yyvsp[-6].string);
	}
#line 6765 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 499: /* assert: opt_sva_label TOK_ASSUME opt_property '(' expr ')' ';'  */
#line 2511 "frontends/verilog/verilog_parser.y"
                                                               {
		if (noassume_mode) {
			delete (yyvsp[-2].ast);
		} else {
			AstNode *node = new AstNode(assert_assumes_mode ? AST_ASSERT : AST_ASSUME, (yyvsp[-2].ast));
			SET_AST_NODE_LOC(node, ((yyvsp[-6].string) != nullptr ? (yylsp[-6]) : (yylsp[-5])), (yylsp[-1]));
			if ((yyvsp[-6].string) != nullptr)
				node->str = *(yyvsp[-6].string);
			ast_stack.back()->children.push_back(node);
		}
		if ((yyvsp[-6].string) != nullptr)
			delete (yyvsp[-6].string);
	}
#line 6783 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 500: /* assert: opt_sva_label TOK_ASSERT opt_property '(' TOK_EVENTUALLY expr ')' ';'  */
#line 2524 "frontends/verilog/verilog_parser.y"
                                                                              {
		if (noassert_mode) {
			delete (yyvsp[-2].ast);
		} else {
			AstNode *node = new AstNode(assume_asserts_mode ? AST_FAIR : AST_LIVE, (yyvsp[-2].ast));
			SET_AST_NODE_LOC(node, ((yyvsp[-7].string) != nullptr ? (yylsp[-7]) : (yylsp[-6])), (yylsp[-1]));
			if ((yyvsp[-7].string) != nullptr)
				node->str = *(yyvsp[-7].string);
			ast_stack.back()->children.push_back(node);
		}
		if ((yyvsp[-7].string) != nullptr)
			delete (yyvsp[-7].string);
	}
#line 6801 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 501: /* assert: opt_sva_label TOK_ASSUME opt_property '(' TOK_EVENTUALLY expr ')' ';'  */
#line 2537 "frontends/verilog/verilog_parser.y"
                                                                              {
		if (noassume_mode) {
			delete (yyvsp[-2].ast);
		} else {
			AstNode *node = new AstNode(assert_assumes_mode ? AST_LIVE : AST_FAIR, (yyvsp[-2].ast));
			SET_AST_NODE_LOC(node, ((yyvsp[-7].string) != nullptr ? (yylsp[-7]) : (yylsp[-6])), (yylsp[-1]));
			if ((yyvsp[-7].string) != nullptr)
				node->str = *(yyvsp[-7].string);
			ast_stack.back()->children.push_back(node);
		}
		if ((yyvsp[-7].string) != nullptr)
			delete (yyvsp[-7].string);
	}
#line 6819 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 502: /* assert: opt_sva_label TOK_COVER opt_property '(' expr ')' ';'  */
#line 2550 "frontends/verilog/verilog_parser.y"
                                                              {
		AstNode *node = new AstNode(AST_COVER, (yyvsp[-2].ast));
		SET_AST_NODE_LOC(node, ((yyvsp[-6].string) != nullptr ? (yylsp[-6]) : (yylsp[-5])), (yylsp[-1]));
		if ((yyvsp[-6].string) != nullptr) {
			node->str = *(yyvsp[-6].string);
			delete (yyvsp[-6].string);
		}
		ast_stack.back()->children.push_back(node);
	}
#line 6833 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 503: /* assert: opt_sva_label TOK_COVER opt_property '(' ')' ';'  */
#line 2559 "frontends/verilog/verilog_parser.y"
                                                         {
		AstNode *node = new AstNode(AST_COVER, AstNode::mkconst_int(1, false));
		SET_AST_NODE_LOC(node, ((yyvsp[-5].string) != nullptr ? (yylsp[-5]) : (yylsp[-4])), (yylsp[-1]));
		if ((yyvsp[-5].string) != nullptr) {
			node->str = *(yyvsp[-5].string);
			delete (yyvsp[-5].string);
		}
		ast_stack.back()->children.push_back(node);
	}
#line 6847 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 504: /* assert: opt_sva_label TOK_COVER ';'  */
#line 2568 "frontends/verilog/verilog_parser.y"
                                    {
		AstNode *node = new AstNode(AST_COVER, AstNode::mkconst_int(1, false));
		SET_AST_NODE_LOC(node, ((yyvsp[-2].string) != nullptr ? (yylsp[-2]) : (yylsp[-1])), (yylsp[-1]));
		if ((yyvsp[-2].string) != nullptr) {
			node->str = *(yyvsp[-2].string);
			delete (yyvsp[-2].string);
		}
		ast_stack.back()->children.push_back(node);
	}
#line 6861 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 505: /* assert: opt_sva_label TOK_RESTRICT opt_property '(' expr ')' ';'  */
#line 2577 "frontends/verilog/verilog_parser.y"
                                                                 {
		if (norestrict_mode) {
			delete (yyvsp[-2].ast);
		} else {
			AstNode *node = new AstNode(AST_ASSUME, (yyvsp[-2].ast));
			SET_AST_NODE_LOC(node, ((yyvsp[-6].string) != nullptr ? (yylsp[-6]) : (yylsp[-5])), (yylsp[-1]));
			if ((yyvsp[-6].string) != nullptr)
				node->str = *(yyvsp[-6].string);
			ast_stack.back()->children.push_back(node);
		}
		if (!(yyvsp[-4].boolean))
			log_file_warning(current_filename, get_line_num(), "SystemVerilog does not allow \"restrict\" without \"property\".\n");
		if ((yyvsp[-6].string) != nullptr)
			delete (yyvsp[-6].string);
	}
#line 6881 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 506: /* assert: opt_sva_label TOK_RESTRICT opt_property '(' TOK_EVENTUALLY expr ')' ';'  */
#line 2592 "frontends/verilog/verilog_parser.y"
                                                                                {
		if (norestrict_mode) {
			delete (yyvsp[-2].ast);
		} else {
			AstNode *node = new AstNode(AST_FAIR, (yyvsp[-2].ast));
			SET_AST_NODE_LOC(node, ((yyvsp[-7].string) != nullptr ? (yylsp[-7]) : (yylsp[-6])), (yylsp[-1]));
			if ((yyvsp[-7].string) != nullptr)
				node->str = *(yyvsp[-7].string);
			ast_stack.back()->children.push_back(node);
		}
		if (!(yyvsp[-5].boolean))
			log_file_warning(current_filename, get_line_num(), "SystemVerilog does not allow \"restrict\" without \"property\".\n");
		if ((yyvsp[-7].string) != nullptr)
			delete (yyvsp[-7].string);
	}
#line 6901 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 507: /* assert_property: opt_sva_label TOK_ASSERT TOK_PROPERTY '(' expr ')' ';'  */
#line 2609 "frontends/verilog/verilog_parser.y"
                                                               {
		AstNode *node = new AstNode(assume_asserts_mode ? AST_ASSUME : AST_ASSERT, (yyvsp[-2].ast));
		SET_AST_NODE_LOC(node, (yylsp[-6]), (yylsp[-1]));
		ast_stack.back()->children.push_back(node);
		if ((yyvsp[-6].string) != nullptr) {
			ast_stack.back()->children.back()->str = *(yyvsp[-6].string);
			delete (yyvsp[-6].string);
		}
	}
#line 6915 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 508: /* assert_property: opt_sva_label TOK_ASSUME TOK_PROPERTY '(' expr ')' ';'  */
#line 2618 "frontends/verilog/verilog_parser.y"
                                                               {
		AstNode *node = new AstNode(AST_ASSUME, (yyvsp[-2].ast));
		SET_AST_NODE_LOC(node, (yylsp[-6]), (yylsp[-1]));
		ast_stack.back()->children.push_back(node);
		if ((yyvsp[-6].string) != nullptr) {
			ast_stack.back()->children.back()->str = *(yyvsp[-6].string);
			delete (yyvsp[-6].string);
		}
	}
#line 6929 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 509: /* assert_property: opt_sva_label TOK_ASSERT TOK_PROPERTY '(' TOK_EVENTUALLY expr ')' ';'  */
#line 2627 "frontends/verilog/verilog_parser.y"
                                                                              {
		AstNode *node = new AstNode(assume_asserts_mode ? AST_FAIR : AST_LIVE, (yyvsp[-2].ast));
		SET_AST_NODE_LOC(node, (yylsp[-7]), (yylsp[-1]));
		ast_stack.back()->children.push_back(node);
		if ((yyvsp[-7].string) != nullptr) {
			ast_stack.back()->children.back()->str = *(yyvsp[-7].string);
			delete (yyvsp[-7].string);
		}
	}
#line 6943 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 510: /* assert_property: opt_sva_label TOK_ASSUME TOK_PROPERTY '(' TOK_EVENTUALLY expr ')' ';'  */
#line 2636 "frontends/verilog/verilog_parser.y"
                                                                              {
		AstNode *node = new AstNode(AST_FAIR, (yyvsp[-2].ast));
		SET_AST_NODE_LOC(node, (yylsp[-7]), (yylsp[-1]));
		ast_stack.back()->children.push_back(node);
		if ((yyvsp[-7].string) != nullptr) {
			ast_stack.back()->children.back()->str = *(yyvsp[-7].string);
			delete (yyvsp[-7].string);
		}
	}
#line 6957 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 511: /* assert_property: opt_sva_label TOK_COVER TOK_PROPERTY '(' expr ')' ';'  */
#line 2645 "frontends/verilog/verilog_parser.y"
                                                              {
		AstNode *node = new AstNode(AST_COVER, (yyvsp[-2].ast));
		SET_AST_NODE_LOC(node, (yylsp[-6]), (yylsp[-1]));
		ast_stack.back()->children.push_back(node);
		if ((yyvsp[-6].string) != nullptr) {
			ast_stack.back()->children.back()->str = *(yyvsp[-6].string);
			delete (yyvsp[-6].string);
		}
	}
#line 6971 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 512: /* assert_property: opt_sva_label TOK_RESTRICT TOK_PROPERTY '(' expr ')' ';'  */
#line 2654 "frontends/verilog/verilog_parser.y"
                                                                 {
		if (norestrict_mode) {
			delete (yyvsp[-2].ast);
		} else {
			AstNode *node = new AstNode(AST_ASSUME, (yyvsp[-2].ast));
			SET_AST_NODE_LOC(node, (yylsp[-6]), (yylsp[-1]));
			ast_stack.back()->children.push_back(node);
			if ((yyvsp[-6].string) != nullptr) {
				ast_stack.back()->children.back()->str = *(yyvsp[-6].string);
				delete (yyvsp[-6].string);
			}
		}
	}
#line 6989 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 513: /* assert_property: opt_sva_label TOK_RESTRICT TOK_PROPERTY '(' TOK_EVENTUALLY expr ')' ';'  */
#line 2667 "frontends/verilog/verilog_parser.y"
                                                                                {
		if (norestrict_mode) {
			delete (yyvsp[-2].ast);
		} else {
			AstNode *node = new AstNode(AST_FAIR, (yyvsp[-2].ast));
			SET_AST_NODE_LOC(node, (yylsp[-7]), (yylsp[-1]));
			ast_stack.back()->children.push_back(node);
			if ((yyvsp[-7].string) != nullptr) {
				ast_stack.back()->children.back()->str = *(yyvsp[-7].string);
				delete (yyvsp[-7].string);
			}
		}
	}
#line 7007 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 514: /* simple_behavioral_stmt: attr lvalue '=' delay expr  */
#line 2682 "frontends/verilog/verilog_parser.y"
                                   {
		AstNode *node = new AstNode(AST_ASSIGN_EQ, (yyvsp[-3].ast), (yyvsp[0].ast));
		ast_stack.back()->children.push_back(node);
		SET_AST_NODE_LOC(node, (yylsp[-3]), (yylsp[0]));
		append_attr(node, (yyvsp[-4].al));
	}
#line 7018 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 515: /* simple_behavioral_stmt: attr lvalue attr inc_or_dec_op  */
#line 2688 "frontends/verilog/verilog_parser.y"
                                       {
		addIncOrDecStmt((yyvsp[-3].al), (yyvsp[-2].ast), (yyvsp[-1].al), (yyvsp[0].ast_node_type), (yylsp[-3]), (yylsp[0]));
	}
#line 7026 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 516: /* simple_behavioral_stmt: attr inc_or_dec_op attr lvalue  */
#line 2691 "frontends/verilog/verilog_parser.y"
                                       {
		addIncOrDecStmt((yyvsp[-3].al), (yyvsp[0].ast), (yyvsp[-1].al), (yyvsp[-2].ast_node_type), (yylsp[-3]), (yylsp[0]));
	}
#line 7034 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 517: /* simple_behavioral_stmt: attr lvalue OP_LE delay expr  */
#line 2694 "frontends/verilog/verilog_parser.y"
                                     {
		AstNode *node = new AstNode(AST_ASSIGN_LE, (yyvsp[-3].ast), (yyvsp[0].ast));
		ast_stack.back()->children.push_back(node);
		SET_AST_NODE_LOC(node, (yylsp[-3]), (yylsp[0]));
		append_attr(node, (yyvsp[-4].al));
	}
#line 7045 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 518: /* simple_behavioral_stmt: attr lvalue asgn_binop delay expr  */
#line 2700 "frontends/verilog/verilog_parser.y"
                                          {
		addAsgnBinopStmt((yyvsp[-4].al), (yyvsp[-3].ast), (yyvsp[-2].ast_node_type), (yyvsp[0].ast), (yylsp[-3]), (yylsp[0]));
	}
#line 7053 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 519: /* asgn_binop: TOK_BIT_OR_ASSIGN  */
#line 2705 "frontends/verilog/verilog_parser.y"
                          { (yyval.ast_node_type) = AST_BIT_OR; }
#line 7059 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 520: /* asgn_binop: TOK_BIT_AND_ASSIGN  */
#line 2706 "frontends/verilog/verilog_parser.y"
                           { (yyval.ast_node_type) = AST_BIT_AND; }
#line 7065 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 521: /* asgn_binop: TOK_BIT_XOR_ASSIGN  */
#line 2707 "frontends/verilog/verilog_parser.y"
                           { (yyval.ast_node_type) = AST_BIT_XOR; }
#line 7071 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 522: /* asgn_binop: TOK_ADD_ASSIGN  */
#line 2708 "frontends/verilog/verilog_parser.y"
                       { (yyval.ast_node_type) = AST_ADD; }
#line 7077 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 523: /* asgn_binop: TOK_SUB_ASSIGN  */
#line 2709 "frontends/verilog/verilog_parser.y"
                       { (yyval.ast_node_type) = AST_SUB; }
#line 7083 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 524: /* asgn_binop: TOK_DIV_ASSIGN  */
#line 2710 "frontends/verilog/verilog_parser.y"
                       { (yyval.ast_node_type) = AST_DIV; }
#line 7089 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 525: /* asgn_binop: TOK_MOD_ASSIGN  */
#line 2711 "frontends/verilog/verilog_parser.y"
                       { (yyval.ast_node_type) = AST_MOD; }
#line 7095 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 526: /* asgn_binop: TOK_MUL_ASSIGN  */
#line 2712 "frontends/verilog/verilog_parser.y"
                       { (yyval.ast_node_type) = AST_MUL; }
#line 7101 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 527: /* asgn_binop: TOK_SHL_ASSIGN  */
#line 2713 "frontends/verilog/verilog_parser.y"
                       { (yyval.ast_node_type) = AST_SHIFT_LEFT; }
#line 7107 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 528: /* asgn_binop: TOK_SHR_ASSIGN  */
#line 2714 "frontends/verilog/verilog_parser.y"
                       { (yyval.ast_node_type) = AST_SHIFT_RIGHT; }
#line 7113 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 529: /* asgn_binop: TOK_SSHL_ASSIGN  */
#line 2715 "frontends/verilog/verilog_parser.y"
                        { (yyval.ast_node_type) = AST_SHIFT_SLEFT; }
#line 7119 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 530: /* asgn_binop: TOK_SSHR_ASSIGN  */
#line 2716 "frontends/verilog/verilog_parser.y"
                        { (yyval.ast_node_type) = AST_SHIFT_SRIGHT; }
#line 7125 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 531: /* inc_or_dec_op: TOK_INCREMENT  */
#line 2721 "frontends/verilog/verilog_parser.y"
                      { (yyval.ast_node_type) = AST_ADD; }
#line 7131 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 532: /* inc_or_dec_op: TOK_DECREMENT  */
#line 2722 "frontends/verilog/verilog_parser.y"
                      { (yyval.ast_node_type) = AST_SUB; }
#line 7137 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 533: /* for_initialization: TOK_ID '=' expr  */
#line 2725 "frontends/verilog/verilog_parser.y"
                        {
		AstNode *ident = new AstNode(AST_IDENTIFIER);
		ident->str = *(yyvsp[-2].string);
		AstNode *node = new AstNode(AST_ASSIGN_EQ, ident, (yyvsp[0].ast));
		ast_stack.back()->children.push_back(node);
		SET_AST_NODE_LOC(node, (yylsp[-2]), (yylsp[0]));
		delete (yyvsp[-2].string);
	}
#line 7150 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 534: /* for_initialization: non_io_wire_type range TOK_ID  */
#line 2733 "frontends/verilog/verilog_parser.y"
                                      {
		frontend_verilog_yyerror("For loop variable declaration is missing initialization!");
	}
#line 7158 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 535: /* for_initialization: non_io_wire_type range TOK_ID '=' expr  */
#line 2736 "frontends/verilog/verilog_parser.y"
                                               {
		if (!sv_mode)
			frontend_verilog_yyerror("For loop inline variable declaration is only supported in SystemVerilog mode!");

		// loop variable declaration
		AstNode *wire = (yyvsp[-4].ast);
		AstNode *range = checkRange(wire, (yyvsp[-3].ast));
		if (range != nullptr)
			wire->children.push_back(range);
		SET_AST_NODE_LOC(wire, (yylsp[-4]), (yylsp[-2]));
		SET_AST_NODE_LOC(range, (yylsp[-3]), (yylsp[-3]));

		AstNode *ident = new AstNode(AST_IDENTIFIER);
		ident->str = *(yyvsp[-2].string);
		wire->str = *(yyvsp[-2].string);
		delete (yyvsp[-2].string);

		AstNode *loop = ast_stack.back();
		AstNode *parent = ast_stack.at(ast_stack.size() - 2);
		log_assert(parent->children.back() == loop);

		// loop variable initialization
		AstNode *asgn = new AstNode(AST_ASSIGN_EQ, ident, (yyvsp[0].ast));
		loop->children.push_back(asgn);
		SET_AST_NODE_LOC(asgn, (yylsp[-2]), (yylsp[0]));
		SET_AST_NODE_LOC(ident, (yylsp[-2]), (yylsp[-2]));

		// inject a wrapping block to declare the loop variable and
		// contain the current loop
		AstNode *wrapper = new AstNode(AST_BLOCK);
		wrapper->str = "$fordecl_block$" + std::to_string(autoidx++);
		wrapper->children.push_back(wire);
		wrapper->children.push_back(loop);
		parent->children.back() = wrapper; // replaces `loop`
	}
#line 7198 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 544: /* behavioral_stmt: attr ';'  */
#line 2777 "frontends/verilog/verilog_parser.y"
                 {
		free_attr((yyvsp[-1].al));
	}
#line 7206 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 545: /* $@60: %empty  */
#line 2780 "frontends/verilog/verilog_parser.y"
                             {
		AstNode *node = new AstNode(AST_TCALL);
		node->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
		append_attr(node, (yyvsp[-1].al));
	}
#line 7219 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 546: /* behavioral_stmt: attr hierarchical_id $@60 opt_arg_list ';'  */
#line 2787 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-3]), (yylsp[0]));
		ast_stack.pop_back();
	}
#line 7228 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 547: /* $@61: %empty  */
#line 2791 "frontends/verilog/verilog_parser.y"
                           {
		AstNode *node = new AstNode(AST_TCALL);
		node->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
		append_attr(node, (yyvsp[-1].al));
	}
#line 7241 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 548: /* behavioral_stmt: attr TOK_MSG_TASKS $@61 opt_arg_list ';'  */
#line 2798 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-3]), (yylsp[0]));
		ast_stack.pop_back();
	}
#line 7250 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 549: /* $@62: %empty  */
#line 2802 "frontends/verilog/verilog_parser.y"
                       {
		enterTypeScope();
	}
#line 7258 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 550: /* $@63: %empty  */
#line 2804 "frontends/verilog/verilog_parser.y"
                    {
		AstNode *node = new AstNode(AST_BLOCK);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
		append_attr(node, (yyvsp[-3].al));
		if ((yyvsp[0].string) != NULL)
			node->str = *(yyvsp[0].string);
	}
#line 7271 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 551: /* behavioral_stmt: attr TOK_BEGIN $@62 opt_label $@63 behavioral_stmt_list TOK_END opt_label  */
#line 2811 "frontends/verilog/verilog_parser.y"
                                                 {
		exitTypeScope();
		checkLabelsMatch("Begin label", (yyvsp[-4].string), (yyvsp[0].string));
		AstNode *node = ast_stack.back();
		// In SystemVerilog, unnamed blocks with block item declarations
		// create an implicit hierarchy scope
		if (sv_mode && node->str.empty())
		    for (const AstNode* child : node->children)
			if (child->type == AST_WIRE || child->type == AST_MEMORY || child->type == AST_PARAMETER
				|| child->type == AST_LOCALPARAM || child->type == AST_TYPEDEF) {
			    node->str = "$unnamed_block$" + std::to_string(autoidx++);
			    break;
			}
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-6]), (yylsp[0]));
		delete (yyvsp[-4].string);
		delete (yyvsp[0].string);
		ast_stack.pop_back();
	}
#line 7294 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 552: /* $@64: %empty  */
#line 2829 "frontends/verilog/verilog_parser.y"
                         {
		AstNode *node = new AstNode(AST_FOR);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
		append_attr(node, (yyvsp[-2].al));
	}
#line 7305 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 553: /* $@65: %empty  */
#line 2834 "frontends/verilog/verilog_parser.y"
                                      {
		ast_stack.back()->children.push_back((yyvsp[0].ast));
	}
#line 7313 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 554: /* $@66: %empty  */
#line 2836 "frontends/verilog/verilog_parser.y"
                                         {
		AstNode *block = new AstNode(AST_BLOCK);
		block->str = "$for_loop$" + std::to_string(autoidx++);
		ast_stack.back()->children.push_back(block);
		ast_stack.push_back(block);
	}
#line 7324 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 555: /* behavioral_stmt: attr TOK_FOR '(' $@64 for_initialization ';' expr $@65 ';' simple_behavioral_stmt ')' $@66 behavioral_stmt  */
#line 2841 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[0]), (yylsp[0]));
		ast_stack.pop_back();
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-11]), (yylsp[0]));
		ast_stack.pop_back();
	}
#line 7335 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 556: /* $@67: %empty  */
#line 2847 "frontends/verilog/verilog_parser.y"
                                    {
		AstNode *node = new AstNode(AST_WHILE);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
		append_attr(node, (yyvsp[-4].al));
		AstNode *block = new AstNode(AST_BLOCK);
		ast_stack.back()->children.push_back((yyvsp[-1].ast));
		ast_stack.back()->children.push_back(block);
		ast_stack.push_back(block);
	}
#line 7350 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 557: /* behavioral_stmt: attr TOK_WHILE '(' expr ')' $@67 behavioral_stmt  */
#line 2856 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[0]), (yylsp[0]));
		ast_stack.pop_back();
		ast_stack.pop_back();
	}
#line 7360 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 558: /* $@68: %empty  */
#line 2861 "frontends/verilog/verilog_parser.y"
                                     {
		AstNode *node = new AstNode(AST_REPEAT);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
		append_attr(node, (yyvsp[-4].al));
		AstNode *block = new AstNode(AST_BLOCK);
		ast_stack.back()->children.push_back((yyvsp[-1].ast));
		ast_stack.back()->children.push_back(block);
		ast_stack.push_back(block);
	}
#line 7375 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 559: /* behavioral_stmt: attr TOK_REPEAT '(' expr ')' $@68 behavioral_stmt  */
#line 2870 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[0]), (yylsp[0]));
		ast_stack.pop_back();
		ast_stack.pop_back();
	}
#line 7385 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 560: /* $@69: %empty  */
#line 2875 "frontends/verilog/verilog_parser.y"
                                    {
		AstNode *node = new AstNode(AST_CASE);
		AstNode *block = new AstNode(AST_BLOCK);
		AstNode *cond = new AstNode(AST_COND, AstNode::mkconst_int(1, false, 1), block);
		SET_AST_NODE_LOC(cond, (yylsp[-1]), (yylsp[-1]));
		ast_stack.back()->children.push_back(node);
		node->children.push_back(new AstNode(AST_REDUCE_BOOL, (yyvsp[-1].ast)));
		node->children.push_back(cond);
		ast_stack.push_back(node);
		ast_stack.push_back(block);
		append_attr(node, (yyvsp[-4].al));
	}
#line 7402 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 561: /* $@70: %empty  */
#line 2886 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[0]), (yylsp[0]));
	}
#line 7410 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 562: /* behavioral_stmt: if_attr TOK_IF '(' expr ')' $@69 behavioral_stmt $@70 optional_else  */
#line 2888 "frontends/verilog/verilog_parser.y"
                        {
		ast_stack.pop_back();
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-7]), (yylsp[0]));
		ast_stack.pop_back();
	}
#line 7420 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 563: /* $@71: %empty  */
#line 2893 "frontends/verilog/verilog_parser.y"
                                         {
		AstNode *node = new AstNode(AST_CASE, (yyvsp[-1].ast));
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
		append_attr(node, (yyvsp[-4].al));
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-1]), (yylsp[-1]));
	}
#line 7432 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 564: /* behavioral_stmt: case_attr case_type '(' expr ')' $@71 opt_synopsys_attr case_body TOK_ENDCASE  */
#line 2899 "frontends/verilog/verilog_parser.y"
                                                  {
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-7]), (yylsp[0]));
		case_type_stack.pop_back();
		ast_stack.pop_back();
	}
#line 7442 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 565: /* if_attr: attr  */
#line 2906 "frontends/verilog/verilog_parser.y"
             {
		(yyval.al) = (yyvsp[0].al);
	}
#line 7450 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 566: /* if_attr: attr TOK_UNIQUE0  */
#line 2909 "frontends/verilog/verilog_parser.y"
                         {
		AstNode *context = ast_stack.back();
		if( context && context->type == AST_BLOCK && context->get_bool_attribute(ID::promoted_if) )
			frontend_verilog_yyerror("unique0 keyword cannot be used for 'else if' branch.");
		(yyval.al) = (yyvsp[-1].al); // accept unique0 keyword, but ignore it for now
	}
#line 7461 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 567: /* if_attr: attr TOK_PRIORITY  */
#line 2915 "frontends/verilog/verilog_parser.y"
                          {
		AstNode *context = ast_stack.back();
		if( context && context->type == AST_BLOCK && context->get_bool_attribute(ID::promoted_if) )
			frontend_verilog_yyerror("priority keyword cannot be used for 'else if' branch.");
		(yyval.al) = (yyvsp[-1].al); // accept priority keyword, but ignore it for now
	}
#line 7472 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 568: /* if_attr: attr TOK_UNIQUE  */
#line 2921 "frontends/verilog/verilog_parser.y"
                        {
		AstNode *context = ast_stack.back();
		if( context && context->type == AST_BLOCK && context->get_bool_attribute(ID::promoted_if) )
			frontend_verilog_yyerror("unique keyword cannot be used for 'else if' branch.");
		(yyval.al) = (yyvsp[-1].al); // accept unique keyword, but ignore it for now
	}
#line 7483 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 569: /* case_attr: attr  */
#line 2929 "frontends/verilog/verilog_parser.y"
             {
		(yyval.al) = (yyvsp[0].al);
	}
#line 7491 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 570: /* case_attr: attr TOK_UNIQUE0  */
#line 2932 "frontends/verilog/verilog_parser.y"
                         {
		(*(yyvsp[-1].al))[ID::parallel_case] = AstNode::mkconst_int(1, false);
		(yyval.al) = (yyvsp[-1].al);
	}
#line 7500 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 571: /* case_attr: attr TOK_PRIORITY  */
#line 2936 "frontends/verilog/verilog_parser.y"
                          {
		(*(yyvsp[-1].al))[ID::full_case] = AstNode::mkconst_int(1, false);
		(yyval.al) = (yyvsp[-1].al);
	}
#line 7509 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 572: /* case_attr: attr TOK_UNIQUE  */
#line 2940 "frontends/verilog/verilog_parser.y"
                        {
		(*(yyvsp[-1].al))[ID::full_case] = AstNode::mkconst_int(1, false);
		(*(yyvsp[-1].al))[ID::parallel_case] = AstNode::mkconst_int(1, false);
		(yyval.al) = (yyvsp[-1].al);
	}
#line 7519 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 573: /* case_type: TOK_CASE  */
#line 2947 "frontends/verilog/verilog_parser.y"
                 {
		case_type_stack.push_back(0);
	}
#line 7527 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 574: /* case_type: TOK_CASEX  */
#line 2950 "frontends/verilog/verilog_parser.y"
                  {
		case_type_stack.push_back('x');
	}
#line 7535 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 575: /* case_type: TOK_CASEZ  */
#line 2953 "frontends/verilog/verilog_parser.y"
                  {
		case_type_stack.push_back('z');
	}
#line 7543 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 576: /* opt_synopsys_attr: opt_synopsys_attr TOK_SYNOPSYS_FULL_CASE  */
#line 2958 "frontends/verilog/verilog_parser.y"
                                                 {
		if (ast_stack.back()->attributes.count(ID::full_case) == 0)
			ast_stack.back()->attributes[ID::full_case] = AstNode::mkconst_int(1, false);
	}
#line 7552 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 577: /* opt_synopsys_attr: opt_synopsys_attr TOK_SYNOPSYS_PARALLEL_CASE  */
#line 2962 "frontends/verilog/verilog_parser.y"
                                                     {
		if (ast_stack.back()->attributes.count(ID::parallel_case) == 0)
			ast_stack.back()->attributes[ID::parallel_case] = AstNode::mkconst_int(1, false);
	}
#line 7561 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 581: /* $@72: %empty  */
#line 2973 "frontends/verilog/verilog_parser.y"
                 {
		AstNode *block = new AstNode(AST_BLOCK);
		block->attributes[ID::promoted_if] = AstNode::mkconst_int(1, false );
		AstNode *cond = new AstNode(AST_COND, new AstNode(AST_DEFAULT), block);
		SET_AST_NODE_LOC(cond, (yylsp[0]), (yylsp[0]));

		ast_stack.pop_back();
		ast_stack.back()->children.push_back(cond);
		ast_stack.push_back(block);
	}
#line 7576 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 582: /* optional_else: TOK_ELSE $@72 behavioral_stmt  */
#line 2982 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[0]), (yylsp[0]));
	}
#line 7584 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 586: /* $@73: %empty  */
#line 2992 "frontends/verilog/verilog_parser.y"
        {
		AstNode *node = new AstNode(
				case_type_stack.size() && case_type_stack.back() == 'x' ? AST_CONDX :
				case_type_stack.size() && case_type_stack.back() == 'z' ? AST_CONDZ : AST_COND);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
	}
#line 7596 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 587: /* $@74: %empty  */
#line 2998 "frontends/verilog/verilog_parser.y"
                      {
		AstNode *block = new AstNode(AST_BLOCK);
		ast_stack.back()->children.push_back(block);
		ast_stack.push_back(block);
		case_type_stack.push_back(0);
	}
#line 7607 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 588: /* case_item: $@73 case_select $@74 behavioral_stmt  */
#line 3003 "frontends/verilog/verilog_parser.y"
                          {
		case_type_stack.pop_back();
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[0]), (yylsp[0]));
		ast_stack.pop_back();
		ast_stack.pop_back();
	}
#line 7618 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 591: /* $@75: %empty  */
#line 3015 "frontends/verilog/verilog_parser.y"
        {
		AstNode *node = new AstNode(
				case_type_stack.size() && case_type_stack.back() == 'x' ? AST_CONDX :
				case_type_stack.size() && case_type_stack.back() == 'z' ? AST_CONDZ : AST_COND);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
	}
#line 7630 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 592: /* $@76: %empty  */
#line 3021 "frontends/verilog/verilog_parser.y"
                      {
		case_type_stack.push_back(0);
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[0]), (yylsp[0]));
	}
#line 7639 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 593: /* gen_case_item: $@75 case_select $@76 gen_stmt_block  */
#line 3024 "frontends/verilog/verilog_parser.y"
                         {
		case_type_stack.pop_back();
		ast_stack.pop_back();
	}
#line 7648 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 596: /* case_expr_list: TOK_DEFAULT  */
#line 3034 "frontends/verilog/verilog_parser.y"
                    {
		AstNode *node = new AstNode(AST_DEFAULT);
		SET_AST_NODE_LOC(node, (yylsp[0]), (yylsp[0]));
		ast_stack.back()->children.push_back(node);
	}
#line 7658 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 597: /* case_expr_list: TOK_SVA_LABEL  */
#line 3039 "frontends/verilog/verilog_parser.y"
                      {
		AstNode *node = new AstNode(AST_IDENTIFIER);
		SET_AST_NODE_LOC(node, (yylsp[0]), (yylsp[0]));
		ast_stack.back()->children.push_back(node);
		ast_stack.back()->children.back()->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
	}
#line 7670 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 598: /* case_expr_list: expr  */
#line 3046 "frontends/verilog/verilog_parser.y"
             {
		ast_stack.back()->children.push_back((yyvsp[0].ast));
	}
#line 7678 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 599: /* case_expr_list: case_expr_list ',' expr  */
#line 3049 "frontends/verilog/verilog_parser.y"
                                {
		ast_stack.back()->children.push_back((yyvsp[0].ast));
	}
#line 7686 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 600: /* rvalue: hierarchical_id '[' expr ']' '.' rvalue  */
#line 3054 "frontends/verilog/verilog_parser.y"
                                                {
		(yyval.ast) = new AstNode(AST_PREFIX, (yyvsp[-3].ast), (yyvsp[0].ast));
		(yyval.ast)->str = *(yyvsp[-5].string);
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-5]), (yylsp[0]));
		delete (yyvsp[-5].string);
	}
#line 7697 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 601: /* rvalue: hierarchical_id range  */
#line 3060 "frontends/verilog/verilog_parser.y"
                              {
		(yyval.ast) = new AstNode(AST_IDENTIFIER, (yyvsp[0].ast));
		(yyval.ast)->str = *(yyvsp[-1].string);
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-1]), (yylsp[-1]));
		delete (yyvsp[-1].string);
		if ((yyvsp[0].ast) == nullptr && ((yyval.ast)->str == "\\$initstate" ||
				(yyval.ast)->str == "\\$anyconst" || (yyval.ast)->str == "\\$anyseq" ||
				(yyval.ast)->str == "\\$allconst" || (yyval.ast)->str == "\\$allseq"))
			(yyval.ast)->type = AST_FCALL;
	}
#line 7712 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 602: /* rvalue: hierarchical_id non_opt_multirange  */
#line 3070 "frontends/verilog/verilog_parser.y"
                                           {
		(yyval.ast) = new AstNode(AST_IDENTIFIER, (yyvsp[0].ast));
		(yyval.ast)->str = *(yyvsp[-1].string);
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-1]), (yylsp[-1]));
		delete (yyvsp[-1].string);
	}
#line 7723 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 603: /* lvalue: rvalue  */
#line 3078 "frontends/verilog/verilog_parser.y"
               {
		(yyval.ast) = (yyvsp[0].ast);
	}
#line 7731 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 604: /* lvalue: '{' lvalue_concat_list '}'  */
#line 3081 "frontends/verilog/verilog_parser.y"
                                   {
		(yyval.ast) = (yyvsp[-1].ast);
	}
#line 7739 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 605: /* lvalue_concat_list: expr  */
#line 3086 "frontends/verilog/verilog_parser.y"
             {
		(yyval.ast) = new AstNode(AST_CONCAT);
		(yyval.ast)->children.push_back((yyvsp[0].ast));
	}
#line 7748 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 606: /* lvalue_concat_list: expr ',' lvalue_concat_list  */
#line 3090 "frontends/verilog/verilog_parser.y"
                                    {
		(yyval.ast) = (yyvsp[0].ast);
		(yyval.ast)->children.push_back((yyvsp[-2].ast));
	}
#line 7757 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 613: /* single_arg: expr  */
#line 3108 "frontends/verilog/verilog_parser.y"
             {
		ast_stack.back()->children.push_back((yyvsp[0].ast));
	}
#line 7765 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 619: /* gen_stmt_or_module_body_stmt: attr ';'  */
#line 3119 "frontends/verilog/verilog_parser.y"
                 {
		free_attr((yyvsp[-1].al));
	}
#line 7773 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 620: /* genvar_identifier: TOK_ID  */
#line 3124 "frontends/verilog/verilog_parser.y"
               {
		(yyval.ast) = new AstNode(AST_IDENTIFIER);
		(yyval.ast)->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
	}
#line 7783 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 621: /* genvar_initialization: TOK_GENVAR genvar_identifier  */
#line 3131 "frontends/verilog/verilog_parser.y"
                                     {
		frontend_verilog_yyerror("Generate for loop variable declaration is missing initialization!");
	}
#line 7791 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 622: /* genvar_initialization: TOK_GENVAR genvar_identifier '=' expr  */
#line 3134 "frontends/verilog/verilog_parser.y"
                                              {
		if (!sv_mode)
			frontend_verilog_yyerror("Generate for loop inline variable declaration is only supported in SystemVerilog mode!");
		AstNode *node = new AstNode(AST_GENVAR);
		node->is_reg = true;
		node->is_signed = true;
		node->range_left = 31;
		node->range_right = 0;
		node->str = (yyvsp[-2].ast)->str;
		node->children.push_back(checkRange(node, nullptr));
		ast_stack.back()->children.push_back(node);
		SET_AST_NODE_LOC(node, (yylsp[-3]), (yylsp[0]));
		node = new AstNode(AST_ASSIGN_EQ, (yyvsp[-2].ast), (yyvsp[0].ast));
		ast_stack.back()->children.push_back(node);
		SET_AST_NODE_LOC(node, (yylsp[-3]), (yylsp[0]));
	}
#line 7812 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 623: /* genvar_initialization: genvar_identifier '=' expr  */
#line 3150 "frontends/verilog/verilog_parser.y"
                                   {
		AstNode *node = new AstNode(AST_ASSIGN_EQ, (yyvsp[-2].ast), (yyvsp[0].ast));
		ast_stack.back()->children.push_back(node);
		SET_AST_NODE_LOC(node, (yylsp[-2]), (yylsp[0]));
	}
#line 7822 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 624: /* $@77: %empty  */
#line 3158 "frontends/verilog/verilog_parser.y"
                    {
		AstNode *node = new AstNode(AST_GENFOR);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
	}
#line 7832 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 625: /* $@78: %empty  */
#line 3162 "frontends/verilog/verilog_parser.y"
                                         {
		ast_stack.back()->children.push_back((yyvsp[0].ast));
	}
#line 7840 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 626: /* gen_stmt: TOK_FOR '(' $@77 genvar_initialization ';' expr $@78 ';' simple_behavioral_stmt ')' gen_stmt_block  */
#line 3164 "frontends/verilog/verilog_parser.y"
                                                        {
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-10]), (yylsp[0]));
		rewriteGenForDeclInit(ast_stack.back());
		ast_stack.pop_back();
	}
#line 7850 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 627: /* $@79: %empty  */
#line 3169 "frontends/verilog/verilog_parser.y"
                            {
		AstNode *node = new AstNode(AST_GENIF);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
		ast_stack.back()->children.push_back((yyvsp[-1].ast));
	}
#line 7861 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 628: /* gen_stmt: TOK_IF '(' expr ')' $@79 gen_stmt_block opt_gen_else  */
#line 3174 "frontends/verilog/verilog_parser.y"
                                      {
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-6]), (yylsp[0]));
		ast_stack.pop_back();
	}
#line 7870 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 629: /* $@80: %empty  */
#line 3178 "frontends/verilog/verilog_parser.y"
                               {
		AstNode *node = new AstNode(AST_GENCASE, (yyvsp[-1].ast));
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
	}
#line 7880 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 630: /* gen_stmt: case_type '(' expr ')' $@80 gen_case_body TOK_ENDCASE  */
#line 3182 "frontends/verilog/verilog_parser.y"
                                    {
		case_type_stack.pop_back();
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-6]), (yylsp[0]));
		ast_stack.pop_back();
	}
#line 7890 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 631: /* $@81: %empty  */
#line 3187 "frontends/verilog/verilog_parser.y"
                      {
		AstNode *node = new AstNode(AST_TECALL);
		node->str = *(yyvsp[0].string);
		delete (yyvsp[0].string);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
	}
#line 7902 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 632: /* gen_stmt: TOK_MSG_TASKS $@81 opt_arg_list ';'  */
#line 3193 "frontends/verilog/verilog_parser.y"
                          {
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-3]), (yylsp[-1]));
		ast_stack.pop_back();
	}
#line 7911 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 633: /* $@82: %empty  */
#line 3199 "frontends/verilog/verilog_parser.y"
                  {
		enterTypeScope();
	}
#line 7919 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 634: /* $@83: %empty  */
#line 3201 "frontends/verilog/verilog_parser.y"
                    {
		AstNode *node = new AstNode(AST_GENBLOCK);
		node->str = (yyvsp[0].string) ? *(yyvsp[0].string) : std::string();
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
	}
#line 7930 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 635: /* gen_block: TOK_BEGIN $@82 opt_label $@83 module_gen_body TOK_END opt_label  */
#line 3206 "frontends/verilog/verilog_parser.y"
                                            {
		exitTypeScope();
		checkLabelsMatch("Begin label", (yyvsp[-4].string), (yyvsp[0].string));
		delete (yyvsp[-4].string);
		delete (yyvsp[0].string);
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[-6]), (yylsp[0]));
		ast_stack.pop_back();
	}
#line 7943 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 636: /* $@84: %empty  */
#line 3217 "frontends/verilog/verilog_parser.y"
        {
		AstNode *node = new AstNode(AST_GENBLOCK);
		ast_stack.back()->children.push_back(node);
		ast_stack.push_back(node);
	}
#line 7953 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 637: /* gen_stmt_block: $@84 gen_stmt_or_module_body_stmt  */
#line 3221 "frontends/verilog/verilog_parser.y"
                                       {
		SET_AST_NODE_LOC(ast_stack.back(), (yylsp[0]), (yylsp[0]));
		ast_stack.pop_back();
	}
#line 7962 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 641: /* expr: basic_expr  */
#line 3230 "frontends/verilog/verilog_parser.y"
                   {
		(yyval.ast) = (yyvsp[0].ast);
	}
#line 7970 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 642: /* expr: basic_expr '?' attr expr ':' expr  */
#line 3233 "frontends/verilog/verilog_parser.y"
                                          {
		(yyval.ast) = new AstNode(AST_TERNARY);
		(yyval.ast)->children.push_back((yyvsp[-5].ast));
		(yyval.ast)->children.push_back((yyvsp[-2].ast));
		(yyval.ast)->children.push_back((yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-5]), (yyloc));
		append_attr((yyval.ast), (yyvsp[-3].al));
	}
#line 7983 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 643: /* expr: inc_or_dec_op attr rvalue  */
#line 3241 "frontends/verilog/verilog_parser.y"
                                  {
		(yyval.ast) = addIncOrDecExpr((yyvsp[0].ast), (yyvsp[-1].al), (yyvsp[-2].ast_node_type), (yylsp[-2]), (yylsp[0]), false);
	}
#line 7991 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 644: /* expr: rvalue inc_or_dec_op  */
#line 3246 "frontends/verilog/verilog_parser.y"
                             {
		(yyval.ast) = addIncOrDecExpr((yyvsp[-1].ast), nullptr, (yyvsp[0].ast_node_type), (yylsp[-1]), (yylsp[0]), true);
	}
#line 7999 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 645: /* basic_expr: rvalue  */
#line 3251 "frontends/verilog/verilog_parser.y"
               {
		(yyval.ast) = (yyvsp[0].ast);
	}
#line 8007 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 646: /* basic_expr: '(' expr ')' integral_number  */
#line 3254 "frontends/verilog/verilog_parser.y"
                                     {
		if ((yyvsp[0].string)->compare(0, 1, "'") != 0)
			frontend_verilog_yyerror("Cast operation must be applied on sized constants e.g. (<expr>)<constval> , while %s is not a sized constant.", (yyvsp[0].string)->c_str());
		AstNode *bits = (yyvsp[-2].ast);
		AstNode *val = const2ast(*(yyvsp[0].string), case_type_stack.size() == 0 ? 0 : case_type_stack.back(), !lib_mode);
		if (val == NULL)
			log_error("Value conversion failed: `%s'\n", (yyvsp[0].string)->c_str());
		(yyval.ast) = new AstNode(AST_TO_BITS, bits, val);
		delete (yyvsp[0].string);
	}
#line 8022 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 647: /* basic_expr: hierarchical_id integral_number  */
#line 3264 "frontends/verilog/verilog_parser.y"
                                        {
		if ((yyvsp[0].string)->compare(0, 1, "'") != 0)
			frontend_verilog_yyerror("Cast operation must be applied on sized constants, e.g. <ID>\'d0, while %s is not a sized constant.", (yyvsp[0].string)->c_str());
		AstNode *bits = new AstNode(AST_IDENTIFIER);
		bits->str = *(yyvsp[-1].string);
		SET_AST_NODE_LOC(bits, (yylsp[-1]), (yylsp[-1]));
		AstNode *val = const2ast(*(yyvsp[0].string), case_type_stack.size() == 0 ? 0 : case_type_stack.back(), !lib_mode);
		SET_AST_NODE_LOC(val, (yylsp[0]), (yylsp[0]));
		if (val == NULL)
			log_error("Value conversion failed: `%s'\n", (yyvsp[0].string)->c_str());
		(yyval.ast) = new AstNode(AST_TO_BITS, bits, val);
		delete (yyvsp[-1].string);
		delete (yyvsp[0].string);
	}
#line 8041 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 648: /* basic_expr: integral_number  */
#line 3278 "frontends/verilog/verilog_parser.y"
                        {
		(yyval.ast) = const2ast(*(yyvsp[0].string), case_type_stack.size() == 0 ? 0 : case_type_stack.back(), !lib_mode);
		SET_AST_NODE_LOC((yyval.ast), (yylsp[0]), (yylsp[0]));
		if ((yyval.ast) == NULL)
			log_error("Value conversion failed: `%s'\n", (yyvsp[0].string)->c_str());
		delete (yyvsp[0].string);
	}
#line 8053 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 649: /* basic_expr: TOK_REALVAL  */
#line 3285 "frontends/verilog/verilog_parser.y"
                    {
		(yyval.ast) = new AstNode(AST_REALVALUE);
		char *p = (char*)malloc(GetSize(*(yyvsp[0].string)) + 1), *q;
		for (int i = 0, j = 0; j < GetSize(*(yyvsp[0].string)); j++)
			if ((*(yyvsp[0].string))[j] != '_')
				p[i++] = (*(yyvsp[0].string))[j], p[i] = 0;
		(yyval.ast)->realvalue = strtod(p, &q);
		SET_AST_NODE_LOC((yyval.ast), (yylsp[0]), (yylsp[0]));
		log_assert(*q == 0);
		delete (yyvsp[0].string);
		free(p);
	}
#line 8070 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 650: /* basic_expr: TOK_STRING  */
#line 3297 "frontends/verilog/verilog_parser.y"
                   {
		(yyval.ast) = AstNode::mkconst_str(*(yyvsp[0].string));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[0]), (yylsp[0]));
		delete (yyvsp[0].string);
	}
#line 8080 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 651: /* $@85: %empty  */
#line 3302 "frontends/verilog/verilog_parser.y"
                             {
		AstNode *node = new AstNode(AST_FCALL);
		node->str = *(yyvsp[-1].string);
		delete (yyvsp[-1].string);
		ast_stack.push_back(node);
		SET_AST_NODE_LOC(node, (yylsp[-1]), (yylsp[-1]));
		append_attr(node, (yyvsp[0].al));
	}
#line 8093 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 652: /* basic_expr: hierarchical_id attr $@85 '(' arg_list optional_comma ')'  */
#line 3309 "frontends/verilog/verilog_parser.y"
                                          {
		(yyval.ast) = ast_stack.back();
		ast_stack.pop_back();
	}
#line 8102 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 653: /* basic_expr: TOK_TO_SIGNED attr '(' expr ')'  */
#line 3313 "frontends/verilog/verilog_parser.y"
                                        {
		(yyval.ast) = new AstNode(AST_TO_SIGNED, (yyvsp[-1].ast));
		append_attr((yyval.ast), (yyvsp[-3].al));
	}
#line 8111 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 654: /* basic_expr: TOK_TO_UNSIGNED attr '(' expr ')'  */
#line 3317 "frontends/verilog/verilog_parser.y"
                                          {
		(yyval.ast) = new AstNode(AST_TO_UNSIGNED, (yyvsp[-1].ast));
		append_attr((yyval.ast), (yyvsp[-3].al));
	}
#line 8120 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 655: /* basic_expr: '(' expr ')'  */
#line 3321 "frontends/verilog/verilog_parser.y"
                     {
		(yyval.ast) = (yyvsp[-1].ast);
	}
#line 8128 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 656: /* basic_expr: '(' expr ':' expr ':' expr ')'  */
#line 3324 "frontends/verilog/verilog_parser.y"
                                       {
		delete (yyvsp[-5].ast);
		(yyval.ast) = (yyvsp[-3].ast);
		delete (yyvsp[-1].ast);
	}
#line 8138 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 657: /* basic_expr: '{' concat_list '}'  */
#line 3329 "frontends/verilog/verilog_parser.y"
                            {
		(yyval.ast) = (yyvsp[-1].ast);
	}
#line 8146 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 658: /* basic_expr: '{' expr '{' concat_list '}' '}'  */
#line 3332 "frontends/verilog/verilog_parser.y"
                                         {
		(yyval.ast) = new AstNode(AST_REPLICATE, (yyvsp[-4].ast), (yyvsp[-2].ast));
	}
#line 8154 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 659: /* basic_expr: '~' attr basic_expr  */
#line 3335 "frontends/verilog/verilog_parser.y"
                                            {
		(yyval.ast) = new AstNode(AST_BIT_NOT, (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-2]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8164 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 660: /* basic_expr: basic_expr '&' attr basic_expr  */
#line 3340 "frontends/verilog/verilog_parser.y"
                                       {
		(yyval.ast) = new AstNode(AST_BIT_AND, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8174 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 661: /* basic_expr: basic_expr OP_NAND attr basic_expr  */
#line 3345 "frontends/verilog/verilog_parser.y"
                                           {
		(yyval.ast) = new AstNode(AST_BIT_NOT, new AstNode(AST_BIT_AND, (yyvsp[-3].ast), (yyvsp[0].ast)));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8184 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 662: /* basic_expr: basic_expr '|' attr basic_expr  */
#line 3350 "frontends/verilog/verilog_parser.y"
                                       {
		(yyval.ast) = new AstNode(AST_BIT_OR, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8194 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 663: /* basic_expr: basic_expr OP_NOR attr basic_expr  */
#line 3355 "frontends/verilog/verilog_parser.y"
                                          {
		(yyval.ast) = new AstNode(AST_BIT_NOT, new AstNode(AST_BIT_OR, (yyvsp[-3].ast), (yyvsp[0].ast)));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8204 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 664: /* basic_expr: basic_expr '^' attr basic_expr  */
#line 3360 "frontends/verilog/verilog_parser.y"
                                       {
		(yyval.ast) = new AstNode(AST_BIT_XOR, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8214 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 665: /* basic_expr: basic_expr OP_XNOR attr basic_expr  */
#line 3365 "frontends/verilog/verilog_parser.y"
                                           {
		(yyval.ast) = new AstNode(AST_BIT_XNOR, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8224 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 666: /* basic_expr: '&' attr basic_expr  */
#line 3370 "frontends/verilog/verilog_parser.y"
                                            {
		(yyval.ast) = new AstNode(AST_REDUCE_AND, (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-2]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8234 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 667: /* basic_expr: OP_NAND attr basic_expr  */
#line 3375 "frontends/verilog/verilog_parser.y"
                                                {
		(yyval.ast) = new AstNode(AST_REDUCE_AND, (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-2]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
		(yyval.ast) = new AstNode(AST_LOGIC_NOT, (yyval.ast));
	}
#line 8245 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 668: /* basic_expr: '|' attr basic_expr  */
#line 3381 "frontends/verilog/verilog_parser.y"
                                            {
		(yyval.ast) = new AstNode(AST_REDUCE_OR, (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-2]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8255 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 669: /* basic_expr: OP_NOR attr basic_expr  */
#line 3386 "frontends/verilog/verilog_parser.y"
                                               {
		(yyval.ast) = new AstNode(AST_REDUCE_OR, (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-2]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
		(yyval.ast) = new AstNode(AST_LOGIC_NOT, (yyval.ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-2]), (yylsp[0]));
	}
#line 8267 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 670: /* basic_expr: '^' attr basic_expr  */
#line 3393 "frontends/verilog/verilog_parser.y"
                                            {
		(yyval.ast) = new AstNode(AST_REDUCE_XOR, (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-2]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8277 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 671: /* basic_expr: OP_XNOR attr basic_expr  */
#line 3398 "frontends/verilog/verilog_parser.y"
                                                {
		(yyval.ast) = new AstNode(AST_REDUCE_XNOR, (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-2]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8287 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 672: /* basic_expr: basic_expr OP_SHL attr basic_expr  */
#line 3403 "frontends/verilog/verilog_parser.y"
                                          {
		(yyval.ast) = new AstNode(AST_SHIFT_LEFT, (yyvsp[-3].ast), new AstNode(AST_TO_UNSIGNED, (yyvsp[0].ast)));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8297 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 673: /* basic_expr: basic_expr OP_SHR attr basic_expr  */
#line 3408 "frontends/verilog/verilog_parser.y"
                                          {
		(yyval.ast) = new AstNode(AST_SHIFT_RIGHT, (yyvsp[-3].ast), new AstNode(AST_TO_UNSIGNED, (yyvsp[0].ast)));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8307 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 674: /* basic_expr: basic_expr OP_SSHL attr basic_expr  */
#line 3413 "frontends/verilog/verilog_parser.y"
                                           {
		(yyval.ast) = new AstNode(AST_SHIFT_SLEFT, (yyvsp[-3].ast), new AstNode(AST_TO_UNSIGNED, (yyvsp[0].ast)));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8317 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 675: /* basic_expr: basic_expr OP_SSHR attr basic_expr  */
#line 3418 "frontends/verilog/verilog_parser.y"
                                           {
		(yyval.ast) = new AstNode(AST_SHIFT_SRIGHT, (yyvsp[-3].ast), new AstNode(AST_TO_UNSIGNED, (yyvsp[0].ast)));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8327 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 676: /* basic_expr: basic_expr '<' attr basic_expr  */
#line 3423 "frontends/verilog/verilog_parser.y"
                                       {
		(yyval.ast) = new AstNode(AST_LT, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8337 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 677: /* basic_expr: basic_expr OP_LE attr basic_expr  */
#line 3428 "frontends/verilog/verilog_parser.y"
                                         {
		(yyval.ast) = new AstNode(AST_LE, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8347 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 678: /* basic_expr: basic_expr OP_EQ attr basic_expr  */
#line 3433 "frontends/verilog/verilog_parser.y"
                                         {
		(yyval.ast) = new AstNode(AST_EQ, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8357 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 679: /* basic_expr: basic_expr OP_NE attr basic_expr  */
#line 3438 "frontends/verilog/verilog_parser.y"
                                         {
		(yyval.ast) = new AstNode(AST_NE, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8367 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 680: /* basic_expr: basic_expr OP_EQX attr basic_expr  */
#line 3443 "frontends/verilog/verilog_parser.y"
                                          {
		(yyval.ast) = new AstNode(AST_EQX, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8377 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 681: /* basic_expr: basic_expr OP_NEX attr basic_expr  */
#line 3448 "frontends/verilog/verilog_parser.y"
                                          {
		(yyval.ast) = new AstNode(AST_NEX, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8387 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 682: /* basic_expr: basic_expr OP_GE attr basic_expr  */
#line 3453 "frontends/verilog/verilog_parser.y"
                                         {
		(yyval.ast) = new AstNode(AST_GE, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8397 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 683: /* basic_expr: basic_expr '>' attr basic_expr  */
#line 3458 "frontends/verilog/verilog_parser.y"
                                       {
		(yyval.ast) = new AstNode(AST_GT, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8407 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 684: /* basic_expr: basic_expr '+' attr basic_expr  */
#line 3463 "frontends/verilog/verilog_parser.y"
                                       {
		(yyval.ast) = new AstNode(AST_ADD, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8417 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 685: /* basic_expr: basic_expr '-' attr basic_expr  */
#line 3468 "frontends/verilog/verilog_parser.y"
                                       {
		(yyval.ast) = new AstNode(AST_SUB, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8427 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 686: /* basic_expr: basic_expr '*' attr basic_expr  */
#line 3473 "frontends/verilog/verilog_parser.y"
                                       {
		(yyval.ast) = new AstNode(AST_MUL, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8437 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 687: /* basic_expr: basic_expr '/' attr basic_expr  */
#line 3478 "frontends/verilog/verilog_parser.y"
                                       {
		(yyval.ast) = new AstNode(AST_DIV, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8447 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 688: /* basic_expr: basic_expr '%' attr basic_expr  */
#line 3483 "frontends/verilog/verilog_parser.y"
                                       {
		(yyval.ast) = new AstNode(AST_MOD, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8457 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 689: /* basic_expr: basic_expr OP_POW attr basic_expr  */
#line 3488 "frontends/verilog/verilog_parser.y"
                                          {
		(yyval.ast) = new AstNode(AST_POW, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8467 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 690: /* basic_expr: '+' attr basic_expr  */
#line 3493 "frontends/verilog/verilog_parser.y"
                                            {
		(yyval.ast) = new AstNode(AST_POS, (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-2]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8477 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 691: /* basic_expr: '-' attr basic_expr  */
#line 3498 "frontends/verilog/verilog_parser.y"
                                            {
		(yyval.ast) = new AstNode(AST_NEG, (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-2]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8487 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 692: /* basic_expr: basic_expr OP_LAND attr basic_expr  */
#line 3503 "frontends/verilog/verilog_parser.y"
                                           {
		(yyval.ast) = new AstNode(AST_LOGIC_AND, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8497 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 693: /* basic_expr: basic_expr OP_LOR attr basic_expr  */
#line 3508 "frontends/verilog/verilog_parser.y"
                                          {
		(yyval.ast) = new AstNode(AST_LOGIC_OR, (yyvsp[-3].ast), (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-3]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8507 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 694: /* basic_expr: '!' attr basic_expr  */
#line 3513 "frontends/verilog/verilog_parser.y"
                                            {
		(yyval.ast) = new AstNode(AST_LOGIC_NOT, (yyvsp[0].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-2]), (yylsp[0]));
		append_attr((yyval.ast), (yyvsp[-1].al));
	}
#line 8517 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 695: /* basic_expr: TOK_SIGNED OP_CAST '(' expr ')'  */
#line 3518 "frontends/verilog/verilog_parser.y"
                                        {
		if (!sv_mode)
			frontend_verilog_yyerror("Static cast is only supported in SystemVerilog mode.");
		(yyval.ast) = new AstNode(AST_TO_SIGNED, (yyvsp[-1].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-4]), (yylsp[-1]));
	}
#line 8528 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 696: /* basic_expr: TOK_UNSIGNED OP_CAST '(' expr ')'  */
#line 3524 "frontends/verilog/verilog_parser.y"
                                          {
		if (!sv_mode)
			frontend_verilog_yyerror("Static cast is only supported in SystemVerilog mode.");
		(yyval.ast) = new AstNode(AST_TO_UNSIGNED, (yyvsp[-1].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-4]), (yylsp[-1]));
	}
#line 8539 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 697: /* basic_expr: basic_expr OP_CAST '(' expr ')'  */
#line 3530 "frontends/verilog/verilog_parser.y"
                                        {
		if (!sv_mode)
			frontend_verilog_yyerror("Static cast is only supported in SystemVerilog mode.");
		(yyval.ast) = new AstNode(AST_CAST_SIZE, (yyvsp[-4].ast), (yyvsp[-1].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-4]), (yylsp[-1]));
	}
#line 8550 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 698: /* basic_expr: typedef_base_type OP_CAST '(' expr ')'  */
#line 3536 "frontends/verilog/verilog_parser.y"
                                               {
		if (!sv_mode)
			frontend_verilog_yyerror("Static cast is only supported in SystemVerilog mode.");
		(yyval.ast) = new AstNode(AST_CAST_SIZE, (yyvsp[-4].ast), (yyvsp[-1].ast));
		SET_AST_NODE_LOC((yyval.ast), (yylsp[-4]), (yylsp[-1]));
	}
#line 8561 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 699: /* basic_expr: '(' expr '=' expr ')'  */
#line 3542 "frontends/verilog/verilog_parser.y"
                              {
		ensureAsgnExprAllowed();
		AstNode *node = new AstNode(AST_ASSIGN_EQ, (yyvsp[-3].ast), (yyvsp[-1].ast));
		ast_stack.back()->children.push_back(node);
		SET_AST_NODE_LOC(node, (yylsp[-3]), (yylsp[-1]));
		(yyval.ast) = (yyvsp[-3].ast)->clone();
	}
#line 8573 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 700: /* basic_expr: '(' expr asgn_binop expr ')'  */
#line 3549 "frontends/verilog/verilog_parser.y"
                                     {
		ensureAsgnExprAllowed();
		(yyval.ast) = addAsgnBinopStmt(nullptr, (yyvsp[-3].ast), (yyvsp[-2].ast_node_type), (yyvsp[-1].ast), (yylsp[-3]), (yylsp[-1]))-> clone();
	}
#line 8582 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 701: /* concat_list: expr  */
#line 3555 "frontends/verilog/verilog_parser.y"
             {
		(yyval.ast) = new AstNode(AST_CONCAT, (yyvsp[0].ast));
	}
#line 8590 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 702: /* concat_list: expr ',' concat_list  */
#line 3558 "frontends/verilog/verilog_parser.y"
                             {
		(yyval.ast) = (yyvsp[0].ast);
		(yyval.ast)->children.push_back((yyvsp[-2].ast));
	}
#line 8599 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 703: /* integral_number: TOK_CONSTVAL  */
#line 3564 "frontends/verilog/verilog_parser.y"
                     { (yyval.string) = (yyvsp[0].string); }
#line 8605 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 704: /* integral_number: TOK_UNBASED_UNSIZED_CONSTVAL  */
#line 3565 "frontends/verilog/verilog_parser.y"
                                     { (yyval.string) = (yyvsp[0].string); }
#line 8611 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 705: /* integral_number: TOK_BASE TOK_BASED_CONSTVAL  */
#line 3566 "frontends/verilog/verilog_parser.y"
                                    {
		(yyvsp[-1].string)->append(*(yyvsp[0].string));
		(yyval.string) = (yyvsp[-1].string);
		delete (yyvsp[0].string);
	}
#line 8621 "frontends/verilog/verilog_parser.tab.cc"
    break;

  case 706: /* integral_number: TOK_CONSTVAL TOK_BASE TOK_BASED_CONSTVAL  */
#line 3571 "frontends/verilog/verilog_parser.y"
                                                 {
		(yyvsp[-2].string)->append(*(yyvsp[-1].string)).append(*(yyvsp[0].string));
		(yyval.string) = (yyvsp[-2].string);
		delete (yyvsp[-1].string);
		delete (yyvsp[0].string);
	}
#line 8632 "frontends/verilog/verilog_parser.tab.cc"
    break;


#line 8636 "frontends/verilog/verilog_parser.tab.cc"

        default: break;
      }
    if (yychar_backup != yychar)
      YY_LAC_DISCARD ("yychar change");
  }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == FRONTEND_VERILOG_YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yyesa, &yyes, &yyes_capacity, yytoken, &yylloc};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        if (yychar != FRONTEND_VERILOG_YYEMPTY)
          YY_LAC_ESTABLISH;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= FRONTEND_VERILOG_YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == FRONTEND_VERILOG_YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc);
          yychar = FRONTEND_VERILOG_YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  /* If the stack popping above didn't lose the initial context for the
     current lookahead token, the shift below will for sure.  */
  YY_LAC_DISCARD ("error recovery");

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != FRONTEND_VERILOG_YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yyes != yyesa)
    YYSTACK_FREE (yyes);
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

