/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import java.util.ListIterator;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.StrutBox;

class VerticalBox
extends Box {
    private float leftMostPos = Float.MAX_VALUE;
    private float rightMostPos = -3.4028235E38f;

    public VerticalBox() {
    }

    public VerticalBox(Box b, float rest, int alignment) {
        this();
        this.add(b);
        if (alignment == 2) {
            StrutBox s = new StrutBox(0.0f, rest / 2.0f, 0.0f, 0.0f);
            super.add(0, s);
            this.height += rest / 2.0f;
            this.depth += rest / 2.0f;
            super.add(s);
        } else if (alignment == 3) {
            this.depth += rest;
            super.add(new StrutBox(0.0f, rest, 0.0f, 0.0f));
        } else if (alignment == 4) {
            this.height += rest;
            super.add(0, new StrutBox(0.0f, rest, 0.0f, 0.0f));
        }
    }

    @Override
    public final void add(Box b) {
        super.add(b);
        if (this.children.size() == 1) {
            this.height = b.height;
            this.depth = b.depth;
        } else {
            this.depth += b.height + b.depth;
        }
        this.recalculateWidth(b);
    }

    public final void add(Box b, float interline) {
        if (this.children.size() >= 1) {
            this.add(new StrutBox(0.0f, interline, 0.0f, 0.0f));
        }
        this.add(b);
    }

    private void recalculateWidth(Box b) {
        this.leftMostPos = Math.min(this.leftMostPos, b.shift);
        this.rightMostPos = Math.max(this.rightMostPos, b.shift + (b.width > 0.0f ? b.width : 0.0f));
        this.width = this.rightMostPos - this.leftMostPos;
    }

    @Override
    public void add(int pos, Box b) {
        super.add(pos, b);
        if (pos == 0) {
            this.depth += b.depth + this.height;
            this.height = b.height;
        } else {
            this.depth += b.height + b.depth;
        }
        this.recalculateWidth(b);
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        float yPos = y - this.height;
        for (Box b : this.children) {
            b.draw(g2, x + b.getShift() - this.leftMostPos, yPos += b.getHeight());
            yPos += b.getDepth();
        }
    }

    public int getSize() {
        return this.children.size();
    }

    @Override
    public int getLastFontId() {
        int fontId = -1;
        ListIterator it = this.children.listIterator(this.children.size());
        while (fontId == -1 && it.hasPrevious()) {
            fontId = ((Box)it.previous()).getLastFontId();
        }
        return fontId;
    }
}

