/*
    Copyright (C) 2008 Nikolas Zimmermann <zimmermann@kde.org>
    Copyright (C) 2008 Jens-Michael Hoffmann <jensmh@gmx.de>

    This file is part of the KDE project

    This library is free software you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    aint with this library see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef GeoDocument_h
#define GeoDocument_h


// Set to a value greater than 0, to enable leak tracking of GeoNode objects
// Set to a value greater than 1, to enable detailed tracking of construction/destruction of GeoNode objects
#define DUMP_GEONODE_LEAKS 1


#include "geodata_export.h"

/**
 * @short A shared base class between GeoDataDocument/GeoSourceDocument
 */
class GEODATA_EXPORT GeoDocument {
protected:
    GeoDocument();

public:
#if DUMP_GEONODE_LEAKS > 0
    static unsigned long s_leakProtector;
#endif

    virtual ~GeoDocument();

    virtual bool isGeoDataDocument() const;
    virtual bool isGeoSceneDocument() const;
};

/**
 * @short A shared base class for all classes that are mapped to a specifig tag (ie. GeoFolder)
 */
class GEODATA_EXPORT GeoNode {
protected:
    GeoNode();
    virtual ~GeoNode();
};

#endif // GeoDocument_h
