/* ============================================================
 *
 * This file is a part of digiKam project
 * https://www.digikam.org
 *
 * Date        : 2018-07-30
 * Description : a plugin to export items to web-services (unified version).
 *
 * SPDX-FileCopyrightText: 2018-2022 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * ============================================================ */

#ifndef DIGIKAM_UNIFIED_PLUGIN_H
#define DIGIKAM_UNIFIED_PLUGIN_H

// Local includes

#include "dplugingeneric.h"

// Local includes

#include "wswizard.h"

#define DPLUGIN_IID "org.kde.digikam.plugin.generic.Unified"

using namespace Digikam;

namespace DigikamGenericUnifiedPlugin
{

class UnifiedPlugin : public DPluginGeneric
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID DPLUGIN_IID)
    Q_INTERFACES(Digikam::DPluginGeneric)

public:

    explicit UnifiedPlugin(QObject* const parent = 0);
    ~UnifiedPlugin()                     override;

    QString name()                 const override;
    QString iid()                  const override;
    QIcon   icon()                 const override;
    QString details()              const override;
    QString description()          const override;
    QList<DPluginAuthor> authors() const override;

    void setup(QObject* const)           override;
    void cleanUp()                       override;

private Q_SLOTS:

    void slotUnified();

private:

    QPointer<WSWizard> m_toolDlg;
};

} // namespace DigikamGenericUnifiedPlugin

#endif // DIGIKAM_UNIFIED_PLUGIN_H
