/* h_etc_ishangul.c  --  ڵ尡 ѱ ù° Ʈ ° Ʈ
                  Ǵ   Ǻϴ ƾ          

					mady by Han dong hun ..1997.1.18                */

#include <stdio.h>
#include <string.h>
#include "hangul.h"

int	ishangul(byte *str, int index) {
	int state;
	int inMode;
	int key;
	int i = 0;
	
	if (strlen(str) < index + 1) return -1;
	state = IS_ENGLISH;

	while ((key = *(str + i)) != '\0') {
		if (key < 128) inMode = IS_LOW_ASC;
		else inMode = IS_HIGH_ASC;

		switch (state) {
			case IS_ENGLISH :
				if (inMode) state = IS_HANGUL_FIRST;
					else state = IS_ENGLISH;
				break;
			case IS_HANGUL_FIRST :
				state = IS_HANGUL_SECOND;
				break;
			case IS_HANGUL_SECOND	:
				if (inMode) state = IS_HANGUL_FIRST;
					else state = IS_ENGLISH;
				break;
		}
		if (i++ == index) break;
	}
	return state;
}
