#include <stdio.h>
#include "hangul.h"

int hputch(int ch) {
	byte *image;

	if (ch < 128 && ch >= 32) {
		image = get_eng_image(ch);
		image = eng_bit_image(image, GL_FG_COLOR, GL_BG_COLOR);
		eng_image_view(GL_X_POSITION, GL_Y_POSITION, image);
		GL_X_POSITION += 8;
		return 1;
	}
	else if (ch > 0x8000) {
		image = get_han_image(ch >> 8, ch & 0xFF);
		image = han_bit_image(image, GL_FG_COLOR, GL_BG_COLOR);
		han_image_view(GL_X_POSITION, GL_Y_POSITION, image);
		GL_X_POSITION += 16;
		return 2;
	}
	else return 0;
}
