/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SizeRequirements;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BRView;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.CommentView;
import javax.swing.text.html.FormView;
import javax.swing.text.html.FrameSetView;
import javax.swing.text.html.FrameView;
import javax.swing.text.html.HRuleView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.HTMLWriter;
import javax.swing.text.html.HiddenTagView;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.IsindexView;
import javax.swing.text.html.LineView;
import javax.swing.text.html.ListView;
import javax.swing.text.html.Map;
import javax.swing.text.html.MinimalHTMLWriter;
import javax.swing.text.html.NoFramesView;
import javax.swing.text.html.ObjectView;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.TableView;

public class HTMLEditorKit
extends StyledEditorKit {
    public static final String DEFAULT_CSS = "default.css";
    private static final Cursor MoveCursor = Cursor.getPredefinedCursor(12);
    private static final Cursor DefaultCursor = Cursor.getPredefinedCursor(0);
    private static final ViewFactory defaultFactory = new HTMLFactory();
    MutableAttributeSet input;
    private static StyleSheet defaultStyles = null;
    private LinkController linkHandler = new LinkController();
    private static Parser defaultParser = null;
    private Cursor defaultCursor = DefaultCursor;
    private Cursor linkCursor = MoveCursor;
    public static final String BOLD_ACTION = "html-bold-action";
    public static final String ITALIC_ACTION = "html-italic-action";
    public static final String PARA_INDENT_LEFT = "html-para-indent-left";
    public static final String PARA_INDENT_RIGHT = "html-para-indent-right";
    public static final String FONT_CHANGE_BIGGER = "html-font-bigger";
    public static final String FONT_CHANGE_SMALLER = "html-font-smaller";
    public static final String COLOR_ACTION = "html-color-action";
    public static final String LOGICAL_STYLE_ACTION = "html-logical-style-action";
    public static final String IMG_ALIGN_TOP = "html-image-align-top";
    public static final String IMG_ALIGN_MIDDLE = "html-image-align-middle";
    public static final String IMG_ALIGN_BOTTOM = "html-image-align-bottom";
    public static final String IMG_BORDER = "html-image-border";
    private static final String INSERT_TABLE_HTML = "<table border=1><tr><td></td></tr></table>";
    private static final String INSERT_UL_HTML = "<ul><li></li></ul>";
    private static final String INSERT_OL_HTML = "<ol><li></li></ol>";
    private static final String INSERT_HR_HTML = "<hr>";
    private static final String INSERT_PRE_HTML = "<pre></pre>";
    private static final Action[] defaultActions = new Action[]{new InsertHTMLTextAction("InsertTable", "<table border=1><tr><td></td></tr></table>", HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableRow", "<table border=1><tr><td></td></tr></table>", HTML.Tag.TABLE, HTML.Tag.TR, HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableDataCell", "<table border=1><tr><td></td></tr></table>", HTML.Tag.TR, HTML.Tag.TD, HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertUnorderedList", "<ul><li></li></ul>", HTML.Tag.BODY, HTML.Tag.UL), new InsertHTMLTextAction("InsertUnorderedListItem", "<ul><li></li></ul>", HTML.Tag.UL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.UL), new InsertHTMLTextAction("InsertOrderedList", "<ol><li></li></ol>", HTML.Tag.BODY, HTML.Tag.OL), new InsertHTMLTextAction("InsertOrderedListItem", "<ol><li></li></ol>", HTML.Tag.OL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.OL), new InsertHRAction(), new InsertHTMLTextAction("InsertPre", "<pre></pre>", HTML.Tag.BODY, HTML.Tag.PRE), new NavigateLinkAction("next-link-action"), new NavigateLinkAction("previous-link-action"), new ActivateLinkAction("activate-link-action")};
    static /* synthetic */ Class class$javax$swing$text$html$HTMLEditorKit;
    static /* synthetic */ Class class$java$lang$String;

    public Object clone() {
        return new HTMLEditorKit();
    }

    public String getContentType() {
        return "text/html";
    }

    public ViewFactory getViewFactory() {
        return defaultFactory;
    }

    public Document createDefaultDocument() {
        StyleSheet styleSheet = this.getStyleSheet();
        StyleSheet styleSheet2 = new StyleSheet();
        styleSheet2.addStyleSheet(styleSheet);
        HTMLDocument hTMLDocument = new HTMLDocument(styleSheet2);
        hTMLDocument.setParser(this.getParser());
        hTMLDocument.setAsynchronousLoadPriority(4);
        hTMLDocument.setTokenThreshold(100);
        return hTMLDocument;
    }

    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        if (document instanceof HTMLDocument) {
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            Parser parser = this.getParser();
            if (parser == null) {
                throw new IOException("Can't load parser");
            }
            if (n > document.getLength()) {
                throw new BadLocationException("Invalid location", n);
            }
            ParserCallback parserCallback = hTMLDocument.getReader(n);
            Boolean bl = (Boolean)document.getProperty("IgnoreCharsetDirective");
            parser.parse(reader, parserCallback, bl == null ? false : bl);
            parserCallback.flush();
        } else {
            super.read(reader, document, n);
        }
    }

    public void insertHTML(HTMLDocument hTMLDocument, int n, String string, int n2, int n3, HTML.Tag tag) throws BadLocationException, IOException {
        Parser parser = this.getParser();
        if (parser == null) {
            throw new IOException("Can't load parser");
        }
        if (n > hTMLDocument.getLength()) {
            throw new BadLocationException("Invalid location", n);
        }
        ParserCallback parserCallback = hTMLDocument.getReader(n, n2, n3, tag);
        Boolean bl = (Boolean)hTMLDocument.getProperty("IgnoreCharsetDirective");
        parser.parse(new StringReader(string), parserCallback, bl == null ? false : bl);
        parserCallback.flush();
    }

    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        if (document instanceof HTMLDocument) {
            HTMLWriter hTMLWriter = new HTMLWriter(writer, (HTMLDocument)document, n, n2);
            hTMLWriter.write();
        } else if (document instanceof StyledDocument) {
            MinimalHTMLWriter minimalHTMLWriter = new MinimalHTMLWriter(writer, (StyledDocument)document, n, n2);
            minimalHTMLWriter.write();
        } else {
            super.write(writer, document, n, n2);
        }
    }

    public void install(JEditorPane jEditorPane) {
        jEditorPane.addMouseListener(this.linkHandler);
        jEditorPane.addMouseMotionListener(this.linkHandler);
        super.install(jEditorPane);
    }

    public void deinstall(JEditorPane jEditorPane) {
        jEditorPane.removeMouseListener(this.linkHandler);
        jEditorPane.removeMouseMotionListener(this.linkHandler);
        super.deinstall(jEditorPane);
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        defaultStyles = styleSheet;
    }

    public StyleSheet getStyleSheet() {
        if (defaultStyles == null) {
            defaultStyles = new StyleSheet();
            try {
                InputStream inputStream = HTMLEditorKit.getResourceAsStream(DEFAULT_CSS);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                defaultStyles.loadRules(bufferedReader, null);
                ((Reader)bufferedReader).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultStyles;
    }

    static InputStream getResourceAsStream(String string) {
        try {
            ClassLoader classLoader = (class$javax$swing$text$html$HTMLEditorKit == null ? (class$javax$swing$text$html$HTMLEditorKit = HTMLEditorKit.class$("javax.swing.text.html.HTMLEditorKit")) : class$javax$swing$text$html$HTMLEditorKit).getClassLoader();
            Class clazz = classLoader != null ? classLoader.loadClass("javax.swing.text.html.ResourceLoader") : Class.forName("javax.swing.text.html.ResourceLoader");
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = HTMLEditorKit.class$("java.lang.String")) : class$java$lang$String};
            Method method = clazz.getMethod("getResourceAsStream", classArray);
            Object[] objectArray = new String[]{string};
            return (InputStream)method.invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            return (class$javax$swing$text$html$HTMLEditorKit == null ? (class$javax$swing$text$html$HTMLEditorKit = HTMLEditorKit.class$("javax.swing.text.html.HTMLEditorKit")) : class$javax$swing$text$html$HTMLEditorKit).getResourceAsStream(string);
        }
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    protected void createInputAttributes(Element element, MutableAttributeSet mutableAttributeSet) {
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        mutableAttributeSet.addAttributes(element.getAttributes());
        mutableAttributeSet.removeAttribute(StyleConstants.ComposedTextAttribute);
        Object object = mutableAttributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            if (tag == HTML.Tag.IMG) {
                mutableAttributeSet.removeAttribute(HTML.Attribute.SRC);
                mutableAttributeSet.removeAttribute(HTML.Attribute.HEIGHT);
                mutableAttributeSet.removeAttribute(HTML.Attribute.WIDTH);
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            } else if (tag == HTML.Tag.HR || tag == HTML.Tag.BR) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            } else if (tag == HTML.Tag.COMMENT) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                mutableAttributeSet.removeAttribute(HTML.Attribute.COMMENT);
            } else if (tag == HTML.Tag.INPUT) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                mutableAttributeSet.removeAttribute(HTML.Tag.INPUT);
            } else if (tag instanceof HTML.UnknownTag) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                mutableAttributeSet.removeAttribute(HTML.Attribute.ENDTAG);
            }
        }
    }

    public MutableAttributeSet getInputAttributes() {
        if (this.input == null) {
            this.input = this.getStyleSheet().addStyle(null, null);
        }
        return this.input;
    }

    public void setDefaultCursor(Cursor cursor) {
        this.defaultCursor = cursor;
    }

    public Cursor getDefaultCursor() {
        return this.defaultCursor;
    }

    public void setLinkCursor(Cursor cursor) {
        this.linkCursor = cursor;
    }

    public Cursor getLinkCursor() {
        return this.linkCursor;
    }

    protected Parser getParser() {
        if (defaultParser == null) {
            try {
                Class clazz = Class.forName("javax.swing.text.html.parser.ParserDelegator");
                defaultParser = (Parser)clazz.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultParser;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ActivateLinkAction
    extends TextAction {
        public ActivateLinkAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Document document;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (!(jTextComponent instanceof JEditorPane)) {
                return;
            }
            JEditorPane jEditorPane = (JEditorPane)jTextComponent;
            if (jEditorPane.isEditable()) {
                return;
            }
            if (jEditorPane != null && (document = jEditorPane.getDocument()) != null) {
                Object object;
                Object object2;
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
                int n = jEditorPane.getCaretPosition();
                Object object3 = null;
                while (iterator.isValid()) {
                    object2 = iterator.getAttributes();
                    if (object2 != null && (object = (String)object2.getAttribute(HTML.Attribute.HREF)) != null && n >= iterator.getStartOffset() && n <= iterator.getEndOffset()) {
                        object3 = object;
                        break;
                    }
                    iterator.next();
                }
                if (object3 != null) {
                    try {
                        object2 = (URL)document.getProperty("stream");
                        object = new URL((URL)object2, (String)object3);
                        HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, (URL)object);
                        jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static class NavigateLinkAction
    extends TextAction {
        FocusHighlightPainter focusPainter = new FocusHighlightPainter(null);
        Object selectionTag;
        boolean focusBack = false;

        public NavigateLinkAction(String string) {
            super(string);
            if ("previous-link-action".equals(string)) {
                this.focusBack = true;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Document document;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent.isEditable()) {
                return;
            }
            if (jTextComponent != null && (document = jTextComponent.getDocument()) != null) {
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
                int n = jTextComponent.getCaretPosition();
                int n2 = 0;
                int n3 = 0;
                while (iterator.isValid()) {
                    String string;
                    AttributeSet attributeSet = iterator.getAttributes();
                    if (attributeSet != null && (string = (String)attributeSet.getAttribute(HTML.Attribute.HREF)) != null) {
                        int n4 = iterator.getStartOffset();
                        if (this.focusBack) {
                            if (n4 >= n) {
                                jTextComponent.setCaretPosition(n2);
                                this.moveCaretPosition(jTextComponent, n2, n3);
                                return;
                            }
                        } else if (n4 > n) {
                            jTextComponent.setCaretPosition(n4);
                            this.moveCaretPosition(jTextComponent, n4, iterator.getEndOffset());
                            return;
                        }
                    }
                    n2 = iterator.getStartOffset();
                    n3 = iterator.getEndOffset();
                    iterator.next();
                }
            }
        }

        private void moveCaretPosition(JTextComponent jTextComponent, int n, int n2) {
            Highlighter highlighter = jTextComponent.getHighlighter();
            if (highlighter != null) {
                int n3 = Math.min(n2, n);
                int n4 = Math.max(n2, n);
                try {
                    if (this.selectionTag != null) {
                        highlighter.changeHighlight(this.selectionTag, n3, n4);
                    } else {
                        FocusHighlightPainter focusHighlightPainter = this.focusPainter;
                        this.selectionTag = highlighter.addHighlight(n3, n4, focusHighlightPainter);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        class FocusHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            FocusHighlightPainter(Color color) {
                super(color);
            }

            public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
                Color color = this.getColor();
                if (color == null) {
                    graphics.setColor(jTextComponent.getSelectionColor());
                } else {
                    graphics.setColor(color);
                }
                if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
                    Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    return rectangle;
                }
                try {
                    Shape shape2 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                    Rectangle rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                    graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                    return rectangle;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
        }
    }

    static class InsertHRAction
    extends InsertHTMLTextAction {
        InsertHRAction() {
            super("InsertHR", HTMLEditorKit.INSERT_HR_HTML, null, HTML.Tag.IMPLIED, null, null, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            HTMLDocument hTMLDocument;
            Element element;
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null && (element = (hTMLDocument = this.getHTMLDocument(jEditorPane)).getParagraphElement(n = jEditorPane.getSelectionStart())).getParentElement() != null) {
                this.parentTag = (HTML.Tag)element.getParentElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
                super.actionPerformed(actionEvent);
            }
        }
    }

    public static class InsertHTMLTextAction
    extends HTMLTextAction {
        protected String html;
        protected HTML.Tag parentTag;
        protected HTML.Tag addTag;
        protected HTML.Tag alternateParentTag;
        protected HTML.Tag alternateAddTag;
        boolean adjustSelection;

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2) {
            this(string, string2, tag, tag2, null, null);
        }

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2, HTML.Tag tag3, HTML.Tag tag4) {
            this(string, string2, tag, tag2, tag3, tag4, true);
        }

        InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2, HTML.Tag tag3, HTML.Tag tag4, boolean bl) {
            super(string);
            this.html = string2;
            this.parentTag = tag;
            this.addTag = tag2;
            this.alternateParentTag = tag3;
            this.alternateAddTag = tag4;
            this.adjustSelection = bl;
        }

        protected void insertHTML(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, String string, int n2, int n3, HTML.Tag tag) {
            try {
                this.getHTMLEditorKit(jEditorPane).insertHTML(hTMLDocument, n, string, n2, n3, tag);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to insert: " + iOException);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException("Unable to insert: " + badLocationException);
            }
        }

        protected void insertAtBoundary(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, Element element, String string, HTML.Tag tag, HTML.Tag tag2) {
            this.insertAtBoundry(jEditorPane, hTMLDocument, n, element, string, tag, tag2);
        }

        protected void insertAtBoundry(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, Element element, String string, HTML.Tag tag, HTML.Tag tag2) {
            Element element2;
            Element element3;
            boolean bl;
            boolean bl2 = bl = n == 0;
            if (n > 0 || element == null) {
                element3 = hTMLDocument.getDefaultRootElement();
                while (element3 != null && element3.getStartOffset() != n && !element3.isLeaf()) {
                    element3 = element3.getElement(element3.getElementIndex(n));
                }
                element2 = element3 != null ? element3.getParentElement() : null;
            } else {
                element2 = element;
            }
            if (element2 != null) {
                int n2 = 0;
                int n3 = 0;
                if (bl && element != null) {
                    element3 = element2;
                    while (element3 != null && !element3.isLeaf()) {
                        element3 = element3.getElement(element3.getElementIndex(n));
                        ++n2;
                    }
                } else {
                    element3 = element2;
                    --n;
                    while (element3 != null && !element3.isLeaf()) {
                        element3 = element3.getElement(element3.getElementIndex(n));
                        ++n2;
                    }
                    element3 = element2;
                    ++n;
                    while (element3 != null && element3 != element) {
                        element3 = element3.getElement(element3.getElementIndex(n));
                        ++n3;
                    }
                }
                n2 = Math.max(0, n2 - 1);
                this.insertHTML(jEditorPane, hTMLDocument, n, string, n2, n3, tag2);
            }
        }

        boolean insertIntoTag(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, HTML.Tag tag, HTML.Tag tag2) {
            int n2;
            Element element = this.findElementMatchingTag(hTMLDocument, n, tag);
            if (element != null && element.getStartOffset() == n) {
                this.insertAtBoundary(jEditorPane, hTMLDocument, n, element, this.html, tag, tag2);
                return true;
            }
            if (n > 0 && (n2 = this.elementCountToTag(hTMLDocument, n - 1, tag)) != -1) {
                this.insertHTML(jEditorPane, hTMLDocument, n, this.html, n2, 0, tag2);
                return true;
            }
            return false;
        }

        void adjustSelection(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, int n2) {
            int n3 = hTMLDocument.getLength();
            if (n3 != n2 && n < n3) {
                if (n > 0) {
                    String string;
                    try {
                        string = hTMLDocument.getText(n - 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        string = null;
                    }
                    if (string != null && string.length() > 0 && string.charAt(0) == '\n') {
                        jEditorPane.select(n, n);
                    } else {
                        jEditorPane.select(n + 1, n + 1);
                    }
                } else {
                    jEditorPane.select(1, 1);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                HTMLDocument hTMLDocument = this.getHTMLDocument(jEditorPane);
                int n = jEditorPane.getSelectionStart();
                int n2 = hTMLDocument.getLength();
                boolean bl = !this.insertIntoTag(jEditorPane, hTMLDocument, n, this.parentTag, this.addTag) && this.alternateParentTag != null ? this.insertIntoTag(jEditorPane, hTMLDocument, n, this.alternateParentTag, this.alternateAddTag) : true;
                if (this.adjustSelection && bl) {
                    this.adjustSelection(jEditorPane, hTMLDocument, n, n2);
                }
            }
        }
    }

    public static abstract class HTMLTextAction
    extends StyledEditorKit.StyledTextAction {
        public HTMLTextAction(String string) {
            super(string);
        }

        protected HTMLDocument getHTMLDocument(JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            if (document instanceof HTMLDocument) {
                return (HTMLDocument)document;
            }
            throw new IllegalArgumentException("document must be HTMLDocument");
        }

        protected HTMLEditorKit getHTMLEditorKit(JEditorPane jEditorPane) {
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit instanceof HTMLEditorKit) {
                return (HTMLEditorKit)editorKit;
            }
            throw new IllegalArgumentException("EditorKit must be HTMLEditorKit");
        }

        protected Element[] getElementsAt(HTMLDocument hTMLDocument, int n) {
            return this.getElementsAt(hTMLDocument.getDefaultRootElement(), n, 0);
        }

        private Element[] getElementsAt(Element element, int n, int n2) {
            if (element.isLeaf()) {
                Element[] elementArray = new Element[n2 + 1];
                elementArray[n2] = element;
                return elementArray;
            }
            Element[] elementArray = this.getElementsAt(element.getElement(element.getElementIndex(n)), n, n2 + 1);
            elementArray[n2] = element;
            return elementArray;
        }

        protected int elementCountToTag(HTMLDocument hTMLDocument, int n, HTML.Tag tag) {
            int n2 = -1;
            Element element = hTMLDocument.getCharacterElement(n);
            while (element != null && element.getAttributes().getAttribute(StyleConstants.NameAttribute) != tag) {
                element = element.getParentElement();
                ++n2;
            }
            if (element == null) {
                return -1;
            }
            return n2;
        }

        protected Element findElementMatchingTag(HTMLDocument hTMLDocument, int n, HTML.Tag tag) {
            Element element = hTMLDocument.getDefaultRootElement();
            Element element2 = null;
            while (element != null) {
                if (element.getAttributes().getAttribute(StyleConstants.NameAttribute) == tag) {
                    element2 = element;
                }
                element = element.getElement(element.getElementIndex(n));
            }
            return element2;
        }
    }

    public static class HTMLFactory
    implements ViewFactory {
        public View create(Element element) {
            Object object;
            Object object2 = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (object2 instanceof HTML.Tag) {
                object = (HTML.Tag)object2;
                if (object == HTML.Tag.CONTENT) {
                    return new InlineView(element);
                }
                if (object == HTML.Tag.IMPLIED) {
                    String string = (String)element.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                    if (string != null && string.equals("pre")) {
                        return new LineView(element);
                    }
                    return new ParagraphView(element);
                }
                if (object == HTML.Tag.P || object == HTML.Tag.H1 || object == HTML.Tag.H2 || object == HTML.Tag.H3 || object == HTML.Tag.H4 || object == HTML.Tag.H5 || object == HTML.Tag.H6 || object == HTML.Tag.DT) {
                    return new ParagraphView(element);
                }
                if (object == HTML.Tag.MENU || object == HTML.Tag.DIR || object == HTML.Tag.UL || object == HTML.Tag.OL) {
                    return new ListView(element);
                }
                if (object == HTML.Tag.BODY) {
                    return new BlockView(this, element, 1){
                        private final /* synthetic */ HTMLFactory this$0;
                        {
                            this.this$0 = hTMLFactory;
                        }

                        protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
                            sizeRequirements = super.calculateMajorAxisRequirements(n, sizeRequirements);
                            sizeRequirements.maximum = Integer.MAX_VALUE;
                            return sizeRequirements;
                        }
                    };
                }
                if (object == HTML.Tag.HTML) {
                    return new BlockView(element, 1);
                }
                if (object == HTML.Tag.LI || object == HTML.Tag.CENTER || object == HTML.Tag.DL || object == HTML.Tag.DD || object == HTML.Tag.DIV || object == HTML.Tag.BLOCKQUOTE || object == HTML.Tag.PRE) {
                    return new BlockView(element, 1);
                }
                if (object == HTML.Tag.NOFRAMES) {
                    return new NoFramesView(element, 1);
                }
                if (object == HTML.Tag.IMG) {
                    return new ImageView(element);
                }
                if (object == HTML.Tag.ISINDEX) {
                    return new IsindexView(element);
                }
                if (object == HTML.Tag.HR) {
                    return new HRuleView(element);
                }
                if (object == HTML.Tag.BR) {
                    return new BRView(element);
                }
                if (object == HTML.Tag.TABLE) {
                    return new TableView(element);
                }
                if (object == HTML.Tag.INPUT || object == HTML.Tag.SELECT || object == HTML.Tag.TEXTAREA) {
                    return new FormView(element);
                }
                if (object == HTML.Tag.OBJECT) {
                    return new ObjectView(element);
                }
                if (object == HTML.Tag.FRAMESET) {
                    if (element.getAttributes().isDefined(HTML.Attribute.ROWS)) {
                        return new FrameSetView(element, 1);
                    }
                    if (element.getAttributes().isDefined(HTML.Attribute.COLS)) {
                        return new FrameSetView(element, 0);
                    }
                    throw new Error("Can't build a" + object + ", " + element + ":" + "no ROWS or COLS defined.");
                }
                if (object == HTML.Tag.FRAME) {
                    return new FrameView(element);
                }
                if (object instanceof HTML.UnknownTag) {
                    return new HiddenTagView(element);
                }
                if (object == HTML.Tag.COMMENT) {
                    return new CommentView(element);
                }
                if (object == HTML.Tag.HEAD) {
                    return new BlockView(this, element, 0){
                        private final /* synthetic */ HTMLFactory this$0;
                        {
                            this.this$0 = hTMLFactory;
                        }

                        public float getPreferredSpan(int n) {
                            return 0.0f;
                        }

                        public float getMinimumSpan(int n) {
                            return 0.0f;
                        }

                        public float getMaximumSpan(int n) {
                            return 0.0f;
                        }

                        protected void loadChildren(ViewFactory viewFactory) {
                        }

                        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) {
                            return this.getElement().getEndOffset();
                        }
                    };
                }
                if (object == HTML.Tag.TITLE || object == HTML.Tag.META || object == HTML.Tag.LINK || object == HTML.Tag.STYLE || object == HTML.Tag.SCRIPT || object == HTML.Tag.AREA || object == HTML.Tag.MAP || object == HTML.Tag.PARAM || object == HTML.Tag.APPLET) {
                    return new HiddenTagView(element);
                }
            }
            if ((object = element.getName()) != null) {
                if (((String)object).equals("content")) {
                    return new LabelView(element);
                }
                if (((String)object).equals("paragraph")) {
                    return new ParagraphView(element);
                }
                if (((String)object).equals("section")) {
                    return new BoxView(element, 1);
                }
                if (((String)object).equals("component")) {
                    return new ComponentView(element);
                }
                if (((String)object).equals("icon")) {
                    return new IconView(element);
                }
            }
            return new LabelView(element);
        }
    }

    public static class ParserCallback {
        public static final Object IMPLIED = "_implied_";

        public void flush() throws BadLocationException {
        }

        public void handleText(char[] cArray, int n) {
        }

        public void handleComment(char[] cArray, int n) {
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleEndTag(HTML.Tag tag, int n) {
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleError(String string, int n) {
        }

        public void handleEndOfLineString(String string) {
        }
    }

    public static abstract class Parser {
        public abstract void parse(Reader var1, ParserCallback var2, boolean var3) throws IOException;
    }

    public static class LinkController
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        private Element curElem = null;
        private String href = null;
        private Position.Bias[] bias = new Position.Bias[1];

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point;
            int n;
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            if (!jEditorPane.isEditable() && (n = jEditorPane.viewToModel(point = new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0) {
                this.activateLink(n, jEditorPane, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
            boolean bl = true;
            Cursor cursor = hTMLEditorKit.getDefaultCursor();
            if (!jEditorPane.isEditable()) {
                Document document;
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                int n = jEditorPane.getUI().viewToModel(jEditorPane, point, this.bias);
                if (this.bias[0] == Position.Bias.Backward && n > 0) {
                    --n;
                }
                if (n >= 0 && (document = jEditorPane.getDocument()) instanceof HTMLDocument) {
                    HTMLDocument hTMLDocument = (HTMLDocument)document;
                    Element element = hTMLDocument.getCharacterElement(n);
                    if (this.curElem != element) {
                        String string;
                        this.curElem = element;
                        AttributeSet attributeSet = element.getAttributes();
                        AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                        String string2 = string = attributeSet2 != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null;
                        if (string != this.href) {
                            this.fireEvents(jEditorPane, hTMLDocument, string);
                            this.href = string;
                            if (string != null) {
                                cursor = hTMLEditorKit.getLinkCursor();
                            }
                        }
                    } else {
                        bl = false;
                    }
                }
            }
            if (bl && jEditorPane.getCursor() != cursor) {
                jEditorPane.setCursor(cursor);
            }
        }

        protected void activateLink(int n, JEditorPane jEditorPane) {
            this.activateLink(n, jEditorPane, -1, -1);
        }

        void activateLink(int n, JEditorPane jEditorPane, int n2, int n3) {
            Document document = jEditorPane.getDocument();
            if (document instanceof HTMLDocument) {
                Map map;
                Object object;
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                Element element = hTMLDocument.getCharacterElement(n);
                AttributeSet attributeSet = element.getAttributes();
                AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                String string = attributeSet2 != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null;
                HyperlinkEvent hyperlinkEvent = null;
                if (string != null) {
                    hyperlinkEvent = this.createHyperlinkEvent(jEditorPane, hTMLDocument, string, attributeSet2);
                } else if (n2 >= 0 && n3 >= 0 && (object = attributeSet.getAttribute(HTML.Attribute.USEMAP)) != null && object instanceof String && (map = hTMLDocument.getMap((String)object)) != null) {
                    Object object2;
                    Rectangle rectangle;
                    try {
                        rectangle = jEditorPane.modelToView(n);
                        object2 = jEditorPane.modelToView(n + 1);
                        if (rectangle != null && object2 != null) {
                            rectangle.union((Rectangle)object2);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        rectangle = null;
                    }
                    if (rectangle != null && (object2 = map.getArea(n2 - rectangle.x, n3 - rectangle.y, rectangle.width, rectangle.height)) != null && (string = (String)object2.getAttribute(HTML.Attribute.HREF)) != null) {
                        hyperlinkEvent = this.createHyperlinkEvent(jEditorPane, hTMLDocument, string, attributeSet2);
                    }
                }
                if (hyperlinkEvent != null) {
                    jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
                }
            }
        }

        HyperlinkEvent createHyperlinkEvent(JEditorPane jEditorPane, HTMLDocument hTMLDocument, String string, AttributeSet attributeSet) {
            String string2;
            URL uRL;
            Serializable serializable;
            try {
                serializable = hTMLDocument.getBase();
                uRL = new URL((URL)serializable, string);
                if (string != null && "file".equals(uRL.getProtocol()) && string.startsWith("#")) {
                    string2 = ((URL)serializable).getFile();
                    String string3 = uRL.getFile();
                    if (string2 != null && string3 != null && !string3.startsWith(string2)) {
                        uRL = new URL((URL)serializable, string2 + string);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
            }
            serializable = null;
            if (!hTMLDocument.isFrameDocument()) {
                serializable = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL, string);
            } else {
                String string4 = string2 = attributeSet != null ? (String)attributeSet.getAttribute(HTML.Attribute.TARGET) : null;
                if (string2 == null || string2.equals("")) {
                    string2 = "_self";
                }
                serializable = new HTMLFrameHyperlinkEvent((Object)jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL, string, string2);
            }
            return serializable;
        }

        void fireEvents(JEditorPane jEditorPane, HTMLDocument hTMLDocument, String string) {
            HyperlinkEvent hyperlinkEvent;
            URL uRL;
            if (this.href != null) {
                try {
                    uRL = new URL(hTMLDocument.getBase(), this.href);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
                hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.EXITED, uRL, this.href);
                jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
            }
            if (string != null) {
                try {
                    uRL = new URL(hTMLDocument.getBase(), string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
                hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ENTERED, uRL, string);
                jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
            }
        }
    }
}

