/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import sun.awt.font.Utilities;

public final class Bidi {
    private boolean ltr;
    private byte[] dirs;
    private byte[] levels;
    private int[] l2vMap;
    private int[] v2lMap;
    public static final byte L = 0;
    public static final byte R = 1;
    public static final byte EN = 2;
    public static final byte ES = 3;
    public static final byte ET = 4;
    public static final byte AN = 5;
    public static final byte CS = 6;
    public static final byte B = 7;
    public static final byte S = 8;
    public static final byte WS = 9;
    public static final byte ON = 10;
    public static final byte AR = 11;
    public static final byte CM = 12;
    public static final byte F = 13;
    public static final char LRM = '\u200e';
    public static final char RLM = '\u200f';
    public static final char LRE = '\u202a';
    public static final char RLE = '\u202b';
    public static final char PDF = '\u202c';
    public static final char LRO = '\u202d';
    public static final char RLO = '\u202e';
    static final char NUMLEVELS = '\u0010';
    private static byte[] dirIndices = new byte[]{14, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, -124, 14, 18, 15, 16, 17, 18, 19, 20, 21, 22, 23, 14, 24, 25, 26, 27, 14, 28, 29, 30, -104, 14, 14, 2, 31, 32, 33, 34, 35, 36, 37, 38, 14, 39, 14, 40, 41, -106, 14, 8, 42, 43, 44, 45, 46, 47, 48, 49, -76, 14, -2, 2, -91, 2, 1, 50, -104, 14, -41, 2, 1, 51, -60, 2, 12, 52, 14, 53, 54, 55, 55, 56, 57, 58, 59, 60, 61};
    private static byte[] dirValues = new byte[]{-119, 10, 5, 8, 7, 8, 7, 7, -114, 10, -125, 7, 4, 8, 9, 10, 10, -125, 4, -123, 10, 5, 4, 6, 4, 6, 3, -118, 2, 1, 6, -122, 10, -102, 0, -122, 10, -102, 0, -91, 10, 2, 9, 10, -124, 4, -124, 10, 1, 0, -123, 10, 6, 4, 4, 2, 2, 10, 0, -125, 10, 2, 2, 0, -123, 10, -105, 0, 1, 10, -97, 0, 1, 10, -2, 0, -2, 0, 2, 0, 0, -124, 10, -98, 0, -72, 10, -39, 0, -121, 10, -119, 0, 2, 10, 10, -121, 0, -98, 10, -123, 0, -101, 10, -58, 12, -102, 10, 2, 12, 12, -110, 10, 2, 0, 0, -124, 10, 1, 0, -117, 10, 2, 0, 10, -125, 0, 3, 10, 0, 10, -108, 0, 1, 10, -84, 0, 1, 10, -121, 0, -125, 10, 8, 0, 10, 0, 10, 0, 10, 0, 10, -110, 0, -115, 10, -116, 0, 1, 10, -62, 0, 1, 10, -116, 0, 1, 10, -91, 0, -124, 12, -119, 10, -75, 0, 8, 10, 10, 0, 0, 10, 10, 0, 0, -125, 10, -100, 0, 2, 10, 10, -120, 0, 4, 10, 10, 0, 0, -73, 10, -90, 0, 2, 10, 10, -121, 0, 1, 10, -89, 0, 2, 10, 0, -121, 10, -111, 12, 1, 10, -105, 12, 1, 10, -125, 12, 7, 1, 12, 1, 12, 12, 1, 12, -117, 10, -101, 1, -123, 10, -123, 1, -105, 10, 1, 6, -114, 10, 1, 11, -125, 10, 2, 11, 10, -102, 11, -123, 10, -117, 11, -120, 12, -115, 10, -118, 5, 7, 4, 5, 5, 11, 10, 10, 12, -57, 11, 2, 10, 10, -123, 11, 1, 10, -113, 11, 1, 10, -122, 11, -113, 12, 5, 11, 11, 12, 12, 10, -124, 12, 2, 10, 10, -118, 2, -2, 10, -119, 10, 4, 12, 12, 0, 10, -75, 0, 3, 10, 10, 12, -124, 0, -120, 12, -124, 0, 4, 12, 10, 10, 0, -124, 12, -125, 10, -118, 0, 2, 12, 12, -115, 0, -112, 10, 4, 12, 0, 0, 10, -120, 0, 6, 10, 10, 0, 0, 10, 10, -106, 0, 1, 10, -121, 0, 2, 10, 0, -125, 10, -124, 0, 4, 10, 10, 12, 10, -125, 0, -124, 12, 9, 10, 10, 0, 0, 10, 10, 0, 0, 12, -119, 10, 1, 0, -124, 10, 3, 0, 0, 10, -125, 0, 4, 12, 12, 10, 10, -116, 0, 2, 4, 4, -121, 0, -121, 10, 3, 12, 10, 10, -122, 0, -124, 10, 4, 0, 0, 10, 10, -106, 0, 1, 10, -121, 0, 13, 10, 0, 0, 10, 0, 0, 10, 0, 0, 10, 10, 12, 10, -125, 0, 2, 12, 12, -124, 10, 4, 12, 12, 10, 10, -125, 12, -117, 10, -124, 0, 2, 10, 0, -121, 10, -118, 0, 2, 12, 12, -125, 0, -116, 10, 4, 12, 12, 0, 10, -121, 0, 3, 10, 0, 10, -125, 0, 1, 10, -106, 0, 1, 10, -121, 0, 4, 10, 0, 0, 10, -123, 0, 3, 10, 10, 12, -124, 0, -123, 12, 11, 10, 12, 12, 0, 10, 0, 0, 12, 10, 10, 0, -113, 10, 1, 0, -123, 10, -118, 0, -111, 10, 4, 12, 0, 0, 10, -120, 0, 6, 10, 10, 0, 0, 10, 10, -106, 0, 1, 10, -121, 0, 5, 10, 0, 0, 10, 10, -124, 0, 7, 10, 10, 12, 0, 0, 12, 0, -125, 12, -125, 10, 7, 0, 0, 10, 10, 0, 0, 12, -120, 10, 2, 12, 0, -124, 10, 3, 0, 0, 10, -125, 0, -124, 10, -117, 0, -111, 10, 3, 12, 0, 10, -122, 0, -125, 10, -125, 0, 1, 10, -124, 0, -125, 10, 7, 0, 0, 10, 0, 10, 0, 0, -125, 10, 2, 0, 0, -125, 10, -125, 0, -125, 10, -120, 0, 1, 10, -125, 0, -124, 10, 5, 0, 0, 12, 0, 0, -125, 10, -125, 0, 1, 10, -125, 0, 1, 12, -119, 10, 1, 0, -113, 10, -116, 0, -114, 10, -125, 0, 1, 10, -120, 0, 1, 10, -125, 0, 1, 10, -105, 0, 1, 10, -118, 0, 1, 10, -123, 0, -124, 10, -125, 12, -124, 0, 1, 10, -125, 12, 1, 10, -124, 12, -121, 10, 2, 12, 12, -119, 10, 2, 0, 0, -124, 10, -118, 0, -110, 10, 3, 0, 0, 10, -120, 0, 1, 10, -125, 0, 1, 10, -105, 0, 1, 10, -118, 0, 1, 10, -123, 0, -124, 10, 2, 0, 12, -123, 0, 9, 10, 12, 0, 0, 10, 0, 0, 12, 12, -121, 10, 2, 0, 0, -121, 10, 4, 0, 10, 0, 0, -124, 10, -118, 0, -110, 10, 3, 0, 0, 10, -120, 0, 1, 10, -125, 0, 1, 10, -105, 0, 1, 10, -112, 0, -124, 10, -125, 0, -125, 12, 2, 10, 10, -125, 0, 1, 10, -125, 0, 1, 12, -119, 10, 1, 0, -120, 10, 2, 0, 0, -124, 10, -118, 0, -111, 10, -80, 0, 3, 12, 0, 0, -121, 12, -124, 10, 1, 4, -121, 0, -120, 12, -115, 0, -91, 10, 13, 0, 0, 10, 0, 10, 10, 0, 0, 10, 0, 10, 10, 0, -122, 10, -124, 0, 1, 10, -121, 0, 1, 10, -125, 0, 9, 10, 0, 10, 0, 10, 10, 0, 0, 10, -124, 0, 3, 12, 0, 0, -122, 12, 6, 10, 12, 12, 0, 10, 10, -123, 0, 3, 10, 0, 10, -122, 12, 2, 10, 10, -118, 0, 4, 10, 10, 0, 0, -94, 10, -104, 0, 2, 12, 12, -101, 0, 5, 12, 0, 12, 0, 12, -124, 10, 2, 12, 12, -120, 0, 1, 10, -95, 0, -121, 10, -114, 12, 1, 0, -123, 12, 3, 0, 12, 12, -124, 0, -124, 10, -122, 12, 3, 10, 12, 10, -107, 12, -125, 10, -121, 12, 2, 10, 12, -26, 10, -90, 0, -118, 10, -89, 0, -124, 10, 1, 0, -124, 10, -38, 0, -123, 10, -60, 0, -123, 10, -46, 0, -122, 10, -100, 0, -124, 10, -38, 0, -122, 10, -106, 0, 2, 10, 10, -122, 0, 2, 10, 10, -90, 0, 2, 10, 10, -122, 0, 2, 10, 10, -120, 0, 7, 10, 0, 10, 0, 10, 0, 10, -97, 0, 2, 10, 10, -75, 0, 1, 10, -121, 0, 2, 10, 0, -125, 10, -125, 0, 1, 10, -121, 0, -125, 10, -124, 0, 2, 10, 10, -122, 0, -124, 10, -115, 0, -123, 10, -125, 0, 1, 10, -121, 0, -125, 10, -121, 9, 1, 6, -124, 9, 4, 10, 10, 0, 1, -104, 10, 8, 7, 7, 13, 13, 10, 13, 13, 10, -123, 4, -69, 10, 1, 2, -125, 10, -122, 2, 2, 4, 4, -125, 10, 1, 0, -118, 2, 2, 4, 4, -108, 10, -115, 4, -93, 10, -110, 12, -96, 10, 1, 0, -124, 10, 3, 0, 10, 10, -118, 0, 4, 10, 0, 10, 10, -122, 0, -122, 10, 6, 0, 10, 0, 10, 0, 10, -120, 0, 1, 10, -122, 0, -89, 10, -93, 0, -2, 10, -111, 10, 2, 4, 4, -2, 10, -92, 10, -59, 0, -27, 10, -68, 2, -50, 0, 1, 2, -107, 10, 1, 9, -123, 10, 2, 0, 0, -103, 10, -119, 0, -122, 12, -111, 10, -44, 0, -124, 10, 8, 12, 12, 10, 10, 0, 0, 10, 10, -34, 0, -122, 10, -88, 0, -124, 10, -34, 0, 1, 10, -112, 0, -32, 10, -99, 0, -125, 10, -92, 0, -100, 10, -100, 0, -125, 10, -78, 0, -113, 10, -116, 0, -124, 10, -81, 0, 1, 10, -9, 0, -124, 10, -29, 0, 2, 10, 10, -97, 0, 1, 10, -90, 0, -38, 10, -92, 0, -36, 10, -82, 0, -46, 10, -121, 0, -116, 10, -123, 0, -122, 10, 1, 12, -118, 1, 1, 4, -115, 1, 1, 10, -123, 1, 9, 10, 1, 10, 1, 1, 10, 1, 1, 10, -20, 1, -95, 10, -2, 1, -19, 1, -110, 10, -64, 1, 2, 10, 10, -74, 1, -88, 10, -116, 1, -92, 10, -124, 12, -84, 10, 6, 6, 10, 6, 10, 10, 6, -119, 10, 5, 4, 10, 10, 4, 4, -123, 10, 2, 4, 4, -123, 10, -125, 1, 3, 10, 1, 10, -2, 1, -119, 1, -122, 10, -125, 4, -123, 10, 5, 4, 6, 4, 6, 3, -118, 2, 1, 6, -122, 10, -102, 0, -122, 10, -102, 0, -118, 10, -71, 0, 2, 10, 10, -97, 0, -125, 10, -122, 0, 2, 10, 10, -122, 0, 2, 10, 10, -122, 0, 2, 10, 10, -125, 0, -125, 10, 2, 4, 4, -125, 10, 2, 4, 4, -103, 10};

    public int getLength() {
        return this.levels.length;
    }

    public boolean isDirectionLTR() {
        return this.ltr;
    }

    public int[] getLogicalToVisualMap() {
        if (this.l2vMap == null) {
            this.l2vMap = Bidi.getInverseOrder(this.getVisualToLogicalMap());
        }
        return this.l2vMap;
    }

    public int[] getVisualToLogicalMap() {
        if (this.v2lMap == null) {
            this.v2lMap = Bidi.createVisualToLogicalMap(this.levels);
        }
        return this.v2lMap;
    }

    public byte[] getLevels() {
        return this.levels;
    }

    public Bidi createLineBidi(int n, int n2) {
        byte[] byArray = new byte[n2 - n];
        System.arraycopy(this.levels, n, byArray, 0, byArray.length);
        if (this.dirs != null) {
            int n3 = this.ltr ? 0 : 1;
            int n4 = byArray.length;
            while (--n4 >= 0) {
                if (byArray[n4] % 2 == n3 || this.dirs[n + n4] != 9) break;
                byArray[n4] = n3;
            }
        }
        return new Bidi(byArray, this.ltr);
    }

    public int getLevelAt(int n) {
        return this.levels[n];
    }

    public int getLevelLimit(int n) {
        byte by = this.levels[n];
        while (++n < this.levels.length && this.levels[n] == by) {
        }
        return n;
    }

    public Bidi(char[] cArray) {
        this(cArray, Bidi.defaultIsLTR(cArray, 0, cArray.length));
    }

    public Bidi(char[] cArray, boolean bl) {
        this(cArray, Bidi.getEmbeddingArray(cArray, bl), bl);
    }

    public Bidi(char[] cArray, byte[] byArray, boolean bl) {
        byte[] byArray2 = Bidi.getDirectionCodeArray(cArray, byArray);
        int n = 0;
        while (n < byArray.length) {
            if ((byArray[n] & 0x10) != 0) {
                int n2 = n;
                byArray[n2] = (byte)(byArray[n2] & 0xF);
                byArray2[n] = (byte)(byArray[n] & 1);
            }
            ++n;
        }
        Bidi.applyBidiRules(byArray2, byArray, bl);
        this.ltr = bl;
        this.dirs = byArray2;
        this.levels = byArray;
    }

    public Bidi(byte[] byArray, byte[] byArray2, boolean bl) {
        Bidi.applyBidiRules(byArray, byArray2, bl);
        this.ltr = bl;
        this.dirs = byArray;
        this.levels = byArray2;
    }

    protected Bidi(byte[] byArray, boolean bl) {
        this.ltr = bl;
        this.dirs = null;
        this.levels = byArray;
    }

    public static void applyBidiRules(byte[] byArray, byte[] byArray2, boolean bl) {
        byte[] byArray3 = (byte[])byArray.clone();
        Bidi.resolveWeakTypes(byArray3, byArray2, bl);
        Bidi.resolveNeutralTypes(byArray3, byArray2, bl);
        Bidi.resolveImplicitLevels(byArray3, byArray, byArray2, bl);
    }

    private static void resolveWeakTypes(byte[] byArray, byte[] byArray2, boolean bl) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by = byArray2[n2++];
            while (n2 < byArray.length && byArray2[n2] == by) {
                ++n2;
            }
            int n3 = -1;
            int n4 = byArray[n];
            boolean bl2 = n4 == 11;
            while (n < n2) {
                int n5;
                int n6 = n + 1;
                int n7 = n5 = n6 == n2 ? -1 : byArray[n6];
                if (n5 == 2 && bl2) {
                    n5 = 5;
                }
                int n8 = n4;
                block0 : switch (n4) {
                    case 0: 
                    case 1: {
                        bl2 = false;
                        break;
                    }
                    case 11: {
                        bl2 = true;
                        break;
                    }
                    case 3: {
                        if (n3 == 2 && n5 == 2) {
                            n8 = 2;
                            break;
                        }
                        n8 = 10;
                        break;
                    }
                    case 6: {
                        if (n3 == 2 && n5 == 2) {
                            n8 = 2;
                            break;
                        }
                        if (n3 == 5 && n5 == 5) {
                            n8 = 5;
                            break;
                        }
                        n8 = 10;
                        break;
                    }
                    case 4: {
                        if (n3 == 2 || n5 == 2) {
                            n8 = 2;
                            break;
                        }
                        if (n5 == 4 && !bl2) {
                            int n9 = n6 + 1;
                            while (n9 < n2) {
                                int n10 = byArray[n9];
                                if (n10 != 4) {
                                    int n11 = n10 == 2 ? 2 : 10;
                                    while (n6 < n9) {
                                        byArray[n6++] = n11;
                                    }
                                    n8 = n11;
                                    n5 = n10;
                                    break block0;
                                }
                                ++n9;
                            }
                            break;
                        }
                        n8 = 10;
                        break;
                    }
                }
                byArray[n] = n8;
                n = n6;
                n3 = n8;
                n4 = n5;
            }
        }
    }

    private static void resolveNeutralTypes(byte[] byArray, byte[] byArray2, boolean bl) {
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            byte by = byArray2[n];
            byte by2 = (by & 1) == 0 ? (byte)0 : 1;
            int n3 = n + 1;
            while (n3 < n2 && byArray2[n3] == by) {
                ++n3;
            }
            byte by3 = by2;
            byte by4 = by2;
            int n4 = n - 1;
            while (n < n3) {
                byte by5 = byArray[n];
                switch (by5) {
                    case 0: {
                        by3 = 0;
                        break;
                    }
                    case 1: 
                    case 11: {
                        by3 = 1;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: 
                    case 8: {
                        by3 = by2;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 12: {
                        if (n > n4) {
                            by4 = by2;
                            n4 = n + 1;
                            block16: while (n4 < n3) {
                                byte by6 = byArray[n4];
                                switch (by6) {
                                    case 0: {
                                        by4 = by3 == 0 ? (byte)0 : by2;
                                        break block16;
                                    }
                                    case 1: 
                                    case 5: 
                                    case 11: {
                                        by4 = by3 == 0 ? by2 : (byte)1;
                                        break block16;
                                    }
                                    case 2: {
                                        by4 = by3;
                                        break block16;
                                    }
                                    case 8: {
                                        by4 = by2;
                                        break block16;
                                    }
                                    default: {
                                        ++n4;
                                    }
                                }
                            }
                        }
                        byArray[n] = by4;
                    }
                }
                ++n;
            }
        }
    }

    private static void resolveImplicitLevels(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) {
        int n;
        int n2 = bl ? 0 : 1;
        int n3 = byArray.length;
        int n4 = -1;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = n = byArray3[n5];
            switch (byArray[n5]) {
                case 0: {
                    n6 = (byte)(n + 1 & 0x1E);
                    break;
                }
                case 1: 
                case 11: {
                    n6 = (byte)(n | 1);
                    break;
                }
                case 5: {
                    n6 = (byte)((n & 0xE) + 2);
                    break;
                }
                case 2: {
                    if ((n & 1) != 0) {
                        n6 = (byte)(n6 + 1);
                        break;
                    }
                    if (n5 == 0 || n4 != n) break;
                    int n7 = byArray[n5 - 1];
                    if (n7 == 2) {
                        n6 = byArray3[n5 - 1];
                        break;
                    }
                    if (n7 == 0) break;
                    n6 = (byte)(n6 + 2);
                    break;
                }
                case 7: 
                case 8: {
                    n6 = n2;
                    int n7 = n5 - 1;
                    while (n7 >= 0 && byArray2[n7] == 9) {
                        byArray3[n7] = n2;
                        --n7;
                    }
                    break;
                }
            }
            if (n6 != n) {
                byArray3[n5] = n6;
            }
            n4 = n;
            ++n5;
        }
        n = n3 - 1;
        while (n >= 0 && byArray2[n] == 9) {
            byArray3[n] = n2;
            --n;
        }
    }

    public Bidi(Bidi bidi, int n, int n2) {
        byte[] byArray = bidi.dirs;
        byte[] byArray2 = Bidi.createLineLevels(byArray, bidi.levels, bidi.ltr, n, n2);
        this.ltr = bidi.ltr;
        this.dirs = null;
        this.levels = byArray2;
    }

    public static byte[] createLineLevels(byte[] byArray, byte[] byArray2, boolean bl, int n, int n2) {
        byte[] byArray3 = new byte[n2 - n];
        System.arraycopy(byArray2, n, byArray3, 0, byArray3.length);
        byte by = bl ? (byte)0 : 1;
        int n3 = n2 - n - 1;
        while (n3 >= 0) {
            if (byArray3[n3] == by || byArray[n + n3] != 9) break;
            byArray3[n3] = by;
            --n3;
        }
        return byArray3;
    }

    public static boolean defaultIsLTR(char[] cArray, int n, int n2) {
        while (n < n2) {
            char c = cArray[n++];
            byte by = Bidi.getDirectionCode(c);
            switch (by) {
                case 0: {
                    return true;
                }
                case 1: 
                case 11: {
                    return false;
                }
                case 13: {
                    return c == '\u202d' || c == '\u202a';
                }
            }
        }
        return true;
    }

    public static boolean requiresBidi(char c) {
        if (c < '\u0591') {
            return false;
        }
        if (c > '\u202e') {
            return false;
        }
        byte by = Bidi.getDirectionCode(c);
        return by == 1 || by == 11 || by == 13;
    }

    public static byte getDirectionCode(char c) {
        return dirValues[(dirIndices[c >> 7] << 7) + (c & 0x7F)];
    }

    public static byte[] getDirectionCodeArray(char[] cArray, byte[] byArray) {
        int n = 10;
        byte by = -1;
        byte[] byArray2 = new byte[cArray.length];
        int n2 = 0;
        while (n2 < cArray.length) {
            if (byArray[n2] != by) {
                n = 10;
                by = byArray[n2];
            }
            char c = cArray[n2];
            int n3 = Bidi.getDirectionCode(c);
            switch (n3) {
                case 0: 
                case 1: 
                case 11: {
                    n = n3;
                    break;
                }
                case 7: {
                    n = 10;
                    break;
                }
                case 12: {
                    n3 = n;
                    break;
                }
                case 13: {
                    n3 = 10;
                    break;
                }
            }
            byArray2[n2] = n3;
            ++n2;
        }
        return byArray2;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] getEmbeddingArray(char[] var0, boolean var1_1) {
        var2_2 = new byte[var0.length];
        var4_4 = var3_3 = var1_1 != false ? 0 : 1;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = new byte[16];
        var8_8 = new char[16];
        var9_9 = 0;
        while (var9_9 < var0.length) {
            var10_10 = var0[var9_9];
            switch (var10_10) {
                case '\u202a': 
                case '\u202d': {
                    if (var6_6 <= 0) ** GOTO lbl15
                    ++var6_6;
                    ** GOTO lbl54
lbl15:
                    // 1 sources

                    var11_11 = (byte)((var4_4 & 14) + 2);
                    if (var11_11 < 16) ** GOTO lbl19
                    ++var6_6;
                    ** GOTO lbl54
lbl19:
                    // 1 sources

                    var8_8[var5_5] = var10_10;
                    var7_7[var5_5++] = var4_4;
                    var2_2[var9_9] = var4_4;
                    if (var10_10 == '\u202d') {
                        var4_4 = (byte)(var11_11 + 16);
                        break;
                    }
                    var4_4 = var11_11;
                    break;
                }
                case '\u202b': 
                case '\u202e': {
                    if (var6_6 <= 0) ** GOTO lbl31
                    ++var6_6;
                    ** GOTO lbl54
lbl31:
                    // 1 sources

                    var11_11 = (byte)((var4_4 & 15) + 1 | 1);
                    if (var11_11 < 16) ** GOTO lbl35
                    ++var6_6;
                    ** GOTO lbl54
lbl35:
                    // 1 sources

                    var8_8[var5_5] = var10_10;
                    var7_7[var5_5++] = var4_4;
                    var2_2[var9_9] = var4_4;
                    if (var10_10 == '\u202e') {
                        var4_4 = (byte)(var11_11 + 16);
                        break;
                    }
                    var4_4 = var11_11;
                    break;
                }
                case '\u202c': {
                    if (var6_6 <= 0) ** GOTO lbl47
                    --var6_6;
                    ** GOTO lbl54
lbl47:
                    // 1 sources

                    if (var5_5 > 0) {
                        if (var9_9 < var0.length - 1 && var0[var9_9 + 1] == var8_8[var5_5 - 1]) {
                            var2_2[var9_9] = var4_4;
                            var2_2[var9_9 + 1] = var4_4;
                            ++var9_9;
                            break;
                        }
                        var4_4 = var7_7[--var5_5];
                    }
                }
lbl54:
                // 9 sources

                default: {
                    var2_2[var9_9] = var4_4;
                }
            }
            ++var9_9;
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    public static int[] createVisualToLogicalMap(byte[] var0) {
        var1_1 = var0.length;
        var2_2 = new int[var1_1];
        var3_3 = 17;
        var4_4 = 0;
        var5_5 = 0;
        while (var5_5 < var1_1) {
            var2_2[var5_5] = var5_5;
            var6_6 = var0[var5_5];
            if (var6_6 > var4_4) {
                var4_4 = var6_6;
            }
            if ((var6_6 & 1) != 0 && var6_6 < var3_3) {
                var3_3 = var6_6;
            }
            ++var5_5;
        }
        while (var4_4 >= var3_3) {
            var6_6 = 0;
            block2: while (true) {
                if (var6_6 < var1_1 && var0[var6_6] < var4_4) {
                    ++var6_6;
                    continue;
                }
                if ((var7_7 = var6_6++) != var0.length) ** GOTO lbl24
                break;
lbl-1000:
                // 1 sources

                {
                    ++var6_6;
lbl24:
                    // 2 sources

                    ** while (var6_6 < var1_1 && var0[var6_6] >= var4_4)
                }
lbl25:
                // 1 sources

                var8_8 = var6_6 - 1;
                while (true) {
                    if (var7_7 < var8_8) ** break;
                    continue block2;
                    var9_9 = var2_2[var7_7];
                    var2_2[var7_7] = var2_2[var8_8];
                    var2_2[var8_8] = var9_9;
                    ++var7_7;
                    --var8_8;
                }
                break;
            }
            var4_4 = (byte)(var4_4 - 1);
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    public static void reorderVisually(byte[] var0, Object[] var1_1) {
        var2_2 = var0.length;
        var3_3 = 17;
        var4_4 = 0;
        var5_5 = 0;
        while (var5_5 < var2_2) {
            var6_6 = var0[var5_5];
            if (var6_6 > var4_4) {
                var4_4 = var6_6;
            }
            if ((var6_6 & 1) != 0 && var6_6 < var3_3) {
                var3_3 = var6_6;
            }
            ++var5_5;
        }
        while (var4_4 >= var3_3) {
            var6_6 = 0;
            block2: while (true) {
                if (var6_6 < var2_2 && var0[var6_6] < var4_4) {
                    ++var6_6;
                    continue;
                }
                if ((var7_7 = var6_6++) != var0.length) ** GOTO lbl22
                break;
lbl-1000:
                // 1 sources

                {
                    ++var6_6;
lbl22:
                    // 2 sources

                    ** while (var6_6 < var2_2 && var0[var6_6] >= var4_4)
                }
lbl23:
                // 1 sources

                var8_8 = var6_6 - 1;
                while (true) {
                    if (var7_7 < var8_8) ** break;
                    continue block2;
                    var9_9 = var1_1[var7_7];
                    var1_1[var7_7] = var1_1[var8_8];
                    var1_1[var8_8] = var9_9;
                    ++var7_7;
                    --var8_8;
                }
                break;
            }
            var4_4 = (byte)(var4_4 - 1);
        }
    }

    public static int[] getInverseOrder(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[nArray[n]] = n;
            ++n;
        }
        return nArray2;
    }

    private static int[] computeContiguousOrder(int[] nArray, int n, int n2) {
        int n3;
        int[] nArray2 = new int[n2 - n];
        int n4 = 0;
        while (n4 < nArray2.length) {
            nArray2[n4] = n4 + n;
            ++n4;
        }
        int n5 = 0;
        while (n5 < nArray2.length - 1) {
            n3 = n5;
            int n6 = nArray[nArray2[n3]];
            int n7 = n5;
            while (n7 < nArray2.length) {
                if (nArray[nArray2[n7]] < n6) {
                    n3 = n7;
                    n6 = nArray[nArray2[n3]];
                }
                ++n7;
            }
            int n8 = nArray2[n5];
            nArray2[n5] = nArray2[n3];
            nArray2[n3] = n8;
            ++n5;
        }
        if (n != 0) {
            n3 = 0;
            while (n3 < nArray2.length) {
                int n9 = n3++;
                nArray2[n9] = nArray2[n9] - n;
            }
        }
        n3 = 0;
        while (n3 < nArray2.length) {
            if (nArray2[n3] != n3) break;
            ++n3;
        }
        if (n3 == nArray2.length) {
            return null;
        }
        return Bidi.getInverseOrder(nArray2);
    }

    public static int[] getContiguousOrder(int[] nArray) {
        if (nArray != null) {
            return Bidi.computeContiguousOrder(nArray, 0, nArray.length);
        }
        return null;
    }

    public static int[] getNormalizedOrder(int[] nArray, byte[] byArray, int n, int n2) {
        if (nArray != null) {
            if (n != 0 || n2 != nArray.length) {
                boolean bl;
                boolean bl2;
                byte by;
                if (byArray == null) {
                    by = 0;
                    bl2 = true;
                    bl = true;
                } else if (byArray[n] == byArray[n2 - 1]) {
                    by = byArray[n];
                    bl = (by & 1) == 0;
                    int n3 = n;
                    while (n3 < n2) {
                        if (byArray[n3] < by) break;
                        if (bl) {
                            bl = byArray[n3] == by;
                        }
                        ++n3;
                    }
                    bl2 = n3 == n2;
                } else {
                    bl2 = false;
                    by = 0;
                    bl = false;
                }
                if (bl2) {
                    if (bl) {
                        return null;
                    }
                    int[] nArray2 = new int[n2 - n];
                    int n4 = (by & 1) != 0 ? nArray[n2 - 1] : nArray[n];
                    if (n4 == 0) {
                        System.arraycopy(nArray, n, nArray2, 0, n2 - n);
                    } else {
                        int n5 = 0;
                        while (n5 < nArray2.length) {
                            nArray2[n5] = nArray[n5 + n] - n4;
                            ++n5;
                        }
                    }
                    return nArray2;
                }
                return Bidi.computeContiguousOrder(nArray, n, n2);
            }
            return nArray;
        }
        return null;
    }

    public static Bidi createBidi(char[] cArray) {
        return new Bidi(cArray);
    }

    static {
        dirIndices = Utilities.readRLE(dirIndices);
        dirValues = Utilities.readRLE(dirValues);
    }
}

