/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import sun.misc.ExtensionDependency;
import sun.misc.InvalidJarIndexException;
import sun.misc.JarIndex;
import sun.misc.Resource;
import sun.security.action.GetPropertyAction;

public class URLClassPath {
    static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    static final String JAVA_VERSION = (String)AccessController.doPrivileged(new GetPropertyAction("java.version"));
    private ArrayList path = new ArrayList();
    private Stack urls = new Stack();
    private ArrayList loaders = new ArrayList();
    private HashMap lmap = new HashMap();
    private URLStreamHandler jarHandler;

    public URLClassPath(URL[] uRLArray, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        int n = 0;
        while (n < uRLArray.length) {
            this.path.add(uRLArray[n]);
            ++n;
        }
        this.push(uRLArray);
        if (uRLStreamHandlerFactory != null) {
            this.jarHandler = uRLStreamHandlerFactory.createURLStreamHandler("jar");
        }
    }

    public URLClassPath(URL[] uRLArray) {
        this(uRLArray, null);
    }

    public void addURL(URL uRL) {
        Stack stack = this.urls;
        synchronized (stack) {
            this.urls.add(0, uRL);
            this.path.add(uRL);
        }
    }

    public URL[] getURLs() {
        Stack stack = this.urls;
        synchronized (stack) {
            URL[] uRLArray = (URL[])this.path.toArray(new URL[this.path.size()]);
            return uRLArray;
        }
    }

    public Resource getResource(String string, boolean bl) {
        Loader loader;
        int n = 0;
        while ((loader = this.getLoader(n)) != null) {
            Resource resource = loader.getResource(string, bl);
            if (resource != null) {
                return resource;
            }
            ++n;
        }
        return null;
    }

    public Resource getResource(String string) {
        return this.getResource(string, true);
    }

    public Enumeration getResources(final String string, final boolean bl) {
        return new Enumeration(){
            private int index = 0;
            private Resource res = null;

            /*
             * Unable to fully structure code
             */
            private boolean next() {
                if (this.res == null) ** GOTO lbl6
                return true;
lbl-1000:
                // 1 sources

                {
                    this.res = var1_1.getResource(string, bl);
                    if (this.res == null) continue;
                    return true;
lbl6:
                    // 2 sources

                    ** while ((var1_1 = URLClassPath.access$000((URLClassPath)URLClassPath.this, (int)this.index++)) != null)
                }
lbl7:
                // 1 sources

                return false;
            }

            public boolean hasMoreElements() {
                return this.next();
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                Resource resource = this.res;
                this.res = null;
                return resource;
            }
        };
    }

    public Enumeration getResources(String string) {
        return this.getResources(string, true);
    }

    private synchronized Loader getLoader(int n) {
        while (this.loaders.size() < n + 1) {
            URL uRL;
            Object object;
            block9: {
                try {
                    object = this.urls;
                    synchronized (object) {
                        uRL = (URL)this.urls.pop();
                    }
                }
                catch (EmptyStackException emptyStackException) {
                    return null;
                }
                if (this.lmap.containsKey(uRL)) continue;
                try {
                    object = this.getLoader(uRL);
                    URL[] uRLArray = ((Loader)object).getClassPath();
                    if (uRLArray == null) break block9;
                    this.push(uRLArray);
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            this.loaders.add(object);
            this.lmap.put(uRL, object);
        }
        return (Loader)this.loaders.get(n);
    }

    private Loader getLoader(final URL uRL) throws IOException {
        try {
            return (Loader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    String string = uRL.getFile();
                    if (string != null && string.endsWith("/")) {
                        if ("file".equals(uRL.getProtocol())) {
                            return new FileLoader(uRL);
                        }
                        return new Loader(uRL);
                    }
                    return new JarLoader(uRL, URLClassPath.this.jarHandler, URLClassPath.this.lmap);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private void push(URL[] uRLArray) {
        Stack stack = this.urls;
        synchronized (stack) {
            int n = uRLArray.length - 1;
            while (n >= 0) {
                this.urls.push(uRLArray[n]);
                --n;
            }
        }
    }

    public static URL[] pathToURLs(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = new File(stringTokenizer.nextToken());
            try {
                object = new File(((File)object).getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                uRLArray[n++] = ((File)object).toURL();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (uRLArray.length != n) {
            object = new URL[n];
            System.arraycopy(uRLArray, 0, object, 0, n);
            uRLArray = object;
        }
        return uRLArray;
    }

    public URL checkURL(URL uRL) {
        try {
            URLClassPath.check(uRL);
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    static void check(URL uRL) throws IOException {
        Permission permission;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (permission = uRL.openConnection().getPermission()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
                throw securityException;
            }
        }
    }

    static /* synthetic */ Loader access$000(URLClassPath uRLClassPath, int n) {
        return uRLClassPath.getLoader(n);
    }

    private static class FileLoader
    extends Loader {
        private File dir;

        FileLoader(URL uRL) throws IOException {
            super(uRL);
            if (!"file".equals(uRL.getProtocol())) {
                throw new IllegalArgumentException("url");
            }
            this.dir = new File(uRL.getFile().replace('/', File.separatorChar));
        }

        Resource getResource(String string, boolean bl) {
            try {
                File file;
                URL uRL = new URL(this.getBaseURL(), string);
                if (!uRL.getFile().startsWith(this.getBaseURL().getFile())) {
                    return null;
                }
                if (bl) {
                    URLClassPath.check(uRL);
                }
                if ((file = new File(this.dir, string.replace('/', File.separatorChar))).exists()) {
                    return new Resource(this, string, uRL, file){
                        private final /* synthetic */ String val$name;
                        private final /* synthetic */ URL val$url;
                        private final /* synthetic */ File val$file;
                        private final /* synthetic */ FileLoader this$0;
                        {
                            this.this$0 = fileLoader;
                            this.val$name = string;
                            this.val$url = uRL;
                            this.val$file = file;
                        }

                        public String getName() {
                            return this.val$name;
                        }

                        public URL getURL() {
                            return this.val$url;
                        }

                        public URL getCodeSourceURL() {
                            return this.this$0.getBaseURL();
                        }

                        public InputStream getInputStream() throws IOException {
                            return new FileInputStream(this.val$file);
                        }

                        public int getContentLength() throws IOException {
                            return (int)this.val$file.length();
                        }
                    };
                }
            }
            catch (Exception exception) {
                return null;
            }
            return null;
        }
    }

    private static class JarLoader
    extends Loader {
        private JarFile jar;
        private URL csu;
        private JarIndex index;
        private URLStreamHandler handler;
        private HashMap lmap;

        JarLoader(URL uRL, URLStreamHandler uRLStreamHandler, HashMap hashMap) throws IOException {
            super(new URL("jar", "", -1, uRL + "!/", uRLStreamHandler));
            this.jar = this.getJarFile(uRL);
            this.index = JarIndex.getJarIndex(this.jar);
            this.csu = uRL;
            this.handler = uRLStreamHandler;
            this.lmap = hashMap;
            if (this.index != null) {
                String[] stringArray = this.index.getJarFiles();
                int n = 0;
                while (n < stringArray.length) {
                    try {
                        URL uRL2 = new URL(this.csu, stringArray[n]);
                        if (!this.lmap.containsKey(uRL2)) {
                            this.lmap.put(uRL2, null);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    ++n;
                }
            }
        }

        private JarFile getJarFile(URL uRL) throws IOException {
            if ("file".equals(uRL.getProtocol())) {
                String string = uRL.getFile().replace('/', File.separatorChar);
                File file = new File(string);
                if (!file.exists()) {
                    throw new FileNotFoundException(string);
                }
                return new JarFile(string);
            }
            URLConnection uRLConnection = this.getBaseURL().openConnection();
            uRLConnection.setRequestProperty(URLClassPath.USER_AGENT_JAVA_VERSION, JAVA_VERSION);
            return ((JarURLConnection)uRLConnection).getJarFile();
        }

        JarIndex getIndex() {
            return this.index;
        }

        Resource checkResource(String string, boolean bl, JarEntry jarEntry) {
            URL uRL;
            try {
                uRL = new URL(this.getBaseURL(), string);
                if (bl) {
                    URLClassPath.check(uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            catch (AccessControlException accessControlException) {
                return null;
            }
            return new Resource(this, string, uRL, jarEntry){
                private final /* synthetic */ String val$name;
                private final /* synthetic */ URL val$url;
                private final /* synthetic */ JarEntry val$entry;
                private final /* synthetic */ JarLoader this$0;
                {
                    this.this$0 = jarLoader;
                    this.val$name = string;
                    this.val$url = uRL;
                    this.val$entry = jarEntry;
                }

                public String getName() {
                    return this.val$name;
                }

                public URL getURL() {
                    return this.val$url;
                }

                public URL getCodeSourceURL() {
                    return JarLoader.access$400(this.this$0);
                }

                public InputStream getInputStream() throws IOException {
                    return JarLoader.access$500(this.this$0).getInputStream(this.val$entry);
                }

                public int getContentLength() {
                    return (int)this.val$entry.getSize();
                }

                public Manifest getManifest() throws IOException {
                    return JarLoader.access$500(this.this$0).getManifest();
                }

                public Certificate[] getCertificates() {
                    return this.val$entry.getCertificates();
                }
            };
        }

        Resource getResource(String string, boolean bl) {
            JarEntry jarEntry = this.jar.getJarEntry(string);
            if (jarEntry != null) {
                return this.checkResource(string, bl, jarEntry);
            }
            if (this.index == null) {
                return null;
            }
            HashSet hashSet = new HashSet();
            return this.getResource(string, bl, hashSet);
        }

        boolean validIndex(String string) {
            String string2 = string;
            int n = string.lastIndexOf("/");
            if (n != -1) {
                string2 = string.substring(0, n);
            }
            Enumeration enumeration = this.jar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                String string3 = zipEntry.getName();
                n = string3.lastIndexOf("/");
                if (n != -1) {
                    string3 = string3.substring(0, n);
                }
                if (!string3.equals(string2)) continue;
                return true;
            }
            return false;
        }

        Resource getResource(String string, boolean bl, Set set) {
            boolean bl2 = false;
            int n = 0;
            LinkedList linkedList = null;
            linkedList = this.index.get(string);
            if (linkedList == null) {
                return null;
            }
            do {
                Object[] objectArray = linkedList.toArray();
                int n2 = linkedList.size();
                while (n < n2) {
                    Resource resource;
                    boolean bl3;
                    JarLoader jarLoader;
                    URL uRL;
                    block10: {
                        String string2 = (String)objectArray[n++];
                        try {
                            uRL = new URL(this.csu, string2);
                            jarLoader = (JarLoader)this.lmap.get(uRL);
                            if (jarLoader != null) break block10;
                            jarLoader = (JarLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(this, uRL){
                                private final /* synthetic */ URL val$url;
                                private final /* synthetic */ JarLoader this$0;
                                {
                                    this.this$0 = jarLoader;
                                    this.val$url = uRL;
                                }

                                public Object run() throws IOException {
                                    return new JarLoader(this.val$url, JarLoader.access$600(this.this$0), JarLoader.access$700(this.this$0));
                                }
                            });
                            JarIndex jarIndex = jarLoader.getIndex();
                            if (jarIndex != null) {
                                int n3 = string2.lastIndexOf("/");
                                jarIndex.merge(this.index, n3 == -1 ? null : string2.substring(0, n3 + 1));
                            }
                            this.lmap.put(uRL, jarLoader);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            continue;
                        }
                    }
                    boolean bl4 = bl3 = !set.add(uRL);
                    if (!bl3) {
                        JarEntry jarEntry = jarLoader.jar.getJarEntry(string);
                        if (jarEntry != null) {
                            return jarLoader.checkResource(string, bl, jarEntry);
                        }
                        if (!jarLoader.validIndex(string)) {
                            throw new InvalidJarIndexException("Invalid index");
                        }
                    }
                    if (bl3 || jarLoader == this || jarLoader.getIndex() == null || (resource = jarLoader.getResource(string, bl, set)) == null) continue;
                    return resource;
                }
            } while (n < (linkedList = this.index.get(string)).size());
            return null;
        }

        URL[] getClassPath() throws IOException {
            String string;
            Attributes attributes;
            if (this.index != null) {
                return null;
            }
            this.parseExtensionsDependencies();
            Manifest manifest = this.jar.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (string = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                return this.parseClassPath(this.csu, string);
            }
            return null;
        }

        private void parseExtensionsDependencies() throws IOException {
            ExtensionDependency.checkExtensionsDependencies(this.jar);
        }

        private URL[] parseClassPath(URL uRL, String string) throws MalformedURLException {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            URL[] uRLArray = new URL[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                uRLArray[n] = new URL(uRL, string2);
                ++n;
            }
            return uRLArray;
        }

        static /* synthetic */ URL access$400(JarLoader jarLoader) {
            return jarLoader.csu;
        }

        static /* synthetic */ JarFile access$500(JarLoader jarLoader) {
            return jarLoader.jar;
        }

        static /* synthetic */ URLStreamHandler access$600(JarLoader jarLoader) {
            return jarLoader.handler;
        }

        static /* synthetic */ HashMap access$700(JarLoader jarLoader) {
            return jarLoader.lmap;
        }
    }

    private static class Loader {
        private final URL base;

        Loader(URL uRL) {
            this.base = uRL;
        }

        URL getBaseURL() {
            return this.base;
        }

        Resource getResource(String string, boolean bl) {
            URLConnection uRLConnection;
            URL uRL;
            try {
                uRL = new URL(this.base, string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("name");
            }
            try {
                if (bl) {
                    URLClassPath.check(uRL);
                }
                if ((uRLConnection = uRL.openConnection()) instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    int n = httpURLConnection.getResponseCode();
                    if (n >= 400) {
                        return null;
                    }
                } else {
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                return null;
            }
            return new Resource(this, string, uRL, uRLConnection){
                private final /* synthetic */ String val$name;
                private final /* synthetic */ URL val$url;
                private final /* synthetic */ URLConnection val$uc;
                private final /* synthetic */ Loader this$0;
                {
                    this.this$0 = loader;
                    this.val$name = string;
                    this.val$url = uRL;
                    this.val$uc = uRLConnection;
                }

                public String getName() {
                    return this.val$name;
                }

                public URL getURL() {
                    return this.val$url;
                }

                public URL getCodeSourceURL() {
                    return Loader.access$300(this.this$0);
                }

                public InputStream getInputStream() throws IOException {
                    return this.val$uc.getInputStream();
                }

                public int getContentLength() throws IOException {
                    return this.val$uc.getContentLength();
                }
            };
        }

        Resource getResource(String string) {
            return this.getResource(string, true);
        }

        URL[] getClassPath() throws IOException {
            return null;
        }

        static /* synthetic */ URL access$300(Loader loader) {
            return loader.base;
        }
    }
}

