/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import org.mozilla.util.Assert;
import org.mozilla.util.ParameterCheck;
import org.mozilla.webclient.BrowserControl;
import org.mozilla.webclient.WindowControl;

public abstract class BrowserControlCanvas
extends Canvas {
    private static int webShellCount = 0;
    private boolean initializeOK = false;
    private boolean boundsValid = false;
    private boolean hasFocus = false;
    private BrowserControl webShell = null;
    private int nativeWindow = 0;
    private Rectangle windowRelativeBounds;

    protected BrowserControlCanvas() {
    }

    protected void initialize(BrowserControl browserControl) {
        ParameterCheck.nonNull(browserControl);
        this.webShell = browserControl;
    }

    protected abstract int getWindow();

    public void addNotify() {
        super.addNotify();
        this.windowRelativeBounds = new Rectangle();
        this.nativeWindow = this.getWindow();
        try {
            Rectangle rectangle = new Rectangle(this.getBoundsRelativeToWindow());
            Assert.assert_it(null != this.webShell);
            WindowControl windowControl = (WindowControl)this.webShell.queryInterface("webclient.WindowControl");
            windowControl.createWindow(this.nativeWindow, rectangle);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return;
        }
        this.initializeOK = true;
        ++webShellCount;
    }

    public BrowserControl getWebShell() {
        return this.webShell;
    }

    protected Point getEventCoordsLocalToWindow(MouseEvent mouseEvent) {
        Rectangle rectangle = this.getBoundsRelativeToWindow();
        int n = mouseEvent.getX() + rectangle.x;
        int n2 = mouseEvent.getY() + rectangle.y;
        return new Point(n, n2);
    }

    protected Rectangle getWindowBounds() {
        Container container = this.getParent();
        if (container != null) {
            do {
                if (!(container instanceof Window)) continue;
                return container.getBounds();
            } while ((container = container.getParent()) != null);
        }
        return new Rectangle();
    }

    protected Rectangle getBoundsRelativeToWindow() {
        if (this.boundsValid) {
            return this.windowRelativeBounds;
        }
        Container container = this.getParent();
        Point point = this.getLocation();
        Rectangle rectangle = this.getBounds();
        if (container != null) {
            while (!(container instanceof Window)) {
                Point point2 = container.getLocation();
                point.translate(-point2.x, -point2.y);
                if ((container = container.getParent()) != null) continue;
            }
        }
        this.windowRelativeBounds.setBounds(-point.x, -point.y, rectangle.width, rectangle.height);
        this.boundsValid = true;
        return this.windowRelativeBounds;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        Rectangle rectangle = new Rectangle(0, 0, n3 - 1, n4 - 1);
        if (this.webShell != null) {
            System.out.println("in BrowserControlCanvas setBounds: x = " + n + " y = " + n2 + " w = " + n3 + " h = " + n4);
            try {
                WindowControl windowControl = (WindowControl)this.webShell.queryInterface("webclient.WindowControl");
                windowControl.setBounds(rectangle);
            }
            catch (Exception exception) {
                System.out.println("Can't setBounds(" + rectangle + ") " + exception.getMessage());
            }
        }
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
    }
}

