/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.test;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMTreeDumper {
    private String prefix = "DOMTreeDumper";
    private boolean debug;
    private PrintStream ps;
    private boolean inA;
    private final String[] endTagForbiddenNames = new String[]{"AREA", "BASE", "BASEFONT", "BR", "COL", "FRAME", "HR", "IMG", "INPUT", "ISINDEX", "LINK", "META", "PARAM"};

    DOMTreeDumper() {
        this(true);
    }

    DOMTreeDumper(boolean bl) {
        this.debug = bl;
    }

    private void dumpDocument(Document document) {
        if (document == null) {
            return;
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return;
        }
        element.normalize();
        this.dumpNode(element);
        this.ps.println();
        this.ps.flush();
        element = null;
        document = null;
    }

    private void dumpNode(Node node) {
        this.dumpNode(node, false);
    }

    private void dumpNode(Node node, boolean bl) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        switch (s) {
            case 1: {
                if (string.equals("A")) {
                    this.inA = true;
                }
                if (!this.inA && !string.equals("BR")) {
                    this.ps.println();
                }
                this.ps.print("<" + string);
                this.dumpAttributes(node);
                this.ps.print(">");
                this.dumpChildren(node);
                if (string.equals("A")) {
                    this.inA = false;
                }
                if (this.endTagForbidden(string)) break;
                this.ps.print("</" + node.getNodeName() + ">");
                break;
            }
            case 2: {
                this.ps.print(" " + string.toUpperCase() + "=\"" + string2 + "\"");
                break;
            }
            case 3: {
                if (!node.getParentNode().getNodeName().equals("PRE")) {
                    string2 = string2.trim();
                }
                if (string2.equals("")) break;
                if (!this.inA) {
                    this.ps.println();
                }
                this.ps.print(this.canonicalize(string2));
                break;
            }
            case 8: {
                this.ps.print("\n<!--" + string2 + "-->");
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.ps.println("\n<!-- NOT HANDLED: " + string + "  value=" + string2 + " -->");
            }
        }
    }

    private void dumpAttributes(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = namedNodeMap.item(n2);
            this.dumpNode(node2, true);
            ++n2;
        }
    }

    private void dumpChildren(Node node) {
        boolean bl;
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        boolean bl2 = bl = nodeList != null && (n = nodeList.getLength()) > 0;
        if (!bl) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.dumpNode(nodeList.item(n2), false);
            ++n2;
        }
        if (!this.inA) {
            this.ps.println();
        }
    }

    private String canonicalize(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = stringBuffer.charAt(n2);
            switch (c) {
                case '&': {
                    stringBuffer2.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer2.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer2.append("&gt;");
                    break;
                }
                case '\u00a0': {
                    stringBuffer2.append("&nbsp;");
                    break;
                }
                default: {
                    stringBuffer2.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer2.toString();
    }

    private boolean endTagForbidden(String string) {
        int n = 0;
        while (n < this.endTagForbiddenNames.length) {
            if (string.equals(this.endTagForbiddenNames[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void dumpToFile(String string, Document document) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.ps = new PrintStream(new BufferedOutputStream(fileOutputStream, 1024));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.dbg("dumping to " + string);
        this.dumpDocument(document);
        this.dbg("finished dumping...");
    }

    private void dbg(String string) {
        if (this.debug) {
            System.out.println(this.prefix + ": " + string);
        }
    }
}

