/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.xpcom;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Hashtable;
import org.mozilla.xpcom.Debug;
import org.mozilla.xpcom.IID;
import org.mozilla.xpcom.MethodArray;
import org.mozilla.xpcom.Utilities;
import org.mozilla.xpcom.nsISupports;

public class InterfaceRegistry {
    private static String IID_STRING = "IID";
    private static Hashtable interfaces = null;
    private static Hashtable iMethods = null;
    private static HashSet keywords = null;
    private static boolean debug = true;
    private static String[] javaKeywords = new String[]{"abstract", "default", "if", "private", "this", "boolean", "do", "implements", "protected", "throw", "break", "double", "import", "public", "throws", "byte", "else", "instanceof", "return", "transient", "case", "extends", "int", "short", "try", "catch", "final", "interface", "static", "void", "char", "finally", "long", "strictfp", "volatile", "class", "float", "native", "super", "while", "const", "for", "new", "switch", "continue", "goto", "package", "synchronized", "toString", "clone", "finalize", "hashCode", "equals"};

    private InterfaceRegistry() {
    }

    public static void register(nsISupports nsISupports2) {
        if (nsISupports2 == null) {
            return;
        }
        Class<?> clazz = nsISupports2.getClass();
        InterfaceRegistry.register(clazz);
    }

    public static void register(String string) {
        try {
            InterfaceRegistry.register(Class.forName(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void register(Class clazz) {
        if (clazz == null) {
            return;
        }
        if (interfaces == null) {
            interfaces = new Hashtable();
        }
        if (iMethods == null) {
            iMethods = new Hashtable();
        }
        if (keywords == null) {
            keywords = new HashSet(javaKeywords.length);
            int n = 0;
            while (n < javaKeywords.length) {
                keywords.add(javaKeywords[n]);
                ++n;
            }
        }
        if (!clazz.isInterface()) {
            Class<?>[] classArray = clazz.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                InterfaceRegistry.registerInterfaces(classArray[n]);
                ++n;
            }
        } else {
            InterfaceRegistry.registerInterfaces(clazz);
        }
    }

    public static void unregister(IID iID) {
        interfaces.remove(iID);
        iMethods.remove(iID);
    }

    private static Hashtable registerInterfaces(Class clazz) {
        try {
            Object object = clazz.getField(IID_STRING).get(clazz);
            if (object instanceof IID) {
                IID iID = (IID)object;
                if (interfaces.get(iID) == null) {
                    String[] stringArray = Utilities.getInterfaceMethodNames(iID.getString());
                    if (stringArray != null) {
                        Method[] methodArray = new Method[stringArray.length];
                        Class<?>[] classArray = clazz.getInterfaces();
                        if (classArray.length < 2) {
                            Hashtable<String, Method> hashtable = null;
                            Method[] methodArray2 = clazz.getDeclaredMethods();
                            hashtable = classArray.length == 0 ? new Hashtable<String, Method>(methodArray2.length) : new Hashtable(InterfaceRegistry.registerInterfaces(classArray[0]));
                            int n = 0;
                            while (n < methodArray2.length) {
                                hashtable.put(methodArray2[n].getName(), methodArray2[n]);
                                ++n;
                            }
                            int n2 = stringArray.length - 1;
                            while (n2 >= 0) {
                                methodArray[n2] = (Method)hashtable.get(InterfaceRegistry.subscriptMethodName(stringArray[n2]));
                                --n2;
                            }
                            interfaces.put(iID, clazz);
                            iMethods.put(iID, new MethodArray(methodArray, hashtable));
                            InterfaceRegistry.debug(clazz.getName() + ": " + iID + "  ( " + clazz + " )");
                            InterfaceRegistry.printMethods(methodArray);
                            return hashtable;
                        }
                    }
                } else {
                    MethodArray methodArray = (MethodArray)iMethods.get(iID);
                    if (methodArray != null) {
                        return methodArray.names;
                    }
                }
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            InterfaceRegistry.debug("no such field...");
        }
        catch (IllegalAccessException illegalAccessException) {
            InterfaceRegistry.debug("can't access field...");
        }
        return new Hashtable();
    }

    public static Class getInterface(IID iID) {
        Object var1_1 = null;
        if (interfaces != null) {
            var1_1 = interfaces.get(iID);
        }
        if (var1_1 == null || !(var1_1 instanceof Class)) {
            return null;
        }
        return var1_1;
    }

    public static Method getMethodByIndex(int n, IID iID) {
        Method method = null;
        MethodArray methodArray = (MethodArray)iMethods.get(iID);
        if (methodArray != null && methodArray.methods != null) {
            try {
                method = methodArray.methods[n];
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return method;
    }

    public static int getIndexByMethod(Method method, IID iID) {
        int n = -1;
        MethodArray methodArray = (MethodArray)iMethods.get(iID);
        if (methodArray != null && methodArray.methods != null) {
            int n2 = 0;
            while (n2 < methodArray.methods.length) {
                if (methodArray.methods[n2] != null && method.equals(methodArray.methods[n2])) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        return n;
    }

    private static String subscriptMethodName(String string) {
        if (keywords.contains(string)) {
            return string + "_";
        }
        return string;
    }

    private static void printMethods(Method[] methodArray) {
        if (debug) {
            int n = 0;
            while (n < methodArray.length) {
                InterfaceRegistry.printMethod(methodArray[n]);
                ++n;
            }
        }
    }

    private static void printMethod(Method method) {
        if (method == null) {
            Debug.log("<null>");
            return;
        }
        Class<?> clazz = method.getReturnType();
        Class<?>[] classArray = method.getParameterTypes();
        String string = method.getName();
        System.out.print(Modifier.toString(method.getModifiers()));
        System.out.print(" " + clazz.getName() + " " + string + "(");
        int n = 0;
        while (n < classArray.length) {
            if (n > 0) {
                System.out.print(", ");
            }
            System.out.print(classArray[n].getName());
            ++n;
        }
        Debug.log(");");
    }

    private static void debug(String string) {
        if (debug) {
            Debug.log(string);
        }
    }
}

