/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cachescheme;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import sun.plugin.cachescheme.CacheTableEntryException;
import sun.plugin.cachescheme.InvalidCacheParameterException;
import sun.plugin.cachescheme.JarFileInvalidException;
import sun.plugin.cachescheme.PluginJarCacheTable;

public class PluginJarCacheTableEntry {
    private static String delimitor = "#";
    long m_timeStamp;
    int m_fileSize;
    String m_fileName;
    String m_versionString;
    String m_entry;

    PluginJarCacheTableEntry(String string) throws CacheTableEntryException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, delimitor, false);
        if (stringTokenizer.countTokens() != 4) {
            throw new CacheTableEntryException("Entry is found invalid");
        }
        this.m_entry = string;
        this.m_versionString = stringTokenizer.nextToken().trim();
        this.m_fileName = stringTokenizer.nextToken().trim();
        try {
            this.m_timeStamp = Long.parseLong(stringTokenizer.nextToken().trim(), 10);
            this.m_fileSize = Integer.parseInt(stringTokenizer.nextToken().trim(), 10);
        }
        catch (Exception exception) {
            throw new CacheTableEntryException("Entry is found invalid");
        }
    }

    public static PluginJarCacheTableEntry createEntry(String string, String string2, long l, int n) throws CacheTableEntryException {
        String string3 = string + delimitor + string2 + delimitor + String.valueOf(l) + delimitor + String.valueOf(n);
        PluginJarCacheTableEntry pluginJarCacheTableEntry = new PluginJarCacheTableEntry(string3);
        return pluginJarCacheTableEntry;
    }

    public String toString() {
        return this.m_entry;
    }

    public boolean verifyCacheVersion(String string) throws JarFileInvalidException, InvalidCacheParameterException {
        if (!this.m_versionString.equalsIgnoreCase("null") && PluginJarCacheTableEntry.extractVersion(string) <= PluginJarCacheTableEntry.extractVersion(this.m_versionString)) {
            return true;
        }
        throw new JarFileInvalidException("Jarfile version doesn't match");
    }

    public Date getCacheTimeStamp() {
        return new Date(this.m_timeStamp);
    }

    public int getCacheFileSize() {
        return this.m_fileSize;
    }

    public boolean verifyCacheTimeStamp(Date date) throws JarFileInvalidException {
        Date date2;
        if (this.m_timeStamp > 0L && date != null && (date.before(date2 = this.getCacheTimeStamp()) || date.equals(date2))) {
            return true;
        }
        throw new JarFileInvalidException("File time stamp doesn't match");
    }

    public boolean verifyCacheFileSize(int n) throws JarFileInvalidException {
        if (this.m_fileSize > 0 && n > 0 && n == this.m_fileSize) {
            return true;
        }
        throw new JarFileInvalidException("File size doesn't match");
    }

    public File getFileInCache() throws IOException {
        File file = new File(PluginJarCacheTable.getCacheHomeDir() + File.separator + this.m_fileName);
        return file;
    }

    /*
     * Unable to fully structure code
     */
    public static long extractVersion(String var0) throws InvalidCacheParameterException {
        var1_1 = 0L;
        var3_2 = new StringTokenizer(var0, ".", false);
        if (var3_2.countTokens() == 4) ** GOTO lbl8
        throw new InvalidCacheParameterException("Requires attribute 'cache_version' in X.X.X.X form, where X is 0 to F");
lbl-1000:
        // 1 sources

        {
            var4_3 = var3_2.nextToken().trim();
            var1_1 *= 16L;
            var1_1 += (long)Integer.parseInt(var4_3, 16);
lbl8:
            // 2 sources

            ** while (var3_2.hasMoreTokens())
        }
lbl9:
        // 1 sources

        return var1_1;
    }
}

