; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc  -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff -mattr=+aix-small-local-exec-tls < %s \
; RUN:      | FileCheck %s --check-prefix=SMALL-LOCAL-EXEC-SMALLCM64
; RUN: llc  -verify-machineinstrs -mcpu=pwr7 -ppc-asm-full-reg-names \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff --code-model=large \
; RUN:      -mattr=+aix-small-local-exec-tls < %s | FileCheck %s \
; RUN:      --check-prefix=SMALL-LOCAL-EXEC-LARGECM64

; Test disassembly of object.
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=+aix-small-local-exec-tls \
; RUN:      -mtriple powerpc64-ibm-aix-xcoff -xcoff-traceback-table=false \
; RUN:      --code-model=large -filetype=obj -o %t.o < %s
; RUN: llvm-objdump -D -r --symbol-description %t.o | FileCheck -D#NFA=2 --check-prefix=DIS %s

@mySmallLocalExecTLSv1 = thread_local(localexec) global [8187 x i32] zeroinitializer, align 4
@mySmallLocalExecTLS2 = thread_local(localexec) global [4000 x i32] zeroinitializer, align 4
@mySmallLocalExecTLS3 = thread_local(localexec) global [4000 x i32] zeroinitializer, align 4
@mySmallLocalExecTLS4 = thread_local(localexec) global [4000 x i32] zeroinitializer, align 4
@mySmallLocalExecTLS5 = thread_local(localexec) global [4000 x i32] zeroinitializer, align 4
@mySmallLocalExecTLSv2 = thread_local(localexec) global [9000 x i32] zeroinitializer, align 4
declare nonnull ptr @llvm.threadlocal.address.p0(ptr nonnull) #1

; All accesses use a "faster" local-exec sequence directly off the thread pointer.
define signext i32 @StoreArrays1() {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: StoreArrays1:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 1
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r4, 4
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r3, mySmallLocalExecTLSv1[TL]@le(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 2
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r4, mySmallLocalExecTLSv1[TL]@le+24(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r4, mySmallLocalExecTLS4[TL]@le+328-65536(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r3, mySmallLocalExecTLS2[TL]@le+320-65536(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 3
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r3, mySmallLocalExecTLS3[TL]@le+324-65536(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 88
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r3, mySmallLocalExecTLS5[TL]@le+332-65536(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 102
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: StoreArrays1:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 1
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r4, 4
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r3, mySmallLocalExecTLSv1[TL]@le(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 2
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r4, mySmallLocalExecTLSv1[TL]@le+24(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r4, mySmallLocalExecTLS4[TL]@le+328-65536(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r3, mySmallLocalExecTLS2[TL]@le+320-65536(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 3
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r3, mySmallLocalExecTLS3[TL]@le+324-65536(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 88
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r3, mySmallLocalExecTLS5[TL]@le+332-65536(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 102
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLSv1)
  store i32 1, ptr %0, align 4
  %arrayidx1 = getelementptr inbounds [8187 x i32], ptr %0, i64 0, i64 6
  store i32 4, ptr %arrayidx1, align 4
  %1 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS2)
  %arrayidx2 = getelementptr inbounds [4000 x i32], ptr %1, i64 0, i64 80
  store i32 2, ptr %arrayidx2, align 4
  %2 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS3)
  %arrayidx3 = getelementptr inbounds [4000 x i32], ptr %2, i64 0, i64 81
  store i32 3, ptr %arrayidx3, align 4
  %3 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS4)
  %arrayidx4 = getelementptr inbounds [4000 x i32], ptr %3, i64 0, i64 82
  store i32 4, ptr %arrayidx4, align 4
  %4 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS5)
  %arrayidx5 = getelementptr inbounds [4000 x i32], ptr %4, i64 0, i64 83
  store i32 88, ptr %arrayidx5, align 4
  %5 = load i32, ptr %0, align 4
  %6 = load i32, ptr %arrayidx1, align 4
  %7 = load i32, ptr %arrayidx2, align 4
  %8 = load i32, ptr %arrayidx3, align 4
  %9 = load i32, ptr %arrayidx4, align 4
  %add = add i32 %5, 88
  %add9 = add i32 %add, %6
  %add11 = add i32 %add9, %7
  %add13 = add i32 %add11, %8
  %add15 = add i32 %add13, %9
  ret i32 %add15
}

; Example of one access using the regular local-exec access from the TOC.
define signext i32 @StoreArrays2() {
; SMALL-LOCAL-EXEC-SMALLCM64-LABEL: StoreArrays2:
; SMALL-LOCAL-EXEC-SMALLCM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r4, 2
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 1
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r4, mySmallLocalExecTLS2[TL]@le+320-65536(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r4, 3
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r4, mySmallLocalExecTLS3[TL]@le+324-65536(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    ld r4, L..C0(r2) # target-flags(ppc-tprel) @mySmallLocalExecTLSv2
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    add r4, r13, r4
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r3, 0(r4)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 4
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r3, 24(r4)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r4, 88
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r3, mySmallLocalExecTLS4[TL]@le+328-65536(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    li r3, 102
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    stw r4, mySmallLocalExecTLS5[TL]@le+332-65536(r13)
; SMALL-LOCAL-EXEC-SMALLCM64-NEXT:    blr
;
; SMALL-LOCAL-EXEC-LARGECM64-LABEL: StoreArrays2:
; SMALL-LOCAL-EXEC-LARGECM64:       # %bb.0: # %entry
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 2
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r4, 3
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r3, mySmallLocalExecTLS2[TL]@le+320-65536(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    addis r3, L..C0@u(r2)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    ld r3, L..C0@l(r3)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r4, mySmallLocalExecTLS3[TL]@le+324-65536(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r4, 1
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    add r3, r13, r3
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r4, 0(r3)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r4, 4
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r4, 24(r3)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 88
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r4, mySmallLocalExecTLS4[TL]@le+328-65536(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    stw r3, mySmallLocalExecTLS5[TL]@le+332-65536(r13)
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    li r3, 102
; SMALL-LOCAL-EXEC-LARGECM64-NEXT:    blr
entry:
  %0 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLSv2)
  store i32 1, ptr %0, align 4
  %arrayidx1 = getelementptr inbounds [9000 x i32], ptr %0, i64 0, i64 6
  store i32 4, ptr %arrayidx1, align 4
  %1 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS2)
  %arrayidx2 = getelementptr inbounds [4000 x i32], ptr %1, i64 0, i64 80
  store i32 2, ptr %arrayidx2, align 4
  %2 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS3)
  %arrayidx3 = getelementptr inbounds [4000 x i32], ptr %2, i64 0, i64 81
  store i32 3, ptr %arrayidx3, align 4
  %3 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS4)
  %arrayidx4 = getelementptr inbounds [4000 x i32], ptr %3, i64 0, i64 82
  store i32 4, ptr %arrayidx4, align 4
  %4 = tail call align 4 ptr @llvm.threadlocal.address.p0(ptr align 4 @mySmallLocalExecTLS5)
  %arrayidx5 = getelementptr inbounds [4000 x i32], ptr %4, i64 0, i64 83
  store i32 88, ptr %arrayidx5, align 4
  %5 = load i32, ptr %0, align 4
  %6 = load i32, ptr %arrayidx1, align 4
  %7 = load i32, ptr %arrayidx2, align 4
  %8 = load i32, ptr %arrayidx3, align 4
  %9 = load i32, ptr %arrayidx4, align 4
  %add = add i32 %5, 88
  %add9 = add i32 %add, %6
  %add11 = add i32 %add9, %7
  %add13 = add i32 %add11, %8
  %add15 = add i32 %add13, %9
  ret i32 %add15
}

; DIS:      file format aix5coff64-rs6000
; DIS:      Disassembly of section .text:
; DIS:      0000000000000000 (idx: [[#NFA+3]]) .StoreArrays1:
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 1
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 4
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 3, 0(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: [[#NFA+15]]) mySmallLocalExecTLSv1[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 2
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 24(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: [[#NFA+15]]) mySmallLocalExecTLSv1[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, -460(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: [[#NFA+21]]) mySmallLocalExecTLS4[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 3, -32468(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: [[#NFA+17]]) mySmallLocalExecTLS2[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 3
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 3, -16464(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: [[#NFA+19]]) mySmallLocalExecTLS3[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 88
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 3, 15544(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: [[#NFA+23]]) mySmallLocalExecTLS5[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 102
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                blr

; DIS:      0000000000000040 (idx: [[#NFA+5]]) .StoreArrays2:
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 2
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 3
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 3, -32468(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: [[#NFA+17]]) mySmallLocalExecTLS2[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                addis 3, 2, 0
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCU	(idx: [[#NFA+13]]) mySmallLocalExecTLSv2[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                ld 3, 0(3)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TOCL	(idx: [[#NFA+13]]) mySmallLocalExecTLSv2[TE]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, -16464(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: [[#NFA+19]]) mySmallLocalExecTLS3[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 1
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                add 3, 13, 3
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 0(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 4, 4
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, 24(3)
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 88
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 4, -460(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: [[#NFA+21]]) mySmallLocalExecTLS4[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                stw 3, 15544(13)
; DIS-NEXT: {{0*}}[[#ADDR + 2]]: R_TLS_LE	(idx: [[#NFA+23]]) mySmallLocalExecTLS5[TL]
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                li 3, 102
; DIS-NEXT: [[#%x, ADDR:]]: {{.*}}                blr

; DIS:      Disassembly of section .data:
; DIS:      0000000000000080 (idx: [[#NFA+7]]) StoreArrays1[DS]:
; DIS-NEXT:       80: 00 00 00 00
; DIS-NEXT: 0000000000000080:  R_POS	(idx: [[#NFA+3]]) .StoreArrays1
; DIS-NEXT:       84: 00 00 00 00
; DIS-NEXT:       88: 00 00 00 00
; DIS-NEXT: 0000000000000088:  R_POS        (idx: [[#NFA+11]]) TOC[TC0]
; DIS-NEXT:       8c: 00 00 00 b0

; DIS:      0000000000000098 (idx: [[#NFA+9]]) StoreArrays2[DS]:
; DIS-NEXT:       98: 00 00 00 00
; DIS-NEXT: 0000000000000098:  R_POS	(idx: [[#NFA+5]]) .StoreArrays2
; DIS-NEXT:       9c: 00 00 00 40
; DIS-NEXT:       a0: 00 00 00 00
; DIS-NEXT: 00000000000000a0:  R_POS        (idx: [[#NFA+11]]) TOC[TC0]
; DIS-NEXT:       a4: 00 00 00 b0

; DIS:      00000000000000b0 (idx: [[#NFA+13]]) mySmallLocalExecTLSv2[TE]:
; DIS-NEXT:       b0: 00 00 00 00
; DIS-NEXT: 00000000000000b0:  R_TLS_LE     (idx: [[#NFA+25]]) mySmallLocalExecTLSv2[TL]
; DIS-NEXT:       b4: 00 01 79 ec

; DIS:      Disassembly of section .tdata:
; DIS:      0000000000000000 (idx: [[#NFA+15]]) mySmallLocalExecTLSv1[TL]:
; DIS:      0000000000007fec (idx: [[#NFA+17]]) mySmallLocalExecTLS2[TL]:
; DIS:      000000000000be6c (idx: [[#NFA+19]]) mySmallLocalExecTLS3[TL]:
; DIS:      000000000000fcec (idx: [[#NFA+21]]) mySmallLocalExecTLS4[TL]:
; DIS:      0000000000013b6c (idx: [[#NFA+23]]) mySmallLocalExecTLS5[TL]:
; DIS:      00000000000179ec (idx: [[#NFA+25]]) mySmallLocalExecTLSv2[TL]:
