/* utils.c generated by valac 0.26.1, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 * Copyright (C) 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 * Authored by Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>


#define TYPE_UTILS (utils_get_type ())
#define UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UTILS, Utils))
#define UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UTILS, UtilsClass))
#define IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UTILS))
#define IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UTILS))
#define UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UTILS, UtilsClass))

typedef struct _Utils Utils;
typedef struct _UtilsClass UtilsClass;
typedef struct _UtilsPrivate UtilsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _Utils {
	GObject parent_instance;
	UtilsPrivate * priv;
};

struct _UtilsClass {
	GObjectClass parent_class;
};


static gpointer utils_parent_class = NULL;
static GHashTable* utils_app_to_desktop_file;
static GHashTable* utils_app_to_desktop_file = NULL;
static gchar** utils_desktop_file_prefixes;
static gint utils_desktop_file_prefixes_length1;
static gchar** utils_desktop_file_prefixes = NULL;
static gint utils_desktop_file_prefixes_length1 = 0;
static gint _utils_desktop_file_prefixes_size_ = 0;

GType utils_get_type (void) G_GNUC_CONST;
enum  {
	UTILS_DUMMY_PROPERTY
};
gchar* utils_get_file_contents (GFile* file);
static void utils_init_desktop_id (void);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static gchar* utils_extract_desktop_id (const gchar* path);
gchar* utils_get_actor_for_desktop_file (const gchar* desktop_file, GDesktopAppInfo** dai);
static void utils_init_application_cache (void);
static void _g_free0_ (gpointer var);
gchar* utils_get_ooo_desktop_file_for_mimetype (const gchar* mimetype);
gchar* utils_find_desktop_file_for_app (const gchar* app_name, const gchar* mimetype);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
Utils* utils_new (void);
Utils* utils_construct (GType object_type);
static void utils_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


gchar* utils_get_file_contents (GFile* file) {
	gchar* result = NULL;
	gchar* contents = NULL;
	guint8* contents_array = NULL;
	gint contents_array_length1 = 0;
	gint _contents_array_size_ = 0;
	guint8* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gchar* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	{
		gboolean _tmp0_ = FALSE;
		GFile* _tmp1_ = NULL;
		guint8* _tmp2_ = NULL;
		gsize _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp1_ = file;
		_tmp4_ = g_file_load_contents (_tmp1_, NULL, &_tmp2_, &_tmp3_, NULL, &_inner_error_);
		contents_array = (g_free (contents_array), NULL);
		contents_array = _tmp2_;
		contents_array_length1 = _tmp3_;
		_contents_array_size_ = contents_array_length1;
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		if (!_tmp0_) {
			result = NULL;
			contents_array = (g_free (contents_array), NULL);
			_g_free0 (contents);
			return result;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* err = NULL;
		GFile* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = file;
		_tmp6_ = g_file_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = err;
		_tmp9_ = _tmp8_->message;
		g_debug ("utils.vala:47: Couldn't get file contents %s: %s", _tmp7_, _tmp9_);
		_g_free0 (_tmp7_);
		_g_error_free0 (err);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		contents_array = (g_free (contents_array), NULL);
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp10_ = contents_array;
	_tmp10__length1 = contents_array_length1;
	_tmp11_ = g_strdup ((const gchar*) _tmp10_);
	_g_free0 (contents);
	contents = _tmp11_;
	result = contents;
	contents_array = (g_free (contents_array), NULL);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void utils_init_desktop_id (void) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* session_var = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	_tmp0_ = utils_desktop_file_prefixes;
	_tmp0__length1 = utils_desktop_file_prefixes_length1;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_getenv ("XDG_CURRENT_DESKTOP");
	session_var = _tmp1_;
	_tmp2_ = session_var;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = session_var;
		g_desktop_app_info_set_desktop_env (_tmp3_);
	} else {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp4_ = g_getenv ("DESKTOP_SESSION");
		session_var = _tmp4_;
		_tmp5_ = session_var;
		if (_tmp5_ == NULL) {
			g_desktop_app_info_set_desktop_env ("GNOME");
		} else {
			gchar* desktop_session = NULL;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			_tmp6_ = session_var;
			_tmp7_ = g_utf8_strup (_tmp6_, (gssize) (-1));
			desktop_session = _tmp7_;
			_tmp8_ = desktop_session;
			_tmp9_ = g_str_has_prefix (_tmp8_, "GNOME");
			if (_tmp9_) {
				g_desktop_app_info_set_desktop_env ("GNOME");
			} else {
				const gchar* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				_tmp10_ = desktop_session;
				_tmp11_ = g_str_has_prefix (_tmp10_, "KDE");
				if (_tmp11_) {
					g_desktop_app_info_set_desktop_env ("KDE");
				} else {
					const gchar* _tmp12_ = NULL;
					gboolean _tmp13_ = FALSE;
					_tmp12_ = desktop_session;
					_tmp13_ = g_str_has_prefix (_tmp12_, "XFCE");
					if (_tmp13_) {
						g_desktop_app_info_set_desktop_env ("XFCE");
					} else {
						g_desktop_app_info_set_desktop_env ("GNOME");
					}
				}
			}
			_g_free0 (desktop_session);
		}
	}
	_tmp15_ = _tmp14_ = g_get_system_data_dirs ();
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
		data_dir_collection = _tmp15_;
		data_dir_collection_length1 = _vala_array_length (_tmp14_);
		for (data_dir_it = 0; data_dir_it < _vala_array_length (_tmp14_); data_dir_it = data_dir_it + 1) {
			const gchar* data_dir = NULL;
			data_dir = data_dir_collection[data_dir_it];
			{
				gchar** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				_tmp16_ = utils_desktop_file_prefixes;
				_tmp16__length1 = utils_desktop_file_prefixes_length1;
				_tmp17_ = data_dir;
				_tmp18_ = g_build_path (G_DIR_SEPARATOR_S, _tmp17_, "applications", G_DIR_SEPARATOR_S, NULL, NULL);
				_vala_array_add1 (&utils_desktop_file_prefixes, &utils_desktop_file_prefixes_length1, &_utils_desktop_file_prefixes_size_, _tmp18_);
			}
		}
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* utils_extract_desktop_id (const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* normalized_path = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = g_str_has_prefix (_tmp0_, "/");
	if (!_tmp1_) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = path;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = path;
	_tmp5_ = string_replace (_tmp4_, "//", "/");
	normalized_path = _tmp5_;
	_tmp6_ = utils_desktop_file_prefixes;
	_tmp6__length1 = utils_desktop_file_prefixes_length1;
	{
		gchar** prefix_collection = NULL;
		gint prefix_collection_length1 = 0;
		gint _prefix_collection_size_ = 0;
		gint prefix_it = 0;
		prefix_collection = _tmp6_;
		prefix_collection_length1 = _tmp6__length1;
		for (prefix_it = 0; prefix_it < _tmp6__length1; prefix_it = prefix_it + 1) {
			const gchar* prefix = NULL;
			prefix = prefix_collection[prefix_it];
			{
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				_tmp7_ = normalized_path;
				_tmp8_ = prefix;
				_tmp9_ = g_str_has_prefix (_tmp7_, _tmp8_);
				if (_tmp9_) {
					gchar* without_prefix = NULL;
					const gchar* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					gchar* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					_tmp10_ = normalized_path;
					_tmp11_ = prefix;
					_tmp12_ = strlen (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = string_substring (_tmp10_, (glong) _tmp13_, (glong) (-1));
					without_prefix = _tmp14_;
					_tmp15_ = without_prefix;
					_tmp16_ = string_contains (_tmp15_, G_DIR_SEPARATOR_S);
					if (_tmp16_) {
						const gchar* _tmp17_ = NULL;
						gchar* _tmp18_ = NULL;
						_tmp17_ = without_prefix;
						_tmp18_ = string_replace (_tmp17_, G_DIR_SEPARATOR_S, "-");
						result = _tmp18_;
						_g_free0 (without_prefix);
						_g_free0 (normalized_path);
						return result;
					}
					result = without_prefix;
					_g_free0 (normalized_path);
					return result;
				}
			}
		}
	}
	_tmp19_ = path;
	_tmp20_ = g_path_get_basename (_tmp19_);
	result = _tmp20_;
	_g_free0 (normalized_path);
	return result;
}


gchar* utils_get_actor_for_desktop_file (const gchar* desktop_file, GDesktopAppInfo** dai) {
	GDesktopAppInfo* _vala_dai = NULL;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GDesktopAppInfo* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GDesktopAppInfo* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* desktop_id = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	g_return_val_if_fail (desktop_file != NULL, NULL);
	utils_init_desktop_id ();
	_tmp0_ = desktop_file;
	_tmp1_ = g_path_is_absolute (_tmp0_);
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		GDesktopAppInfo* _tmp3_ = NULL;
		_tmp2_ = desktop_file;
		_tmp3_ = g_desktop_app_info_new_from_filename (_tmp2_);
		_g_object_unref0 (_vala_dai);
		_vala_dai = _tmp3_;
	} else {
		const gchar* _tmp4_ = NULL;
		GDesktopAppInfo* _tmp5_ = NULL;
		_tmp4_ = desktop_file;
		_tmp5_ = g_desktop_app_info_new (_tmp4_);
		_g_object_unref0 (_vala_dai);
		_vala_dai = _tmp5_;
	}
	_tmp6_ = _vala_dai;
	if (_tmp6_ == NULL) {
		result = NULL;
		if (dai) {
			*dai = _vala_dai;
		} else {
			_g_object_unref0 (_vala_dai);
		}
		return result;
	}
	_tmp8_ = _vala_dai;
	_tmp9_ = g_app_info_get_id ((GAppInfo*) _tmp8_);
	_tmp10_ = g_strdup (_tmp9_);
	_tmp7_ = _tmp10_;
	if (_tmp7_ == NULL) {
		GDesktopAppInfo* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp11_ = _vala_dai;
		_tmp12_ = g_desktop_app_info_get_filename (_tmp11_);
		_tmp13_ = utils_extract_desktop_id (_tmp12_);
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp13_;
	}
	_tmp14_ = _tmp7_;
	_tmp7_ = NULL;
	desktop_id = _tmp14_;
	_tmp15_ = desktop_id;
	_tmp16_ = g_strdup_printf ("application://%s", _tmp15_);
	result = _tmp16_;
	_g_free0 (desktop_id);
	_g_free0 (_tmp7_);
	if (dai) {
		*dai = _vala_dai;
	} else {
		_g_object_unref0 (_vala_dai);
	}
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void utils_init_application_cache (void) {
	GHashTable* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = utils_app_to_desktop_file;
	_tmp1_ = G_UNLIKELY (_tmp0_ == NULL);
	if (_tmp1_) {
		GHashFunc _tmp2_ = NULL;
		GEqualFunc _tmp3_ = NULL;
		GHashTable* _tmp4_ = NULL;
		_tmp2_ = g_str_hash;
		_tmp3_ = g_str_equal;
		_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_free0_);
		_g_hash_table_unref0 (utils_app_to_desktop_file);
		utils_app_to_desktop_file = _tmp4_;
	}
}


gchar* utils_get_ooo_desktop_file_for_mimetype (const gchar* mimetype) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (mimetype != NULL, NULL);
	_tmp1_ = mimetype;
	_tmp2_ = utils_find_desktop_file_for_app ("libreoffice", _tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = mimetype;
		_tmp4_ = utils_find_desktop_file_for_app ("ooffice", _tmp3_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_g_free0 (_tmp0_);
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar* utils_find_desktop_file_for_app (const gchar* app_name, const gchar* mimetype) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* hash_name = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* in_cache = NULL;
	GHashTable* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gconstpointer _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar** data_dirs = NULL;
	gchar** _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint data_dirs_length1 = 0;
	gint _data_dirs_size_ = 0;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar** _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (app_name != NULL, NULL);
	utils_init_application_cache ();
	_tmp1_ = mimetype;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp2_ = app_name;
		_tmp3_ = mimetype;
		_tmp4_ = g_strdup_printf ("%s::%s", _tmp2_, _tmp3_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	} else {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = app_name;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	_tmp7_ = g_strdup (_tmp0_);
	hash_name = _tmp7_;
	_tmp8_ = utils_app_to_desktop_file;
	_tmp9_ = hash_name;
	_tmp10_ = g_hash_table_lookup (_tmp8_, _tmp9_);
	in_cache = (const gchar*) _tmp10_;
	_tmp11_ = in_cache;
	if (_tmp11_ != NULL) {
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp12_ = in_cache;
		_tmp13_ = g_strdup (_tmp12_);
		result = _tmp13_;
		_g_free0 (hash_name);
		_g_free0 (_tmp0_);
		return result;
	}
	_tmp15_ = _tmp14_ = g_get_system_data_dirs ();
	_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup1 (_tmp15_, _vala_array_length (_tmp14_)) : ((gpointer) _tmp15_);
	_tmp16__length1 = _vala_array_length (_tmp14_);
	data_dirs = _tmp16_;
	data_dirs_length1 = _tmp16__length1;
	_data_dirs_size_ = data_dirs_length1;
	_tmp17_ = data_dirs;
	_tmp17__length1 = data_dirs_length1;
	_tmp18_ = g_get_user_data_dir ();
	_tmp19_ = g_strdup (_tmp18_);
	_vala_array_add2 (&data_dirs, &data_dirs_length1, &_data_dirs_size_, _tmp19_);
	_tmp20_ = data_dirs;
	_tmp20__length1 = data_dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp20_;
		dir_collection_length1 = _tmp20__length1;
		for (dir_it = 0; dir_it < _tmp20__length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				gchar* p = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				GFile* f = NULL;
				const gchar* _tmp27_ = NULL;
				GFile* _tmp28_ = NULL;
				GFile* _tmp29_ = NULL;
				gboolean _tmp30_ = FALSE;
				_tmp21_ = dir;
				_tmp22_ = app_name;
				_tmp23_ = g_strdup_printf ("%s.desktop", _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_build_filename (_tmp21_, "applications", _tmp24_, NULL, NULL);
				_tmp26_ = _tmp25_;
				_g_free0 (_tmp24_);
				p = _tmp26_;
				_tmp27_ = p;
				_tmp28_ = g_file_new_for_path (_tmp27_);
				f = _tmp28_;
				_tmp29_ = f;
				_tmp30_ = g_file_query_exists (_tmp29_, NULL);
				if (_tmp30_) {
					GHashTable* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					gchar* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					_tmp31_ = utils_app_to_desktop_file;
					_tmp32_ = hash_name;
					_tmp33_ = g_strdup (_tmp32_);
					_tmp34_ = p;
					_tmp35_ = g_strdup (_tmp34_);
					g_hash_table_insert (_tmp31_, _tmp33_, _tmp35_);
					result = p;
					_g_object_unref0 (f);
					data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (hash_name);
					_g_free0 (_tmp0_);
					return result;
				}
				_g_object_unref0 (f);
				_g_free0 (p);
			}
		}
	}
	_tmp36_ = data_dirs;
	_tmp36__length1 = data_dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp36_;
		dir_collection_length1 = _tmp36__length1;
		for (dir_it = 0; dir_it < _tmp36__length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				gchar* p = NULL;
				const gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				GFile* app_dir = NULL;
				const gchar* _tmp39_ = NULL;
				GFile* _tmp40_ = NULL;
				GFile* _tmp41_ = NULL;
				gboolean _tmp42_ = FALSE;
				_tmp37_ = dir;
				_tmp38_ = g_build_filename (_tmp37_, "applications", NULL, NULL);
				p = _tmp38_;
				_tmp39_ = p;
				_tmp40_ = g_file_new_for_path (_tmp39_);
				app_dir = _tmp40_;
				_tmp41_ = app_dir;
				_tmp42_ = g_file_query_exists (_tmp41_, NULL);
				if (!_tmp42_) {
					_g_object_unref0 (app_dir);
					_g_free0 (p);
					continue;
				}
				{
					GFileEnumerator* enumerator = NULL;
					GFile* _tmp43_ = NULL;
					GFileEnumerator* _tmp44_ = NULL;
					GFileInfo* fi = NULL;
					GFileEnumerator* _tmp45_ = NULL;
					GFileInfo* _tmp46_ = NULL;
					GFileEnumerator* _tmp80_ = NULL;
					_tmp43_ = app_dir;
					_tmp44_ = g_file_enumerate_children (_tmp43_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
					enumerator = _tmp44_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch9_g_error;
					}
					_tmp45_ = enumerator;
					_tmp46_ = g_file_enumerator_next_file (_tmp45_, NULL, &_inner_error_);
					fi = _tmp46_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (enumerator);
						goto __catch9_g_error;
					}
					while (TRUE) {
						GFileInfo* _tmp47_ = NULL;
						GFileInfo* _tmp48_ = NULL;
						const gchar* _tmp49_ = NULL;
						gboolean _tmp50_ = FALSE;
						GFileInfo* _tmp76_ = NULL;
						GFileEnumerator* _tmp77_ = NULL;
						GFileInfo* _tmp78_ = NULL;
						GFileInfo* _tmp79_ = NULL;
						_tmp47_ = fi;
						if (!(_tmp47_ != NULL)) {
							break;
						}
						_tmp48_ = fi;
						_tmp49_ = g_file_info_get_name (_tmp48_);
						_tmp50_ = g_str_has_suffix (_tmp49_, ".desktop");
						if (_tmp50_) {
							gchar* desktop_file = NULL;
							const gchar* _tmp51_ = NULL;
							GFileInfo* _tmp52_ = NULL;
							const gchar* _tmp53_ = NULL;
							gchar* _tmp54_ = NULL;
							GFile* f = NULL;
							const gchar* _tmp55_ = NULL;
							GFile* _tmp56_ = NULL;
							gchar* contents = NULL;
							GFile* _tmp57_ = NULL;
							gchar* _tmp58_ = NULL;
							const gchar* _tmp59_ = NULL;
							_tmp51_ = p;
							_tmp52_ = fi;
							_tmp53_ = g_file_info_get_name (_tmp52_);
							_tmp54_ = g_build_filename (_tmp51_, _tmp53_, NULL, NULL);
							desktop_file = _tmp54_;
							_tmp55_ = desktop_file;
							_tmp56_ = g_file_new_for_path (_tmp55_);
							f = _tmp56_;
							_tmp57_ = f;
							_tmp58_ = utils_get_file_contents (_tmp57_);
							contents = _tmp58_;
							_tmp59_ = contents;
							if (_tmp59_ != NULL) {
								const gchar* _tmp60_ = NULL;
								const gchar* _tmp61_ = NULL;
								gchar* _tmp62_ = NULL;
								gchar* _tmp63_ = NULL;
								gboolean _tmp64_ = FALSE;
								gboolean _tmp65_ = FALSE;
								_tmp60_ = contents;
								_tmp61_ = app_name;
								_tmp62_ = g_strdup_printf ("Exec=%s", _tmp61_);
								_tmp63_ = _tmp62_;
								_tmp64_ = string_contains (_tmp60_, _tmp63_);
								_tmp65_ = _tmp64_;
								_g_free0 (_tmp63_);
								if (_tmp65_) {
									gboolean _tmp66_ = FALSE;
									const gchar* _tmp67_ = NULL;
									_tmp67_ = mimetype;
									if (_tmp67_ == NULL) {
										_tmp66_ = TRUE;
									} else {
										const gchar* _tmp68_ = NULL;
										const gchar* _tmp69_ = NULL;
										gboolean _tmp70_ = FALSE;
										_tmp68_ = contents;
										_tmp69_ = mimetype;
										_tmp70_ = string_contains (_tmp68_, _tmp69_);
										_tmp66_ = _tmp70_;
									}
									if (_tmp66_) {
										GHashTable* _tmp71_ = NULL;
										const gchar* _tmp72_ = NULL;
										gchar* _tmp73_ = NULL;
										const gchar* _tmp74_ = NULL;
										gchar* _tmp75_ = NULL;
										_tmp71_ = utils_app_to_desktop_file;
										_tmp72_ = hash_name;
										_tmp73_ = g_strdup (_tmp72_);
										_tmp74_ = desktop_file;
										_tmp75_ = g_strdup (_tmp74_);
										g_hash_table_insert (_tmp71_, _tmp73_, _tmp75_);
										result = desktop_file;
										_g_free0 (contents);
										_g_object_unref0 (f);
										_g_object_unref0 (fi);
										_g_object_unref0 (enumerator);
										_g_object_unref0 (app_dir);
										_g_free0 (p);
										data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (hash_name);
										_g_free0 (_tmp0_);
										return result;
									}
								}
							}
							_g_free0 (contents);
							_g_object_unref0 (f);
							_g_free0 (desktop_file);
						}
						_tmp77_ = enumerator;
						_tmp78_ = g_file_enumerator_next_file (_tmp77_, NULL, &_inner_error_);
						_tmp76_ = _tmp78_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_object_unref0 (fi);
							_g_object_unref0 (enumerator);
							goto __catch9_g_error;
						}
						_tmp79_ = _tmp76_;
						_tmp76_ = NULL;
						_g_object_unref0 (fi);
						fi = _tmp79_;
						_g_object_unref0 (_tmp76_);
					}
					_tmp80_ = enumerator;
					g_file_enumerator_close (_tmp80_, NULL, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (fi);
						_g_object_unref0 (enumerator);
						goto __catch9_g_error;
					}
					_g_object_unref0 (fi);
					_g_object_unref0 (enumerator);
				}
				goto __finally9;
				__catch9_g_error:
				{
					GError* err = NULL;
					GError* _tmp81_ = NULL;
					const gchar* _tmp82_ = NULL;
					err = _inner_error_;
					_inner_error_ = NULL;
					_tmp81_ = err;
					_tmp82_ = _tmp81_->message;
					g_warning ("utils.vala:260: %s", _tmp82_);
					_g_error_free0 (err);
				}
				__finally9:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (app_dir);
					_g_free0 (p);
					data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (hash_name);
					_g_free0 (_tmp0_);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_object_unref0 (app_dir);
				_g_free0 (p);
			}
		}
	}
	result = NULL;
	data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (hash_name);
	_g_free0 (_tmp0_);
	return result;
}


Utils* utils_construct (GType object_type) {
	Utils * self = NULL;
	self = (Utils*) g_object_new (object_type, NULL);
	return self;
}


Utils* utils_new (void) {
	return utils_construct (TYPE_UTILS);
}


static void utils_class_init (UtilsClass * klass) {
	utils_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = utils_finalize;
}


static void utils_instance_init (Utils * self) {
}


static void utils_finalize (GObject* obj) {
	Utils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UTILS, Utils);
	G_OBJECT_CLASS (utils_parent_class)->finalize (obj);
}


GType utils_get_type (void) {
	static volatile gsize utils_type_id__volatile = 0;
	if (g_once_init_enter (&utils_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Utils), 0, (GInstanceInitFunc) utils_instance_init, NULL };
		GType utils_type_id;
		utils_type_id = g_type_register_static (G_TYPE_OBJECT, "Utils", &g_define_type_info, 0);
		g_once_init_leave (&utils_type_id__volatile, utils_type_id);
	}
	return utils_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



