/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.xmlbeans;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XSDConfig {
    private static final String XMLBEANS_NS = "http://xml.apache.org/xmlbeans/2004/02/xbean/config";
    private static final String XMLBEANS_QNAME_NODE = "qname";
    private static final String XMLBEANS_NS_NODE = "namespace";
    private Document xsdConfigDoc = null;
    private HashMap prefixesToURIMappings = null;
    private HashMap qnamesToJavaNamesMappings = null;
    private HashMap nsToJavaPackagesMap = null;
    public boolean hasQNameToJavaNameMappings = false;
    public boolean hasNamespaceToJavaPackageMappings = false;

    public XSDConfig(String xsdConfigFile) {
        try {
            DocumentBuilder builder = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ParseErrorHandler());
            this.xsdConfigDoc = builder.parse(new File(xsdConfigFile));
            this.prefixesToURIMappings = new HashMap();
            NamedNodeMap attributes = this.xsdConfigDoc.getDocumentElement().getAttributes();
            for (int c = 0; c < attributes.getLength(); ++c) {
                if (attributes.item(c).getNodeName().indexOf("xmlns:") == -1) continue;
                String[] parts = attributes.item(c).getNodeName().split(":");
                this.prefixesToURIMappings.put(parts[1], attributes.item(c).getNodeValue());
            }
            this.qnamesToJavaNamesMappings = this.getQNamesToJavaNames();
            if (this.qnamesToJavaNamesMappings.size() > 0) {
                this.hasQNameToJavaNameMappings = true;
            }
            this.nsToJavaPackagesMap = this.getNamespacesToPackages();
            if (this.nsToJavaPackagesMap.size() > 0) {
                this.hasNamespaceToJavaPackageMappings = true;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (SAXException se) {
            throw new RuntimeException(se);
        }
        catch (IllegalArgumentException iae) {
            throw new RuntimeException(iae);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    public HashMap getSchemaTypesToJavaNames() {
        return this.qnamesToJavaNamesMappings;
    }

    public HashMap getNamespacesToJavaPackages() {
        return this.nsToJavaPackagesMap;
    }

    private HashMap getQNamesToJavaNames() {
        HashMap<String, String> qnamesToJavaNamesMap = new HashMap<String, String>();
        NodeList qnameNodes = this.xsdConfigDoc.getElementsByTagNameNS(XMLBEANS_NS, XMLBEANS_QNAME_NODE);
        for (int c = 0; c < qnameNodes.getLength(); ++c) {
            Node qnameNode = qnameNodes.item(c);
            String schemaType = qnameNode.getAttributes().getNamedItem("name").getNodeValue();
            if (schemaType.indexOf(":") == -1) continue;
            String prefix = schemaType.split(":")[0];
            String localName = schemaType.split(":")[1];
            if (!this.prefixesToURIMappings.containsKey(prefix)) continue;
            String key = (String)this.prefixesToURIMappings.get(prefix) + ":" + localName;
            qnamesToJavaNamesMap.put(key, qnameNode.getAttributes().getNamedItem("javaname").getNodeValue());
        }
        return qnamesToJavaNamesMap;
    }

    private HashMap getNamespacesToPackages() {
        HashMap<String, String> nsToJavaPackagesMap = new HashMap<String, String>();
        NodeList nsNodes = this.xsdConfigDoc.getElementsByTagNameNS(XMLBEANS_NS, XMLBEANS_NS_NODE);
        for (int nsNodesCount = 0; nsNodesCount < nsNodes.getLength(); ++nsNodesCount) {
            Node nsNode = nsNodes.item(nsNodesCount);
            String uri = nsNode.getAttributes().getNamedItem("uri").getNodeValue();
            String packageName = null;
            NodeList childNodes = nsNode.getChildNodes();
            for (int childNodesCount = 0; childNodesCount < childNodes.getLength(); ++childNodesCount) {
                Node childNode = childNodes.item(childNodesCount);
                if (childNode.getLocalName() == null || !childNode.getLocalName().equals("package")) continue;
                packageName = childNode.getFirstChild().getNodeValue();
            }
            if (packageName == null) continue;
            nsToJavaPackagesMap.put(uri, packageName);
        }
        return nsToJavaPackagesMap;
    }

    class ParseErrorHandler
    implements ErrorHandler {
        ParseErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }
    }
}

