/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.InputStream;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.DiskFileDataSource;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.kernel.http.HTTPConstants;
import org.apache.axis2.util.MultipleEntryHashMap;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;

public class MultipartFormDataBuilder
implements Builder {
    @Override
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (request == null) {
            throw new AxisFault("Cannot create DocumentElement without HttpServletRequest");
        }
        String charSetEncoding = (String)messageContext.getProperty("CHARACTER_SET_ENCODING");
        if (charSetEncoding == null) {
            charSetEncoding = request.getCharacterEncoding();
        }
        try {
            MultipleEntryHashMap parameterMap = this.getParameterMap(request, charSetEncoding);
            return BuilderUtil.buildsoapMessage(messageContext, parameterMap, OMAbstractFactory.getSOAP12Factory());
        }
        catch (FileUploadException e) {
            throw AxisFault.makeFault(e);
        }
    }

    private MultipleEntryHashMap getParameterMap(HttpServletRequest request, String charSetEncoding) throws FileUploadException {
        MultipleEntryHashMap parameterMap = new MultipleEntryHashMap();
        List items = MultipartFormDataBuilder.parseRequest(new ServletRequestContext(request));
        for (DiskFileItem diskFileItem : items) {
            Object value;
            boolean isFormField = diskFileItem.isFormField();
            try {
                value = isFormField ? this.getTextParameter(diskFileItem, charSetEncoding) : this.getFileParameter(diskFileItem);
            }
            catch (Exception ex) {
                throw new FileUploadException(ex.getMessage());
            }
            parameterMap.put(diskFileItem.getFieldName(), value);
        }
        return parameterMap;
    }

    private static List parseRequest(ServletRequestContext requestContext) throws FileUploadException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        return upload.parseRequest((RequestContext)requestContext);
    }

    private String getTextParameter(DiskFileItem diskFileItem, String characterEncoding) throws Exception {
        String encoding = diskFileItem.getCharSet();
        if (encoding == null) {
            encoding = characterEncoding;
        }
        String textValue = encoding == null ? new String(diskFileItem.get()) : new String(diskFileItem.get(), encoding);
        return textValue;
    }

    private DataHandler getFileParameter(DiskFileItem diskFileItem) throws Exception {
        DiskFileDataSource dataSource = new DiskFileDataSource(diskFileItem);
        DataHandler dataHandler = new DataHandler((DataSource)dataSource);
        return dataHandler;
    }
}

