/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing.wsdl;

import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.PortType;
import javax.wsdl.extensions.AttributeExtensible;
import javax.xml.namespace.QName;
import org.apache.axis2.addressing.wsdl.WSDL11DefaultActionPatternHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDL11ActionHelper {
    private static final Log log = LogFactory.getLog(WSDL11ActionHelper.class);
    private static final QName submissionWSAWNS = new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Action");
    private static final QName finalWSANS = new QName("http://www.w3.org/2005/08/addressing", "Action");
    private static final QName finalWSAWNS = new QName("http://www.w3.org/2006/05/addressing/wsdl", "Action");
    private static final QName finalWSAMNS = new QName("http://www.w3.org/2007/05/addressing/metadata", "Action");

    public static String getActionFromInputElement(Definition def, PortType wsdl4jPortType, Operation op, Input input) {
        String result = WSDL11ActionHelper.getWSAWActionExtensionAttribute((AttributeExtensible)input);
        if (result == null || result.equals("")) {
            result = WSDL11DefaultActionPatternHelper.generateActionFromInputElement(def, wsdl4jPortType, op, input);
        }
        log.trace((Object)result);
        return result;
    }

    public static String getActionFromOutputElement(Definition def, PortType wsdl4jPortType, Operation op, Output output) {
        String result = WSDL11ActionHelper.getWSAWActionExtensionAttribute((AttributeExtensible)output);
        if (result == null || result.equals("")) {
            result = WSDL11DefaultActionPatternHelper.generateActionFromOutputElement(def, wsdl4jPortType, op, output);
        }
        log.trace((Object)result);
        return result;
    }

    public static String getActionFromFaultElement(Definition def, PortType wsdl4jPortType, Operation op, Fault fault) {
        String result = WSDL11ActionHelper.getWSAWActionExtensionAttribute((AttributeExtensible)fault);
        if (result == null || result.equals("")) {
            result = WSDL11DefaultActionPatternHelper.generateActionFromFaultElement(def, wsdl4jPortType, op, fault);
        }
        log.trace((Object)result);
        return result;
    }

    private static String getWSAWActionExtensionAttribute(AttributeExtensible ae) {
        Object attribute = ae.getExtensionAttribute(submissionWSAWNS);
        if (attribute == null) {
            attribute = ae.getExtensionAttribute(finalWSAMNS);
        }
        if (attribute == null) {
            attribute = ae.getExtensionAttribute(finalWSAWNS);
        }
        if (attribute == null) {
            attribute = ae.getExtensionAttribute(finalWSANS);
        }
        if (attribute instanceof List) {
            List l = (List)attribute;
            attribute = l.size() > 0 ? l.get(0) : null;
        }
        if (attribute instanceof QName) {
            QName qn = (QName)attribute;
            attribute = qn.getLocalPart();
        }
        if (attribute instanceof String) {
            String result = (String)attribute;
            log.trace((Object)result);
            return result;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"No wsaw:Action attribute found");
        }
        return null;
    }

    public static String getInputActionFromStringInformation(String messageExchangePattern, String targetNamespace, String portTypeName, String operationName, String inputName) {
        return WSDL11DefaultActionPatternHelper.getInputActionFromStringInformation(messageExchangePattern, targetNamespace, portTypeName, operationName, inputName);
    }

    public static String getOutputActionFromStringInformation(String messageExchangePattern, String targetNamespace, String portTypeName, String operationName, String outputName) {
        return WSDL11DefaultActionPatternHelper.getOutputActionFromStringInformation(messageExchangePattern, targetNamespace, portTypeName, operationName, outputName);
    }

    public static String getFaultActionFromStringInformation(String targetNamespace, String portTypeName, String operationName, String faultName) {
        return WSDL11DefaultActionPatternHelper.getFaultActionFromStringInformation(targetNamespace, portTypeName, operationName, faultName);
    }
}

