/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.jaxws;

import com.sun.tools.ws.wscompile.WsimportTool;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionConstants;
import org.apache.axis2.util.CommandLineOptionParser;
import org.apache.axis2.util.LogWriter;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXWSCodeGenerationEngine {
    private static final Log log = LogFactory.getLog(JAXWSCodeGenerationEngine.class);
    private CodeGenConfiguration configuration;
    private CommandLineOptionParser commandLineOptionParser;
    private String[] originalArgs;
    public static final String WS_IMPORT_EXTENSION = "-extension";
    public static final String WS_IMPORT_NO_COMPILE = "-Xnocompile";
    public static final String WS_IMPORT_FILE_OUTPUT_DIR = "-d";
    public static final String WS_IMPORT_SOURCE_OUTPUT_DIR = "-s";
    public static final String WS_IMPORT_KEEP_FILE = "-keep";
    public static final String WS_IMPORT_PKG = "-p";
    public static final String WS_IMPORT_PROXY = "-httpproxy";

    public JAXWSCodeGenerationEngine(CodeGenConfiguration configuration, String[] originalArgs) throws CodeGenerationException {
        this.configuration = configuration;
        this.originalArgs = originalArgs;
    }

    public JAXWSCodeGenerationEngine(CommandLineOptionParser commandLineOptionParser, String[] originalArgs) {
        this.commandLineOptionParser = commandLineOptionParser;
        this.originalArgs = originalArgs;
    }

    public void generate() throws CodeGenerationException {
        WsimportTool importTool = new WsimportTool((OutputStream)new WriterOutputStream((Writer)new LogWriter(log)));
        ArrayList<String> args = new ArrayList<String>();
        this.configurImportToolOptions(args);
        this.mergeOriginalArgs(args);
        boolean success = importTool.run(args.toArray(new String[args.size()]));
        if (success) {
            log.info((Object)"Code generation completed");
        }
    }

    private void mergeOriginalArgs(ArrayList<String> args) {
        Map allOptions = this.commandLineOptionParser.getAllOptions();
        ArrayList<String> axisOptionList = new ArrayList<String>();
        ArrayList<String> originalArgsOps = new ArrayList<String>(Arrays.asList(this.originalArgs));
        originalArgsOps.remove("-".concat("jws"));
        originalArgsOps.remove("-".concat("jax_ws_service"));
        Field[] allFields = CommandLineOptionConstants.WSDL2JavaConstants.class.getFields();
        Iterator mapItr = allOptions.keySet().iterator();
        for (Field field : allFields) {
            if (!String.class.equals(field.getType())) continue;
            try {
                axisOptionList.add((String)field.get(CommandLineOptionConstants.WSDL2JavaConstants.class));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        while (mapItr.hasNext()) {
            CommandLineOption op = (CommandLineOption)allOptions.get(mapItr.next());
            if (!axisOptionList.contains(op.getOptionType())) continue;
            if (op.getOptionType() != null) {
                originalArgsOps.remove("-".concat(op.getOptionType()));
            }
            if (op.getOptionValue() == null) continue;
            originalArgsOps.remove(op.getOptionValue());
        }
        args.addAll(originalArgsOps);
        log.info((Object)("Original WSImport options" + String.valueOf(Arrays.asList(originalArgsOps))));
        log.info((Object)("All WSImport options" + String.valueOf(Arrays.asList(args))));
    }

    private void configurImportToolOptions(ArrayList<String> args) {
        String pkg;
        String location;
        Map allOptions = this.commandLineOptionParser.getAllOptions();
        args.add(WS_IMPORT_EXTENSION);
        args.add(WS_IMPORT_NO_COMPILE);
        args.add(WS_IMPORT_KEEP_FILE);
        String uri = JAXWSCodeGenerationEngine.getOptionValue(allOptions, "uri");
        if (uri != null) {
            args.add(uri);
        }
        if ((location = JAXWSCodeGenerationEngine.getOptionValue(allOptions, "o")) == null) {
            location = JAXWSCodeGenerationEngine.getOptionValue(allOptions, "output");
        }
        if (location != null) {
            args.add(WS_IMPORT_FILE_OUTPUT_DIR);
            args.add(location);
        }
        if ((pkg = JAXWSCodeGenerationEngine.getOptionValue(allOptions, "p")) == null) {
            pkg = JAXWSCodeGenerationEngine.getOptionValue(allOptions, "package");
        }
        if (pkg != null) {
            args.add(WS_IMPORT_PKG);
            args.add(pkg);
        }
        String proxcyHost = JAXWSCodeGenerationEngine.getOptionValue(allOptions, "http-proxy-host");
        String proxcyPort = JAXWSCodeGenerationEngine.getOptionValue(allOptions, "http-proxy-port");
        if (pkg != null) {
            args.add(WS_IMPORT_PROXY);
            args.add(proxcyHost + ":" + proxcyPort);
        }
    }

    private static String getOptionValue(Map allOptions, String optionName) {
        CommandLineOption option = (CommandLineOption)allOptions.get(optionName);
        if (option != null) {
            return option.getOptionValue().toString();
        }
        return null;
    }
}

