/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.description.Parameter;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenIssuer;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SCTIssuerConfig;
import org.apache.rahas.impl.TokenIssuerUtil;
import org.apache.wss4j.common.derivedKey.ConversationConstants;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.DateUtil;
import org.apache.wss4j.dom.message.token.SecurityContextToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SCTIssuer
implements TokenIssuer {
    public static final String COMPUTED_KEY = "ComputedKey";
    private String configFile;
    private OMElement configElement;
    private String configParamName;

    @Override
    public SOAPEnvelope issue(RahasData data) throws TrustException {
        SCTIssuerConfig config = null;
        if (this.configElement != null) {
            config = SCTIssuerConfig.load(this.configElement.getFirstChildWithName(SCTIssuerConfig.SCT_ISSUER_CONFIG));
        }
        if (config == null && this.configFile != null) {
            config = SCTIssuerConfig.load(this.configFile);
        }
        if (config == null && this.configParamName != null) {
            Parameter param = data.getInMessageContext().getParameter(this.configParamName);
            if (param != null && param.getParameterElement() != null) {
                config = SCTIssuerConfig.load(param.getParameterElement().getFirstChildWithName(SCTIssuerConfig.SCT_ISSUER_CONFIG));
            } else {
                throw new TrustException("expectedParameterMissing", new String[]{this.configParamName});
            }
        }
        if (config == null) {
            throw new TrustException("missingConfiguration", new String[]{SCTIssuerConfig.SCT_ISSUER_CONFIG.getLocalPart()});
        }
        return this.createEnvelope(data, config);
    }

    private SOAPEnvelope createEnvelope(RahasData data, SCTIssuerConfig config) throws TrustException {
        try {
            OMElement rstrElem;
            SOAPEnvelope env = TrustUtil.createSOAPEnvelope(data.getSoapNs());
            int wstVersion = data.getVersion();
            Document doc = ((Element)env).getOwnerDocument();
            SecurityContextToken sct = new SecurityContextToken(this.getWSCVersion(data.getTokenType()), doc);
            sct.setID(UIDGenerator.generateUID());
            if (wstVersion == 2) {
                OMElement requestedSecurityTokenResponseCollection = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)env.getBody());
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, requestedSecurityTokenResponseCollection);
            } else {
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)env.getBody());
            }
            OMElement rstElem = TrustUtil.createRequestedSecurityTokenElement(wstVersion, rstrElem);
            rstElem.addChild((OMNode)((OMElement)sct.getElement()));
            String tokenType = data.getTokenType();
            OMElement reqAttachedRef = null;
            OMElement reqUnattachedRef = null;
            if (config.isAddRequestedAttachedRef()) {
                reqAttachedRef = TrustUtil.createRequestedAttachedRef(wstVersion, rstrElem, "#" + sct.getID(), tokenType);
            }
            if (config.isAddRequestedUnattachedRef()) {
                reqUnattachedRef = TrustUtil.createRequestedUnattachedRef(wstVersion, rstrElem, sct.getIdentifier(), tokenType);
            }
            ZonedDateTime creationTime = ZonedDateTime.now(ZoneOffset.UTC);
            ZonedDateTime expirationTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(creationTime.toInstant().toEpochMilli() + config.getTtl()), ZoneOffset.UTC);
            TrustUtil.createLifetimeElement(wstVersion, rstrElem, DateUtil.getDateTimeFormatter((boolean)true).format(creationTime), DateUtil.getDateTimeFormatter((boolean)true).format(expirationTime));
            Token sctToken = new Token(sct.getIdentifier(), (OMElement)sct.getElement(), Date.from(creationTime.toInstant()), Date.from(expirationTime.toInstant()));
            if (config.isAddRequestedAttachedRef()) {
                sctToken.setAttachedReference(reqAttachedRef.getFirstElement());
            }
            if (config.isAddRequestedUnattachedRef()) {
                sctToken.setUnattachedReference(reqUnattachedRef.getFirstElement());
            }
            byte[] secret = TokenIssuerUtil.getSharedSecret(data, config.getKeyComputation(), config.getKeySize());
            sctToken.setSecret(secret);
            TokenIssuerUtil.handleRequestedProofToken(data, wstVersion, config, rstrElem, sctToken, doc);
            sctToken.setState(1);
            TrustUtil.getTokenStore(data.getInMessageContext()).add(sctToken);
            return env;
        }
        catch (Exception e) {
            throw new TrustException(e.getMessage(), e);
        }
    }

    @Override
    public String getResponseAction(RahasData data) throws TrustException {
        return TrustUtil.getActionValue(data.getVersion(), "/RSTR/SCT");
    }

    @Override
    public void setConfigurationFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public void setConfigurationElement(OMElement configElement) {
        this.configElement = configElement;
    }

    @Override
    public void setConfigurationParamName(String configParamName) {
        this.configParamName = configParamName;
    }

    private int getWSCVersion(String tokenTypeValue) throws WSSecurityException {
        if (tokenTypeValue == null) {
            return 2;
        }
        if (tokenTypeValue.startsWith("http://schemas.xmlsoap.org/ws/2005/02/sc")) {
            return ConversationConstants.getWSTVersion((String)"http://schemas.xmlsoap.org/ws/2005/02/sc");
        }
        if (tokenTypeValue.startsWith("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512")) {
            return ConversationConstants.getWSTVersion((String)"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512");
        }
        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "unsupportedSecConvVersion");
    }
}

