/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.CaptureLog;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.ObjectContext;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.logging.Log;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionTest
extends JexlTestCase {
    public ExceptionTest() {
        super("ExceptionTest");
    }

    @Test
    public void testWrappedEx() throws Exception {
        Engine jexl = new Engine();
        JexlExpression e = jexl.createExpression("npe()");
        ObjectContext jc = new ObjectContext((JexlEngine)jexl, (Object)new ThrowNPE());
        try {
            e.evaluate((JexlContext)jc);
            Assert.fail((String)"Should have thrown NPE");
        }
        catch (JexlException xany) {
            Throwable xth = xany.getCause();
            Assert.assertEquals(NullPointerException.class, xth.getClass());
        }
    }

    @Test
    public void testWrappedExmore() throws Exception {
        Throwable xth;
        Throwable xth2;
        Engine jexl = new Engine();
        ThrowNPE npe = new ThrowNPE();
        try {
            Object r = jexl.getProperty((Object)npe, "foo");
            Assert.fail((String)"Should have thrown JexlException.Property");
        }
        catch (JexlException.Property xany) {
            xth2 = xany.getCause();
            Assert.assertNull((Object)xth2);
        }
        try {
            jexl.setProperty((Object)npe, "foo", (Object)42);
            Assert.fail((String)"Should have thrown JexlException.Property");
        }
        catch (JexlException.Property xany) {
            xth2 = xany.getCause();
            Assert.assertNull((Object)xth2);
        }
        boolean b = (Boolean)jexl.getProperty((Object)npe, "fail");
        Assert.assertFalse((boolean)b);
        try {
            jexl.setProperty((Object)npe, "fail", (Object)false);
            jexl.setProperty((Object)npe, "fail", (Object)true);
            Assert.fail((String)"Should have thrown JexlException.Property");
        }
        catch (JexlException.Property xany) {
            xth = xany.getCause();
            Assert.assertEquals(NullPointerException.class, xth.getClass());
        }
        try {
            jexl.getProperty((Object)npe, "fail");
            Assert.fail((String)"Should have thrown JexlException.Property");
        }
        catch (JexlException.Property xany) {
            xth = xany.getCause();
            Assert.assertEquals(NullPointerException.class, xth.getClass());
        }
        try {
            jexl.invokeMethod((Object)npe, "foo", new Object[]{42});
            Assert.fail((String)"Should have thrown JexlException.Method");
        }
        catch (JexlException.Method xany) {
            xth = xany.getCause();
            Assert.assertNull((Object)xth);
        }
        try {
            jexl.invokeMethod((Object)npe, "npe", new Object[0]);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (JexlException.Method xany) {
            xth = xany.getCause();
            Assert.assertEquals(NullPointerException.class, xth.getClass());
        }
    }

    @Test
    public void testEx() throws Exception {
        String msg;
        JexlEngine jexl = ExceptionTest.createEngine(false);
        JexlExpression e = jexl.createExpression("c.e * 6");
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        options.setStrict(true);
        try {
            e.evaluate((JexlContext)ctxt);
            Assert.fail((String)"c not defined as variable should throw");
        }
        catch (JexlException.Variable xjexl) {
            msg = xjexl.getMessage();
            Assert.assertTrue((msg.indexOf("variable 'c.e'") > 0 ? 1 : 0) != 0);
        }
        options.setStrictArithmetic(true);
        ctxt.set("c.e", null);
        try {
            e.evaluate((JexlContext)ctxt);
            Assert.fail((String)"c.e as null operand should throw");
        }
        catch (JexlException.Variable xjexl) {
            msg = xjexl.getMessage();
            Assert.assertTrue((msg.indexOf("variable 'c.e'") > 0 ? 1 : 0) != 0);
        }
        options.setStrictArithmetic(false);
        try {
            e.evaluate((JexlContext)ctxt);
        }
        catch (JexlException xjexl) {
            Assert.fail((String)"c.e in expr should not throw");
        }
        ctxt.set("c", "{ 'a' : 3, 'b' : 5}");
        ctxt.set("e", 2);
        try {
            e.evaluate((JexlContext)ctxt);
            Assert.fail((String)"c.e not accessible as property should throw");
        }
        catch (JexlException.Property xjexl) {
            msg = xjexl.getMessage();
            Assert.assertTrue((msg.indexOf("property 'e") > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testExVar() throws Exception {
        JexlEngine jexl = ExceptionTest.createEngine(false);
        JexlScript e = jexl.createScript("(x)->{ x * 6 }");
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        options.setStrict(true);
        options.setStrictArithmetic(true);
        try {
            e.execute((JexlContext)ctxt);
            Assert.fail((String)"x is null, should throw");
        }
        catch (JexlException xjexl) {
            String msg = xjexl.getMessage();
            Assert.assertTrue((msg.indexOf("null") > 0 ? 1 : 0) != 0);
        }
        options.setStrictArithmetic(false);
        try {
            Object xjexl = e.execute((JexlContext)ctxt, new Object[]{null});
        }
        catch (JexlException.Variable xjexl) {
            Assert.fail((String)"arithmetic allows null operands, should not throw");
        }
    }

    @Test
    public void testExMethod() throws Exception {
        String msg;
        JexlEngine jexl = ExceptionTest.createEngine(false);
        JexlExpression e = jexl.createExpression("c.e.foo()");
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        options.setStrict(true);
        try {
            e.evaluate((JexlContext)ctxt);
            Assert.fail((String)"c not declared as variable should throw");
        }
        catch (JexlException.Variable xjexl) {
            msg = xjexl.getMessage();
            Assert.assertTrue((msg.indexOf("variable 'c.e'") > 0 ? 1 : 0) != 0);
        }
        options.setStrictArithmetic(true);
        ctxt.set("c.e", null);
        try {
            e.evaluate((JexlContext)ctxt);
            Assert.fail((String)"c.e as null operand should throw");
        }
        catch (JexlException xjexl) {
            msg = xjexl.getMessage();
            Assert.assertTrue((msg.indexOf("variable 'c.e'") > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void test206() throws Exception {
        String src = "null.1 = 2; return 42";
        this.doTest206(src, false, false);
        this.doTest206(src, false, true);
        this.doTest206(src, true, false);
        this.doTest206(src, true, true);
        src = "x = null.1; return 42";
        this.doTest206(src, false, false);
        this.doTest206(src, false, true);
        this.doTest206(src, true, false);
        this.doTest206(src, true, true);
        src = "x = y.1; return 42";
        this.doTest206(src, false, false);
        this.doTest206(src, false, true);
        this.doTest206(src, true, false);
        this.doTest206(src, true, true);
    }

    private void doTest206(String src, boolean strict, boolean silent) throws Exception {
        Object r;
        CaptureLog l;
        block7: {
            l = new CaptureLog();
            MapContext jc = new MapContext();
            JexlEngine jexl = new JexlBuilder().logger((Log)l).strict(strict).silent(silent).create();
            r = -1;
            JexlScript e = jexl.createScript(src);
            try {
                r = e.execute((JexlContext)jc);
                if (strict && !silent) {
                    Assert.fail((String)"should have thrown an exception");
                }
            }
            catch (JexlException xjexl) {
                if (strict && !silent) break block7;
                Assert.fail((String)(src + ": should not have thrown an exception"));
            }
        }
        if (strict) {
            if (silent && l.count("warn") == 0) {
                Assert.fail((String)(src + ": should have generated a warning"));
            }
        } else {
            if (l.count("debug") == 0) {
                Assert.fail((String)(src + ": should have generated a debug"));
            }
            Assert.assertEquals((Object)42, (Object)r);
        }
    }

    public static class ThrowNPE {
        boolean doThrow = false;

        public String npe() {
            throw new NullPointerException("ThrowNPE");
        }

        public void setFail(boolean f) {
            this.doThrow = f;
            if (f) {
                throw new NullPointerException("ThrowNPE/set");
            }
        }

        public boolean getFail() {
            if (this.doThrow) {
                throw new NullPointerException("ThrowNPE/get");
            }
            return this.doThrow;
        }
    }
}

