/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.control.action;

import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.control.TokenReplacer;
import org.apache.torque.generator.control.action.MergepointAction;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourcePath;

public class SourceElementAttributeAction
implements MergepointAction {
    private final String elementPath;
    private final String attributeName;
    private boolean acceptNotSet = true;

    public SourceElementAttributeAction(String element, String attributeName, Boolean acceptNotSet) {
        if (element == null) {
            throw new IllegalArgumentException("SourceElementAttributeAction: element must not be null");
        }
        this.elementPath = element;
        this.attributeName = attributeName;
        if (acceptNotSet != null) {
            this.acceptNotSet = acceptNotSet;
        }
    }

    @Override
    public OutletResult execute(ControllerState controllerState) throws GeneratorException {
        TokenReplacer tokenReplacer = new TokenReplacer(controllerState);
        String detonizedElementPath = tokenReplacer.process(this.elementPath);
        SourceElement sourceElement = SourcePath.getElement((SourceElement)controllerState.getModel(), detonizedElementPath, this.acceptNotSet);
        if (sourceElement == null) {
            if (this.acceptNotSet) {
                return new OutletResult("");
            }
            throw new GeneratorException("SourceElementAttributeAction: No element " + this.elementPath + "can be found.");
        }
        String detokenizedAttributeName = tokenReplacer.process(this.attributeName);
        Object result = sourceElement.getAttribute(detokenizedAttributeName);
        if (result == null) {
            if (this.acceptNotSet) {
                return new OutletResult("");
            }
            throw new GeneratorException("SourceElementAttributeAction: The attribute " + this.attributeName + " is not set on the element " + sourceElement.getName() + " (element path was " + this.elementPath + ", value was" + String.valueOf(sourceElement) + ")");
        }
        return new OutletResult(result.toString());
    }

    public String toString() {
        return "(ApplyAction: element=" + this.elementPath + ", attribute=" + this.attributeName + ", acceptNotSet=" + this.acceptNotSet + ")";
    }
}

