/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.LongDecoder;
import org.apache.directory.api.asn1.ber.tlv.LongDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchRequestSizeLimit
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestSizeLimit.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreSearchRequestSizeLimit() {
        super("Store SearchRequest sizeLimit");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequest searchRequest = (SearchRequest)container.getMessage().getDecorated();
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        long sizeLimit = 0L;
        try {
            sizeLimit = LongDecoder.parse((BerValue)value, (long)0L, (long)Integer.MAX_VALUE);
        }
        catch (LongDecoderException lde) {
            String msg = I18n.err((I18n)I18n.ERR_04103, (Object[])new Object[]{value.toString()});
            LOG.error(msg);
            throw new DecoderException(msg, (Throwable)lde);
        }
        searchRequest.setSizeLimit(sizeLimit);
        if (IS_DEBUG) {
            LOG.debug("The sizeLimit value is set to {} objects", (Object)sizeLimit);
        }
    }
}

