/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import java.util.Map;
import org.apache.directory.api.i18n.I18n;

public enum AliasDerefMode {
    NEVER_DEREF_ALIASES(0, "never"),
    DEREF_IN_SEARCHING(1, "searching"),
    DEREF_FINDING_BASE_OBJ(2, "finding"),
    DEREF_ALWAYS(3, "always");

    private int value;
    private String jndiValue;

    private AliasDerefMode(int value, String jndiValue) {
        this.value = value;
        this.jndiValue = jndiValue;
    }

    public int getValue() {
        return this.value;
    }

    public static AliasDerefMode getEnum(Map<String, Object> env) {
        String property = (String)env.get("java.naming.ldap.derefAliases");
        if (null == property) {
            return DEREF_ALWAYS;
        }
        String trimmedProperty = property.trim();
        if ("always".equalsIgnoreCase(trimmedProperty)) {
            return DEREF_ALWAYS;
        }
        if ("never".equalsIgnoreCase(trimmedProperty)) {
            return NEVER_DEREF_ALIASES;
        }
        if ("finding".equalsIgnoreCase(trimmedProperty)) {
            return DEREF_FINDING_BASE_OBJ;
        }
        if ("searching".equalsIgnoreCase(trimmedProperty)) {
            return DEREF_IN_SEARCHING;
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04186, (Object[])new Object[]{property, "java.naming.ldap.derefAliases"}));
    }

    public boolean isDerefAlways() {
        return this == DEREF_ALWAYS;
    }

    public boolean isNeverDeref() {
        return this == NEVER_DEREF_ALIASES;
    }

    public boolean isDerefInSearching() {
        switch (this) {
            case DEREF_ALWAYS: {
                return true;
            }
            case DEREF_FINDING_BASE_OBJ: {
                return false;
            }
            case DEREF_IN_SEARCHING: {
                return true;
            }
            case NEVER_DEREF_ALIASES: {
                return false;
            }
        }
        throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04187, (Object[])new Object[0]));
    }

    public boolean isDerefFindingBase() {
        switch (this) {
            case DEREF_ALWAYS: {
                return true;
            }
            case DEREF_FINDING_BASE_OBJ: {
                return true;
            }
            case DEREF_IN_SEARCHING: {
                return false;
            }
            case NEVER_DEREF_ALIASES: {
                return false;
            }
        }
        throw new IllegalArgumentException("Class has bug: check for valid enumeration values");
    }

    public static AliasDerefMode getDerefMode(int val) {
        switch (val) {
            case 0: {
                return NEVER_DEREF_ALIASES;
            }
            case 1: {
                return DEREF_IN_SEARCHING;
            }
            case 2: {
                return DEREF_FINDING_BASE_OBJ;
            }
            case 3: {
                return DEREF_ALWAYS;
            }
        }
        throw new IllegalArgumentException("Unknown derefmode " + val);
    }

    public static AliasDerefMode getDerefMode(String val) {
        if (val != null) {
            if (val.equals(AliasDerefMode.NEVER_DEREF_ALIASES.jndiValue)) {
                return NEVER_DEREF_ALIASES;
            }
            if (val.equals(AliasDerefMode.DEREF_IN_SEARCHING.jndiValue)) {
                return DEREF_IN_SEARCHING;
            }
            if (val.equals(AliasDerefMode.DEREF_FINDING_BASE_OBJ.jndiValue)) {
                return DEREF_FINDING_BASE_OBJ;
            }
            if (val.equals(AliasDerefMode.DEREF_ALWAYS.jndiValue)) {
                return DEREF_ALWAYS;
            }
        }
        throw new IllegalArgumentException("Unknown derefmode " + val);
    }

    public String getJndiValue() {
        return this.jndiValue;
    }
}

