/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.response.extended;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreExtendedResponseName
extends GrammarAction<LdapMessageContainer<ExtendedResponse>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreExtendedResponseName.class);

    public StoreExtendedResponseName() {
        super("Store response name");
    }

    @Override
    public void action(LdapMessageContainer<ExtendedResponse> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_05122_NULL_NAME, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        byte[] responseNameBytes = tlv.getValue().getData();
        String responseName = Strings.asciiBytesToString(responseNameBytes);
        try {
            if (!Oid.isOid(responseName)) {
                String msg = I18n.err(I18n.ERR_05159_INVALID_RESPONSE_NAME_OID, responseName, Strings.dumpBytes(responseNameBytes));
                LOG.error(msg);
                throw new DecoderException(msg);
            }
            LdapApiService codec = container.getLdapCodecService();
            ExtendedOperationFactory factory = codec.getExtendedResponseFactories().get(responseName);
            ExtendedResponse extendedResponse = container.getMessage();
            if (factory != null) {
                extendedResponse = factory.newResponse();
                LdapMessageContainer.copyLdapResult(container.getMessage(), extendedResponse);
                extendedResponse.setMessageId(container.getMessageId());
                container.setMessage(extendedResponse);
            } else {
                extendedResponse.setResponseName(responseName);
            }
            container.setExtendedFactory(factory);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg(I18n.MSG_05172_OID_READ, extendedResponse.getResponseName()));
            }
        }
        catch (DecoderException de) {
            String msg = I18n.err(I18n.ERR_05159_INVALID_RESPONSE_NAME_OID, responseName, Strings.dumpBytes(responseNameBytes));
            LOG.error(I18n.err(I18n.ERR_05114_ERROR_MESSAGE, msg, de.getMessage()));
            throw de;
        }
        container.setGrammarEndAllowed(true);
    }
}

