// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.functions.agg;

import org.apache.doris.catalog.FunctionSignature;
import org.apache.doris.nereids.trees.expressions.Expression;
import org.apache.doris.nereids.trees.expressions.functions.ExplicitlyCastableSignature;
import org.apache.doris.nereids.trees.expressions.functions.Function;
import org.apache.doris.nereids.trees.expressions.shape.UnaryExpression;
import org.apache.doris.nereids.trees.expressions.visitor.ExpressionVisitor;
import org.apache.doris.nereids.types.coercion.AnyDataType;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * AggregateFunction 'any_value'. This class is generated by GenerateFunction.
 */
public class AnyValue extends NullableAggregateFunction
        implements UnaryExpression, ExplicitlyCastableSignature, RollUpTrait {

    public static final List<FunctionSignature> SIGNATURES = ImmutableList.of(
            FunctionSignature.retArgType(0).args(AnyDataType.INSTANCE_WITHOUT_INDEX)
    );

    /**
     * constructor with 1 argument.
     */
    public AnyValue(Expression arg) {
        this(false, arg);
    }

    /**
     * constructor with 1 argument.
     */
    public AnyValue(boolean distinct, Expression arg) {
        this(false, false, arg);
    }

    private AnyValue(boolean distinct, boolean alwaysNullable, Expression arg) {
        super("any_value", false, alwaysNullable, arg);
    }

    /** constructor for withChildren and reuse signature */
    private AnyValue(NullableAggregateFunctionParams functionParams) {
        super(functionParams);
    }

    /**
     * withDistinctAndChildren.
     */
    @Override
    public AnyValue withDistinctAndChildren(boolean distinct, List<Expression> children) {
        Preconditions.checkArgument(children.size() == 1);
        return new AnyValue(getFunctionParams(distinct, children));
    }

    @Override
    public AnyValue withAlwaysNullable(boolean alwaysNullable) {
        return new AnyValue(getAlwaysNullableFunctionParams(alwaysNullable));
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitAnyValue(this, context);
    }

    @Override
    public List<FunctionSignature> getSignatures() {
        return SIGNATURES;
    }

    @Override
    public Function constructRollUp(Expression param, Expression... varParams) {
        return new AnyValue(getFunctionParams(ImmutableList.of(param)));
    }

    @Override
    public boolean canRollUp() {
        return true;
    }
}
