/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.jsf2.components;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.view.AttachedObjectHandler;
import org.apache.empire.data.Column;
import org.apache.empire.jsf2.controls.InputControl;
import org.apache.empire.jsf2.utils.StyleClass;
import org.apache.empire.jsf2.utils.TagEncodingHelper;
import org.apache.empire.jsf2.utils.TagEncodingHelperFactory;
import org.apache.empire.jsf2.utils.TagStyleClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputTag
extends UIInput
implements NamingContainer,
TagEncodingHelperFactory.TagEncodingHolder {
    private static final Logger log = LoggerFactory.getLogger(InputTag.class);
    protected static final String readOnlyState = "readOnlyState";
    protected final TagEncodingHelper helper = TagEncodingHelperFactory.create((UIOutput)this, TagStyleClass.INPUT.get());
    protected InputControl control = null;
    protected InputControl.InputInfo inpInfo = null;
    protected boolean submittedValueDetected = false;
    protected Object submittedValue;
    protected boolean valueValidated = false;
    private String treeClientId = null;

    public String getFamily() {
        return "javax.faces.NamingContainer";
    }

    @Override
    public TagEncodingHelper getEncodingHelper() {
        return this.helper;
    }

    protected void saveState() {
        this.getStateHelper().put((Serializable)((Object)readOnlyState), (Object)(this.inpInfo == null ? 1 : 0));
    }

    protected boolean initState(FacesContext context) {
        this.helper.prepareData();
        if (!this.helper.isVisible()) {
            return false;
        }
        Boolean ros = (Boolean)this.getStateHelper().get((Serializable)((Object)readOnlyState));
        if (ros != null && ros.booleanValue()) {
            return false;
        }
        if (this.getChildCount() == 0) {
            log.warn("InputTag '{}' has no children. encodeBegin may not have been called yet.", (Object)this.getClientId());
            return false;
        }
        this.control = this.helper.getInputControl();
        this.inpInfo = this.helper.getInputInfo(context);
        return this.control != null && this.inpInfo != null;
    }

    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        FacesContext context = visitContext.getFacesContext();
        this.treeClientId = this.getClientId(context);
        return super.visitTree(visitContext, callback);
    }

    public String getClientId(FacesContext context) {
        if (this.treeClientId != null && this.control != null && this.control.isCreatingComponents()) {
            return this.treeClientId;
        }
        return super.getClientId(context);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        this.helper.encodeBegin();
        this.control = this.helper.getInputControl();
        this.inpInfo = this.helper.getInputInfo(context);
        super.setRequired(this.helper.isValueRequired());
        if (this.getChildCount() == 0) {
            this.control.createInput((UIComponent)this, this.inpInfo, context);
            this.attachEvents(context);
        } else {
            this.control.updateInputState((UIComponent)this, this.inpInfo, context, context.getCurrentPhaseId());
        }
        boolean controlVisible = this.helper.isVisible();
        boolean renderValue = this.helper.isRenderValueComponent();
        this.setRenderInput(!renderValue && controlVisible);
        if (controlVisible) {
            String wrapperTag = this.helper.writeWrapperTag(context, this.helper.hasComponentId(), renderValue);
            if (renderValue) {
                String tagName = "span";
                StyleClass styleClass = this.helper.getTagStyleClass();
                styleClass.add((Object)TagStyleClass.INPUT_DIS);
                String tooltip = this.helper.getValueTooltip(this.helper.getTagAttributeValue("title"));
                this.control.renderValue((UIComponent)this, tagName, styleClass, tooltip, this.inpInfo, context);
            } else {
                this.control.renderInput((UIComponent)this, this.inpInfo, context);
            }
            if (wrapperTag != null) {
                ResponseWriter writer = context.getResponseWriter();
                writer.endElement(wrapperTag);
            }
        }
        this.saveState();
    }

    public void encodeChildren(FacesContext context) throws IOException {
        log.debug("InputTag:encodeChildren is ignored");
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
    }

    public String getId() {
        String compId = super.getId();
        if ("null".equals(compId)) {
            compId = this.helper.completeInputTagId(null);
        }
        return compId;
    }

    public void setId(String id) {
        id = this.helper.completeInputTagId(id);
        super.setId(id);
    }

    public void setParent(UIComponent parent) {
        super.setParent(parent);
        if (this.helper.hasComponentId()) {
            return;
        }
        String autoId = this.helper.getAutoControlId();
        if (autoId != null) {
            this.setId(autoId);
            log.debug("Auto-Setting compontent id for Input to {}", (Object)this.getId());
        }
    }

    public Object getValue() {
        if (this.helper.getRecord() != null) {
            return this.helper.getDataValue(true);
        }
        Object value = super.getValue();
        return value;
    }

    public Object getSubmittedValue() {
        if (this.submittedValueDetected) {
            return this.submittedValue;
        }
        if (this.control == null || this.inpInfo == null || this.helper.isReadOnly()) {
            return null;
        }
        this.submittedValue = this.control.getInputValue((UIComponent)this, this.inpInfo, true);
        this.submittedValueDetected = true;
        return this.submittedValue;
    }

    public void setSubmittedValue(Object submittedValue) {
        this.submittedValue = submittedValue;
        this.submittedValueDetected = true;
    }

    protected Object getConvertedValue(FacesContext context, Object newSubmittedValue) throws ConverterException {
        if (this.control == null || this.inpInfo == null || this.helper.isReadOnly()) {
            return null;
        }
        try {
            return this.control.getConvertedValue((UIComponent)this, this.inpInfo, newSubmittedValue);
        }
        catch (Exception e) {
            FacesMessage msg = this.helper.getFieldValueErrorMessage(context, e, newSubmittedValue);
            throw new ConverterException(msg);
        }
    }

    public void processDecodes(FacesContext context) {
        if (this.helper.isInsideUIData() && this.getChildCount() > 0) {
            this.updateControlInputState(context);
            boolean renderValue = this.helper.isRenderValueComponent();
            this.setRenderInput(!renderValue);
        }
        super.processDecodes(context);
    }

    public void processValidators(FacesContext context) {
        this.resetSubmittedValue();
        if (this.helper.isInsideUIData() && this.getChildCount() > 0) {
            this.updateControlInputState(context);
            boolean hasValue = this.getSubmittedValue() != null;
            this.setRenderInput(hasValue);
        }
        super.processValidators(context);
    }

    public void validate(FacesContext context) {
        if (!this.initState(context)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating input for {}.", (Object)this.inpInfo.getColumn().getName());
        }
        this.resetSubmittedValue();
        this.valueValidated = false;
        super.validate(context);
        if (this.isValid() && !this.valueValidated && !this.helper.isReadOnly() && !this.helper.isDisabled()) {
            Object value = this.helper.getDataValue(true);
            log.warn("No Submitted value for {}. Validating Record value of \"{}\" instead.", (Object)this.helper.getColumnName(), value);
            if (value != null) {
                this.validateValue(context, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateValue(FacesContext context, Object value) {
        try {
            if (this.inpInfo == null) {
                return;
            }
            if (this.helper.beginValidateValue(context, value)) {
                this.inpInfo.validate(value);
            }
            this.setValid(true);
        }
        catch (Exception e) {
            this.helper.addFieldValueErrorMessage(context, e, value);
            this.setValid(false);
        }
        finally {
            this.valueValidated = true;
        }
    }

    public void processUpdates(FacesContext context) {
        try {
            this.pushComponentToEL(context, (UIComponent)this);
            if (!this.isRendered()) {
                return;
            }
            try {
                this.updateModel(context);
            }
            catch (RuntimeException e) {
                context.renderResponse();
                throw e;
            }
            if (!this.isValid()) {
                context.renderResponse();
            }
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    public void updateModel(FacesContext context) {
        if (!this.initState(context)) {
            return;
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        Object value = this.getLocalValue();
        if (this.helper.beginUpdateModel(context, value)) {
            log.debug("Updating model input for {}.", (Object)this.inpInfo.getColumn().getName());
            this.inpInfo.setValue(value);
        }
        this.setValue(null);
        this.setLocalValueSet(false);
        this.control.postUpdateModel((UIComponent)this, this.inpInfo, context);
    }

    public Column getInputColumn() {
        return this.helper.getColumn();
    }

    public boolean isInputReadOnly() {
        return this.helper.isRecordReadOnly();
    }

    public boolean isInputRequired() {
        return this.helper.isValueRequired();
    }

    protected void resetSubmittedValue() {
        this.submittedValueDetected = false;
        this.submittedValue = null;
    }

    protected void updateControlInputState(FacesContext context) {
        this.helper.prepareData();
        if (this.control == null) {
            this.control = this.helper.getInputControl();
        }
        if (this.inpInfo == null) {
            this.inpInfo = this.helper.getInputInfo(context);
        }
        this.control.updateInputState((UIComponent)this, this.inpInfo, context, context.getCurrentPhaseId());
    }

    protected void setRenderInput(boolean renderInput) {
        for (UIComponent child : this.getChildren()) {
            if (child.isRendered() == renderInput) continue;
            if (log.isDebugEnabled()) {
                log.debug("Changing UIInput rendered state for {} to {}", (Object)this.helper.getColumnName(), (Object)renderInput);
            }
            child.setRendered(renderInput);
        }
    }

    protected void attachEvents(FacesContext context) {
        List result = (List)this.getAttributes().get("javax.faces.RetargetableHandlers");
        if (result == null) {
            return;
        }
        UIInput inputComponent = null;
        for (UIComponent c : this.getChildren()) {
            if (!(c instanceof UIInput)) continue;
            inputComponent = (UIInput)c;
            break;
        }
        if (inputComponent == null) {
            return;
        }
        for (AttachedObjectHandler aoh : result) {
            aoh.applyAttachedObject(context, (UIComponent)inputComponent);
        }
        result.clear();
        this.getAttributes().remove("javax.faces.RetargetableHandlers");
    }
}

