/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.p2;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.osgi.util.DelegatingHandler;
import org.xml.sax.Attributes;

public class PropertiesParser {

    static class PropertyHandler
    extends DelegatingHandler {
        private static final String PROPERTY = "property";
        private static final String NAME = "name";
        private static final String VALUE = "value";
        String name;
        String value;

        public PropertyHandler() {
            super(PROPERTY);
        }

        @Override
        protected void handleAttributes(Attributes atts) {
            this.name = atts.getValue(NAME);
            this.value = atts.getValue(VALUE);
        }
    }

    static class PropertiesHandler
    extends DelegatingHandler {
        private static final String PROPERTIES = "properties";
        private static final String SIZE = "size";
        Map<String, String> properties;

        public PropertiesHandler(String ... props) {
            super(PROPERTIES);
            final List<String> propList = Arrays.asList(props);
            this.addChild(new PropertyHandler(), new DelegatingHandler.ChildElementHandler<PropertyHandler>(){

                @Override
                public void childHandled(PropertyHandler child) {
                    if (propList.isEmpty() || propList.contains(child.name)) {
                        properties.put(child.name, child.value);
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.properties = new HashMap<String, String>(size);
        }
    }
}

