/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.cache.query.index.Order;
import org.apache.ignite.internal.cache.query.index.SortOrder;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IndexKeyDefinition
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private IndexKeyType idxType;
    private Order order;
    private int precision;

    public IndexKeyDefinition() {
    }

    public IndexKeyDefinition(int idxTypeCode, Order order, long precision) {
        this.idxType = IndexKeyType.forCode(idxTypeCode);
        this.order = order;
        this.precision = precision >= Integer.MAX_VALUE ? -1 : (int)precision;
    }

    public Order order() {
        return this.order;
    }

    public IndexKeyType idxType() {
        return this.idxType;
    }

    public int precision() {
        return this.precision;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.idxType.code());
        U.writeEnum(out, this.order.sortOrder());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.idxType = IndexKeyType.forCode(in.readInt());
        this.order = new Order(U.readEnum(in, SortOrder.class), null);
    }
}

