/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cache.query.QueryDetailMetrics;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryDetailMetricsKey;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridCacheQueryDetailMetricsAdapter
implements QueryDetailMetrics,
Externalizable {
    private static final long serialVersionUID = 0L;
    private GridCacheQueryType qryType;
    private String qry;
    private String cache;
    private int execs;
    private int completions;
    private int failures;
    private long minTime = -1L;
    private long maxTime;
    private long totalTime;
    private long lastStartTime;
    private GridCacheQueryDetailMetricsKey key;

    public GridCacheQueryDetailMetricsAdapter() {
    }

    public GridCacheQueryDetailMetricsAdapter(GridCacheQueryType qryType, String qry, String cache, long startTime, long duration, boolean failed) {
        this.qryType = qryType;
        this.qry = qryType == GridCacheQueryType.SCAN && qry == null ? cache : qry;
        this.cache = cache;
        if (failed) {
            this.execs = 1;
            this.failures = 1;
        } else {
            this.execs = 1;
            this.completions = 1;
            this.totalTime = duration;
            this.minTime = duration;
            this.maxTime = duration;
        }
        this.lastStartTime = startTime;
    }

    public GridCacheQueryDetailMetricsAdapter(GridCacheQueryType qryType, String qry, String cache, int execs, int completions, int failures, long minTime, long maxTime, long totalTime, long lastStartTime, GridCacheQueryDetailMetricsKey key) {
        this.qryType = qryType;
        this.qry = qry;
        this.cache = cache;
        this.execs = execs;
        this.completions = completions;
        this.failures = failures;
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.totalTime = totalTime;
        this.lastStartTime = lastStartTime;
        this.key = key;
    }

    public GridCacheQueryDetailMetricsKey key() {
        if (this.key == null) {
            this.key = new GridCacheQueryDetailMetricsKey(this.qryType, this.qry);
        }
        return this.key;
    }

    public GridCacheQueryDetailMetricsAdapter aggregate(QueryDetailMetrics m) {
        return new GridCacheQueryDetailMetricsAdapter(this.qryType, this.qry, m.cache(), this.execs + m.executions(), this.completions + m.completions(), this.failures + m.failures(), this.minTime < 0L || this.minTime > m.minimumTime() ? m.minimumTime() : this.minTime, this.maxTime < m.maximumTime() ? m.maximumTime() : this.maxTime, this.totalTime + m.totalTime(), this.lastStartTime < m.lastStartTime() ? m.lastStartTime() : this.lastStartTime, this.key);
    }

    @Override
    public String queryType() {
        return this.qryType.name();
    }

    @Override
    public String query() {
        return this.qry;
    }

    @Override
    public String cache() {
        return this.cache;
    }

    @Override
    public int executions() {
        return this.execs;
    }

    @Override
    public int completions() {
        return this.completions;
    }

    @Override
    public int failures() {
        return this.failures;
    }

    @Override
    public long minimumTime() {
        return this.minTime < 0L ? 0L : this.minTime;
    }

    @Override
    public long maximumTime() {
        return this.maxTime;
    }

    @Override
    public double averageTime() {
        double val = this.completions;
        return val > 0.0 ? (double)this.totalTime / val : 0.0;
    }

    @Override
    public long totalTime() {
        return this.totalTime;
    }

    @Override
    public long lastStartTime() {
        return this.lastStartTime;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.qryType);
        U.writeString(out, this.qry);
        U.writeString(out, this.cache);
        out.writeInt(this.execs);
        out.writeInt(this.completions);
        out.writeLong(this.minTime);
        out.writeLong(this.maxTime);
        out.writeLong(this.totalTime);
        out.writeLong(this.lastStartTime);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.qryType = GridCacheQueryType.fromOrdinal(in.readByte());
        this.qry = U.readString(in);
        this.cache = U.readString(in);
        this.execs = in.readInt();
        this.completions = in.readInt();
        this.minTime = in.readLong();
        this.maxTime = in.readLong();
        this.totalTime = in.readLong();
        this.lastStartTime = in.readLong();
    }

    public String toString() {
        return S.toString(GridCacheQueryDetailMetricsAdapter.class, this);
    }
}

