/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence;

import org.apache.ignite3.internal.pagememory.FullPageId;
import org.apache.ignite3.internal.pagememory.persistence.DirtyFullPageId;
import org.apache.ignite3.internal.util.GridUnsafe;

public class PageHeader {
    static final long PAGE_MARKER = 1L;
    private static final int DIRTY_FLAG = 0x1000000;
    static final int UNKNOWN_PARTITION_GENERATION = -1;
    public static final int PAGE_OVERHEAD = 48;
    private static final int MARKER_OR_TIMESTAMP_OFFSET = 0;
    private static final int PARTITION_GENERATION_OFFSET = 8;
    private static final int FLAGS_OFFSET = 12;
    private static final int PAGE_ID_OFFSET = 16;
    private static final int PAGE_GROUP_ID_OFFSET = 24;
    private static final int PAGE_PIN_CNT_OFFSET = 28;
    public static final int PAGE_LOCK_OFFSET = 32;
    private static final int PAGE_TMP_BUF_OFFSET = 40;

    public static void initNew(long absPtr) {
        PageHeader.partitionGeneration(absPtr, -1);
        PageHeader.tempBufferPointer(absPtr, 0xFFFFFFFFFFFFFFL);
        GridUnsafe.putLong(absPtr + 0L, 1L);
        GridUnsafe.putInt(absPtr + 28L, 0);
    }

    public static boolean dirty(long absPtr) {
        return PageHeader.flag(absPtr, 0x1000000);
    }

    public static boolean dirty(long absPtr, boolean dirty) {
        return PageHeader.flag(absPtr, 0x1000000, dirty);
    }

    private static boolean flag(long absPtr, int flagMask) {
        assert ((flagMask & 0xFFFFFF) == 0) : Integer.toHexString(flagMask);
        assert (Long.bitCount(flagMask) == 1) : Integer.toHexString(flagMask);
        int flags = GridUnsafe.getInt(absPtr + 12L);
        return (flags & flagMask) != 0;
    }

    private static boolean flag(long absPtr, int flagMask, boolean set) {
        boolean was;
        assert ((flagMask & 0xFFFFFF) == 0) : Integer.toHexString(flagMask);
        assert (Long.bitCount(flagMask) == 1) : Integer.toHexString(flagMask);
        int flags = GridUnsafe.getInt(absPtr + 12L);
        boolean bl = was = (flags & flagMask) != 0;
        flags = set ? (flags |= flagMask) : (flags &= ~flagMask);
        GridUnsafe.putInt(absPtr + 12L, flags);
        return was;
    }

    public static boolean isAcquired(long absPtr) {
        return GridUnsafe.getInt(absPtr + 28L) > 0;
    }

    public static int acquirePage(long absPtr) {
        return GridUnsafe.incrementAndGetInt(absPtr + 28L);
    }

    public static int releasePage(long absPtr) {
        return GridUnsafe.decrementAndGetInt(absPtr + 28L);
    }

    static int pinCount(long absPtr) {
        return GridUnsafe.getIntVolatile(null, absPtr + 28L);
    }

    public static void timestamp(long absPtr, long timestamp) {
        GridUnsafe.putLongVolatile(null, absPtr + 0L, (timestamp &= 0xFFFFFFFFFFFFFF00L) | 1L);
    }

    public static long timestamp(long absPtr) {
        long markerAndTs = GridUnsafe.getLong(absPtr + 0L);
        return markerAndTs & 0xFFFFFFFFFFFFFF00L;
    }

    static void tempBufferPointer(long absPtr, long tmpRelPtr) {
        GridUnsafe.putLong(absPtr + 40L, tmpRelPtr);
    }

    static long tempBufferPointer(long absPtr) {
        return GridUnsafe.getLong(absPtr + 40L);
    }

    static long pageId(long absPtr) {
        return GridUnsafe.getLong(absPtr + 16L);
    }

    private static void pageId(long absPtr, long pageId) {
        GridUnsafe.putLong(absPtr + 16L, pageId);
    }

    private static int pageGroupId(long absPtr) {
        return GridUnsafe.getInt(absPtr + 24L);
    }

    private static void pageGroupId(long absPtr, int grpId) {
        GridUnsafe.putInt(absPtr + 24L, grpId);
    }

    public static FullPageId fullPageId(long absPtr) {
        return new FullPageId(PageHeader.pageId(absPtr), PageHeader.pageGroupId(absPtr));
    }

    public static void fullPageId(long absPtr, FullPageId fullPageId) {
        PageHeader.pageId(absPtr, fullPageId.pageId());
        PageHeader.pageGroupId(absPtr, fullPageId.groupId());
    }

    public static int partitionGeneration(long absPtr) {
        return GridUnsafe.getInt(absPtr + 8L);
    }

    static void partitionGeneration(long absPtr, int partitionGeneration) {
        assert (partitionGeneration > 0 || partitionGeneration == -1) : partitionGeneration;
        GridUnsafe.putInt(absPtr + 8L, partitionGeneration);
    }

    public static DirtyFullPageId dirtyFullPageId(long absPtr) {
        return new DirtyFullPageId(PageHeader.pageId(absPtr), PageHeader.pageGroupId(absPtr), PageHeader.partitionGeneration(absPtr));
    }

    public static void dirtyFullPageId(long absPtr, DirtyFullPageId dirtyFullPageId) {
        PageHeader.pageId(absPtr, dirtyFullPageId.pageId());
        PageHeader.pageGroupId(absPtr, dirtyFullPageId.groupId());
        PageHeader.partitionGeneration(absPtr, dirtyFullPageId.partitionGeneration());
    }
}

