/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tx.TxPriority;
import org.jetbrains.annotations.Nullable;

public class InternalTxOptions {
    private static final InternalTxOptions DEFAULT_OPTIONS = InternalTxOptions.builder().build();
    private final TxPriority priority;
    private final long timeoutMillis;
    @Nullable
    private final HybridTimestamp readTimestamp;

    private InternalTxOptions(TxPriority priority, long timeoutMillis, @Nullable HybridTimestamp readTimestamp) {
        this.priority = priority;
        this.timeoutMillis = timeoutMillis;
        this.readTimestamp = readTimestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static InternalTxOptions defaults() {
        return DEFAULT_OPTIONS;
    }

    public static InternalTxOptions defaultsWithPriority(TxPriority priority) {
        return InternalTxOptions.builder().priority(priority).build();
    }

    public TxPriority priority() {
        return this.priority;
    }

    public long timeoutMillis() {
        return this.timeoutMillis;
    }

    @Nullable
    public HybridTimestamp readTimestamp() {
        return this.readTimestamp;
    }

    public static class Builder {
        private TxPriority priority = TxPriority.NORMAL;
        private long timeoutMillis = 0L;
        @Nullable
        private HybridTimestamp readTimestamp = null;

        public Builder priority(TxPriority priority) {
            this.priority = priority;
            return this;
        }

        public Builder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public Builder readTimestamp(HybridTimestamp readTimestamp) {
            this.readTimestamp = readTimestamp;
            return this;
        }

        public InternalTxOptions build() {
            return new InternalTxOptions(this.priority, this.timeoutMillis, this.readTimestamp);
        }
    }
}

