/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.storage.impl;

import java.util.List;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.entity.EnumOutter;
import org.apache.ignite3.raft.jraft.entity.LogEntry;
import org.apache.ignite3.raft.jraft.entity.LogId;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryEncoder;
import org.apache.ignite3.raft.jraft.option.LogStorageOptions;
import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.storage.LogStorage;
import org.apache.ignite3.raft.jraft.storage.VolatileStorage;
import org.apache.ignite3.raft.jraft.util.Describer;
import org.apache.ignite3.raft.jraft.util.Requires;

public class LocalLogStorage
implements LogStorage,
Describer,
VolatileStorage {
    private static final IgniteLogger LOG = Loggers.forClass(LocalLogStorage.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final NavigableMap<Long, LogEntry> log = new ConcurrentSkipListMap<Long, LogEntry>();
    private LogEntryEncoder logEntryEncoder;
    private LogEntryDecoder logEntryDecoder;
    private volatile long firstLogIndex = 1L;
    private volatile long lastLogIndex = 0L;
    private volatile boolean initialized = false;

    public LocalLogStorage(RaftOptions raftOptions) {
    }

    @Override
    public boolean init(LogStorageOptions opts) {
        Requires.requireNonNull(opts.getConfigurationManager(), "Null conf manager");
        Requires.requireNonNull(opts.getLogEntryCodecFactory(), "Null log entry codec factory");
        this.writeLock.lock();
        try {
            if (this.initialized) {
                LOG.warn("LocalLogStorage init() was already called.", new Object[0]);
                boolean bl = true;
                return bl;
            }
            this.initialized = true;
            this.logEntryDecoder = opts.getLogEntryCodecFactory().decoder();
            this.logEntryEncoder = opts.getLogEntryCodecFactory().encoder();
            Requires.requireNonNull(this.logEntryDecoder, "Null log entry decoder");
            Requires.requireNonNull(this.logEntryEncoder, "Null log entry encoder");
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.writeLock.lock();
        try {
            this.initialized = false;
            this.log.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getFirstLogIndex() {
        this.readLock.lock();
        try {
            long l = this.firstLogIndex;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getLastLogIndex() {
        this.readLock.lock();
        try {
            long l = this.lastLogIndex;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogEntry getEntry(long index) {
        this.readLock.lock();
        try {
            if (index < this.getFirstLogIndex()) {
                LogEntry logEntry = null;
                return logEntry;
            }
            LogEntry logEntry = (LogEntry)this.log.get(index);
            return logEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getTerm(long index) {
        LogEntry entry = this.getEntry(index);
        if (entry != null) {
            return entry.getId().getTerm();
        }
        return 0L;
    }

    @Override
    public boolean appendEntry(LogEntry entry) {
        this.readLock.lock();
        try {
            if (!this.initialized) {
                LOG.warn("DB not initialized or destroyed.", new Object[0]);
                boolean bl = false;
                return bl;
            }
            this.log.put(entry.getId().getIndex(), entry);
            this.lastLogIndex = (Long)this.log.lastKey();
            this.firstLogIndex = (Long)this.log.firstKey();
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int appendEntries(List<LogEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return 0;
        }
        int entriesCount = entries.size();
        this.readLock.lock();
        try {
            if (!this.initialized) {
                LOG.warn("DB not initialized or destroyed.", new Object[0]);
                int n = 0;
                return n;
            }
            for (LogEntry logEntry : entries) {
                this.log.put(logEntry.getId().getIndex(), logEntry);
            }
            this.lastLogIndex = (Long)this.log.lastKey();
            this.firstLogIndex = (Long)this.log.firstKey();
            int n = entriesCount;
            return n;
        }
        catch (Exception e) {
            LOG.error("Fail to append entry.", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncatePrefix(long firstIndexKept) {
        this.readLock.lock();
        try {
            SortedMap<Long, LogEntry> map = this.log.headMap(firstIndexKept);
            map.clear();
            this.firstLogIndex = this.log.isEmpty() ? 1L : (Long)this.log.firstKey();
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncateSuffix(long lastIndexKept) {
        this.readLock.lock();
        try {
            NavigableMap<Long, LogEntry> suffix = this.log.tailMap(lastIndexKept, false);
            suffix.clear();
            this.lastLogIndex = this.log.isEmpty() ? 0L : (Long)this.log.lastKey();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Fail to truncateSuffix {}.", e, lastIndexKept);
        }
        finally {
            this.readLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reset(long nextLogIndex) {
        if (nextLogIndex <= 0L) {
            throw new IllegalArgumentException("Invalid next log index.");
        }
        this.writeLock.lock();
        try {
            LogEntry entry = this.getEntry(nextLogIndex);
            this.log.clear();
            this.firstLogIndex = 1L;
            this.lastLogIndex = 0L;
            if (entry == null) {
                entry = new LogEntry();
                entry.setType(EnumOutter.EntryType.ENTRY_TYPE_NO_OP);
                entry.setId(new LogId(nextLogIndex, 0L));
                LOG.warn("Entry not found for nextLogIndex {} when reset.", nextLogIndex);
            }
            boolean bl = this.appendEntry(entry);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void describe(Describer.Printer out) {
        this.readLock.lock();
        try {
            out.println("firstLogIndex=" + this.firstLogIndex);
            out.println("lastLogIndex=" + this.lastLogIndex);
        }
        catch (Exception e) {
            out.println(e);
        }
        finally {
            this.readLock.unlock();
        }
    }
}

