/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.BytesUtils;

public class ReplaceFunctionColumnTransformer
extends UnaryColumnTransformer {
    private final String from;
    private final String to;

    public ReplaceFunctionColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, String from, String to) {
        super(returnType, childColumnTransformer);
        this.from = from;
        this.to = to;
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                this.returnType.writeBinary(columnBuilder, BytesUtils.valueOf((String)this.childColumnTransformer.getType().getBinary(column, i).getStringValue(TSFileConfig.STRING_CHARSET).replace(this.from, this.to)));
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                this.returnType.writeBinary(columnBuilder, BytesUtils.valueOf((String)this.childColumnTransformer.getType().getBinary(column, i).getStringValue(TSFileConfig.STRING_CHARSET).replace(this.from, this.to)));
                continue;
            }
            columnBuilder.appendNull();
        }
    }
}

