/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.updater;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.basic.EntityTraverser;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.updater.Updater;

public abstract class EntityUpdater<N extends IMNode<N>>
extends EntityTraverser<Void, N>
implements Updater {
    protected EntityUpdater(N startNode, PartialPath path, IMTreeStore<N> store, boolean isPrefixMatch, PathPatternTree scope) throws MetadataException {
        super(startNode, path, store, isPrefixMatch, scope);
    }

    protected Void generateResult(N nextMatchedNode) {
        try {
            this.updateEntity(nextMatchedNode.getAsDeviceMNode());
        }
        catch (MetadataException e) {
            this.setFailure(e);
        }
        return null;
    }

    @Override
    public void update() throws MetadataException {
        while (super.hasNext()) {
            super.next();
        }
        if (!this.isSuccess()) {
            Throwable e = this.getFailure();
            throw new MetadataException(e.getMessage(), e);
        }
    }

    protected abstract void updateEntity(IDeviceMNode<N> var1) throws MetadataException;
}

